DROP TABLE IF EXISTS `em_cp_pay_unifiedorder`
;
CREATE TABLE `em_cp_pay_unifiedorder` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `cp_corp_id` varchar(32) DEFAULT NULL COMMENT '企业号基本信息ID',
  `open_user_id` varchar(128) DEFAULT NULL COMMENT '用户在企业号内的唯一标识',
  `mchid` varchar(32) DEFAULT NULL COMMENT '商户ID',
  `trade_type` varchar(16) DEFAULT NULL COMMENT '交易类型',
  `out_trade_no` varchar(32) DEFAULT NULL COMMENT '订单号',
  `total_fee` int(11) DEFAULT NULL COMMENT '总金额',
  `body` varchar(128) DEFAULT NULL COMMENT '商品描述',
  `attach` varchar(127) DEFAULT NULL COMMENT '附加数据',
  `nonce_str` varchar(32) DEFAULT NULL COMMENT '随机字符串',
  `notify_url` varchar(256) DEFAULT NULL COMMENT '通知地址',
  `spbill_create_ip` varchar(16) DEFAULT NULL COMMENT '终端IP',
  `sign` varchar(32) DEFAULT NULL COMMENT '签名',
  `order_status` tinyint(4) DEFAULT NULL COMMENT '订单状态，0：下单成功，1：下单失败，2：支付成功，3：支付失败',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`)
) COMMENT='企业号支付订单';
