CREATE TABLE `em_msg_expression_item` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `item_name` varchar(100) DEFAULT NULL COMMENT '分组名称',
  `item_icon` varchar(32) DEFAULT NULL COMMENT '分组图标ID',
  `showorder` int DEFAULT NULL COMMENT '显示顺序',
  `status` tinyint DEFAULT '1' COMMENT '状态 1-正常，2-禁用，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY showorder(`showorder`)
) COMMENT='消息自定义表情分组表'
;

CREATE TABLE `em_msg_expression_data` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `item_id` varchar(32) DEFAULT NULL COMMENT '所属表情分组ID',
  `data_icon` varchar(32) DEFAULT NULL COMMENT '表情数据图标ID',
  `showorder` int DEFAULT NULL COMMENT '显示顺序',
  `status` tinyint DEFAULT '1' COMMENT '状态 1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  key item_id(item_id),
  key showorder(showorder)
) COMMENT='消息自定义表情数据表'
;
