DROP TABLE IF EXISTS `em_cp_user_sync_field`
;
CREATE TABLE `em_cp_user_sync_field` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `cp_syncset_id` varchar(32) DEFAULT NULL COMMENT '企业号同步设置ID',
  `user_field_name` varchar(50) DEFAULT NULL COMMENT '企业号字段名称',
  `user_field_key` varchar(50) DEFAULT NULL COMMENT '企业号字段唯一标识',
  `user_field_type` tinyint(4) DEFAULT 0 COMMENT '企业号字段类型，0：基础字段，1：自定义字段',
  `outsys_field_name` varchar(50) DEFAULT NULL COMMENT '集成系统字段名称',
  `outsys_field_key` varchar(50) DEFAULT NULL COMMENT '集成系统字段唯一标识',
  `outsys_field_type` tinyint(4) DEFAULT 0 COMMENT '集成系统字段类型，0：基础字段，1：自定义字段',
  `showorder` int(11) DEFAULT NULL COMMENT '显示排序',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`)
) COMMENT='企业号人员同步字段配置'
;
