CREATE TABLE em_video_zhumu_user (
  id varchar(32) NOT NULL,
  base_user_id varchar(32) DEFAULT NULL COMMENT '基础用户ID',
  zcode varchar(50) DEFAULT NULL COMMENT '瞩目人员标识',
  email varchar(100) DEFAULT NULL COMMENT '邮箱',
  pmi varchar(50) DEFAULT NULL COMMENT '个人会议号',
  status tinyint(4) DEFAULT 1 COMMENT '状态',
  create_user_id varchar(32) DEFAULT NULL COMMENT '创建人',
  create_time datetime DEFAULT NULL COMMENT '创建时间',
  update_user_id varchar(32) DEFAULT NULL COMMENT '修改人',
  update_time datetime DEFAULT NULL COMMENT '修改时间',
  tenant_id varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (id),
  KEY base_user_id(`base_user_id`)
) COMMENT='瞩目视频会议人员标识表'
;

CREATE TABLE em_video_zhumu_meeting (
  id varchar(32) NOT NULL,
  base_user_id varchar(32) DEFAULT NULL COMMENT '会议主持人对应的基础用户ID',
  meeting_id varchar(50) DEFAULT NULL COMMENT '瞩目会议ID',
  meeting_password varchar(20) DEFAULT NULL COMMENT '会议密码',
  meeting_topic varchar(50) DEFAULT NULL COMMENT '瞩目会议名称',
  meeting_type tinyint(4) DEFAULT NULL COMMENT '会议类型：1-即时会议，2-计划会议，3-长期会议',
  meeting_start_time datetime DEFAULT NULL COMMENT '会议开始时间',
  meeting_duration varchar(20) DEFAULT NULL COMMENT '会议持续时间',
  option_jbh tinyint(4) DEFAULT NULL COMMENT '是否可以在主持人开始会议之前加入会议：1-是，0-否',
  option_start_type varchar(10) DEFAULT NULL COMMENT '会议开始类型，可以是"video"或者 "screen_share". (不赞成)',
  option_no_video_host tinyint(4) DEFAULT NULL COMMENT '当主持人加入会议时关闭视频：1-是，0-否',
  option_no_video_participants tinyint(4) DEFAULT NULL COMMENT '当参与人加入会议室不打开视频：1-是，0-否',
  option_audio varchar(10) DEFAULT NULL COMMENT '会议语音选项。可以是"both", "telephony", “voip”',
  status tinyint(4) DEFAULT 1 COMMENT '状态',
  create_user_id varchar(32) DEFAULT NULL COMMENT '创建人',
  create_time datetime DEFAULT NULL COMMENT '创建时间',
  update_user_id varchar(32) DEFAULT NULL COMMENT '修改人',
  update_time datetime DEFAULT NULL COMMENT '修改时间',
  tenant_id varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (id),
  KEY base_user_id(`base_user_id`)
) COMMENT='瞩目视频会议会议信息表'
;
