CREATE TABLE em_msg_group_dept (
  id varchar(32) NOT NULL,
  group_id varchar(50) DEFAULT NULL COMMENT '群组ID',
  dept_id varchar(32) DEFAULT NULL COMMENT '部门ID',
  status tinyint(4) DEFAULT 1 COMMENT '状态',
  create_user_id varchar(32) DEFAULT NULL COMMENT '创建人',
  create_time datetime DEFAULT NULL COMMENT '创建时间',
  update_user_id varchar(32) DEFAULT NULL COMMENT '修改人',
  update_time datetime DEFAULT NULL COMMENT '修改时间',
  tenant_id varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (id),
  KEY group_id(group_id),
  KEY dept_id(dept_id),
  KEY create_time(create_time)
) COMMENT='部门群数据表'
;

CREATE TABLE em_msg_group_dept_user (
  id varchar(32) NOT NULL,
  group_id varchar(50) DEFAULT NULL COMMENT '群组ID',
  dept_id varchar(32) DEFAULT NULL COMMENT '部门ID',
  user_id varchar(32) DEFAULT NULL COMMENT '人员ID',
  status tinyint(4) DEFAULT 1 COMMENT '状态',
  create_user_id varchar(32) DEFAULT NULL COMMENT '创建人',
  create_time datetime DEFAULT NULL COMMENT '创建时间',
  update_user_id varchar(32) DEFAULT NULL COMMENT '修改人',
  update_time datetime DEFAULT NULL COMMENT '修改时间',
  tenant_id varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (id),
  KEY group_id(group_id),
  KEY dept_id(dept_id),
  KEY user_id(user_id),
  KEY create_time(create_time)
) COMMENT='部门群成员表'
;