ALTER TABLE em_msg_ding RENAME TO em_msg_ding_bak
;
CREATE TABLE em_msg_ding (
  id varchar(32) NOT NULL COMMENT '主键ID',
  send_user_id varchar(32) DEFAULT NULL COMMENT '发送人id',
  touserids text DEFAULT NULL COMMENT '接收人员id，多个用逗号分隔',
  msg_content varchar(1000) DEFAULT NULL COMMENT '消息内容',
  msg_type tinyint(4) DEFAULT 1 comment '消息类型：1-应用内，2-短信，3-电话',
  send_type tinyint(4) DEFAULT 1 comment '发送类型：1-立即发送，2-定时发送',
  send_time datetime DEFAULT NULL COMMENT '定时发送的时间，格式为YYYY-MM-DD HH:MM:ss',
  send_result tinyint(4) DEFAULT 1 comment '发送结果：1-发生成功，2-等待发送，3-发送失败',
   msg_ding_id  varchar(50)  DEFAULT NULL COMMENT '对应消息服务中的数据ID',
   messageid   varchar(50) COMMENT '消息转必达id',
  status tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  create_user_id varchar(32) DEFAULT NULL COMMENT '创建人',
  create_time datetime DEFAULT NULL COMMENT '创建时间',
  update_user_id varchar(32) DEFAULT NULL COMMENT '修改人',
  update_time datetime DEFAULT NULL COMMENT '修改时间',
  tenant_id varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (id),
  KEY create_time (create_time),
  KEY tenant_id (tenant_id)
) COMMENT='必达消息数据表'
;