CREATE TABLE em_sys_mine_setting (
  id varchar(32) NOT NULL,
  item_name varchar(50) DEFAULT NULL COMMENT '菜单项名称，支持多语言',
  item_icon varchar(100) DEFAULT NULL COMMENT '菜单项图标',
  item_type tinyint(4) DEFAULT 0 COMMENT '菜单项类型：0-空白，1-设置，2-扫一扫，3-切换主题，4-收藏，5-钱包，10-打开页面，11-打开应用',
  item_setting varchar(100) DEFAULT NULL COMMENT '菜单项类型详细设置，即打开页面类型的页面地址',
  item_order int(11) DEFAULT 0 COMMENT '菜单项显示顺序',
  is_sys  int(11) DEFAULT 0 COMMENT '是否系统默认1-系统默认，不允许删，0-自定义',
  status tinyint(4) DEFAULT 1 COMMENT '状态 2-禁用',
  create_user_id varchar(32) DEFAULT NULL COMMENT '创建人',
  create_time datetime DEFAULT NULL COMMENT '创建时间',
  update_user_id varchar(32) DEFAULT NULL COMMENT '修改人',
  update_time datetime DEFAULT NULL COMMENT '修改时间',
  tenant_id varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (id),
  key(item_order)
) COMMENT='个人信息设置表'
;
INSERT INTO em_sys_mine_setting (id,item_name,item_icon,item_type,item_setting,item_order,is_sys,STATUS,create_user_id,tenant_id) VALUES ('1','我的钱包','/common/images/app/mine_item_wallet.png',5,'',  1,1, 1,'1','1')
;
INSERT INTO em_sys_mine_setting (id,item_name,item_icon,item_type,item_setting,item_order,is_sys,STATUS,create_user_id,tenant_id) VALUES ('2','切换主题','/common/images/app/mine_item_theme.png',3,'',   2,1, 1,'1','1')
;
INSERT INTO em_sys_mine_setting (id,item_name,item_icon,item_type,item_setting,item_order,is_sys,STATUS,create_user_id,tenant_id) VALUES ('3','主次账号切换','/common/images/app/mine_item_accounts.png',10,'',3,1, 1,'1','1')
;
INSERT INTO em_sys_mine_setting (id,item_name,item_icon,item_type,item_setting,item_order,is_sys,STATUS,create_user_id,tenant_id) VALUES ('4','修改密码','/common/images/app/mine_item_password.png',10,'',  4,1, 1,'1','1')
;
INSERT INTO em_sys_mine_setting (id,item_name,item_icon,item_type,item_setting,item_order,is_sys,STATUS,create_user_id,tenant_id) VALUES ('5','收藏','/common/images/app/mine_item_favorite.png',4,'',    5,1, 1,'1','1')
;
INSERT INTO em_sys_mine_setting (id,item_name,item_icon,item_type,item_setting,item_order,is_sys,STATUS,create_user_id,tenant_id) VALUES ('6','扫一扫','/common/images/app/mine_item_scan.png',2,'',      6,1, 1,'1','1')
;
INSERT INTO em_sys_mine_setting (id,item_name,item_icon,item_type,item_setting,item_order,is_sys,STATUS,create_user_id,tenant_id) VALUES ('7','设置','/common/images/app/mine_item_setting.png',1,'',      7,1, 1,'1','1')
;

INSERT INTO em_sys_lang_data (id,data_tag, data_id,lang_tag,set_value,STATUS,tenant_id) VALUES ('mineitemwalleten', 'em_sys_mine_setting:item_name', '1', 'en', 'My Wallet',1, '1'),('mineitemwalletzh','em_sys_mine_setting:item_name', '1', 'zh', '我的钱包',1, '1'),('mineitemwalletzhTW', 'em_sys_mine_setting:item_name', '1', 'zh_TW', '我的錢包',1, '1')
;
INSERT INTO em_sys_lang_data (id,data_tag, data_id,lang_tag,set_value,STATUS,tenant_id) VALUES ('mineitemthemeen', 'em_sys_mine_setting:item_name', '2', 'en', 'Change Theme',1, '1'),('mineitemthemezh','em_sys_mine_setting:item_name', '2', 'zh', '切换主题',1, '1'),('mineitemthemezhTW', 'em_sys_mine_setting:item_name', '2', 'zh_TW', '切換主題',1, '1')
;
INSERT INTO em_sys_lang_data (id,data_tag, data_id,lang_tag,set_value,STATUS,tenant_id) VALUES ('mineitemaccountsen', 'em_sys_mine_setting:item_name', '3', 'en', 'Primary and secondary account switching',1, '1'),('mineitemaccountszh','em_sys_mine_setting:item_name', '3', 'zh', '主次账号切换',1, '1'),('mineitemaccountszhTW', 'em_sys_mine_setting:item_name', '3', 'zh_TW', '主次賬號切換',1, '1')
;
INSERT INTO em_sys_lang_data (id,data_tag, data_id,lang_tag,set_value,STATUS,tenant_id) VALUES ('mineitempassworden', 'em_sys_mine_setting:item_name', '4', 'en', 'Change Password',1, '1'),('mineitempasswordzh','em_sys_mine_setting:item_name', '4', 'zh', '修改密码',1, '1'),('mineitempasswordzhTW', 'em_sys_mine_setting:item_name', '4', 'zh_TW', '修改密碼',1, '1')
;
INSERT INTO em_sys_lang_data (id,data_tag, data_id,lang_tag,set_value,STATUS,tenant_id) VALUES ('mineitemfavoriteen', 'em_sys_mine_setting:item_name', '5', 'en', 'Favorite',1, '1'),('mineitemfavoritezh','em_sys_mine_setting:item_name', '5', 'zh', '收藏',1, '1'),('mineitemfavoritezhTW', 'em_sys_mine_setting:item_name', '5', 'zh_TW', '收藏',1, '1')
;
INSERT INTO em_sys_lang_data (id,data_tag, data_id,lang_tag,set_value,STATUS,tenant_id) VALUES ('mineitemscanen', 'em_sys_mine_setting:item_name', '6', 'en', 'Scan',1, '1'),('mineitemscanzh','em_sys_mine_setting:item_name', '6', 'zh', '扫一扫',1, '1'),('mineitemscanzhTW', 'em_sys_mine_setting:item_name', '6', 'zh_TW', '掃壹掃',1, '1')
;
INSERT INTO em_sys_lang_data (id,data_tag, data_id,lang_tag,set_value,STATUS,tenant_id) VALUES ('mineitemsettingen', 'em_sys_mine_setting:item_name', '7', 'en', 'Settings',1, '1'),('mineitemsettingzh','em_sys_mine_setting:item_name', '7', 'zh', '设置',1, '1'),('mineitemsettingzhTW', 'em_sys_mine_setting:item_name', '7', 'zh_TW', '設置',1, '1')
;