DROP TABLE IF EXISTS em_cp_msgaudit_file
;
CREATE TABLE em_cp_msgaudit_file (
  id varchar(32) NOT NULL COMMENT '主键',
  file_name varchar(1000) DEFAULT NULL COMMENT '文件名称',
  file_extension varchar(255) DEFAULT NULL COMMENT '文件扩展名',
  file_content_type varchar(255) DEFAULT NULL COMMENT '文件类型',
  file_size bigint(20) DEFAULT NULL COMMENT '文件大小',
  file_path varchar(255) DEFAULT NULL COMMENT '文件路径',
  status tinyint(4) DEFAULT NULL COMMENT '状态',
  create_user_id varchar(32) DEFAULT NULL COMMENT '创建人',
  create_time datetime DEFAULT NULL COMMENT '创建时间',
  update_user_id varchar(32) DEFAULT NULL COMMENT '修改人',
  update_time datetime DEFAULT NULL COMMENT '修改时间',
  tenant_id varchar(32) DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (id)
) COMMENT='会话内容存档文件'
;
DROP TABLE IF EXISTS em_cp_msgaudit_member
;
CREATE TABLE em_cp_msgaudit_member (
  id varchar(32) NOT NULL COMMENT '主键',
  corp_id varchar(32) DEFAULT NULL COMMENT '企业ID',
  member_id varchar(64) DEFAULT NULL COMMENT '接口成员ID',
  status tinyint(4) DEFAULT NULL COMMENT '状态',
  create_user_id varchar(32) DEFAULT NULL COMMENT '创建人',
  create_time datetime DEFAULT NULL COMMENT '创建时间',
  update_user_id varchar(32) DEFAULT NULL COMMENT '修改人',
  update_time datetime DEFAULT NULL COMMENT '修改时间',
  tenant_id varchar(32) DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (id),
  INDEX member_id(member_id),
  INDEX corp_id_member_id(corp_id, member_id)
) COMMENT='会话内容存档成员'
;
DROP TABLE IF EXISTS em_cp_msgaudit_message
;
CREATE TABLE em_cp_msgaudit_message (
  id varchar(32) NOT NULL COMMENT '主键',
  corp_id varchar(32) DEFAULT NULL COMMENT '企业ID',
  seq bigint(20) DEFAULT NULL COMMENT 'seq',
  room_id varchar(32) DEFAULT NULL COMMENT '会话ID',
  msg_id varchar(64) DEFAULT NULL COMMENT '接口消息ID',
  msg_action varchar(32) DEFAULT NULL COMMENT '消息动作：send-发送消息、recall-撤回消息、switch-切换企业日志',
  msg_from varchar(255) DEFAULT NULL COMMENT '消息发送方id',
  to_list mediumtext NULL COMMENT '消息接收方列表，可能是多个，同一个企业内容为userid，非相同企业为external_userid',
  msg_type varchar(32) DEFAULT NULL COMMENT '消息类型',
  msg_time datetime DEFAULT NULL COMMENT '消息发送时间',
  content mediumtext NULL COMMENT '消息内容',
  sdk_file_id text NULL COMMENT '接口媒体资源的id信息',
  file_id varchar(32) DEFAULT NULL COMMENT '文件ID',
  msg_json mediumtext NULL COMMENT '消息原始JSON数据',
  status tinyint(4) DEFAULT NULL COMMENT '状态',
  tenant_id varchar(32) DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (id),
  INDEX room_id(room_id),
  INDEX msg_id(msg_id)
) COMMENT='会话内容存档消息'
;
DROP TABLE IF EXISTS em_cp_msgaudit_room
;
CREATE TABLE em_cp_msgaudit_room (
  id varchar(32) NOT NULL COMMENT '主键',
  corp_id varchar(32) DEFAULT NULL COMMENT '企业ID',
  room_id varchar(64) DEFAULT NULL COMMENT '接口会话ID',
  room_type tinyint(4) DEFAULT NULL COMMENT '会话类型：1-单聊、2-群聊',
  room_name varchar(255) DEFAULT NULL COMMENT '群名称',
  room_creator varchar(255) DEFAULT NULL COMMENT '群创建者',
  room_create_time datetime DEFAULT NULL COMMENT '群创建时间',
  room_notice text NULL COMMENT '群公告',
  status tinyint(4) DEFAULT NULL COMMENT '状态',
  create_user_id varchar(255) DEFAULT NULL COMMENT '创建人',
  create_time datetime DEFAULT NULL COMMENT '创建时间',
  update_user_id varchar(32) DEFAULT NULL COMMENT '修改人',
  update_time datetime DEFAULT NULL COMMENT '修改时间',
  tenant_id varchar(32) DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (id),
  INDEX corp_id(corp_id),
  INDEX corp_id_room_id(corp_id, room_id)
) COMMENT='会话内容存档会话'
;
DROP TABLE IF EXISTS em_cp_msgaudit_room_member
;
CREATE TABLE em_cp_msgaudit_room_member (
  id varchar(32) NOT NULL COMMENT '主键',
  room_id varchar(64) DEFAULT NULL COMMENT '会话ID',
  member_id varchar(64) DEFAULT NULL COMMENT '成员ID',
  join_time datetime DEFAULT NULL COMMENT '加入时间',
  status tinyint(4) DEFAULT NULL COMMENT '状态',
  create_user_id varchar(32) DEFAULT NULL COMMENT '创建人',
  create_time datetime DEFAULT NULL COMMENT '创建时间',
  update_user_id varchar(32) DEFAULT NULL COMMENT '修改人',
  update_time datetime DEFAULT NULL COMMENT '修改时间',
  tenant_id varchar(32) DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (id),
  INDEX room_id(room_id),
  INDEX room_id_member_id(room_id, member_id)
) COMMENT='会话内容存档会话成员关联关系'
;
DROP TABLE IF EXISTS em_cp_msgaudit_sync_record
;
CREATE TABLE em_cp_msgaudit_sync_record (
  id varchar(32) NOT NULL COMMENT '主键',
  corp_id varchar(32) DEFAULT NULL COMMENT '企业ID',
  first_seq bigint(20) DEFAULT NULL COMMENT '开始seq',
  last_seq bigint(20) DEFAULT NULL COMMENT '结束seq',
  message_count bigint(20) DEFAULT NULL COMMENT '同步消息数量',
  create_user_id varchar(32) DEFAULT NULL COMMENT '创建人',
  create_time datetime DEFAULT NULL COMMENT '创建时间',
  tenant_id varchar(32) DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (id),
  INDEX corp_id(corp_id),
  INDEX create_time(create_time)
) COMMENT='会话内容存档同步记录'
;
DROP TABLE IF EXISTS em_cp_msgaudit_sync_setting
;
CREATE TABLE em_cp_msgaudit_sync_setting (
  id varchar(32) NOT NULL COMMENT '主键',
  corp_id varchar(32) DEFAULT NULL COMMENT '企业ID',
  seq bigint(20) DEFAULT NULL COMMENT '最大seq',
  create_user_id varchar(32) DEFAULT NULL COMMENT '创建人',
  create_time datetime DEFAULT NULL COMMENT '创建时间',
  update_user_id varchar(32) DEFAULT NULL COMMENT '修改人',
  update_time datetime DEFAULT NULL COMMENT '修改时间',
  tenant_id varchar(32) DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (id),
  INDEX corp_id(corp_id)
) COMMENT='会话内容存档同步设置'
;