CREATE TABLE em_agent_base_msgmenu (
  id varchar(32) NOT NULL COMMENT '主键ID',
  agent_base_id  varchar(32) NOT NULL COMMENT '应用ID',
  issys tinyint(4) DEFAULT 0 COMMENT '是否系统默认,系统默认的菜单按钮不允许修改',
  msgtype varchar(500) DEFAULT NULL COMMENT '适用消息类型：1-文本消息，2-图片消息，3-表情消息，4-语音消息，5-位置消息，6-文件，适用于多个类型时用逗号分隔表示',
  ismultiple tinyint(4) DEFAULT NULL COMMENT '是否支持消息多选，1-是，0-否',
  open_type tinyint(4) DEFAULT NULL   COMMENT '菜单点击打开目标方式，1-窗口，2-浏览器',
  win_width  int  DEFAULT NULL   COMMENT '如果是打开窗口，窗口宽带，单位像素px',
  win_height int  DEFAULT NULL   COMMENT '如果是打开窗口，窗口高度，单位像素px',
  showorder decimal(10,2) DEFAULT NULL comment '显示顺序',
  PRIMARY KEY (id),
  KEY(agent_base_id)
) COMMENT='消息菜单配置信息表'
;
