create table em_cp_dept_simulated
(
    id               varchar(32)   not null comment '主键ID'
        primary key,
    cp_corp_id       varchar(32)   null comment '企业号基本信息ID',
    open_dept_id     varchar(100)  null comment '企业号中的部门ID',
    dept_name        varchar(100)  null comment '部门名称',
    english_name     varchar(100)  null comment '英文名称',
    parent_id        varchar(100)  null comment '上级部门ID',
    all_parent_ids   varchar(1000) null comment '所有上级部门ID用逗号分隔',
    outsys_id        varchar(32)   null comment '对应集成系统的ID',
    outsys_dept_type tinyint       null comment '对应集成系统部门类型：1-分部，2-部门',
    outsys_dept_id   varchar(32)   null comment '对应集成系统部门ID',
    showorder        bigint        null comment '显示顺序',
    status           tinyint       null comment '状态 1-正常，3-删除',
    create_user_id   varchar(32)   null comment '创建人',
    create_time      datetime      null comment '创建时间',
    update_user_id   varchar(32)   null comment '修改人',
    update_time      datetime      null comment '修改时间',
    tenant_id        varchar(32)   null comment '企业租户ID'
) comment '企业号通讯录部门模拟表'
;

create index open_dept_id on em_cp_dept_simulated (open_dept_id)
;

create index parent_id on em_cp_dept_simulated (parent_id)
;

create index tenant_id on em_cp_dept_simulated (tenant_id)
;

