DROP TABLE IF EXISTS em_log_client_report
;
CREATE TABLE em_log_client_report (
  id VARCHAR(32) NOT NULL  PRIMARY KEY COMMENT '主键',
	base_user_id VARCHAR(32) NOT NULL COMMENT '用户ID',
	base_user_name VARCHAR(32) COMMENT '用户名',
	client_type tinyint(4) COMMENT '客户端类型： 1-PC客户端，2-IOS客户端，3-安卓客户端',
	client_version VARCHAR(50) COMMENT '客户端版本号',
	device_id VARCHAR(200) COMMENT '客户端硬件标识',
	client_model VARCHAR(200) COMMENT '客户端设备型号',
	os_version VARCHAR(200) COMMENT '客户端操作系统版本',
	log_file_id VARCHAR(32) COMMENT '日志文件ID',
	ip VARCHAR(200) COMMENT '客户端IP地址',
	create_time Datetime COMMENT '上报时间',
	tenant_id VARCHAR(32) COMMENT '租户ID'
) COMMENT = '客户端上报日志记录表'
;
