DROP TABLE IF EXISTS `em_otp_userinfo`
;
CREATE TABLE `em_otp_userinfo` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `base_user_id` varchar(32) DEFAULT NULL COMMENT '用户ID',
  `sn` varchar(255) DEFAULT NULL COMMENT '序列号',
  `code` varchar(255) DEFAULT NULL COMMENT '激活码',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '最后修改人',
  `update_time` datetime DEFAULT NULL COMMENT '最后修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (`id`),
  KEY `base_user_id` (`base_user_id`)
) COMMENT='OTP用户信息'
;
DROP TABLE IF EXISTS `em_otp_verify_record`
;
CREATE TABLE `em_otp_verify_record` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `base_user_id` varchar(32) DEFAULT NULL COMMENT '用户ID',
  `token` varchar(255) DEFAULT NULL COMMENT '令牌',
  `success` tinyint(4) DEFAULT NULL COMMENT '是否验证成功：0-失败、1-成功',
  `verify_msg` text COMMENT '验证信息',
  `ip` varchar(255) COMMENT 'ip地址',
  `status` varchar(255) DEFAULT NULL COMMENT '状态',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (`id`),
  KEY `create_time` (`create_time`)
) COMMENT='OTP验证记录'
;