DROP TABLE IF EXISTS `em_cp_external_contact`
;
CREATE TABLE `em_cp_external_contact` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `cp_corp_id` varchar(32) DEFAULT NULL COMMENT '企业号基本信息ID',
  `external_user_id` varchar(32) DEFAULT NULL COMMENT '外部联系人的userid',
  `name` varchar(255) DEFAULT NULL COMMENT '外部联系人的名称',
  `avatar` varchar(255) DEFAULT NULL COMMENT '外部联系人头像，第三方不可获取',
  `type` tinyint(4) DEFAULT NULL COMMENT '外部联系人的类型，1表示该外部联系人是微信用户，2表示该外部联系人是企业微信用户',
  `gender` tinyint(4) DEFAULT NULL COMMENT '外部联系人性别 0-未知 1-男性 2-女性',
  `union_id` varchar(255) DEFAULT NULL COMMENT '外部联系人在微信开放平台的唯一身份标识',
  `position` varchar(255) DEFAULT NULL COMMENT '外部联系人的职位',
  `corp_name` varchar(255) DEFAULT NULL COMMENT '外部联系人所在企业的简称',
  `corp_full_name` varchar(255) DEFAULT NULL COMMENT '外部联系人所在企业的主体名称',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (`id`),
  KEY `external_user_id` (`external_user_id`),
  KEY `create_time` (`create_time`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='外部联系人信息'
;
DROP TABLE IF EXISTS `em_cp_user_external_contact`
;
CREATE TABLE `em_cp_user_external_contact` (
  `id` varchar(32) NOT NULL COMMENT '主键',
  `cp_corp_id` varchar(32) DEFAULT NULL COMMENT '企业号基本信息ID',
  `open_user_id` varchar(32) DEFAULT NULL COMMENT '用户在企业号内的唯一标识',
  `external_user_id` varchar(32) DEFAULT NULL COMMENT '外部联系人的userid',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '租户ID',
  PRIMARY KEY (`id`),
  KEY `user_id` (`open_user_id`),
  KEY `external_contact_id` (`external_user_id`),
  KEY `tenant_id` (`tenant_id`)
) COMMENT='企业内部人员于外部联系人关联关系'
;