DROP TABLE IF EXISTS em_cp_domain_file
;
CREATE TABLE em_cp_domain_file (
  id VARCHAR ( 32 ) NOT NULL PRIMARY KEY COMMENT '主键ID',
  cp_corp_id  VARCHAR ( 32 ) NOT NULL COMMENT '文件所属企业号id',
  media_id  VARCHAR ( 50 ) NOT NULL COMMENT '文件id' ,
  file_name   VARCHAR(2000) DEFAULT NULL COMMENT '文件名称',
  STATUS TINYINT(4) DEFAULT '1' COMMENT '状态：1-正常，3-删除',
  create_user_id VARCHAR(32) DEFAULT NULL COMMENT '创建人',
  create_time DATETIME DEFAULT NULL COMMENT '创建时间',
  update_user_id VARCHAR(32) DEFAULT NULL COMMENT '修改人',
  update_time DATETIME DEFAULT NULL COMMENT '修改时间',
  tenant_id VARCHAR(32) DEFAULT NULL COMMENT '企业租户ID',
  KEY cp_corp_id (cp_corp_id)
) COMMENT = '可信域名文件上传记录'
;
DELETE FROM em_sys_cache_configuration WHERE cacheName ='emobile:common:cpdomain'
;
INSERT  INTO em_sys_cache_configuration(cacheName,maxEntriesLocalHeap,maxEntriesLocalDisk,eternal,clearOnFlush,timeToIdleSeconds,timeToLiveSeconds,diskSpoolBufferSizeMB,persistenceStrategy,diskExpiryThreadIntervalSecond,memoryStoreEvictionPolicy,transactionalMode,isDefaultCache,allow_remove) VALUES ('emobile:common:cpdomain',100000,10000000,0,1,1800,1800,1024,'LOCALTEMPSWAP',120,'LRU','OFF',0,1)
;