DROP TABLE IF EXISTS `em_cp_calendar`
;
CREATE TABLE `em_cp_calendar`(
    `id` varchar(32) NOT NULL COMMENT '主键ID',
    `organizer` varchar(32) NOT NULL COMMENT '日历组织者',
    `readonly` int(4) NOT NULL DEFAULT 1 COMMENT '组织者不可在日历上添加日程 0-否 1-是',
    `cal_id` varchar(50) NOT NULL COMMENT '企业微信接口返回的日程id',
    `summary` varchar(128) NOT NULL COMMENT '日历标题',
    `color` varchar(32) NOT NULL COMMENT '日历颜色',
    `description` varchar(512) NOT NULL COMMENT '描述',
    `shares` TEXT NOT NULL COMMENT '日历共享成员列表(<=2000)',
    `corp_id` varchar(64) NOT NULL COMMENT '本地企业号id',
    `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
    `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
    `create_time` datetime DEFAULT NULL COMMENT '创建时间',
    `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
    `update_time` datetime DEFAULT NULL COMMENT '修改时间',
    `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
    PRIMARY KEY (`id`)
) COMMENT = '日历表'
;