DROP TABLE IF EXISTS `em_cp_schedule`
;
CREATE TABLE `em_cp_schedule`(
     `id` varchar(32) NOT NULL COMMENT '主键ID',
     `organizer` varchar(32) NOT NULL COMMENT '日程组织者',
     `start_time` datetime NOT NULL COMMENT '日程开始时间',
     `end_time` datetime NOT NULL COMMENT '日程结束时间',
     `summary` varchar(128) COMMENT '日程标题',
     `description` varchar(512) COMMENT '描述',
     `attendees` TEXT NOT NULL COMMENT '日程参与者列表',
     `location` varchar(128) COMMENT '日程地址',
     `cal_id` varchar(64) COMMENT '日程所属企业微信日历id',
     `schedule_id` varchar(64) NOT NULL COMMENT '企业微信日程id',
     `corp_id` varchar(64) NOT NULL COMMENT '本地企业号id',
     `status` tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，3-删除',
     `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
     `create_time` datetime DEFAULT NULL COMMENT '创建时间',
     `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
     `update_time` datetime DEFAULT NULL COMMENT '修改时间',
     `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
     PRIMARY KEY (`id`)
) COMMENT = '日程表'
;