CREATE TABLE em_agent_extendmenu (
  id VARCHAR (32) NOT NULL COMMENT '主键ID',
  extend_key VARCHAR (32) NOT NULL COMMENT '该分享按钮记录的标识key',
  extend_pkey VARCHAR (32) DEFAULT NULL COMMENT '该分享按钮所属的父按钮记录key，为空表示一级按钮',
  extend_icon VARCHAR (32) DEFAULT NULL COMMENT '该分享按钮图标，默认为空,使用应用或者门户本身logo，如果设置将强制指定',
  extend_name VARCHAR (32) DEFAULT NULL COMMENT '该分享按钮标题，默认为空,使用应用或者门户本身标题，如果设置将强制指定',
  associate_agent_id VARCHAR (32) NOT NULL COMMENT '分享按钮归属的应用id',
  extend_func_type INT DEFAULT 2 COMMENT '分享按钮对应的功能类型，1-打开门户，2-打开应用，3-自定义链接',
  extend_func_setting VARCHAR (200) NOT NULL COMMENT '分享按钮对应的功能数据，当msg_func为1时表示应用id，为3时表示自定义链接地址',
  showorder INT DEFAULT NULL COMMENT '显示顺序',
  STATUS INT DEFAULT 1 COMMENT '状态 1-正常，3-删除',
  create_user_id VARCHAR (32) DEFAULT NULL COMMENT '创建人',
  create_time DATETIME DEFAULT NULL COMMENT '创建时间',
  update_user_id VARCHAR (32) DEFAULT NULL COMMENT '修改人',
  update_time DATETIME DEFAULT NULL COMMENT '修改时间',
  tenant_id VARCHAR (32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (id),
  KEY associate_agent_id (associate_agent_id)
) COMMENT = '消息分享按钮菜单信息表'
;