DROP TABLE IF EXISTS `em_cp_user_opt_log`
;
CREATE TABLE `em_cp_user_opt_log` (
  `id` varchar(32) NOT NULL COMMENT '主键ID',
  `cp_corp_id` varchar(32) DEFAULT NULL COMMENT '企业号基本信息ID',
  `opt_level` varchar(20) DEFAULT NULL COMMENT '操作级别',
  `opt_source` tinyint DEFAULT NULL COMMENT '操作来源：1-从APP同步，2-从EC同步，3-手动创建',
  `opt_type` varchar(50) DEFAULT NULL COMMENT '操作类型',
  `ip` varchar(50) DEFAULT NULL COMMENT '操作ip',
  `brief_info` varchar(100) DEFAULT NULL COMMENT '简要信息',
  `detail_info` mediumtext COMMENT '详细信息',
  `req_body` mediumtext COMMENT '请求信息',
  `resp_body` mediumtext COMMENT '响应信息',
  `original_data` mediumtext COMMENT '原始数据',
  `showorder` bigint COMMENT '显示顺序',
  `status` tinyint(4) DEFAULT 1 COMMENT '状态：1-正常，3-删除',
  `create_user_id` varchar(32) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_user_id` varchar(32) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `tenant_id` varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (`id`),
  KEY `idx_optlog_tenant_id` (`tenant_id`),
  KEY `idx_optlog_ti_cci` (`tenant_id`,`cp_corp_id`),
  KEY `idx_optlog_ti_cci_clb` (`tenant_id`,`cp_corp_id`,`create_time`,`opt_level`,`brief_info`),
  KEY `idx_optlog_ti_cci_csb` (`tenant_id`,`cp_corp_id`,`create_time`,`opt_source`,`brief_info`),
  KEY `idx_optlog_ti_cci_ctb` (`tenant_id`,`cp_corp_id`,`create_time`,`opt_type`,`brief_info`)
) COMMENT='云桥通讯录操作日志表'
;