CREATE TABLE em_agent_base_msgrobot (
  id VARCHAR(32) NOT NULL COMMENT '主键Id保持和agent_base_id一致方便逻辑处理',
  agent_base_id  VARCHAR(32) NOT NULL COMMENT '应用ID',
  bind_baseuser_id  VARCHAR(32) DEFAULT NULL COMMENT '绑定基础用户',
  callback_url  VARCHAR(1000) DEFAULT NULL COMMENT '机器人回调地址（http 接口地址）',
  msg_type  VARCHAR(1000) DEFAULT NULL COMMENT '消息类型,RC:TxtMsg，RC:ImgMsg等',
  token  VARCHAR(200) DEFAULT NULL COMMENT '签名token',
  secret  VARCHAR(200) DEFAULT NULL COMMENT '加密密钥',
  read_status INT DEFAULT 1 COMMENT '阅读状态处理：1-关闭阅读状态、2-回调成功为已读、3-由机器人回执',
  server_id VARCHAR(32) DEFAULT NULL COMMENT '同步到消息服务的id,如果绑定基础用户应该是bind_baseuser_id，如果没有绑定用户应该是agent_base_id',
  PRIMARY KEY (id),
  KEY(agent_base_id)
) COMMENT='消息机器人'
;
