CREATE TABLE em_sys_license_user (
  id VARCHAR(32) NOT NULL COMMENT '主键Id',
  base_user_id  VARCHAR(32) NOT NULL COMMENT '基础用户Id',
  data_user_id  VARCHAR(32) NOT NULL COMMENT '用户所在模块的用户id，比如hrm就是hrmDataId，cp的就是cpDataId',
  cp_type  TINYINT  NOT NULL COMMENT '授权类型：-2-emApp、-1-emPC、1-企业微信、2-钉钉、3-简聊、4-蓝信、5-工作宝、8-金蝶云之家',
  cp_corp_id  VARCHAR(32)  NOT NULL COMMENT '用户所在企业号id，emobile用户企业号id为1，cp为corp企业信息表id',
  status TINYINT DEFAULT NULL COMMENT '状态: 1-正常，2-禁用，3-删除',
  create_time DATETIME DEFAULT NULL COMMENT '创建时间',
  update_time DATETIME DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (id),
  KEY(cp_corp_id),
  KEY(base_user_id)
) COMMENT='授权的已经注册的用户'
;

CREATE TABLE em_sys_license_target (
  id varchar(32) NOT NULL COMMENT '主键ID',
  cp_type  TINYINT  NOT NULL COMMENT '授权类型：-2-emApp、-1-emPC、1-企业微信、2-钉钉、3-简聊、4-蓝信、5-工作宝、8-金蝶云之家',
  cp_corp_id  VARCHAR(32)  NOT NULL COMMENT '用户所在企业号id，emobile用户企业号id为1，cp为corp企业信息表id',
  target_data_type tinyint NOT NULL COMMENT '通讯录数据类型：1-成员，2-部门（含下级），4-部门（不含下级）',
  target_data_id varchar(32) NOT NULL COMMENT '通讯录成员或部门表ID',
  status tinyint DEFAULT '1' COMMENT '状态：1-正常，3-删除',
  create_user_id varchar(32) DEFAULT NULL COMMENT '创建人',
  create_time datetime DEFAULT NULL COMMENT '创建时间',
  update_user_id varchar(32) DEFAULT NULL COMMENT '修改人',
  update_time datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (id),
  KEY cp_corp_id (cp_corp_id),
  KEY target_data_id (target_data_id)
) COMMENT='授权的允许注册的用户对象'
;

delete from em_sys_task where class_name = 'com.weaver.emobile.module.sys.scheduling.SysRegisterUserTask'
;
insert into em_sys_task(id,enabled,class_name,start_time,end_time,cycle,description,`status`,create_user_id,create_time,tenant_id) values ('sysregisterusertask001',1,'com.weaver.emobile.module.sys.scheduling.SysRegisterUserTask','2023-11-14 04:00:00',null,86400000,'矫正注册授权范围和获得注册用户数据',1,'1',now(),'1')
;

