CREATE TABLE em_e10_integrate (
  id varchar(32) NOT NULL COMMENT '主键ID',
  em_name varchar(2000) DEFAULT NULL COMMENT '系统名称',
  em_url  varchar(2000) DEFAULT NULL COMMENT '系统访问地址',
  em_url_open varchar(2000) DEFAULT NULL COMMENT '系统访问外网地址',
  em_corpid varchar(50) DEFAULT NULL COMMENT '系统接入corpid',
  accesstoken varchar(50) DEFAULT NULL COMMENT '系统接入密钥',
  workbench_agentid varchar(200) DEFAULT NULL COMMENT '接入的工作台id',
  ec_id varchar(200) DEFAULT NULL COMMENT '接入的选择的ecology的id',
  status tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，2-禁用，3-删除',
  create_user_id varchar(32) DEFAULT NULL COMMENT '创建人',
  create_time datetime DEFAULT NULL COMMENT '创建时间',
  update_user_id varchar(32) DEFAULT NULL COMMENT '修改人',
  update_time datetime DEFAULT NULL COMMENT '修改时间',
  tenant_id varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (id)
) COMMENT='E10集成系统信息表'
;


CREATE TABLE em_e10_agent (
  id varchar(32) NOT NULL COMMENT '主键ID',
  e10_agentid int(11)  NOT NULL COMMENT 'E10中应用agentid',
  em7_agentid  int(11)  NOT NULL COMMENT 'EM7中应用agentid',
  e10_id  varchar(32) DEFAULT NULL COMMENT 'E10中应用id',
  status tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，2-禁用，3-删除',
  create_user_id varchar(32) DEFAULT NULL COMMENT '创建人',
  create_time datetime DEFAULT NULL COMMENT '创建时间',
  tenant_id varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (id),
  KEY e10_agentid(e10_agentid),
  KEY e10_id(e10_id),
  KEY em7_agentid(em7_agentid)
) COMMENT='E10集成系统信息表'
;
