CREATE TABLE em_sc_vpn (
  id varchar(32) NOT NULL COMMENT '主键ID',
  enable_vpn    tinyint DEFAULT 0 COMMENT '是否启用vpn',
  vpn_type      tinyint DEFAULT 1 COMMENT 'VPN类型，1-深信服，2-天融信',
  vpn_url       varchar(500) DEFAULT NULL COMMENT 'VPN地址',
  login_timing  tinyint DEFAULT NULL COMMENT '客户端登录VPN时机，1-登录app自动登录，2-匹配到地址自动登录',
  acount_timing tinyint DEFAULT NULL COMMENT '客户端获取vpn账号密码时机，1-每次，2，登录APP时',
  acount_type   tinyint DEFAULT NULL COMMENT 'vpn账号密码获取方式：1-默认账号，此时需要配置固定的账号密码，2-em登录账号，vpn的账号密码和登录账号密码一致，3-自定义接口，此时需要配置获取账号密码的接口地址，4-账号映射表，此时需要用户手动维护每个人的账号密码',
  account_loginid    varchar(500) DEFAULT NULL COMMENT 'vpn账号密码获取方式为1时，固定账号的vpn的账号',
  account_password   varchar(1000) DEFAULT NULL COMMENT 'vpn账号密码获取方式为1时，固定账号的vpn的密码', 
  custom_acount_type tinyint DEFAULT NULL COMMENT 'vpn账号密码获取方式为3时，自定义接口的地址调用方式：1-java方式，2-http方式',
  custom_acount_setting  varchar(1000) DEFAULT NULL COMMENT 'vpn账号密码获取方式为3时，自定义接口的地址值',  
  status tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，2-禁用，3-删除',
  create_user_id varchar(32) DEFAULT NULL COMMENT '创建人',
  create_time datetime DEFAULT NULL COMMENT '创建时间',
  update_user_id varchar(32) DEFAULT NULL COMMENT '修改人',
  update_time datetime DEFAULT NULL COMMENT '修改时间',
  tenant_id varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (id)
) COMMENT='vpn基本信息配置表'
;

CREATE TABLE em_sc_vpn_login_matchurl (
  id varchar(32) NOT NULL COMMENT '主键ID',
  match_url   varchar(200) DEFAULT NULL COMMENT '使用匹配到地址自动登录时，设置的配地址清单',
  status tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，2-禁用，3-删除',
  create_user_id varchar(32) DEFAULT NULL COMMENT '创建人',
  create_time datetime DEFAULT NULL COMMENT '创建时间',
  update_user_id varchar(32) DEFAULT NULL COMMENT '修改人',
  update_time datetime DEFAULT NULL COMMENT '修改时间',
  tenant_id varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  PRIMARY KEY (id)
) COMMENT='vpn登录时机的匹配地址表'
;

CREATE TABLE em_sc_vpn_account_detail (
  id varchar(32) NOT NULL COMMENT '主键ID',
  base_user_id varchar(32) DEFAULT NULL ,
  account_loginid    varchar(500) DEFAULT NULL COMMENT '每个用于对应的vpn的账号',
  account_password   varchar(1000) DEFAULT NULL COMMENT '每个用于对应的vpn的密码',
  status tinyint(4) DEFAULT 1 COMMENT '状态 1-正常，2-禁用，3-删除',
  create_user_id varchar(32) DEFAULT NULL COMMENT '创建人',
  create_time datetime DEFAULT NULL COMMENT '创建时间',
  update_user_id varchar(32) DEFAULT NULL COMMENT '修改人',
  update_time datetime DEFAULT NULL COMMENT '修改时间',
  tenant_id varchar(32) DEFAULT NULL COMMENT '企业租户ID',
  index base_user_id(base_user_id),
  PRIMARY KEY (id)
) COMMENT='vpn账号密码映射表'
;

