CREATE TABLE em_agent_base (
  id varchar(32) NOT NULL PRIMARY KEY,
  open_agent_id NUMBER(11,0) DEFAULT NULL,
  agent_type NUMBER(4,0) DEFAULT 1,
  agent_name varchar(100) DEFAULT NULL,
  english_name varchar(100) DEFAULT NULL,
  associate_outsysid varchar(32) DEFAULT NULL,
  description varchar(200) DEFAULT NULL,
  logo varchar(255) DEFAULT NULL,
  enable_home NUMBER(4,0) DEFAULT NULL,
  redirect_domain varchar(100) DEFAULT NULL,
  msg_url varchar(200) DEFAULT NULL,
  share_url varchar(200) DEFAULT NULL,
  dialog_url varchar(200) DEFAULT NULL,
  status_url varchar(200) DEFAULT NULL,
  attention_url varchar(200) DEFAULT NULL,
  home_url varchar(200) DEFAULT NULL,
  home_url_pc varchar(200) DEFAULT NULL,
  manage_url varchar(200) DEFAULT NULL,
  count_url varchar(200) DEFAULT NULL,
  setting_url varchar(200) DEFAULT NULL,
  report_location_flag NUMBER(4,0) DEFAULT NULL,
  isreportenter NUMBER(4,0) DEFAULT NULL,
  ios_pkgname varchar(50) DEFAULT NULL,
  ios_downloadurl varchar(500) DEFAULT NULL,
  and_pkgname varchar(50) DEFAULT NULL,
  and_downloadurl varchar(500) DEFAULT NULL,
  app_auth varchar(100) DEFAULT NULL,
  app_gopage varchar(500) DEFAULT NULL,
  clienttypes varchar(20) DEFAULT NULL,
  isshowinportal NUMBER(4,0) DEFAULT 1,
  isshowinstore NUMBER(4,0) DEFAULT 1,
  enable_msg NUMBER(4,0) DEFAULT NULL,
  isshowinmsg NUMBER(4,0) DEFAULT 0,
  msg_extend_url varchar(200) DEFAULT NULL,
  msg_extend_name varchar(100) DEFAULT NULL,
  msg_extend_logo varchar(255) DEFAULT NULL,
  msg_extend_logo_pc varchar(255) DEFAULT NULL,
  msg_extend_showorder decimal(10, 2) DEFAULT NULL,
  msg_extend_ishead NUMBER(4,0) DEFAULT NULL,
  msg_extend_wwidth NUMBER(11,0) DEFAULT NULL,
  msg_extend_wheight NUMBER(11,0) DEFAULT NULL,
  msg_extend_ispreload NUMBER(4,0) DEFAULT NULL,
  enable_auth NUMBER(4,0) DEFAULT NULL,
  auth_type NUMBER(4,0) DEFAULT NULL,
  auth_access_token varchar(50) DEFAULT NULL,
  auth_userid_field varchar(32) DEFAULT NULL,
  auth_outsysid varchar(32) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT 1,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL,
  server_agent_id varchar(200) DEFAULT NULL
)
;
COMMENT ON TABLE em_agent_base IS '企业应用基本信息表'
;
COMMENT ON COLUMN em_agent_base.id IS '主键ID'
;
COMMENT ON COLUMN em_agent_base.open_agent_id IS 'API交互时的唯一标识，采用某企业内自增长逻辑，即按tenantid自增长'
;
COMMENT ON COLUMN em_agent_base.agent_type IS '应用类型 1-链接型，2-打开第三方APP，3-ecology应用'
;
COMMENT ON COLUMN em_agent_base.agent_name IS '应用名称'
;
COMMENT ON COLUMN em_agent_base.english_name IS '英文名称'
;
COMMENT ON COLUMN em_agent_base.associate_outsysid IS '应用关联的集成系统'
;
COMMENT ON COLUMN em_agent_base.description IS '描述'
;
COMMENT ON COLUMN em_agent_base.logo IS '图标'
;
COMMENT ON COLUMN em_agent_base.enable_home IS '是否开启主页信息'
;
COMMENT ON COLUMN em_agent_base.redirect_domain IS '可信域名'
;
COMMENT ON COLUMN em_agent_base.msg_url IS '消息链接地址'
;
COMMENT ON COLUMN em_agent_base.share_url IS '消息分享地址'
;
COMMENT ON COLUMN em_agent_base.dialog_url IS '消息主页地址：用户在消息会话列表中点击此应用会话时打开的页面地址，不设置则进入系统默认的消息页面'
;
COMMENT ON COLUMN em_agent_base.status_url IS '消息状态接口地址：推送到此应用的消息的状态获取接口地址，例如流程的已处理未处理'
;
COMMENT ON COLUMN em_agent_base.attention_url IS '消息提醒设置地址：用户个性化设置消息提醒的页面地址'
;
COMMENT ON COLUMN em_agent_base.home_url IS '应用主页地址'
;
COMMENT ON COLUMN em_agent_base.home_url_pc IS 'PC版应用主页地址'
;
COMMENT ON COLUMN em_agent_base.manage_url IS '后台管理主页'
;
COMMENT ON COLUMN em_agent_base.count_url IS '统计提示信息数量url地址'
;
COMMENT ON COLUMN em_agent_base.setting_url IS '客户端设置页面'
;
COMMENT ON COLUMN em_agent_base.report_location_flag IS '企业应用是否打开地理位置上报 0：不上报；1：进入会话上报'
;
COMMENT ON COLUMN em_agent_base.isreportenter IS '是否上报用户进入应用事件。0：不接收；1：接收'
;
COMMENT ON COLUMN em_agent_base.ios_pkgname IS '第三方APPiOS应用scheme'
;
COMMENT ON COLUMN em_agent_base.ios_downloadurl IS '第三方APPiOS应用下载地址'
;
COMMENT ON COLUMN em_agent_base.and_pkgname IS '第三方APPAndroid应用包名'
;
COMMENT ON COLUMN em_agent_base.and_downloadurl IS '第三方APPAndroid应用下载地址'
;
COMMENT ON COLUMN em_agent_base.app_auth IS '第三方APP访问验证参数'
;
COMMENT ON COLUMN em_agent_base.app_gopage IS '第三方APP访问直接打开的地址'
;
COMMENT ON COLUMN em_agent_base.clienttypes IS '适用客户端类型：1-PC客户端，2-IOS客户端，3-安卓客户端，4-web版，适用于多个客户端时用逗号分隔表示，值为null或者空字符串时表示适用于所有客户端类型'
;
COMMENT ON COLUMN em_agent_base.isshowinportal IS '是否显示在门户的其他应用分组中 1-显示，0-不显示'
;
COMMENT ON COLUMN em_agent_base.isshowinstore IS '是否显示在应用商店中，即所有应用列表中 1-显示，0-不显示'
;
COMMENT ON COLUMN em_agent_base.enable_msg IS '是否开启消息相关'
;
COMMENT ON COLUMN em_agent_base.isshowinmsg IS '是否显示在消息扩展功能中，即发送消息时的扩展功能按钮 1-显示，0-不显示'
;
COMMENT ON COLUMN em_agent_base.msg_extend_url IS '消息扩展链接地址'
;
COMMENT ON COLUMN em_agent_base.msg_extend_name IS '消息扩展名称，不设置则与应用名称相同'
;
COMMENT ON COLUMN em_agent_base.msg_extend_logo IS '消息扩展图标，不设置则与应用图标相同'
;
COMMENT ON COLUMN em_agent_base.msg_extend_logo_pc IS '消息扩展图标，不设置则与应用图标相同'
;
COMMENT ON COLUMN em_agent_base.msg_extend_showorder IS '消息扩展排序'
;
COMMENT ON COLUMN em_agent_base.msg_extend_ishead IS '应用消息拓展，添加是否显示头'
;
COMMENT ON COLUMN em_agent_base.msg_extend_wwidth IS '应用消息拓展，显示窗口宽度'
;
COMMENT ON COLUMN em_agent_base.msg_extend_wheight IS '应用消息拓展，显示窗口高度'
;
COMMENT ON COLUMN em_agent_base.msg_extend_ispreload IS '消息是否显示预加载'
;
COMMENT ON COLUMN em_agent_base.enable_auth IS '是否开启授权'
;
COMMENT ON COLUMN em_agent_base.auth_type IS '单点登录方式 1：oauth2 2：SHA1 3：ecology'
;
COMMENT ON COLUMN em_agent_base.auth_access_token IS '单点登录秘钥，当auth_type为2时使用'
;
COMMENT ON COLUMN em_agent_base.auth_userid_field IS '单点登录用户标识字段，当auth_type为2时使用，其中1标识基础用户ID，2标识通讯录userid，3标识通讯录手机号，其他表示自定义字段ID'
;
COMMENT ON COLUMN em_agent_base.auth_outsysid IS '单点登录集成系统ID，当auth_type为3时使用，对应em_integrate_outsys_info表的id'
;
COMMENT ON COLUMN em_agent_base.status IS '状态 1-正常，2-禁用，3-删除'
;
COMMENT ON COLUMN em_agent_base.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_agent_base.create_time IS '创建时间'
;
COMMENT ON COLUMN em_agent_base.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_agent_base.update_time IS '修改时间'
;
COMMENT ON COLUMN em_agent_base.tenant_id IS '企业租户ID'
;
CREATE INDEX em_agent_base_oai_idx ON em_agent_base(open_agent_id)
;
CREATE INDEX em_agent_base_bti_idx ON em_agent_base(tenant_id)
;
CREATE TABLE em_agent_msg_log (
  id varchar(32) NOT NULL PRIMARY KEY,
  open_agent_id NUMBER(11,0) DEFAULT NULL,
  touser CLOB,
  toparty CLOB,
  todept CLOB,
  totag CLOB,
  msgtype varchar(10) DEFAULT NULL,
  safe NUMBER(4,0) DEFAULT '0',
  datainfo CLOB,
  requsetinfo CLOB,
  errcode NUMBER(11,0) DEFAULT NULL,
  errmsg varchar(1000) DEFAULT NULL,
  invaliduser CLOB,
  invalidparty CLOB,
  invaliddept CLOB,
  invalidtag CLOB,
  realityreceivers CLOB,
  send_type NUMBER(4,0) DEFAULT NULL,
  send_time TIMESTAMP DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_agent_msg_log IS '企业应用发送消息记录表'
;
COMMENT ON COLUMN em_agent_msg_log.id IS '主键ID'
;
COMMENT ON COLUMN em_agent_msg_log.open_agent_id IS '企业应用openid'
;
COMMENT ON COLUMN em_agent_msg_log.touser IS '成员ID列表（消息接收者，多个接收者用‘|’分隔，最多支持1000个）。特殊情况：指定为@all，则向该企业应用的全部成员发送'
;
COMMENT ON COLUMN em_agent_msg_log.toparty IS '部门ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数'
;
COMMENT ON COLUMN em_agent_msg_log.todept IS '部门ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数'
;
COMMENT ON COLUMN em_agent_msg_log.totag IS '标签ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数'
;
COMMENT ON COLUMN em_agent_msg_log.msgtype IS '消息类型 text-文本，image-图片，voice-语音，video-视频，file-文件，news-图文'
;
COMMENT ON COLUMN em_agent_msg_log.safe IS '表示是否是保密消息，0表示否，1表示是，默认0'
;
COMMENT ON COLUMN em_agent_msg_log.datainfo IS '发送数据的详细信息，json格式的完整内容'
;
COMMENT ON COLUMN em_agent_msg_log.requsetinfo IS '请求数据vo'
;
COMMENT ON COLUMN em_agent_msg_log.errcode IS '发送结果状态码'
;
COMMENT ON COLUMN em_agent_msg_log.errmsg IS '错误信息'
;
COMMENT ON COLUMN em_agent_msg_log.invaliduser IS '无效的成员ID列表'
;
COMMENT ON COLUMN em_agent_msg_log.invalidparty IS '无效的部门ID列表'
;
COMMENT ON COLUMN em_agent_msg_log.invaliddept IS '无效的部门ID列表'
;
COMMENT ON COLUMN em_agent_msg_log.invalidtag IS '无效的标签ID列表'
;
COMMENT ON COLUMN em_agent_msg_log.realityreceivers IS '消息发送实际上所有接收人id'
;
COMMENT ON COLUMN em_agent_msg_log.send_type IS '消息发送类型，1-立即发送，2-定时发送'
;
COMMENT ON COLUMN em_agent_msg_log.send_time IS '消息发送时间，如果为定时发送，这里为定时发送时间'
;
COMMENT ON COLUMN em_agent_msg_log.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_agent_msg_log.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_agent_msg_log.create_time IS '创建时间'
;
COMMENT ON COLUMN em_agent_msg_log.tenant_id IS '企业租户ID'
;
CREATE INDEX em_agent_msg_log_oai_idx ON em_agent_msg_log(open_agent_id)
;
CREATE INDEX em_agent_msg_log_ti_idx ON em_agent_msg_log(tenant_id)
;
CREATE TABLE em_agent_view (
  id varchar(32) NOT NULL PRIMARY KEY,
  agent_base_id varchar(32) DEFAULT NULL,
  hrm_data_id varchar(32) DEFAULT NULL,
  hrm_data_type NUMBER(4,0) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_agent_view IS '企业应用可见范围设置表'
;
COMMENT ON COLUMN em_agent_view.id IS '主键ID'
;
COMMENT ON COLUMN em_agent_view.agent_base_id IS '应用ID'
;
COMMENT ON COLUMN em_agent_view.hrm_data_id IS '通讯录成员或部门表ID'
;
COMMENT ON COLUMN em_agent_view.hrm_data_type IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;
COMMENT ON COLUMN em_agent_view.status IS '状态：1-正常，3-删除'
;
COMMENT ON COLUMN em_agent_view.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_agent_view.create_time IS '创建时间'
;
COMMENT ON COLUMN em_agent_view.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_agent_view.update_time IS '修改时间'
;
COMMENT ON COLUMN em_agent_view.tenant_id IS '企业租户ID'
;
CREATE INDEX em_agent_view_abi_idx ON em_agent_view(agent_base_id)
;
CREATE INDEX em_agent_view_hdi_idx ON em_agent_view(hrm_data_id)
;
CREATE INDEX em_agent_view_ti_idx ON em_agent_view(tenant_id)
;
CREATE TABLE em_demo_user (
  id varchar(32) NOT NULL PRIMARY KEY,
  nick_name varchar(255) DEFAULT NULL,
  username varchar(100) DEFAULT NULL,
  password varchar(255) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL
)
;
CREATE UNIQUE INDEX em_demo_user_username_index ON em_demo_user(username)
;
INSERT INTO em_demo_user VALUES ('1','系统管理员','sysadmin','admin',to_date('2017-07-31 10:56:39','yyyy-mm-dd hh24:mi:ss'),to_date('2017-07-31 10:56:43','yyyy-mm-dd hh24:mi:ss'))
;
INSERT INTO em_demo_user VALUES ('2','管理员','admin','admin',to_date('2017-07-31 10:56:39','yyyy-mm-dd hh24:mi:ss'),to_date('2017-07-31 10:56:43','yyyy-mm-dd hh24:mi:ss'))
;
CREATE TABLE em_ehcache_cluster_node (
  id varchar(32) NOT NULL PRIMARY KEY,
  node_id varchar(191) DEFAULT NULL,
  node_name varchar(255) DEFAULT NULL,
  computer_name varchar(255) DEFAULT NULL,
  local_ips varchar(255) DEFAULT NULL,
  ip_for_cluster varchar(255) DEFAULT NULL,
  os_name varchar(255) DEFAULT NULL,
  last_start_time TIMESTAMP DEFAULT NULL,
  port NUMBER(11,0) DEFAULT NULL,
  remote_object_port NUMBER(11,0) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL
)
;
COMMENT ON TABLE em_ehcache_cluster_node IS '缓存集群节点表'
;
COMMENT ON COLUMN em_ehcache_cluster_node.id IS '主键'
;
COMMENT ON COLUMN em_ehcache_cluster_node.node_id IS '节点id'
;
COMMENT ON COLUMN em_ehcache_cluster_node.node_name IS '节点名称'
;
COMMENT ON COLUMN em_ehcache_cluster_node.computer_name IS '计算机名称'
;
COMMENT ON COLUMN em_ehcache_cluster_node.local_ips IS '本机所有ip地址'
;
COMMENT ON COLUMN em_ehcache_cluster_node.ip_for_cluster IS '缓存集群使用的ip'
;
COMMENT ON COLUMN em_ehcache_cluster_node.os_name IS '操作系统'
;
COMMENT ON COLUMN em_ehcache_cluster_node.last_start_time IS '最后启动时间'
;
COMMENT ON COLUMN em_ehcache_cluster_node.port IS '注册端口'
;
COMMENT ON COLUMN em_ehcache_cluster_node.remote_object_port IS '服务端口'
;
COMMENT ON COLUMN em_ehcache_cluster_node.create_time IS '创建时间'
;
COMMENT ON COLUMN em_ehcache_cluster_node.update_user_id IS '最后修改人'
;
COMMENT ON COLUMN em_ehcache_cluster_node.update_time IS '最后修改时间'
;
CREATE UNIQUE INDEX em_ehcache_cluster_node_ni_idx ON em_ehcache_cluster_node(node_id)
;
CREATE TABLE em_ehcache_cluster_setting (
  id varchar(32) NOT NULL PRIMARY KEY,
  enabled NUMBER(4,0) DEFAULT NULL,
  multicastGroupAddress varchar(255) DEFAULT NULL,
  multicastGroupPort NUMBER(11,0) DEFAULT NULL,
  timeToLive NUMBER(11,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL
)
;
COMMENT ON TABLE em_ehcache_cluster_setting IS '缓存集群设置表'
;
COMMENT ON COLUMN em_ehcache_cluster_setting.id IS '主键'
;
COMMENT ON COLUMN em_ehcache_cluster_setting.enabled IS '是否启用集群'
;
COMMENT ON COLUMN em_ehcache_cluster_setting.multicastGroupAddress IS '缓存集群使用的组播IP'
;
COMMENT ON COLUMN em_ehcache_cluster_setting.multicastGroupPort IS '缓存集群使用的端口'
;
COMMENT ON COLUMN em_ehcache_cluster_setting.timeToLive IS '缓存组播范围'
;
COMMENT ON COLUMN em_ehcache_cluster_setting.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_ehcache_cluster_setting.create_time IS '创建时间'
;
COMMENT ON COLUMN em_ehcache_cluster_setting.update_user_id IS '最后修改人'
;
COMMENT ON COLUMN em_ehcache_cluster_setting.update_time IS '最后修改时间'
;
CREATE TABLE em_hrm_dept (
  id varchar(32) NOT NULL PRIMARY KEY,
  open_dept_id NUMBER(11,0) DEFAULT NULL,
  dept_name varchar(100) DEFAULT NULL,
  english_name varchar(100) DEFAULT NULL,
  parent_id varchar(32) DEFAULT NULL,
  all_parent_ids varchar(1000) DEFAULT NULL,
  showorder decimal(10,2) DEFAULT NULL,
  outsys_id varchar(32) DEFAULT NULL,
  outsys_dept_type NUMBER(4,0) DEFAULT NULL,
  outsys_dept_id varchar(32) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_hrm_dept IS '企业通信录部门表'
;
COMMENT ON COLUMN em_hrm_dept.id IS '主键ID'
;
COMMENT ON COLUMN em_hrm_dept.open_dept_id IS 'API交互时的唯一标识，采用某企业内自增长逻辑，即按tenantid自增长'
;
COMMENT ON COLUMN em_hrm_dept.dept_name IS '部门名称'
;
COMMENT ON COLUMN em_hrm_dept.english_name IS '英文名称'
;
COMMENT ON COLUMN em_hrm_dept.parent_id IS '上级部门ID'
;
COMMENT ON COLUMN em_hrm_dept.all_parent_ids IS '所有上级部门ID用逗号分隔'
;
COMMENT ON COLUMN em_hrm_dept.showorder IS '显示顺序'
;
COMMENT ON COLUMN em_hrm_dept.outsys_id IS '对应集成系统的ID'
;
COMMENT ON COLUMN em_hrm_dept.outsys_dept_type IS '对应集成系统部门类型'
;
COMMENT ON COLUMN em_hrm_dept.outsys_dept_id IS '对应集成系统部门ID'
;
COMMENT ON COLUMN em_hrm_dept.status IS '状态 1-正常，2-封存，3-删除'
;
COMMENT ON COLUMN em_hrm_dept.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_hrm_dept.create_time IS '创建时间'
;
COMMENT ON COLUMN em_hrm_dept.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_hrm_dept.update_time IS '修改时间'
;
COMMENT ON COLUMN em_hrm_dept.tenant_id IS '企业租户ID'
;
CREATE INDEX em_hrm_dept_open_dept_id_index ON em_hrm_dept(open_dept_id)
;
CREATE INDEX em_hrm_dept_parent_id_index ON em_hrm_dept(parent_id)
;
CREATE INDEX em_hrm_dept_tenant_id_index ON em_hrm_dept(tenant_id)
;
INSERT INTO em_hrm_dept VALUES ('1',1,'默认企业',NULL,'0','',NULL,NULL,NULL,NULL,1,'1',sysdate,NULL,NULL,'1')
;
CREATE TABLE em_hrm_dept_temp (
  id varchar(32) NOT NULL PRIMARY KEY,
  outsys_id varchar(32) DEFAULT NULL,
  dept_name varchar(100) DEFAULT NULL,
  outsys_dept_id varchar(32) DEFAULT NULL,
  outsys_dept_pid varchar(32) DEFAULT NULL,
  outsys_dept_pid2 varchar(32) DEFAULT NULL,
  outsys_dept_type NUMBER(4,0) DEFAULT NULL,
  showorder NUMBER(11,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_hrm_dept_temp IS '通讯录与Ecology系统同步部门临时表'
;
COMMENT ON COLUMN em_hrm_dept_temp.id IS '主键ID'
;
COMMENT ON COLUMN em_hrm_dept_temp.outsys_id IS '对应的Ecology系统ID'
;
COMMENT ON COLUMN em_hrm_dept_temp.dept_name IS 'Ecology系统中部门名称'
;
COMMENT ON COLUMN em_hrm_dept_temp.outsys_dept_id IS 'Ecology系统中部门ID'
;
COMMENT ON COLUMN em_hrm_dept_temp.outsys_dept_pid IS 'Ecology系统中部门的上级部门ID'
;
COMMENT ON COLUMN em_hrm_dept_temp.outsys_dept_pid2 IS 'Ecology系统中部门的上级分部ID'
;
COMMENT ON COLUMN em_hrm_dept_temp.outsys_dept_type IS 'Ecology系统中部门的类型 1表示分部 2表示部门'
;
COMMENT ON COLUMN em_hrm_dept_temp.showorder IS 'Ecology系统中部门的显示顺序'
;
COMMENT ON COLUMN em_hrm_dept_temp.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_hrm_dept_temp.create_time IS '创建时间'
;
COMMENT ON COLUMN em_hrm_dept_temp.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_hrm_dept_temp.update_time IS '修改时间'
;
COMMENT ON COLUMN em_hrm_dept_temp.tenant_id IS '企业租户ID'
;
CREATE TABLE em_hrm_dept_user (
  id varchar(32) NOT NULL PRIMARY KEY,
  hrm_user_id varchar(32) DEFAULT NULL,
  hrm_dept_id varchar(32) DEFAULT NULL,
  showorder decimal(10,2) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_hrm_dept_user IS '企业通讯录成员与部门关联表'
;
COMMENT ON COLUMN em_hrm_dept_user.id IS '主键ID'
;
COMMENT ON COLUMN em_hrm_dept_user.hrm_user_id IS '通讯录人员表ID'
;
COMMENT ON COLUMN em_hrm_dept_user.hrm_dept_id IS '通讯录部门表ID'
;
COMMENT ON COLUMN em_hrm_dept_user.showorder IS '显示顺序'
;
COMMENT ON COLUMN em_hrm_dept_user.status IS '状态：1-正常，3-删除'
;
COMMENT ON COLUMN em_hrm_dept_user.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_hrm_dept_user.create_time IS '创建时间'
;
COMMENT ON COLUMN em_hrm_dept_user.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_hrm_dept_user.update_time IS '修改时间'
;
COMMENT ON COLUMN em_hrm_dept_user.tenant_id IS '企业租户ID'
;
CREATE INDEX em_hrm_dept_user_hui_idx ON em_hrm_dept_user(hrm_user_id)
;
CREATE INDEX em_hrm_dept_user_hdi_idx ON em_hrm_dept_user(hrm_dept_id)
;
CREATE INDEX em_hrm_dept_user_ti_idx ON em_hrm_dept_user(tenant_id)
;
CREATE TABLE em_hrm_group (
  id varchar(32) NOT NULL PRIMARY KEY,
  open_group_id NUMBER(11,0) DEFAULT NULL,
  group_name varchar(100) DEFAULT NULL,
  english_name varchar(100) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT NULL,
  relate_role_id varchar(32) DEFAULT NULL,
  group_type NUMBER(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_hrm_group IS '企业通信录分组表'
;
COMMENT ON COLUMN em_hrm_group.id IS '主键ID'
;
COMMENT ON COLUMN em_hrm_group.open_group_id IS 'API交互时的唯一标识，采用某企业内自增长逻辑，即按tenantid自增长'
;
COMMENT ON COLUMN em_hrm_group.group_name IS '分组名称'
;
COMMENT ON COLUMN em_hrm_group.english_name IS '英文名称'
;
COMMENT ON COLUMN em_hrm_group.status IS '状态 1-正常，2-禁用，3-删除'
;
COMMENT ON COLUMN em_hrm_group.relate_role_id IS '分组所属角色ID，关联em_setting_role表的主键，如果为0则表示超级管理员创建'
;
COMMENT ON COLUMN em_hrm_group.group_type IS '类型，1-通用分组，2-私人分组'
;
COMMENT ON COLUMN em_hrm_group.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_hrm_group.create_time IS '创建时间'
;
COMMENT ON COLUMN em_hrm_group.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_hrm_group.update_time IS '修改时间'
;
COMMENT ON COLUMN em_hrm_group.tenant_id IS '企业租户ID'
;
CREATE INDEX em_hrm_group_ogi_idx ON em_hrm_group(open_group_id)
;
CREATE INDEX em_hrm_group_ti_idx ON em_hrm_group(tenant_id)
;
CREATE INDEX em_hrm_group_rri_idx ON em_hrm_group(relate_role_id)
;
CREATE TABLE em_hrm_group_user (
  id varchar(32) NOT NULL PRIMARY KEY,
  hrm_group_id varchar(32) DEFAULT NULL,
  hrm_data_id varchar(32) DEFAULT NULL,
  hrm_data_type NUMBER(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_hrm_group_user IS '企业通讯录分组与成员及部门关联表'
;
COMMENT ON COLUMN em_hrm_group_user.id IS '主键ID'
;
COMMENT ON COLUMN em_hrm_group_user.hrm_group_id IS '通讯录分组表ID'
;
COMMENT ON COLUMN em_hrm_group_user.hrm_data_id IS '通讯录成员或部门表ID'
;
COMMENT ON COLUMN em_hrm_group_user.hrm_data_type IS '通讯录数据类型：1-成员，2-部门(不包含下级部门)，3-部门(包含下级部门)'
;
COMMENT ON COLUMN em_hrm_group_user.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_hrm_group_user.status IS '状态 1-正常，2-禁用，3-删除'
;
COMMENT ON COLUMN em_hrm_group_user.create_time IS '创建时间'
;
COMMENT ON COLUMN em_hrm_group_user.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_hrm_group_user.update_time IS '修改时间'
;
COMMENT ON COLUMN em_hrm_group_user.tenant_id IS '企业租户ID'
;
CREATE INDEX em_hrm_group_user_hgi_idx ON em_hrm_group_user(hrm_group_id)
;
CREATE INDEX em_hrm_group_user_hdi_idx ON em_hrm_group_user(hrm_data_id)
;
CREATE INDEX em_hrm_group_user_ti_idx ON em_hrm_group_user(tenant_id)
;
CREATE TABLE em_hrm_group_view (
  id varchar(32) NOT NULL PRIMARY KEY,
  hrm_group_id varchar(32) DEFAULT NULL,
  hrm_data_id varchar(32) DEFAULT NULL,
  hrm_data_type NUMBER(4,0) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_hrm_group_view IS '企业应用可见范围设置表'
;
COMMENT ON COLUMN em_hrm_group_view.id IS '主键ID'
;
COMMENT ON COLUMN em_hrm_group_view.hrm_group_id IS '组ID'
;
COMMENT ON COLUMN em_hrm_group_view.hrm_data_id IS '通讯录成员或部门表ID'
;
COMMENT ON COLUMN em_hrm_group_view.hrm_data_type IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;
COMMENT ON COLUMN em_hrm_group_view.status IS '状态：1-正常，3-删除'
;
COMMENT ON COLUMN em_hrm_group_view.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_hrm_group_view.create_time IS '创建时间'
;
COMMENT ON COLUMN em_hrm_group_view.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_hrm_group_view.update_time IS '修改时间'
;
COMMENT ON COLUMN em_hrm_group_view.tenant_id IS '企业租户ID'
;
CREATE INDEX em_hrm_group_view_hgi_idx ON em_hrm_group_view(hrm_group_id)
;
CREATE INDEX em_hrm_group_view_hdi_idx ON em_hrm_group_view(hrm_data_id)
;
CREATE INDEX em_hrm_group_view_ti_idx ON em_hrm_group_view(tenant_id)
;
CREATE TABLE em_hrm_tag (
  id varchar(32) NOT NULL PRIMARY KEY,
  open_tag_id NUMBER(11,0) DEFAULT NULL,
  tag_name varchar(100) DEFAULT NULL,
  english_name varchar(100) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  relate_role_id varchar(32) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_hrm_tag IS '企业通信录标签表'
;
COMMENT ON COLUMN em_hrm_tag.id IS '主键ID'
;
COMMENT ON COLUMN em_hrm_tag.open_tag_id IS 'API交互时的唯一标识，采用某企业内自增长逻辑，即按tenantid自增长'
;
COMMENT ON COLUMN em_hrm_tag.tag_name IS '标签名称'
;
COMMENT ON COLUMN em_hrm_tag.english_name IS '英文名称'
;
COMMENT ON COLUMN em_hrm_tag.status IS '状态 1-正常，2-禁用，3-删除'
;
COMMENT ON COLUMN em_hrm_tag.relate_role_id IS '标签所属角色ID，关联em_setting_role表的主键，如果为0则表示超级管理员创建'
;
COMMENT ON COLUMN em_hrm_tag.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_hrm_tag.create_time IS '创建时间'
;
COMMENT ON COLUMN em_hrm_tag.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_hrm_tag.update_time IS '修改时间'
;
COMMENT ON COLUMN em_hrm_tag.tenant_id IS '企业租户ID'
;
CREATE INDEX em_hrm_tag_oti_idx ON em_hrm_tag(open_tag_id)
;
CREATE INDEX em_hrm_tag_ti_idx ON em_hrm_tag(tenant_id)
;
CREATE INDEX em_hrm_tag_rri_idx ON em_hrm_tag(relate_role_id)
;
CREATE TABLE em_hrm_tag_user (
  id varchar(32) NOT NULL PRIMARY KEY,
  hrm_tag_id varchar(32) DEFAULT NULL,
  hrm_data_id varchar(32) DEFAULT NULL,
  hrm_data_type NUMBER(4,0) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_hrm_tag_user IS '企业通讯录标签与成员及部门关联表'
;
COMMENT ON COLUMN em_hrm_tag_user.id IS '主键ID'
;
COMMENT ON COLUMN em_hrm_tag_user.hrm_tag_id IS '通讯录标签表ID'
;
COMMENT ON COLUMN em_hrm_tag_user.hrm_data_id IS '通讯录成员或部门表ID'
;
COMMENT ON COLUMN em_hrm_tag_user.hrm_data_type IS '通讯录数据类型：1-成员，2-部门(不包含下级部门)，3-部门(包含下级部门)'
;
COMMENT ON COLUMN em_hrm_tag_user.status IS '状态：1-正常，3-删除'
;
COMMENT ON COLUMN em_hrm_tag_user.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_hrm_tag_user.create_time IS '创建时间'
;
COMMENT ON COLUMN em_hrm_tag_user.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_hrm_tag_user.update_time IS '修改时间'
;
COMMENT ON COLUMN em_hrm_tag_user.tenant_id IS '企业租户ID'
;
CREATE INDEX em_hrm_tag_user_hti_idx ON em_hrm_tag_user(hrm_tag_id)
;
CREATE INDEX em_hrm_tag_user_hdi_idx ON em_hrm_tag_user(hrm_data_id)
;
CREATE INDEX em_hrm_tag_user_ti_idx ON em_hrm_tag_user(tenant_id)
;
CREATE TABLE em_hrm_user (
  id varchar(32) NOT NULL PRIMARY KEY,
  open_user_id varchar(100) DEFAULT NULL,
  user_name varchar(100) DEFAULT NULL,
  name_simple_pingyin varchar(500) DEFAULT NULL,
  name_full_pingyin varchar(500) DEFAULT NULL,
  nick_name varchar(100) DEFAULT NULL,
  english_name varchar(100) DEFAULT NULL,
  mobile varchar(50) DEFAULT NULL,
  mobile_prefix varchar(32) DEFAULT NULL,
  position varchar(100) DEFAULT NULL,
  gender NUMBER(4,0) DEFAULT NULL,
  email varchar(100) DEFAULT NULL,
  telephone varchar(100) DEFAULT NULL,
  otherphone varchar(50) DEFAULT NULL,
  avatar varchar(255) DEFAULT NULL,
  showorder decimal(10,2) DEFAULT NULL,
  isleader NUMBER(4,0) DEFAULT NULL,
  isadmin NUMBER(4,0) DEFAULT NULL,
  manager_id varchar(32) DEFAULT NULL,
  admin_password varchar(100) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  base_user_id varchar(32) DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_hrm_user IS '企业通讯录成员表'
;
COMMENT ON COLUMN em_hrm_user.id IS '主键ID'
;
COMMENT ON COLUMN em_hrm_user.open_user_id IS '用户在企业内的唯一标识'
;
COMMENT ON COLUMN em_hrm_user.user_name IS '姓名'
;
COMMENT ON COLUMN em_hrm_user.name_simple_pingyin IS '名字拼音简拼'
;
COMMENT ON COLUMN em_hrm_user.name_full_pingyin IS '名字拼音全拼'
;
COMMENT ON COLUMN em_hrm_user.nick_name IS '昵称'
;
COMMENT ON COLUMN em_hrm_user.english_name IS '英文名'
;
COMMENT ON COLUMN em_hrm_user.mobile IS '手机-企业内唯一'
;
COMMENT ON COLUMN em_hrm_user.mobile_prefix IS '国际手机区号'
;
COMMENT ON COLUMN em_hrm_user.position IS '岗位'
;
COMMENT ON COLUMN em_hrm_user.gender IS '性别 1表示男性，2表示女性，0表示未知'
;
COMMENT ON COLUMN em_hrm_user.email IS '邮箱'
;
COMMENT ON COLUMN em_hrm_user.telephone IS '座机'
;
COMMENT ON COLUMN em_hrm_user.otherphone IS '其他电话'
;
COMMENT ON COLUMN em_hrm_user.avatar IS '头像'
;
COMMENT ON COLUMN em_hrm_user.showorder IS '显示顺序'
;
COMMENT ON COLUMN em_hrm_user.isleader IS '标识是否为上级 1-是，0-否'
;
COMMENT ON COLUMN em_hrm_user.isadmin IS '是否为管理员 1-是，0-否'
;
COMMENT ON COLUMN em_hrm_user.manager_id IS '所属上级人员，管理该表主键id'
;
COMMENT ON COLUMN em_hrm_user.admin_password IS '管理密码'
;
COMMENT ON COLUMN em_hrm_user.status IS '状态 1=已激活，2=已禁用，3=已删除，4=未激活，5=已离职，6=已退出'
;
COMMENT ON COLUMN em_hrm_user.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_hrm_user.create_time IS '创建时间'
;
COMMENT ON COLUMN em_hrm_user.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_hrm_user.update_time IS '修改时间'
;
COMMENT ON COLUMN em_hrm_user.base_user_id IS '基础用户ID'
;
COMMENT ON COLUMN em_hrm_user.tenant_id IS '企业租户ID'
;
CREATE INDEX em_hrm_user_open_user_id_index ON em_hrm_user(open_user_id)
;
CREATE INDEX em_hrm_user_base_user_id_index ON em_hrm_user(base_user_id)
;
CREATE INDEX em_hrm_user_tenant_id_index ON em_hrm_user(tenant_id)
;
CREATE INDEX em_hrm_user_manager_id_index ON em_hrm_user(manager_id)
;
CREATE TABLE em_hrm_user_account (
  id varchar(32) NOT NULL PRIMARY KEY,
  hrm_user_id varchar(32) DEFAULT NULL,
  outsys_id varchar(32) DEFAULT NULL,
  outsys_user_id varchar(32) DEFAULT NULL,
  outsys_user_name varchar(100) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_hrm_user_account IS '通讯录成员与集成系统人员关联表'
;
COMMENT ON COLUMN em_hrm_user_account.id IS '主键ID'
;
COMMENT ON COLUMN em_hrm_user_account.hrm_user_id IS 'HRM用户ID'
;
COMMENT ON COLUMN em_hrm_user_account.outsys_id IS '集成系统ID'
;
COMMENT ON COLUMN em_hrm_user_account.outsys_user_id IS '集成系统中的用户ID'
;
COMMENT ON COLUMN em_hrm_user_account.outsys_user_name IS '集成系统中的用户姓名'
;
COMMENT ON COLUMN em_hrm_user_account.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_hrm_user_account.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_hrm_user_account.create_time IS '创建时间'
;
COMMENT ON COLUMN em_hrm_user_account.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_hrm_user_account.update_time IS '修改时间'
;
COMMENT ON COLUMN em_hrm_user_account.tenant_id IS '企业租户ID'
;
CREATE INDEX em_hrm_user_account_hui_idx ON em_hrm_user_account(hrm_user_id)
;
CREATE INDEX em_hrm_user_account_oui_idx ON em_hrm_user_account(outsys_user_id)
;
CREATE TABLE em_hrm_user_attr (
  id varchar(32) NOT NULL PRIMARY KEY,
  attr_name varchar(100) DEFAULT NULL,
  english_name varchar(100) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_hrm_user_attr IS '企业通讯录成员自定义字段定义表'
;
COMMENT ON COLUMN em_hrm_user_attr.id IS '主键ID'
;
COMMENT ON COLUMN em_hrm_user_attr.attr_name IS '自定义字段名称'
;
COMMENT ON COLUMN em_hrm_user_attr.english_name IS '自定义字段英文名称'
;
COMMENT ON COLUMN em_hrm_user_attr.status IS '状态 1=正常，3=已删除'
;
COMMENT ON COLUMN em_hrm_user_attr.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_hrm_user_attr.create_time IS '创建时间'
;
COMMENT ON COLUMN em_hrm_user_attr.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_hrm_user_attr.update_time IS '修改时间'
;
COMMENT ON COLUMN em_hrm_user_attr.tenant_id IS '企业租户ID'
;
CREATE INDEX em_hrm_user_attr_ti_idx ON em_hrm_user_attr(tenant_id)
;
CREATE TABLE em_hrm_user_attr_value (
  id varchar(32) NOT NULL PRIMARY KEY,
  hrm_user_id varchar(32) DEFAULT NULL,
  attr_id varchar(32) DEFAULT NULL,
  attr_value varchar(100) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_hrm_user_attr_value IS '企业通讯录成员自定义字段内容表'
;
COMMENT ON COLUMN em_hrm_user_attr_value.id IS '主键ID'
;
COMMENT ON COLUMN em_hrm_user_attr_value.hrm_user_id IS '企业通讯录成员ID'
;
COMMENT ON COLUMN em_hrm_user_attr_value.attr_id IS '自定义字段定义表ID'
;
COMMENT ON COLUMN em_hrm_user_attr_value.attr_value IS '自定义字段值'
;
COMMENT ON COLUMN em_hrm_user_attr_value.status IS '状态 1=正常，3=已删除'
;
COMMENT ON COLUMN em_hrm_user_attr_value.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_hrm_user_attr_value.create_time IS '创建时间'
;
COMMENT ON COLUMN em_hrm_user_attr_value.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_hrm_user_attr_value.update_time IS '修改时间'
;
COMMENT ON COLUMN em_hrm_user_attr_value.tenant_id IS '企业租户ID'
;
CREATE INDEX em_hrm_user_attr_value_ti_idx ON em_hrm_user_attr_value(tenant_id)
;
CREATE TABLE em_hrm_user_code (
  auth_code varchar(100) NOT NULL PRIMARY KEY,
  base_user_id varchar(32) NOT NULL,
  tenant_id varchar(32) DEFAULT NULL,
  device_id varchar(100) DEFAULT NULL,
  expire_time TIMESTAMP DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  agent_base_id varchar(50) DEFAULT NULL
)
;
COMMENT ON TABLE em_hrm_user_code IS '企业用户授权code信息'
;
COMMENT ON COLUMN em_hrm_user_code.auth_code IS '授权code'
;
COMMENT ON COLUMN em_hrm_user_code.base_user_id IS '基础用户ID'
;
COMMENT ON COLUMN em_hrm_user_code.tenant_id IS '企业租户ID'
;
COMMENT ON COLUMN em_hrm_user_code.device_id IS '手机设备号'
;
COMMENT ON COLUMN em_hrm_user_code.expire_time IS '过期时间'
;
COMMENT ON COLUMN em_hrm_user_code.status IS '状态 1-正常，2-无效，3-删除'
;
COMMENT ON COLUMN em_hrm_user_code.agent_base_id IS '应用授权时候，绑定的应用主键id'
;
CREATE INDEX em_hrm_user_code_bui_idx ON em_hrm_user_code(base_user_id)
;
CREATE INDEX em_hrm_user_code_ti_idx ON em_hrm_user_code(tenant_id)
;
CREATE TABLE em_hrm_user_sync_cond (
  id varchar(32) NOT NULL PRIMARY KEY,
  outsys_id varchar(32) DEFAULT NULL,
  cond_type NUMBER(4,0) DEFAULT NULL,
  auth_type NUMBER(4,0) DEFAULT NULL,
  auth_type_name varchar(32) DEFAULT NULL,
  auth_value varchar(32) DEFAULT NULL,
  auth_value_name varchar(32) DEFAULT NULL,
  auth_seclevel varchar(32) DEFAULT NULL,
  showorder NUMBER(11,0) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_hrm_user_sync_cond IS '通讯录成员与集成系统人员同步条件表'
;
COMMENT ON COLUMN em_hrm_user_sync_cond.id IS '主键ID'
;
COMMENT ON COLUMN em_hrm_user_sync_cond.outsys_id IS '集成系统ID'
;
COMMENT ON COLUMN em_hrm_user_sync_cond.cond_type IS '条件类型：1-人员，2-部门，3-分部'
;
COMMENT ON COLUMN em_hrm_user_sync_cond.auth_type IS '规则类型：0-人员，1-分部，2-部门，3-角色，4-所有人'
;
COMMENT ON COLUMN em_hrm_user_sync_cond.auth_type_name IS '规则类型显示名'
;
COMMENT ON COLUMN em_hrm_user_sync_cond.auth_value IS '规则类型值'
;
COMMENT ON COLUMN em_hrm_user_sync_cond.auth_value_name IS '规则类型值显示名'
;
COMMENT ON COLUMN em_hrm_user_sync_cond.auth_seclevel IS '规则安全级别'
;
COMMENT ON COLUMN em_hrm_user_sync_cond.showorder IS '显示顺序'
;
COMMENT ON COLUMN em_hrm_user_sync_cond.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_hrm_user_sync_cond.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_hrm_user_sync_cond.create_time IS '创建时间'
;
COMMENT ON COLUMN em_hrm_user_sync_cond.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_hrm_user_sync_cond.update_time IS '修改时间'
;
COMMENT ON COLUMN em_hrm_user_sync_cond.tenant_id IS '企业租户ID'
;
CREATE INDEX em_hrm_user_sync_cond_oi_idx ON em_hrm_user_sync_cond(outsys_id)
;
CREATE TABLE em_hrm_user_sync_set (
  id varchar(32) NOT NULL PRIMARY KEY,
  outsys_id varchar(32) DEFAULT NULL,
  sys_task_id varchar(32) DEFAULT NULL,
  root_dept_id varchar(32) DEFAULT NULL,
  baseid_type NUMBER(4,0) DEFAULT '1',
  userid_field NUMBER(4,0) DEFAULT '1',
  match_user_field NUMBER(4,0) DEFAULT '1',
  match_outsys_field NUMBER(4,0) DEFAULT '1',
  user_del_type NUMBER(4,0) DEFAULT '1',
  dept_sync_type NUMBER(4,0) DEFAULT '1',
  isalluser NUMBER(4,0) DEFAULT '0',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_hrm_user_sync_set IS '通讯录成员与集成系统人员同步设置表'
;
COMMENT ON COLUMN em_hrm_user_sync_set.id IS '主键ID'
;
COMMENT ON COLUMN em_hrm_user_sync_set.outsys_id IS '集成系统ID'
;
COMMENT ON COLUMN em_hrm_user_sync_set.sys_task_id IS '定时同步任务ID'
;
COMMENT ON COLUMN em_hrm_user_sync_set.root_dept_id IS '顶级部门ID，对应em_hrm_dept表主键ID'
;
COMMENT ON COLUMN em_hrm_user_sync_set.baseid_type IS '新成员生成基础用户信息时ID的规则：1-使用系统默认的uuid ，2-使用ecology系统的数据库ID'
;
COMMENT ON COLUMN em_hrm_user_sync_set.userid_field IS '新成员账号字段：1-数据库ID ，2-登录账号，3-手机号'
;
COMMENT ON COLUMN em_hrm_user_sync_set.match_user_field IS '已存在成员本系统的匹配字段：1-账号 ，2-手机号，3-邮箱'
;
COMMENT ON COLUMN em_hrm_user_sync_set.match_outsys_field IS '已存在成员集成系统的匹配字段：1-数据库ID ，2-登录账号，3-手机，4-邮箱'
;
COMMENT ON COLUMN em_hrm_user_sync_set.user_del_type IS '离职成员的处理方式：1-禁用 ，2-删除'
;
COMMENT ON COLUMN em_hrm_user_sync_set.dept_sync_type IS '部门同步方式：1-同步部门 2-不同步部门且将人员移动到顶级部门下 3-不同步部门且人员部门信息不变'
;
COMMENT ON COLUMN em_hrm_user_sync_set.isalluser IS '是否同步无账号人员：0-否 ，1-是'
;
COMMENT ON COLUMN em_hrm_user_sync_set.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_hrm_user_sync_set.create_time IS '创建时间'
;
COMMENT ON COLUMN em_hrm_user_sync_set.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_hrm_user_sync_set.update_time IS '修改时间'
;
COMMENT ON COLUMN em_hrm_user_sync_set.tenant_id IS '企业租户ID'
;
CREATE INDEX em_hrm_user_sync_set_oi_idx ON em_hrm_user_sync_set(outsys_id)
;
CREATE TABLE em_hrm_user_sync_state (
  id varchar(32) NOT NULL PRIMARY KEY,
  sync_state NUMBER(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_hrm_user_sync_state IS '通讯录成员与集成系统人员同步状态表'
;
COMMENT ON COLUMN em_hrm_user_sync_state.id IS '主键ID'
;
COMMENT ON COLUMN em_hrm_user_sync_state.sync_state IS '同步状态：1-未同步，2-同步中'
;
COMMENT ON COLUMN em_hrm_user_sync_state.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_hrm_user_sync_state.create_time IS '创建时间'
;
COMMENT ON COLUMN em_hrm_user_sync_state.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_hrm_user_sync_state.update_time IS '修改时间'
;
COMMENT ON COLUMN em_hrm_user_sync_state.tenant_id IS '企业租户ID'
;
CREATE TABLE em_integrate_outsys_info (
  id varchar(32) NOT NULL PRIMARY KEY,
  sys_name varchar(50) DEFAULT NULL,
  sys_type NUMBER(4,0) DEFAULT '1',
  sys_url varchar(100) DEFAULT NULL,
  sys_url_open varchar(100) DEFAULT NULL,
  sys_url_pc varchar(100) DEFAULT NULL,
  sys_accesstoken varchar(50) DEFAULT NULL,
  sys_uuid varchar(50) DEFAULT NULL,
  rsa_pub varchar(1000) DEFAULT NULL,
  auth_type NUMBER(4,0) DEFAULT NULL,
  redirect_domain varchar(100) DEFAULT NULL,
  auth_access_token varchar(50) DEFAULT NULL,
  auth_userid_field varchar(32) DEFAULT NULL,
  remark varchar(200) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_integrate_outsys_info IS '集成系统信息表'
;
COMMENT ON COLUMN em_integrate_outsys_info.id IS '主键ID'
;
COMMENT ON COLUMN em_integrate_outsys_info.sys_name IS '系统名称'
;
COMMENT ON COLUMN em_integrate_outsys_info.sys_type IS '系统类型：1-ecology系统'
;
COMMENT ON COLUMN em_integrate_outsys_info.sys_url IS '系统访问地址'
;
COMMENT ON COLUMN em_integrate_outsys_info.sys_url_open IS '系统移动端访问地址'
;
COMMENT ON COLUMN em_integrate_outsys_info.sys_url_pc IS '系统pc端访问地址'
;
COMMENT ON COLUMN em_integrate_outsys_info.sys_accesstoken IS '系统接入秘钥'
;
COMMENT ON COLUMN em_integrate_outsys_info.sys_uuid IS '系统uuid标识'
;
COMMENT ON COLUMN em_integrate_outsys_info.rsa_pub IS '集成系统约定间加密秘钥'
;
COMMENT ON COLUMN em_integrate_outsys_info.auth_type IS '单点登录方式：0:未设置,1：oauth2 2：SHA1 3：AUTH_CODE'
;
COMMENT ON COLUMN em_integrate_outsys_info.redirect_domain IS '授权类型未1 oauth2 时，使用的可信域名'
;
COMMENT ON COLUMN em_integrate_outsys_info.auth_access_token IS '单点登录秘钥，当auth_type为2时使用'
;
COMMENT ON COLUMN em_integrate_outsys_info.auth_userid_field IS '单点登录用户标识字段，-1表示继承系统ecology方式，需根据集成系统id获得对应的继承系统用户所在id，其中1标识基础用户ID，2标识通讯录userid，3标识通讯录手机号，其他表示自定义字段ID'
;
COMMENT ON COLUMN em_integrate_outsys_info.remark IS '备注'
;
COMMENT ON COLUMN em_integrate_outsys_info.status IS '状态 1-正常，2-禁用，3-删除'
;
COMMENT ON COLUMN em_integrate_outsys_info.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_integrate_outsys_info.create_time IS '创建时间'
;
COMMENT ON COLUMN em_integrate_outsys_info.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_integrate_outsys_info.update_time IS '修改时间'
;
COMMENT ON COLUMN em_integrate_outsys_info.tenant_id IS '企业租户ID'
;
CREATE INDEX em_integrate_o_i_su_idx ON em_integrate_outsys_info(sys_uuid)
;
CREATE TABLE em_license (
  id varchar(32) NOT NULL PRIMARY KEY,
  custom_id varchar(32) DEFAULT NULL,
  company_name varchar(255) DEFAULT NULL,
  company_name_zh_cn varchar(255) DEFAULT NULL,
  identification_number varchar(32) DEFAULT NULL,
  temporary NUMBER(4,0) DEFAULT NULL,
  eternal NUMBER(4,0) DEFAULT NULL,
  expire_date TIMESTAMP DEFAULT NULL,
  user_count NUMBER(11,0) DEFAULT NULL,
  status varchar(255) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_license IS '服务端License信息表'
;
COMMENT ON COLUMN em_license.id IS '主键'
;
COMMENT ON COLUMN em_license.custom_id IS '客户ID'
;
COMMENT ON COLUMN em_license.company_name IS '公司名称'
;
COMMENT ON COLUMN em_license.company_name_zh_cn IS '公司名称（中文）'
;
COMMENT ON COLUMN em_license.identification_number IS '识别码'
;
COMMENT ON COLUMN em_license.temporary IS '是否为临时license：0-否、1-是'
;
COMMENT ON COLUMN em_license.eternal IS '是否永久有效：0-否、1-是'
;
COMMENT ON COLUMN em_license.expire_date IS '过期时间'
;
COMMENT ON COLUMN em_license.user_count IS '用户数量'
;
COMMENT ON COLUMN em_license.status IS '状态'
;
COMMENT ON COLUMN em_license.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_license.create_time IS '创建时间'
;
COMMENT ON COLUMN em_license.update_user_id IS '最后修改人'
;
COMMENT ON COLUMN em_license.update_time IS '最后修改时间'
;
COMMENT ON COLUMN em_license.tenant_id IS '租户ID'
;
CREATE INDEX em_license_in_idx ON em_license(identification_number)
;
CREATE TABLE em_log_access (
  id varchar(32) NOT NULL PRIMARY KEY,
  base_user_id varchar(32) DEFAULT NULL,
  base_user_name varchar(255) DEFAULT NULL,
  base_user_status NUMBER(4,0) DEFAULT NULL,
  operation varchar(255) DEFAULT NULL,
  access_token varchar(100) DEFAULT NULL,
  login_type NUMBER(4,0) DEFAULT NULL,
  login_mode NUMBER(4,0) DEFAULT NULL,
  client_type NUMBER(4,0) DEFAULT NULL,
  client_version varchar(50) DEFAULT NULL,
  device_id varchar(255) DEFAULT NULL,
  lang_type varchar(10) DEFAULT NULL,
  os_version varchar(100) DEFAULT NULL,
  client_model varchar(100) DEFAULT NULL,
  ip varchar(255) DEFAULT NULL,
  user_agent varchar(500) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_log_access IS '访问日志'
;
COMMENT ON COLUMN em_log_access.id IS '主键'
;
COMMENT ON COLUMN em_log_access.base_user_id IS '用户ID'
;
COMMENT ON COLUMN em_log_access.base_user_name IS '用户名'
;
COMMENT ON COLUMN em_log_access.base_user_status IS '用户状态 1-已注册，2-未注册，3-删除'
;
COMMENT ON COLUMN em_log_access.operation IS '操作：login-登录，logout-登出'
;
COMMENT ON COLUMN em_log_access.access_token IS '访问token'
;
COMMENT ON COLUMN em_log_access.login_type IS '登录类型：1-客户端，2-管理端，3-接口'
;
COMMENT ON COLUMN em_log_access.login_mode IS '登录方式：1-账号密码登录，2-短信验证码登录，3-扫码登录'
;
COMMENT ON COLUMN em_log_access.client_type IS '客户端类型： 1-PC客户端，2-IOS客户端，3-安卓客户端，4-web版'
;
COMMENT ON COLUMN em_log_access.client_version IS '客户端版本'
;
COMMENT ON COLUMN em_log_access.device_id IS '客户端硬件标识'
;
COMMENT ON COLUMN em_log_access.lang_type IS '语言类型'
;
COMMENT ON COLUMN em_log_access.os_version IS '客户端操作系统版本'
;
COMMENT ON COLUMN em_log_access.client_model IS '客户端设备型号'
;
COMMENT ON COLUMN em_log_access.ip IS 'IP地址'
;
COMMENT ON COLUMN em_log_access.user_agent IS '访问头信息'
;
COMMENT ON COLUMN em_log_access.create_time IS '日志创建时间'
;
COMMENT ON COLUMN em_log_access.tenant_id IS '租户ID'
;
CREATE INDEX em_log_access_bui_idx ON em_log_access(base_user_id)
;
CREATE INDEX em_log_access_ti_idx ON em_log_access(tenant_id)
;
CREATE TABLE em_log_agent_use (
  id varchar(32) NOT NULL PRIMARY KEY,
  open_agent_id NUMBER(11,0) DEFAULT NULL,
  base_user_id varchar(32) DEFAULT NULL,
  access_token varchar(100) DEFAULT NULL,
  use_date varchar(10) DEFAULT NULL,
  use_time varchar(8) DEFAULT NULL,
  ip varchar(255) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_log_agent_use IS '应用使用日志'
;
COMMENT ON COLUMN em_log_agent_use.id IS '主键'
;
COMMENT ON COLUMN em_log_agent_use.open_agent_id IS '应用ID'
;
COMMENT ON COLUMN em_log_agent_use.base_user_id IS '用户ID'
;
COMMENT ON COLUMN em_log_agent_use.access_token IS '访问token'
;
COMMENT ON COLUMN em_log_agent_use.use_date IS '使用日期'
;
COMMENT ON COLUMN em_log_agent_use.use_time IS '使用时间'
;
COMMENT ON COLUMN em_log_agent_use.ip IS 'IP地址'
;
COMMENT ON COLUMN em_log_agent_use.create_time IS '日志创建时间'
;
COMMENT ON COLUMN em_log_agent_use.tenant_id IS '租户ID'
;
CREATE INDEX em_log_agent_use_oai_idx ON em_log_agent_use(open_agent_id)
;
CREATE INDEX em_log_agent_use_bui_idx ON em_log_agent_use(base_user_id)
;
CREATE INDEX em_log_agent_use_at_idx ON em_log_agent_use(access_token)
;
CREATE INDEX em_log_agent_use_ti_idx ON em_log_agent_use(tenant_id)
;
CREATE TABLE em_log_client_use (
  id varchar(32) NOT NULL PRIMARY KEY,
  base_user_id varchar(32) DEFAULT NULL,
  access_token varchar(100) DEFAULT NULL,
  use_date varchar(10) DEFAULT NULL,
  last_use_time varchar(8) DEFAULT NULL,
  ip varchar(255) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_log_client_use IS '客户端每天使用日志'
;
COMMENT ON COLUMN em_log_client_use.id IS '主键'
;
COMMENT ON COLUMN em_log_client_use.base_user_id IS '用户ID'
;
COMMENT ON COLUMN em_log_client_use.access_token IS '访问token'
;
COMMENT ON COLUMN em_log_client_use.use_date IS '使用日期'
;
COMMENT ON COLUMN em_log_client_use.last_use_time IS '最后使用时间'
;
COMMENT ON COLUMN em_log_client_use.ip IS 'IP地址'
;
COMMENT ON COLUMN em_log_client_use.create_time IS '日志创建时间'
;
COMMENT ON COLUMN em_log_client_use.update_time IS '日志更新时间'
;
COMMENT ON COLUMN em_log_client_use.tenant_id IS '租户ID'
;
CREATE INDEX em_log_client_use_bui_idx ON em_log_client_use(base_user_id)
;
CREATE INDEX em_log_client_use_at_idx ON em_log_client_use(access_token)
;
CREATE INDEX em_log_client_use_ti_idx ON em_log_client_use(tenant_id)
;
CREATE TABLE em_log_error (
  id varchar(32) NOT NULL PRIMARY KEY,
  base_user_id varchar(32) DEFAULT NULL,
  base_user_name varchar(255) DEFAULT NULL,
  operation varchar(255) DEFAULT NULL,
  params CLOB,
  error_type varchar(255) DEFAULT NULL,
  "exception" CLOB,
  ip varchar(255) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_log_error IS '错误日志'
;
COMMENT ON COLUMN em_log_error.id IS '主键'
;
COMMENT ON COLUMN em_log_error.base_user_id IS '用户ID'
;
COMMENT ON COLUMN em_log_error.base_user_name IS '用户名'
;
COMMENT ON COLUMN em_log_error.operation IS '操作'
;
COMMENT ON COLUMN em_log_error.params IS '请求参数'
;
COMMENT ON COLUMN em_log_error.error_type IS '错误类型'
;
COMMENT ON COLUMN em_log_error."exception" IS '异常信息'
;
COMMENT ON COLUMN em_log_error.ip IS 'IP地址'
;
COMMENT ON COLUMN em_log_error.create_time IS '日志创建时间'
;
COMMENT ON COLUMN em_log_error.tenant_id IS '租户ID'
;
CREATE INDEX em_log_error_bui_idx ON em_log_error(base_user_id)
;
CREATE INDEX em_log_error_ti_idx ON em_log_error(tenant_id)
;
CREATE TABLE em_log_manage (
  id varchar(32) NOT NULL PRIMARY KEY,
  base_user_id varchar(32) DEFAULT NULL,
  base_user_name varchar(100) DEFAULT NULL,
  hrm_user_id varchar(32) DEFAULT NULL,
  hrm_user_name varchar(100) DEFAULT NULL,
  type1 NUMBER(11,0) DEFAULT NULL,
  type2 NUMBER(11,0) DEFAULT NULL,
  type3 NUMBER(11,0) DEFAULT NULL,
  datainfo CLOB,
  method varchar(255) DEFAULT NULL,
  params CLOB,
  ip varchar(255) DEFAULT NULL,
  showorder NUMBER(11,0)  DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_log_manage IS '管理端操作日志'
;
COMMENT ON COLUMN em_log_manage.id IS '主键ID'
;
COMMENT ON COLUMN em_log_manage.base_user_id IS '用户ID'
;
COMMENT ON COLUMN em_log_manage.base_user_name IS '用户名'
;
COMMENT ON COLUMN em_log_manage.hrm_user_id IS '通讯录用户ID'
;
COMMENT ON COLUMN em_log_manage.hrm_user_name IS '通讯录用户名'
;
COMMENT ON COLUMN em_log_manage.type1 IS '操作功能模块'
;
COMMENT ON COLUMN em_log_manage.type2 IS '操作具体功能'
;
COMMENT ON COLUMN em_log_manage.type3 IS '操作具体类型'
;
COMMENT ON COLUMN em_log_manage.datainfo IS '相关数据'
;
COMMENT ON COLUMN em_log_manage.method IS '请求方法'
;
COMMENT ON COLUMN em_log_manage.params IS '请求参数'
;
COMMENT ON COLUMN em_log_manage.ip IS 'IP地址'
;
COMMENT ON COLUMN em_log_manage.create_time IS '创建时间'
;
COMMENT ON COLUMN em_log_manage.tenant_id IS '租户ID'
;
CREATE INDEX em_log_manage_bui_idx ON em_log_manage(base_user_id)
;
CREATE INDEX em_log_manage_ti_idx ON em_log_manage(tenant_id)
;
CREATE INDEX em_log_manage_hui_idx ON em_log_manage(hrm_user_id)
;
CREATE INDEX em_log_manage_si_idx ON em_log_manage(showorder)
;
CREATE SEQUENCE em_log_manage_seq start with 0 increment by 1 minvalue 0
;
CREATE TABLE em_log_operation (
  id varchar(32) NOT NULL PRIMARY KEY,
  base_user_id varchar(32) DEFAULT NULL,
  base_user_name varchar(255) DEFAULT NULL,
  hrm_user_id varchar(32) DEFAULT NULL,
  hrm_user_name varchar(255) DEFAULT NULL,
  admin_type NUMBER(11,0) DEFAULT NULL,
  module NUMBER(4,0) DEFAULT NULL,
  operation varchar(255) DEFAULT NULL,
  method varchar(255) DEFAULT NULL,
  params CLOB,
  data_name varchar(255) DEFAULT NULL,
  cost_time NUMBER(11,0) DEFAULT NULL,
  error_code NUMBER(11,0) DEFAULT NULL,
  error_msg CLOB,
  return_json_data CLOB,
  ip varchar(255) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_log_operation IS '操作日志'
;
COMMENT ON COLUMN em_log_operation.id IS '主键'
;
COMMENT ON COLUMN em_log_operation.base_user_id IS '用户ID'
;
COMMENT ON COLUMN em_log_operation.base_user_name IS '用户名'
;
COMMENT ON COLUMN em_log_operation.hrm_user_id IS '通讯录用户ID'
;
COMMENT ON COLUMN em_log_operation.hrm_user_name IS '通讯录用户名'
;
COMMENT ON COLUMN em_log_operation.admin_type IS '管理员类型'
;
COMMENT ON COLUMN em_log_operation.module IS '模块ID'
;
COMMENT ON COLUMN em_log_operation.operation IS '操作'
;
COMMENT ON COLUMN em_log_operation.method IS '请求方法'
;
COMMENT ON COLUMN em_log_operation.params IS '请求参数'
;
COMMENT ON COLUMN em_log_operation.data_name IS '操作的数据名称'
;
COMMENT ON COLUMN em_log_operation.cost_time IS '操作时长'
;
COMMENT ON COLUMN em_log_operation.error_code IS '错误码'
;
COMMENT ON COLUMN em_log_operation.error_msg IS '错误信息'
;
COMMENT ON COLUMN em_log_operation.return_json_data IS '接口返回数据'
;
COMMENT ON COLUMN em_log_operation.ip IS 'IP地址'
;
COMMENT ON COLUMN em_log_operation.create_time IS '日志创建时间'
;
COMMENT ON COLUMN em_log_operation.tenant_id IS '租户ID'
;
CREATE INDEX em_log_operation_bui_idx ON em_log_operation(base_user_id)
;
CREATE INDEX em_log_operation_ti_idx ON em_log_operation(tenant_id)
;
CREATE INDEX em_log_operation_hui_idx ON em_log_operation(hrm_user_id)
;
CREATE INDEX em_log_operation_ct_idx ON em_log_operation(create_time)
;
CREATE TABLE em_msg_ding (
  id varchar(32) NOT NULL PRIMARY KEY,
  send_user_id varchar(32) DEFAULT NULL,
  touserids CLOB,
  messageid varchar(50) DEFAULT NULL,
  msg_content varchar(1000) DEFAULT NULL,
  msg_type NUMBER(4,0) DEFAULT '1',
  send_type NUMBER(4,0) DEFAULT '1',
  send_time TIMESTAMP DEFAULT NULL,
  send_result NUMBER(4,0) DEFAULT '1',
  msg_ding_id varchar(50) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_msg_ding IS '必达消息数据表'
;
COMMENT ON COLUMN em_msg_ding.id IS '主键ID'
;
COMMENT ON COLUMN em_msg_ding.send_user_id IS '发送人id'
;
COMMENT ON COLUMN em_msg_ding.touserids IS '接收人员id，多个用逗号分隔'
;
COMMENT ON COLUMN em_msg_ding.messageid IS '消息转必达id'
;
COMMENT ON COLUMN em_msg_ding.msg_content IS '消息内容'
;
COMMENT ON COLUMN em_msg_ding.msg_type IS '消息类型：1-应用内，2-短信，3-电话'
;
COMMENT ON COLUMN em_msg_ding.send_type IS '发送类型：1-立即发送，2-定时发送'
;
COMMENT ON COLUMN em_msg_ding.send_time IS '定时发送的时间，格式为YYYY-MM-DD HH:MM:ss'
;
COMMENT ON COLUMN em_msg_ding.send_result IS '发送结果：1-发生成功，2-等待发送，3-发送失败'
;
COMMENT ON COLUMN em_msg_ding.msg_ding_id IS '对应消息服务中的数据ID'
;
COMMENT ON COLUMN em_msg_ding.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_msg_ding.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_msg_ding.create_time IS '创建时间'
;
COMMENT ON COLUMN em_msg_ding.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_msg_ding.update_time IS '修改时间'
;
COMMENT ON COLUMN em_msg_ding.tenant_id IS '企业租户ID'
;
CREATE INDEX em_msg_ding_tenant_id_index ON em_msg_ding(tenant_id)
;
CREATE TABLE em_msg_group (
  id varchar(32) NOT NULL PRIMARY KEY,
  group_type NUMBER(4,0) DEFAULT '1',
  group_name varchar(100) DEFAULT NULL,
  english_name varchar(100) DEFAULT NULL,
  description varchar(200) DEFAULT NULL,
  logo varchar(255) DEFAULT NULL,
  view_count NUMBER(11,0) DEFAULT NULL,
  server_group_id varchar(50) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_msg_group IS '企业消息群组基础表'
;
COMMENT ON COLUMN em_msg_group.id IS '主键ID'
;
COMMENT ON COLUMN em_msg_group.group_type IS '群组类型 1-普通群，2-部门群，3-公司群'
;
COMMENT ON COLUMN em_msg_group.group_name IS '群组名称'
;
COMMENT ON COLUMN em_msg_group.english_name IS '英文名称'
;
COMMENT ON COLUMN em_msg_group.description IS '描述'
;
COMMENT ON COLUMN em_msg_group.logo IS '头像'
;
COMMENT ON COLUMN em_msg_group.view_count IS '新成员可查看最近聊天记录数量，默认100'
;
COMMENT ON COLUMN em_msg_group.server_group_id IS '对应的消息服务器群组ID'
;
COMMENT ON COLUMN em_msg_group.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_msg_group.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_msg_group.create_time IS '创建时间'
;
COMMENT ON COLUMN em_msg_group.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_msg_group.update_time IS '修改时间'
;
COMMENT ON COLUMN em_msg_group.tenant_id IS '企业租户ID'
;
CREATE INDEX em_msg_group_tenant_id_index ON em_msg_group(tenant_id)
;
CREATE TABLE em_msg_group_member (
  id varchar(32) NOT NULL PRIMARY KEY,
  group_id varchar(32) DEFAULT NULL,
  base_user_id varchar(32) DEFAULT NULL,
  member_type NUMBER(4,0) DEFAULT '3',
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_msg_group_member IS '企业消息群组成员表'
;
COMMENT ON COLUMN em_msg_group_member.id IS '主键ID'
;
COMMENT ON COLUMN em_msg_group_member.group_id IS '所属群组ID'
;
COMMENT ON COLUMN em_msg_group_member.base_user_id IS '成员基础用户ID'
;
COMMENT ON COLUMN em_msg_group_member.member_type IS '成员类型 1-群主，2-管理员，3-普通成员'
;
COMMENT ON COLUMN em_msg_group_member.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_msg_group_member.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_msg_group_member.create_time IS '创建时间'
;
COMMENT ON COLUMN em_msg_group_member.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_msg_group_member.update_time IS '修改时间'
;
COMMENT ON COLUMN em_msg_group_member.tenant_id IS '企业租户ID'
;
CREATE INDEX em_msg_group_member_gi_idx ON em_msg_group_member(group_id)
;
CREATE INDEX em_msg_group_member_ti_idx ON em_msg_group_member(tenant_id)
;
CREATE TABLE em_msg_group_notice (
  id varchar(32) NOT NULL PRIMARY KEY,
  group_id varchar(32) DEFAULT NULL,
  remark CLOB,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_msg_group_notice IS '企业消息群组公告表'
;
COMMENT ON COLUMN em_msg_group_notice.id IS '主键ID'
;
COMMENT ON COLUMN em_msg_group_notice.group_id IS '所属群组ID'
;
COMMENT ON COLUMN em_msg_group_notice.remark IS '公告内容'
;
COMMENT ON COLUMN em_msg_group_notice.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_msg_group_notice.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_msg_group_notice.create_time IS '创建时间'
;
COMMENT ON COLUMN em_msg_group_notice.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_msg_group_notice.update_time IS '修改时间'
;
COMMENT ON COLUMN em_msg_group_notice.tenant_id IS '企业租户ID'
;
CREATE INDEX em_msg_group_notice_gi_idx ON em_msg_group_notice(group_id)
;
CREATE INDEX em_msg_group_notice_ti_idx ON em_msg_group_notice(tenant_id)
;
CREATE TABLE em_sc_func (
  id varchar(32) NOT NULL PRIMARY KEY,
  client_type NUMBER(4,0) DEFAULT NULL,
  set_type NUMBER(4,0) DEFAULT NULL,
  icon_unselected varchar(32) DEFAULT NULL,
  icon_selected varchar(32) DEFAULT NULL,
  show_name varchar(20) DEFAULT NULL,
  show_name_en varchar(20) DEFAULT NULL,
  show_order decimal(10,2) DEFAULT NULL,
  func_type NUMBER(11,0) DEFAULT NULL,
  func_value varchar(200) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sc_func IS '企业客户端功能设置表'
;
COMMENT ON COLUMN em_sc_func.id IS '主键ID'
;
COMMENT ON COLUMN em_sc_func.client_type IS '客户端类型 1-移动APP，2-PC客户端，3-web客户端'
;
COMMENT ON COLUMN em_sc_func.set_type IS '设置项类型 1-顶部右上角功能，2-导航栏功能'
;
COMMENT ON COLUMN em_sc_func.icon_unselected IS '未选中图标'
;
COMMENT ON COLUMN em_sc_func.icon_selected IS '已选中图标'
;
COMMENT ON COLUMN em_sc_func.show_name IS '显示名称'
;
COMMENT ON COLUMN em_sc_func.show_name_en IS '英文显示名称'
;
COMMENT ON COLUMN em_sc_func.show_order IS '显示顺序'
;
COMMENT ON COLUMN em_sc_func.func_type IS '功能类型'
;
COMMENT ON COLUMN em_sc_func.func_value IS '功能扩展值'
;
COMMENT ON COLUMN em_sc_func.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_sc_func.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sc_func.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sc_func.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sc_func.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sc_func.tenant_id IS '企业租户ID'
;
CREATE INDEX em_sc_func_tenant_id_index ON em_sc_func(tenant_id)
;
CREATE TABLE em_sc_portal_base (
  id varchar(32) NOT NULL PRIMARY KEY,
  client_type NUMBER(4,0) DEFAULT NULL,
  portal_name varchar(100) DEFAULT NULL,
  show_type NUMBER(4,0) DEFAULT '1',
  isdefault NUMBER(4,0) DEFAULT NULL,
  isuserset NUMBER(4,0) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sc_portal_base IS '企业客户端门户基础信息表'
;
COMMENT ON COLUMN em_sc_portal_base.id IS '主键ID'
;
COMMENT ON COLUMN em_sc_portal_base.client_type IS '客户端类型 1-移动APP，2-PC客户端，3-web客户端'
;
COMMENT ON COLUMN em_sc_portal_base.portal_name IS '门户名称'
;
COMMENT ON COLUMN em_sc_portal_base.show_type IS '显示模式'
;
COMMENT ON COLUMN em_sc_portal_base.isdefault IS '是否默认门户：1-是、0-否'
;
COMMENT ON COLUMN em_sc_portal_base.isuserset IS '是否支持用户自定义：1-是、0-否'
;
COMMENT ON COLUMN em_sc_portal_base.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_sc_portal_base.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sc_portal_base.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sc_portal_base.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sc_portal_base.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sc_portal_base.tenant_id IS '企业租户ID'
;
CREATE INDEX em_sc_portal_base_ti_idx ON em_sc_portal_base(tenant_id)
;
INSERT INTO em_sc_portal_base VALUES ('1',1,'移动端默认门户',1,1,1,1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_portal_base VALUES ('2',2,'PC客户端默认门户',1,1,1,1,NULL,NULL,NULL,NULL,'')
;
CREATE TABLE em_sc_portal_category (
  id varchar(32) NOT NULL PRIMARY KEY,
  portal_base_id varchar(32) DEFAULT NULL,
  category_type NUMBER(4,0) DEFAULT NULL,
  category_name varchar(50) DEFAULT NULL,
  english_name varchar(50) DEFAULT NULL,
  isshowtitle NUMBER(4,0) DEFAULT NULL,
  showorder NUMBER(11,0) DEFAULT NULL,
  icon_default varchar(200) DEFAULT NULL,
  set_value varchar(50) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sc_portal_category IS '企业客户端门户分组信息表'
;
COMMENT ON COLUMN em_sc_portal_category.id IS '主键ID'
;
COMMENT ON COLUMN em_sc_portal_category.portal_base_id IS '主题ID'
;
COMMENT ON COLUMN em_sc_portal_category.category_type IS '分组类型：1-普通分组，2-其他应用，3-常用功能分组'
;
COMMENT ON COLUMN em_sc_portal_category.category_name IS '分组名称'
;
COMMENT ON COLUMN em_sc_portal_category.english_name IS '分组英文名称'
;
COMMENT ON COLUMN em_sc_portal_category.isshowtitle IS '是否显示分组标题：1-显示，0-不显示'
;
COMMENT ON COLUMN em_sc_portal_category.showorder IS '显示顺序'
;
COMMENT ON COLUMN em_sc_portal_category.icon_default IS '默认显示图标'
;
COMMENT ON COLUMN em_sc_portal_category.set_value IS '分组设置，针对常用功能分组设置显示的常用功能数量'
;
COMMENT ON COLUMN em_sc_portal_category.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_sc_portal_category.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sc_portal_category.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sc_portal_category.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sc_portal_category.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sc_portal_category.tenant_id IS '企业租户ID'
;
CREATE INDEX em_sc_portal_category_pbi_idx ON em_sc_portal_category(portal_base_id)
;
CREATE INDEX em_sc_portal_category_ti_idx ON em_sc_portal_category(tenant_id)
;
INSERT INTO em_sc_portal_category VALUES ('1','1',2,'应用列表','Agent List',0,1,NULL,NULL,1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_portal_category VALUES ('2','2',2,'应用列表','Agent List',0,1,NULL,NULL,1,NULL,NULL,NULL,NULL,'')
;
CREATE TABLE em_sc_portal_category_element (
  id varchar(32) NOT NULL PRIMARY KEY,
  portal_base_id varchar(32) DEFAULT NULL,
  portal_category_id varchar(32) DEFAULT NULL,
  btn_type NUMBER(4,0) DEFAULT NULL,
  element_name varchar(50) DEFAULT NULL,
  english_name varchar(50) DEFAULT NULL,
  element_type NUMBER(11,0) DEFAULT NULL,
  element_set1 varchar(200) DEFAULT NULL,
  element_set2 varchar(1000) DEFAULT NULL,
  showorder NUMBER(11,0) DEFAULT NULL,
  icon_default varchar(200) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sc_portal_category_element IS '企业客户端门户分组元素设置表'
;
COMMENT ON COLUMN em_sc_portal_category_element.id IS '主键ID'
;
COMMENT ON COLUMN em_sc_portal_category_element.portal_base_id IS '门户ID'
;
COMMENT ON COLUMN em_sc_portal_category_element.portal_category_id IS '分组ID'
;
COMMENT ON COLUMN em_sc_portal_category_element.btn_type IS '按钮类型 1-右上角按钮，2-消息功能按钮'
;
COMMENT ON COLUMN em_sc_portal_category_element.element_name IS '元素名称'
;
COMMENT ON COLUMN em_sc_portal_category_element.english_name IS '英文名称'
;
COMMENT ON COLUMN em_sc_portal_category_element.element_type IS '元素类型：1-应用，2-门户，3-自定义链接，4-幻灯片'
;
COMMENT ON COLUMN em_sc_portal_category_element.element_set1 IS '元素功能设置，如应用ID、门户ID、自定义链接地址，幻灯片图片等'
;
COMMENT ON COLUMN em_sc_portal_category_element.element_set2 IS '元素功能设置，如链接的打开方式1表示默认窗口，2表示新窗口,如果是配置型幻灯片，这存储相关json配置'
;
COMMENT ON COLUMN em_sc_portal_category_element.showorder IS '显示顺序'
;
COMMENT ON COLUMN em_sc_portal_category_element.icon_default IS '默认显示图标'
;
COMMENT ON COLUMN em_sc_portal_category_element.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_sc_portal_category_element.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sc_portal_category_element.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sc_portal_category_element.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sc_portal_category_element.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sc_portal_category_element.tenant_id IS '企业租户ID'
;
CREATE INDEX em_sc_p_c_e_pbi_idx ON em_sc_portal_category_element(portal_base_id)
;
CREATE INDEX em_sc_p_c_e_pci_idx ON em_sc_portal_category_element(portal_category_id)
;
CREATE INDEX em_sc_p_c_e_ti_idx ON em_sc_portal_category_element(tenant_id)
;
CREATE TABLE em_sc_portal_category_userset (
  id varchar(32) NOT NULL PRIMARY KEY,
  base_user_id varchar(32) DEFAULT NULL,
  portal_base_id varchar(32) DEFAULT NULL,
  portal_category_id varchar(32) DEFAULT NULL,
  set_element_ids varchar(500) DEFAULT NULL,
  reduce_element_ids varchar(500) DEFAULT NULL,
  increase_element_ids varchar(500) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sc_portal_category_userset IS '企业客户端门户分组用户自定义设置表'
;
COMMENT ON COLUMN em_sc_portal_category_userset.id IS '主键ID'
;
COMMENT ON COLUMN em_sc_portal_category_userset.base_user_id IS '基础用户ID'
;
COMMENT ON COLUMN em_sc_portal_category_userset.portal_base_id IS '门户ID'
;
COMMENT ON COLUMN em_sc_portal_category_userset.portal_category_id IS '分组ID'
;
COMMENT ON COLUMN em_sc_portal_category_userset.set_element_ids IS '此分组用户设置的元素id集合用逗号分隔'
;
COMMENT ON COLUMN em_sc_portal_category_userset.reduce_element_ids IS '此分组相对于门户分组减少的元素id集合用逗号分隔'
;
COMMENT ON COLUMN em_sc_portal_category_userset.increase_element_ids IS '此分组相对于门户分组新增的元素id集合用逗号分隔'
;
COMMENT ON COLUMN em_sc_portal_category_userset.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_sc_portal_category_userset.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sc_portal_category_userset.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sc_portal_category_userset.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sc_portal_category_userset.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sc_portal_category_userset.tenant_id IS '企业租户ID'
;
CREATE INDEX em_sc_p_c_u_bui_idx ON em_sc_portal_category_userset(base_user_id)
;
CREATE INDEX em_sc_p_c_u_pbi_idx ON em_sc_portal_category_userset(portal_base_id)
;
CREATE INDEX em_sc_p_c_u_pci_idx ON em_sc_portal_category_userset(portal_category_id)
;
CREATE INDEX em_sc_p_c_u_ti_idx ON em_sc_portal_category_userset(tenant_id)
;
CREATE TABLE em_sc_portal_useraccess (
  id varchar(32) NOT NULL PRIMARY KEY,
  base_user_id varchar(32) DEFAULT NULL,
  portal_base_id varchar(32) DEFAULT NULL,
  element_id varchar(32) DEFAULT NULL,
  ip varchar(255) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sc_portal_useraccess IS '企业客户端门户用户元素访问记录'
;
COMMENT ON COLUMN em_sc_portal_useraccess.id IS '主键ID'
;
COMMENT ON COLUMN em_sc_portal_useraccess.base_user_id IS '基础用户ID'
;
COMMENT ON COLUMN em_sc_portal_useraccess.portal_base_id IS '门户ID'
;
COMMENT ON COLUMN em_sc_portal_useraccess.element_id IS '元素ID'
;
COMMENT ON COLUMN em_sc_portal_useraccess.ip IS 'IP地址'
;
COMMENT ON COLUMN em_sc_portal_useraccess.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sc_portal_useraccess.tenant_id IS '企业租户ID'
;
CREATE INDEX em_sc_p_u_bui_idx ON em_sc_portal_useraccess(base_user_id)
;
CREATE INDEX em_sc_p_u_pbi_idx ON em_sc_portal_useraccess(portal_base_id)
;
CREATE INDEX em_sc_p_u_ei_idx ON em_sc_portal_useraccess(element_id)
;
CREATE INDEX em_sc_p_u_ti_idx ON em_sc_portal_useraccess(tenant_id)
;
CREATE TABLE em_sc_scan_rule (
  id varchar(32) NOT NULL PRIMARY KEY,
  rule_name varchar(50) DEFAULT NULL,
  client_type NUMBER(4,0) DEFAULT '0',
  matching_mode NUMBER(4,0) DEFAULT NULL,
  action_type NUMBER(4,0) DEFAULT NULL,
  action_setting1 varchar(500) DEFAULT NULL,
  action_setting2 varchar(500) DEFAULT NULL,
  action_setting3 varchar(500) DEFAULT NULL,
  close_scan NUMBER(4,0) DEFAULT '1',
  play_sound NUMBER(4,0) DEFAULT '1',
  priority NUMBER(11,0) DEFAULT '0',
  status NUMBER(4,0) DEFAULT NULL,
  publish_time TIMESTAMP DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sc_scan_rule IS '客户端扫码规则表'
;
COMMENT ON COLUMN em_sc_scan_rule.id IS '主键'
;
COMMENT ON COLUMN em_sc_scan_rule.rule_name IS '规则名称'
;
COMMENT ON COLUMN em_sc_scan_rule.client_type IS '适用客户端类型：1-全部，2-ios，3-android'
;
COMMENT ON COLUMN em_sc_scan_rule.matching_mode IS '匹配方式：1-包含，2-开头，3-结束，4-完全匹配，5-正则表达式，6-全部'
;
COMMENT ON COLUMN em_sc_scan_rule.action_type IS '执行动作类型：1-访问地址，2-浮出显示内容，3-新窗口显示内容，4-请求第三方服务，5-添加名片，6-打开某个应用，7-调用本地功能，8-不做任何操作，9-自定义'
;
COMMENT ON COLUMN em_sc_scan_rule.action_setting1 IS '执行动作参数1'
;
COMMENT ON COLUMN em_sc_scan_rule.action_setting2 IS '执行动作参数2'
;
COMMENT ON COLUMN em_sc_scan_rule.action_setting3 IS '执行动作参数3'
;
COMMENT ON COLUMN em_sc_scan_rule.close_scan IS '是否关闭扫码器：1-是，0-否'
;
COMMENT ON COLUMN em_sc_scan_rule.play_sound IS '是否播放提示音：1-是，0-否'
;
COMMENT ON COLUMN em_sc_scan_rule.priority IS '优先级，值越小优先级越高'
;
COMMENT ON COLUMN em_sc_scan_rule.status IS '状态：1-正常，2-禁用，3-删除'
;
COMMENT ON COLUMN em_sc_scan_rule.publish_time IS '发布时间'
;
COMMENT ON COLUMN em_sc_scan_rule.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sc_scan_rule.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sc_scan_rule.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sc_scan_rule.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sc_scan_rule.tenant_id IS '企业租户ID'
;
CREATE TABLE em_sc_show (
  id varchar(32) NOT NULL PRIMARY KEY,
  client_type NUMBER(4,0) DEFAULT NULL,
  set_type NUMBER(4,0) DEFAULT NULL,
  set_tag NUMBER(4,0) DEFAULT NULL,
  set_value varchar(500) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sc_show IS '企业客户端显示设置表'
;
COMMENT ON COLUMN em_sc_show.id IS '主键ID'
;
COMMENT ON COLUMN em_sc_show.client_type IS '客户端类型 1-移动APP，2-PC客户端，3-web客户端'
;
COMMENT ON COLUMN em_sc_show.set_type IS '设置项类型 1-登录前显示，2-登录后显示'
;
COMMENT ON COLUMN em_sc_show.set_tag IS '设置项标识 1-欢迎页背景图片，2-欢迎词内容，3-欢迎词字体颜色，4-登录页logo，5-登录页背景色，6-登录页底部信息内容，7-登录页底部信息字体颜色，21-顶部背景色，22-顶部文字颜色，23-顶部功能菜单背景色，24-顶部功能菜单文字颜色，25-导航栏背景色，26-导航栏文字未选中颜色，27-导航栏文字已选中颜色'
;
COMMENT ON COLUMN em_sc_show.set_value IS '设置内容'
;
COMMENT ON COLUMN em_sc_show.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_sc_show.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sc_show.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sc_show.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sc_show.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sc_show.tenant_id IS '企业租户ID'
;
CREATE INDEX em_sc_show_tenant_id_index ON em_sc_show(tenant_id)
;
CREATE TABLE em_sc_theme_base (
  id varchar(32) NOT NULL PRIMARY KEY,
  client_type NUMBER(4,0) DEFAULT NULL,
  theme_name varchar(100) DEFAULT NULL,
  show_type NUMBER(4,0) DEFAULT '0',
  showorder decimal(10,2) DEFAULT '0.00',
  nav_bgcolor varchar(50) DEFAULT NULL,
  nav_textcolor_default varchar(50) DEFAULT NULL,
  nav_textcolor_selected varchar(50) DEFAULT NULL,
  nav_showtext NUMBER(4,0) DEFAULT '1',
  isdefault NUMBER(4,0) DEFAULT '0',
  other_tag varchar(100) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sc_theme_base IS '企业客户端主题基础信息表'
;
COMMENT ON COLUMN em_sc_theme_base.id IS '主键ID'
;
COMMENT ON COLUMN em_sc_theme_base.client_type IS '客户端类型 1-移动APP，2-PC客户端，3-web客户端'
;
COMMENT ON COLUMN em_sc_theme_base.theme_name IS '主题名称'
;
COMMENT ON COLUMN em_sc_theme_base.show_type IS '显示模式，针对PC端：1-纵向、2-横向'
;
COMMENT ON COLUMN em_sc_theme_base.showorder IS '显示顺序'
;
COMMENT ON COLUMN em_sc_theme_base.nav_bgcolor IS '移动端底部导航背景颜色'
;
COMMENT ON COLUMN em_sc_theme_base.nav_textcolor_default IS '移动端底部导航文字默认颜色'
;
COMMENT ON COLUMN em_sc_theme_base.nav_textcolor_selected IS '移动端底部导航文字选中颜色'
;
COMMENT ON COLUMN em_sc_theme_base.nav_showtext IS '移动端底部导航是否显示文字 1-显示，0-不显示'
;
COMMENT ON COLUMN em_sc_theme_base.isdefault IS '是否默认主题：1-是、0-否'
;
COMMENT ON COLUMN em_sc_theme_base.other_tag IS '主题关联标识'
;
COMMENT ON COLUMN em_sc_theme_base.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_sc_theme_base.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sc_theme_base.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sc_theme_base.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sc_theme_base.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sc_theme_base.tenant_id IS '企业租户ID'
;
CREATE INDEX em_sc_theme_base_ti_idx ON em_sc_theme_base(tenant_id)
;
INSERT INTO em_sc_theme_base VALUES ('1',1,'移动端默认主题',1,0.00,'#FFFFFF','#A3A5A8','#3296FA',1,0,NULL,1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_base VALUES ('2',2,'PC客户端默认主题',1,0.00,'#499BFA','#B7D9FD','#FFFFFF',0,0,NULL,1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_base VALUES ('3',3,'PC网页版默认主题',2,0.00,'#499BFA','#B7D9FD','#FFFFFF',0,0,NULL,1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_base VALUES ('a1',1,'移动端主题',1,0.00,'#FFFFFF','#A3A5A8','#3296FA',1,0,NULL,1,NULL,NULL,NULL,NULL,'1')
;
INSERT INTO em_sc_theme_base VALUES ('p1',2,'PC客户端主题',1,0.00,'#499BFA','#B7D9FD','#FFFFFF',0,0,NULL,1,NULL,NULL,NULL,NULL,'1')
;
INSERT INTO em_sc_theme_base VALUES ('w1',3,'PC网页版主题',2,0.00,'#499BFA','#B7D9FD','#FFFFFF',0,0,NULL,1,NULL,NULL,NULL,NULL,'1')
;
CREATE TABLE em_sc_theme_nav (
  id varchar(32) NOT NULL PRIMARY KEY,
  theme_base_id varchar(32) DEFAULT NULL,
  nav_name varchar(50) DEFAULT NULL,
  nav_func NUMBER(11,0) DEFAULT NULL,
  nav_func_set1 varchar(200) DEFAULT NULL,
  nav_func_set2 varchar(200) DEFAULT NULL,
  isshow NUMBER(4,0) DEFAULT NULL,
  showorder NUMBER(11,0) DEFAULT NULL,
  isdefault NUMBER(4,0) DEFAULT NULL,
  icon_default varchar(200) NOT NULL,
  icon_selected varchar(200) NOT NULL,
  top_bgcolor varchar(50) DEFAULT NULL,
  top_title varchar(50) DEFAULT NULL,
  top_txtcolor varchar(50) DEFAULT NULL,
  icon_more varchar(200) NOT NULL,
  nav_btn_color varchar(50) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sc_theme_nav IS '企业客户端主题导航明细设置表'
;
COMMENT ON COLUMN em_sc_theme_nav.id IS '主键ID'
;
COMMENT ON COLUMN em_sc_theme_nav.theme_base_id IS '主题ID'
;
COMMENT ON COLUMN em_sc_theme_nav.nav_name IS '导航名称'
;
COMMENT ON COLUMN em_sc_theme_nav.nav_func IS '导航功能：-1-消息，-2-通讯录，-3-工作台，-4-我，1-应用，2-门户，3-自定义链接'
;
COMMENT ON COLUMN em_sc_theme_nav.nav_func_set1 IS '导航功能设置，如应用ID、门户ID，自定义链接地址等'
;
COMMENT ON COLUMN em_sc_theme_nav.nav_func_set2 IS '导航功能设置，如自定义链接的打开方式1表示默认窗口，2表示新窗口'
;
COMMENT ON COLUMN em_sc_theme_nav.isshow IS '是否显示：1-登显示，0-不显示'
;
COMMENT ON COLUMN em_sc_theme_nav.showorder IS '显示顺序'
;
COMMENT ON COLUMN em_sc_theme_nav.isdefault IS '是否默认：1-默认，0-不默认'
;
COMMENT ON COLUMN em_sc_theme_nav.icon_default IS '默认显示图标'
;
COMMENT ON COLUMN em_sc_theme_nav.icon_selected IS '选中显示图标'
;
COMMENT ON COLUMN em_sc_theme_nav.top_bgcolor IS '顶部背景颜色'
;
COMMENT ON COLUMN em_sc_theme_nav.top_title IS '顶部显示标题'
;
COMMENT ON COLUMN em_sc_theme_nav.top_txtcolor IS '顶部显示标题文字颜色'
;
COMMENT ON COLUMN em_sc_theme_nav.icon_more IS '顶部更多按钮图标'
;
COMMENT ON COLUMN em_sc_theme_nav.nav_btn_color IS '导航按钮颜色'
;
COMMENT ON COLUMN em_sc_theme_nav.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_sc_theme_nav.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sc_theme_nav.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sc_theme_nav.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sc_theme_nav.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sc_theme_nav.tenant_id IS '企业租户ID'
;
CREATE INDEX em_sc_theme_nav_tbi_idx ON em_sc_theme_nav(theme_base_id)
;
CREATE INDEX em_sc_theme_nav_ti_idx ON em_sc_theme_nav(tenant_id)
;
INSERT INTO em_sc_theme_nav VALUES ('1','1','消息',-1,NULL,NULL,1,1,1,'/common/images/app/nav_msg_default.png','/common/images/app/nav_msg_selected.png','#FFFFFF','消息',NULL,'/common/images/app/btn_more.png','#419bf9',1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_nav VALUES ('11','2','消息',-1,NULL,NULL,1,1,1,'/common/images/pcclient/nav_msg_default.png','/common/images/pcclient/nav_msg_selected.png','#FFFFFF','消息',NULL,'/common/images/pcclient/btn_more.png','#419bf9',1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_nav VALUES ('12','2','通讯录',-2,NULL,NULL,1,2,0,'/common/images/pcclient/nav_contact_default.png','/common/images/pcclient/nav_contact_selected.png','#FFFFFF','通讯录',NULL,'/common/images/pcclient/btn_more.png','#419bf9',1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_nav VALUES ('14','2','工作台',-3,NULL,NULL,1,4,0,'/common/images/pcclient/nav_workbench_default.png','/common/images/pcclient/nav_workbench_selected.png','#FFFFFF','工作台',NULL,'/common/images/pcclient/btn_more.png','#419bf9',1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_nav VALUES ('2','1','通讯录',-2,NULL,NULL,1,2,0,'/common/images/app/nav_contact_default.png','/common/images/app/nav_contact_selected.png','#FFFFFF','通讯录',NULL,'/common/images/app/btn_more.png','#419bf9',1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_nav VALUES ('21','3','消息',-1,NULL,NULL,1,1,1,'/common/images/pcweb/nav_msg_default.png','/common/images/pcweb/nav_msg_selected.png','#FFFFFF','消息',NULL,'/common/images/pcweb/btn_more.png','#419bf9',1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_nav VALUES ('22','3','通讯录',-2,NULL,NULL,1,2,0,'/common/images/pcweb/nav_contact_default.png','/common/images/pcweb/nav_contact_selected.png','#FFFFFF','通讯录',NULL,'/common/images/pcweb/btn_more.png','#419bf9',1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_nav VALUES ('3','1','工作台',-3,NULL,NULL,1,3,0,'/common/images/app/nav_workbench_default.png','/common/images/app/nav_workbench_selected.png','#FFFFFF','工作台',NULL,'/common/images/app/btn_more.png','#419bf9',1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_nav VALUES ('4','1','我',-4,NULL,NULL,1,4,0,'/common/images/app/nav_mine_default.png','/common/images/app/nav_mine_selected.png','#FFFFFF','我',NULL,'/common/images/app/btn_more.png','#419bf9',1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_nav VALUES ('an1','a1','消息',-1,NULL,NULL,1,1,1,'/common/images/app/nav_msg_default.png','/common/images/app/nav_msg_selected.png','#FFFFFF','消息',NULL,'/common/images/app/btn_more.png','#419bf9',1,NULL,NULL,NULL,NULL,'1')
;
INSERT INTO em_sc_theme_nav VALUES ('an2','a1','通讯录',-2,NULL,NULL,1,2,0,'/common/images/app/nav_contact_default.png','/common/images/app/nav_contact_selected.png','#FFFFFF','通讯录',NULL,'/common/images/app/btn_more.png','#419bf9',1,NULL,NULL,NULL,NULL,'1')
;
INSERT INTO em_sc_theme_nav VALUES ('an3','a1','工作台',-3,NULL,NULL,1,3,0,'/common/images/app/nav_workbench_default.png','/common/images/app/nav_workbench_selected.png','#FFFFFF','工作台',NULL,'/common/images/app/btn_more.png','#419bf9',1,NULL,NULL,NULL,NULL,'1')
;
INSERT INTO em_sc_theme_nav VALUES ('an4','a1','我',-4,NULL,NULL,1,4,0,'/common/images/app/nav_mine_default.png','/common/images/app/nav_mine_selected.png','#FFFFFF','我',NULL,'/common/images/app/btn_more.png','#419bf9',1,NULL,NULL,NULL,NULL,'1')
;
INSERT INTO em_sc_theme_nav VALUES ('pn1','p1','消息',-1,NULL,NULL,1,1,1,'/common/images/pcclient/nav_msg_default.png','/common/images/pcclient/nav_msg_selected.png','#FFFFFF','消息',NULL,'/common/images/pcclient/btn_more.png','#419bf9',1,NULL,NULL,NULL,NULL,'1')
;
INSERT INTO em_sc_theme_nav VALUES ('pn2','p1','通讯录',-2,NULL,NULL,1,2,0,'/common/images/pcclient/nav_contact_default.png','/common/images/pcclient/nav_contact_selected.png','#FFFFFF','通讯录',NULL,'/common/images/pcclient/btn_more.png','#419bf9',1,NULL,NULL,NULL,NULL,'1')
;
INSERT INTO em_sc_theme_nav VALUES ('pn3','p1','工作台',-3,NULL,NULL,1,4,0,'/common/images/pcclient/nav_workbench_default.png','/common/images/pcclient/nav_workbench_selected.png','#FFFFFF','工作台',NULL,'/common/images/pcclient/btn_more.png','#419bf9',1,NULL,NULL,NULL,NULL,'1')
;
INSERT INTO em_sc_theme_nav VALUES ('wn1','w1','消息',-1,NULL,NULL,1,1,1,'/common/images/pcweb/nav_msg_default.png','/common/images/pcweb/nav_msg_selected.png','#FFFFFF','消息',NULL,'/common/images/pcweb/btn_more.png','#419bf9',1,NULL,NULL,NULL,NULL,'1')
;
INSERT INTO em_sc_theme_nav VALUES ('wn2','w1','通讯录',-2,NULL,NULL,1,2,0,'/common/images/pcweb/nav_contact_default.png','/common/images/pcweb/nav_contact_selected.png','#FFFFFF','通讯录',NULL,'/common/images/pcweb/btn_more.png','#419bf9',1,NULL,NULL,NULL,NULL,'1')
;
CREATE TABLE em_sc_theme_nav_btn (
  id varchar(32) NOT NULL PRIMARY KEY,
  theme_base_id varchar(32) DEFAULT NULL,
  theme_nav_id varchar(32) DEFAULT NULL,
  btn_type NUMBER(4,0) DEFAULT NULL,
  btn_name varchar(50) DEFAULT NULL,
  btn_func NUMBER(11,0) DEFAULT NULL,
  btn_func_set1 varchar(200) DEFAULT NULL,
  btn_func_set2 varchar(200) DEFAULT NULL,
  isshow NUMBER(4,0) DEFAULT NULL,
  showorder NUMBER(11,0) DEFAULT NULL,
  icon_default varchar(200) NOT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sc_theme_nav_btn IS '企业客户端主题导航按钮设置表'
;
COMMENT ON COLUMN em_sc_theme_nav_btn.id IS '主键ID'
;
COMMENT ON COLUMN em_sc_theme_nav_btn.theme_base_id IS '主题ID'
;
COMMENT ON COLUMN em_sc_theme_nav_btn.theme_nav_id IS '导航明细ID'
;
COMMENT ON COLUMN em_sc_theme_nav_btn.btn_type IS '按钮类型 1-右上角按钮，2-消息功能按钮'
;
COMMENT ON COLUMN em_sc_theme_nav_btn.btn_name IS '按钮名称'
;
COMMENT ON COLUMN em_sc_theme_nav_btn.btn_func IS '按钮功能：1-应用，2-门户，3-自定义链接'
;
COMMENT ON COLUMN em_sc_theme_nav_btn.btn_func_set1 IS '按钮功能设置，如应用ID、门户ID，自定义链接地址等'
;
COMMENT ON COLUMN em_sc_theme_nav_btn.btn_func_set2 IS '按钮功能设置，如自定义链接的打开方式1表示默认窗口，2表示新窗口'
;
COMMENT ON COLUMN em_sc_theme_nav_btn.isshow IS '是否显示：1-登显示，0-不显示'
;
COMMENT ON COLUMN em_sc_theme_nav_btn.showorder IS '显示顺序'
;
COMMENT ON COLUMN em_sc_theme_nav_btn.icon_default IS '默认显示图标'
;
COMMENT ON COLUMN em_sc_theme_nav_btn.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_sc_theme_nav_btn.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sc_theme_nav_btn.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sc_theme_nav_btn.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sc_theme_nav_btn.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sc_theme_nav_btn.tenant_id IS '企业租户ID'
;
CREATE INDEX em_sc_theme_nav_btn_tbi_idx ON em_sc_theme_nav_btn(theme_base_id)
;
CREATE INDEX em_sc_theme_nav_btn_tni_idx ON em_sc_theme_nav_btn(theme_nav_id)
;
CREATE INDEX em_sc_theme_nav_btn_ti_idx ON em_sc_theme_nav_btn(tenant_id)
;
INSERT INTO em_sc_theme_nav_btn VALUES ('1','1','1',1,'密聊',-11,NULL,NULL,1,1,'/common/images/app/btn_chat_default.png',1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('10','1','1',1,'必达',-10,NULL,NULL,1,5,'/common/images/app/btn_ding_default.png',1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('11','2','11',1,'发起群聊',-14,NULL,NULL,1,1,'/common/images/pcclient/btn_group_default.png',1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('12','2','11',1,'必达',-10,NULL,NULL,1,2,'/common/images/pcclient/btn_ding_default.png',1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('2','1','1',1,'电话',-12,NULL,NULL,1,2,'/common/images/app/btn_call_default.png',1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('21','3','21',1,'发起群聊',-14,NULL,NULL,1,1,'/common/images/pcweb/btn_group_default.png',1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('22','3','21',1,'必达',-10,NULL,NULL,1,2,'/common/images/pcweb/btn_ding_default.png',1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('3','1','1',1,'扫一扫',-13,NULL,NULL,1,3,'/common/images/app/btn_scan_default.png',1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('4','1','1',1,'发起群聊',-14,NULL,NULL,1,4,'/common/images/app/btn_group_default.png',1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('5','1','1',1,'专注模式',-15,NULL,NULL,0,6,'/common/images/app/btn_absorbed_default.png',1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('6','1','3',1,'消息',-16,NULL,NULL,0,1,'/common/images/app/btn_msg_default.png',1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('7','1','3',1,'应用商店',-17,NULL,NULL,0,2,'/common/images/app/btn_appstore_default.png',1,NULL,NULL,NULL,NULL,'')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('anb1','a1','an1',1,'密聊',-11,NULL,NULL,1,1,'/common/images/app/btn_chat_default.png',1,NULL,NULL,NULL,NULL,'1')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('anb10','a1','an1',1,'必达',-10,NULL,NULL,1,5,'/common/images/app/btn_ding_default.png',1,NULL,NULL,NULL,NULL,'1')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('anb2','a1','an1',1,'电话',-12,NULL,NULL,1,2,'/common/images/app/btn_call_default.png',1,NULL,NULL,NULL,NULL,'1')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('anb3','a1','an1',1,'扫一扫',-13,NULL,NULL,1,3,'/common/images/app/btn_scan_default.png',1,NULL,NULL,NULL,NULL,'1')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('anb4','a1','an1',1,'发起群聊',-14,NULL,NULL,1,4,'/common/images/app/btn_group_default.png',1,NULL,NULL,NULL,NULL,'1')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('anb5','a1','an1',1,'专注模式',-15,NULL,NULL,0,6,'/common/images/app/btn_absorbed_default.png',1,NULL,NULL,NULL,NULL,'1')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('anb6','a1','an3',1,'消息',-16,NULL,NULL,0,1,'/common/images/app/btn_msg_default.png',1,NULL,NULL,NULL,NULL,'1')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('anb7','a1','an3',1,'应用商店',-17,NULL,NULL,0,2,'/common/images/app/btn_appstore_default.png',1,NULL,NULL,NULL,NULL,'1')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('pnb1','p1','pn1',1,'发起群聊',-14,NULL,NULL,1,1,'/common/images/pcclient/btn_group_default.png',1,NULL,NULL,NULL,NULL,'1')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('pnb2','p1','pn1',1,'必达',-10,NULL,NULL,1,2,'/common/images/pcclient/btn_ding_default.png',1,NULL,NULL,NULL,NULL,'1')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('wnb1','w1','wn1',1,'发起群聊',-14,NULL,NULL,1,1,'/common/images/pcweb/btn_group_default.png',1,NULL,NULL,NULL,NULL,'1')
;
INSERT INTO em_sc_theme_nav_btn VALUES ('wnb2','w1','wn1',1,'必达',-10,NULL,NULL,1,2,'/common/images/pcweb/btn_ding_default.png',1,NULL,NULL,NULL,NULL,'1')
;
CREATE TABLE em_sc_theme_view (
  id varchar(32) NOT NULL PRIMARY KEY,
  theme_base_id varchar(32) DEFAULT NULL,
  hrm_data_type NUMBER(4,0) DEFAULT NULL,
  hrm_data_id varchar(32) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sc_theme_view IS '企业客户端主题可见范围设置表'
;
COMMENT ON COLUMN em_sc_theme_view.id IS '主键ID'
;
COMMENT ON COLUMN em_sc_theme_view.theme_base_id IS '主题ID'
;
COMMENT ON COLUMN em_sc_theme_view.hrm_data_type IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;
COMMENT ON COLUMN em_sc_theme_view.hrm_data_id IS '通讯录成员或部门表ID'
;
COMMENT ON COLUMN em_sc_theme_view.status IS '状态：1-正常，3-删除'
;
COMMENT ON COLUMN em_sc_theme_view.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sc_theme_view.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sc_theme_view.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sc_theme_view.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sc_theme_view.tenant_id IS '企业租户ID'
;
CREATE INDEX em_sc_theme_view_tbi_idx ON em_sc_theme_view(theme_base_id)
;
CREATE INDEX em_sc_theme_view_hdi_idx ON em_sc_theme_view(hrm_data_id)
;
CREATE INDEX em_sc_theme_view_ti_idx ON em_sc_theme_view(tenant_id)
;
CREATE TABLE em_sc_workbench (
  id varchar(32) NOT NULL PRIMARY KEY,
  client_type NUMBER(4,0) DEFAULT NULL,
  set_type NUMBER(4,0) DEFAULT NULL,
  set_value varchar(200) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sc_workbench IS '企业客户端工作台设置表'
;
COMMENT ON COLUMN em_sc_workbench.id IS '主键ID'
;
COMMENT ON COLUMN em_sc_workbench.client_type IS '客户端类型 1-移动APP，2-PC客户端，3-web客户端'
;
COMMENT ON COLUMN em_sc_workbench.set_type IS '设置类型：1-默认门户，2-指定门户，2-自定义链接'
;
COMMENT ON COLUMN em_sc_workbench.set_value IS '设置数据，针对门户对应门户的主键ID，针对自定义链接则为对应的链接地址'
;
COMMENT ON COLUMN em_sc_workbench.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_sc_workbench.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sc_workbench.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sc_workbench.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sc_workbench.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sc_workbench.tenant_id IS '企业租户ID'
;
CREATE INDEX em_sc_workbench_ti_idx ON em_sc_workbench(tenant_id)
;
CREATE TABLE em_sh_data_interface (
  id varchar(32) NOT NULL PRIMARY KEY,
  org_set NUMBER(4,0) DEFAULT NULL,
  org_outsysid varchar(32) DEFAULT NULL,
  card_set NUMBER(4,0) DEFAULT NULL,
  card_outsysid varchar(32) DEFAULT NULL,
  group_set NUMBER(4,0) DEFAULT NULL,
  group_outsysid varchar(32) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sh_data_interface IS '通讯录接口设置表'
;
COMMENT ON COLUMN em_sh_data_interface.id IS '主键'
;
COMMENT ON COLUMN em_sh_data_interface.org_set IS '组织数据获取方式：1-本系统，2-Ecology系统'
;
COMMENT ON COLUMN em_sh_data_interface.org_outsysid IS '组织数据获取对应的集成Ecology系统ID'
;
COMMENT ON COLUMN em_sh_data_interface.card_set IS '人员卡片获取方式：1-本系统，2-Ecology系统'
;
COMMENT ON COLUMN em_sh_data_interface.card_outsysid IS '人员卡片获取对应的集成Ecology系统ID'
;
COMMENT ON COLUMN em_sh_data_interface.group_set IS '常用组获取方式：1-本系统，2-Ecology系统'
;
COMMENT ON COLUMN em_sh_data_interface.group_outsysid IS '常用组获取对应的集成Ecology系统ID'
;
COMMENT ON COLUMN em_sh_data_interface.status IS '状态：1-正常，3-删除'
;
COMMENT ON COLUMN em_sh_data_interface.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sh_data_interface.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sh_data_interface.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sh_data_interface.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sh_data_interface.tenant_id IS '企业租户ID'
;
CREATE TABLE em_sh_right_base (
  id varchar(32) NOT NULL PRIMARY KEY,
  right_base_name varchar(100) DEFAULT NULL,
  priority NUMBER(11,0) DEFAULT '0',
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sh_right_base IS '企业通讯录权限规则基础表'
;
COMMENT ON COLUMN em_sh_right_base.id IS '主键ID'
;
COMMENT ON COLUMN em_sh_right_base.right_base_name IS '权限规则名称'
;
COMMENT ON COLUMN em_sh_right_base.priority IS '优先级'
;
COMMENT ON COLUMN em_sh_right_base.status IS '状态：1-正常，3-删除'
;
COMMENT ON COLUMN em_sh_right_base.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sh_right_base.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sh_right_base.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sh_right_base.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sh_right_base.tenant_id IS '企业租户ID'
;
CREATE INDEX em_sh_right_base_ti_idx ON em_sh_right_base(tenant_id)
;
CREATE TABLE em_sh_right_data (
  id varchar(32) NOT NULL PRIMARY KEY,
  right_base_id varchar(32) DEFAULT NULL,
  right_type NUMBER(11,0) DEFAULT '1',
  right_field_id varchar(32) DEFAULT NULL,
  permit_type NUMBER(4,0) DEFAULT '1',
  hrm_data_type NUMBER(4,0) DEFAULT NULL,
  hrm_data_id varchar(32) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sh_right_data IS '企业通讯录权限规则数据表'
;
COMMENT ON COLUMN em_sh_right_data.id IS '主键ID'
;
COMMENT ON COLUMN em_sh_right_data.right_base_id IS '权限设置基础ID'
;
COMMENT ON COLUMN em_sh_right_data.right_type IS '权限类型：1-查看，2-发消息，3-打电话，9-查看具体字段'
;
COMMENT ON COLUMN em_sh_right_data.right_field_id IS '查看具体字段的ID，当值为1时表示手机号，否则为em_hrm_user_attr表的ID值'
;
COMMENT ON COLUMN em_sh_right_data.permit_type IS '允许或禁止：1-允许，2-禁止'
;
COMMENT ON COLUMN em_sh_right_data.hrm_data_type IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级），5-本部门（含下级），6-本部门（不含下级）'
;
COMMENT ON COLUMN em_sh_right_data.hrm_data_id IS '通讯录成员或部门表ID'
;
COMMENT ON COLUMN em_sh_right_data.status IS '状态：1-正常，3-删除'
;
COMMENT ON COLUMN em_sh_right_data.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sh_right_data.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sh_right_data.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sh_right_data.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sh_right_data.tenant_id IS '企业租户ID'
;
CREATE INDEX em_sh_right_data_rbi_idx ON em_sh_right_data(right_base_id)
;
CREATE INDEX em_sh_right_data_hdi_idx ON em_sh_right_data(hrm_data_id)
;
CREATE INDEX em_sh_right_data_ti_idx ON em_sh_right_data(tenant_id)
;
CREATE TABLE em_sh_right_target (
  id varchar(32) NOT NULL PRIMARY KEY,
  right_base_id varchar(32) DEFAULT NULL,
  hrm_data_type NUMBER(4,0) DEFAULT NULL,
  hrm_data_id varchar(32) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sh_right_target IS '企业通讯录权限规则对象表'
;
COMMENT ON COLUMN em_sh_right_target.id IS '主键ID'
;
COMMENT ON COLUMN em_sh_right_target.right_base_id IS '权限设置基础ID'
;
COMMENT ON COLUMN em_sh_right_target.hrm_data_type IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;
COMMENT ON COLUMN em_sh_right_target.hrm_data_id IS '通讯录成员或部门表ID'
;
COMMENT ON COLUMN em_sh_right_target.status IS '状态：1-正常，3-删除'
;
COMMENT ON COLUMN em_sh_right_target.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sh_right_target.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sh_right_target.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sh_right_target.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sh_right_target.tenant_id IS '企业租户ID'
;
CREATE INDEX em_sh_right_target_rbi_idx ON em_sh_right_target(right_base_id)
;
CREATE INDEX em_sh_right_target_hdi_idx ON em_sh_right_target(hrm_data_id)
;
CREATE INDEX em_sh_right_target_ti_idx ON em_sh_right_target(tenant_id)
;
CREATE TABLE em_sh_user_fieldhidden (
  id varchar(32) NOT NULL PRIMARY KEY,
  field_id varchar(32) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sh_user_fieldhidden IS '企业通讯录信息隐藏设置表'
;
COMMENT ON COLUMN em_sh_user_fieldhidden.id IS '主键ID'
;
COMMENT ON COLUMN em_sh_user_fieldhidden.field_id IS '隐藏的字段ID： 1-手机，2-邮箱，3-岗位，4-座机，否则是em_hrm_user_attr表的ID'
;
COMMENT ON COLUMN em_sh_user_fieldhidden.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_sh_user_fieldhidden.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sh_user_fieldhidden.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sh_user_fieldhidden.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sh_user_fieldhidden.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sh_user_fieldhidden.tenant_id IS '企业租户ID'
;
CREATE INDEX em_sh_user_fieldhidden_ti_idx ON em_sh_user_fieldhidden(tenant_id)
;
CREATE TABLE em_setting_role (
  id varchar(32) NOT NULL PRIMARY KEY,
  open_role_id NUMBER(11,0) DEFAULT NULL,
  role_name varchar(100) DEFAULT NULL,
  english_name varchar(100) DEFAULT NULL,
  description varchar(200) DEFAULT NULL,
  role_type NUMBER(4,0) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_setting_role IS '企业管理角色表'
;
COMMENT ON COLUMN em_setting_role.id IS '主键ID'
;
COMMENT ON COLUMN em_setting_role.open_role_id IS 'API交互时的唯一标识，采用某企业内自增长逻辑，即按tenantid自增长'
;
COMMENT ON COLUMN em_setting_role.role_name IS '角色名称'
;
COMMENT ON COLUMN em_setting_role.english_name IS '英文名称'
;
COMMENT ON COLUMN em_setting_role.description IS '角色描述'
;
COMMENT ON COLUMN em_setting_role.role_type IS '角色类型 1-用户角色，2-应用角色，3-接口角色'
;
COMMENT ON COLUMN em_setting_role.status IS '状态 1-正常，2-禁用，3-删除'
;
COMMENT ON COLUMN em_setting_role.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_setting_role.create_time IS '创建时间'
;
COMMENT ON COLUMN em_setting_role.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_setting_role.update_time IS '修改时间'
;
COMMENT ON COLUMN em_setting_role.tenant_id IS '企业租户ID'
;
CREATE INDEX em_setting_role_ori_idx ON em_setting_role(open_role_id)
;
CREATE INDEX em_setting_role_ti_idx ON em_setting_role(tenant_id)
;
CREATE TABLE em_setting_role_right (
  id varchar(32) NOT NULL PRIMARY KEY,
  setting_role_id varchar(32) DEFAULT NULL,
  right_data_type NUMBER(4,0) DEFAULT NULL,
  right_data_id varchar(32) DEFAULT NULL,
  right_level NUMBER(4,0) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_setting_role_right IS '企业管理角色与权限关联表'
;
COMMENT ON COLUMN em_setting_role_right.id IS '主键ID'
;
COMMENT ON COLUMN em_setting_role_right.setting_role_id IS '管理组ID'
;
COMMENT ON COLUMN em_setting_role_right.right_data_type IS '管理数据类型 1-通讯录部门，2-通讯录成员，3-应用查看管理，4-应用创建'
;
COMMENT ON COLUMN em_setting_role_right.right_data_id IS '管理的数据ID，即部门成员应用ID'
;
COMMENT ON COLUMN em_setting_role_right.right_level IS '管理的权限级别，对应通讯录：1-仅具有查看权限，2-具有管理权限；对于应用：1-仅具有发送消息权限，2-具体管理权限'
;
COMMENT ON COLUMN em_setting_role_right.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_setting_role_right.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_setting_role_right.create_time IS '创建时间'
;
COMMENT ON COLUMN em_setting_role_right.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_setting_role_right.update_time IS '修改时间'
;
COMMENT ON COLUMN em_setting_role_right.tenant_id IS '企业租户ID'
;
CREATE INDEX em_setting_role_right_sri_idx ON em_setting_role_right(setting_role_id)
;
CREATE INDEX em_setting_role_right_rdi_idx ON em_setting_role_right(right_data_id)
;
CREATE INDEX em_setting_role_right_ti_idx ON em_setting_role_right(tenant_id)
;
CREATE TABLE em_setting_role_user (
  id varchar(32) NOT NULL PRIMARY KEY,
  setting_role_id varchar(32) DEFAULT NULL,
  base_user_id varchar(32) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_setting_role_user IS '企业管理角色与基础用户关联表'
;
COMMENT ON COLUMN em_setting_role_user.id IS '主键ID'
;
COMMENT ON COLUMN em_setting_role_user.setting_role_id IS '角色ID'
;
COMMENT ON COLUMN em_setting_role_user.base_user_id IS '基础用户ID'
;
COMMENT ON COLUMN em_setting_role_user.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_setting_role_user.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_setting_role_user.create_time IS '创建时间'
;
COMMENT ON COLUMN em_setting_role_user.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_setting_role_user.update_time IS '修改时间'
;
COMMENT ON COLUMN em_setting_role_user.tenant_id IS '企业租户ID'
;
CREATE INDEX em_setting_role_user_sri_idx ON em_setting_role_user(setting_role_id)
;
CREATE INDEX em_setting_role_user_bui_idx ON em_setting_role_user(base_user_id)
;
CREATE INDEX em_setting_role_user_ti_idx ON em_setting_role_user(tenant_id)
;
CREATE TABLE em_setting_voice (
  id varchar(32) NOT NULL,
  name varchar(255) DEFAULT NULL,
  strategy varchar(255) DEFAULT NULL CHECK (strategy IN ('cloopen')),
  setting CLOB,
  is_defalut NUMBER(4,0) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL,
  PRIMARY KEY (id)
)
;
COMMENT ON TABLE em_setting_voice IS '语音通知设置表'
;
COMMENT ON COLUMN em_setting_voice.id IS '主键'
;
COMMENT ON COLUMN em_setting_voice.name IS '语音通知模板名称'
;
COMMENT ON COLUMN em_setting_voice.strategy IS '语音通知模板策略'
;
COMMENT ON COLUMN em_setting_voice.setting IS '语音通知模板设置参数（JSON数据）'
;
COMMENT ON COLUMN em_setting_voice.is_defalut IS '是否设为默认：1-是，其他-否'
;
COMMENT ON COLUMN em_setting_voice.status IS '状态'
;
COMMENT ON COLUMN em_setting_voice.create_time IS '创建时间'
;
COMMENT ON COLUMN em_setting_voice.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_setting_voice.update_time IS '修改时间'
;
COMMENT ON COLUMN em_setting_voice.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_setting_voice.tenant_id IS '企业租户ID'
;
CREATE TABLE em_sms_record (
  id varchar(32) NOT NULL PRIMARY KEY,
  mobile varchar(50) DEFAULT NULL,
  content CLOB,
  sms_type NUMBER(4,0) DEFAULT NULL,
  strategy varchar(255) DEFAULT NULL,
  success NUMBER(4,0) DEFAULT NULL,
  remark CLOB,
  status NUMBER(4,0) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sms_record IS '短信记录表'
;
COMMENT ON COLUMN em_sms_record.id IS '主键'
;
COMMENT ON COLUMN em_sms_record.mobile IS '手机号'
;
COMMENT ON COLUMN em_sms_record.content IS '短信内容'
;
COMMENT ON COLUMN em_sms_record.sms_type IS '短信类型：1-验证码、2-普通短消息'
;
COMMENT ON COLUMN em_sms_record.strategy IS '策略'
;
COMMENT ON COLUMN em_sms_record.success IS '是否发送成功：0-失败、1-成功'
;
COMMENT ON COLUMN em_sms_record.remark IS '备注'
;
COMMENT ON COLUMN em_sms_record.status IS '状态'
;
COMMENT ON COLUMN em_sms_record.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sms_record.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sms_record.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sms_record.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sms_record.tenant_id IS '企业租户ID'
;
CREATE INDEX em_sms_record_tenant_id_index ON em_sms_record(tenant_id)
;
CREATE TABLE em_sms_template (
  id varchar(32) NOT NULL PRIMARY KEY,
  name varchar(255) DEFAULT NULL,
  strategy varchar(255) DEFAULT NULL CHECK (strategy IN ('ALIYUN','EMAY')),
  setting CLOB,
  is_defalut NUMBER(4,0) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sms_template IS '短信服务设置表'
;
COMMENT ON COLUMN em_sms_template.id IS '主键'
;
COMMENT ON COLUMN em_sms_template.name IS '短信模板名称'
;
COMMENT ON COLUMN em_sms_template.strategy IS '短信模板策略'
;
COMMENT ON COLUMN em_sms_template.setting IS '短信模板设置参数（JSON数据）'
;
COMMENT ON COLUMN em_sms_template.is_defalut IS '是否设为默认：1-是，其他-否'
;
COMMENT ON COLUMN em_sms_template.status IS '状态'
;
COMMENT ON COLUMN em_sms_template.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sms_template.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sms_template.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sms_template.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sms_template.tenant_id IS '企业租户ID'
;
CREATE TABLE em_sys_base_file (
  id varchar(32) NOT NULL PRIMARY KEY,
  file_name varchar(255) DEFAULT NULL,
  file_extension varchar(255) DEFAULT NULL,
  file_content_type varchar(255) DEFAULT NULL,
  file_size NUMBER(20,0) DEFAULT NULL,
  file_path varchar(1000) DEFAULT NULL,
  is_open NUMBER(4,0) DEFAULT NULL,
  media_type varchar(255) DEFAULT NULL CHECK (media_type IN ('image','voice','video','file')),
  parent_id varchar(32) DEFAULT NULL,
  thumbnail NUMBER(4,0) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_base_file IS '文件记录表'
;
COMMENT ON COLUMN em_sys_base_file.id IS '主键'
;
COMMENT ON COLUMN em_sys_base_file.file_name IS '文件名称'
;
COMMENT ON COLUMN em_sys_base_file.file_extension IS '文件扩展名'
;
COMMENT ON COLUMN em_sys_base_file.file_content_type IS '文件类型'
;
COMMENT ON COLUMN em_sys_base_file.file_size IS '文件大小'
;
COMMENT ON COLUMN em_sys_base_file.file_path IS '文件路径'
;
COMMENT ON COLUMN em_sys_base_file.is_open IS '文件是否开放访问：0-不开放、1-开放'
;
COMMENT ON COLUMN em_sys_base_file.media_type IS '素材类型'
;
COMMENT ON COLUMN em_sys_base_file.parent_id IS '父文件ID'
;
COMMENT ON COLUMN em_sys_base_file.thumbnail IS '缩略图类型'
;
COMMENT ON COLUMN em_sys_base_file.status IS '状态'
;
COMMENT ON COLUMN em_sys_base_file.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_base_file.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_base_file.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_base_file.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_base_file.tenant_id IS '企业租户ID'
;
CREATE TABLE em_sys_base_setting (
  id varchar(32) NOT NULL PRIMARY KEY,
  sys_outer_url varchar(100) DEFAULT NULL,
  sys_inner_url varchar(100) DEFAULT NULL,
  upload_path varchar(255) DEFAULT NULL,
  cache_auth_type varchar(255) DEFAULT NULL CHECK (cache_auth_type IN ('EHCACHE','REDIS','NONE')),
  cache_common_type varchar(255) DEFAULT NULL CHECK (cache_common_type IN ('EHCACHE','REDIS','NONE')),
  login_mode_app varchar(32) DEFAULT NULL,
  login_mode_pc varchar(32) DEFAULT NULL,
  enable_register NUMBER(4,0) DEFAULT NULL,
  enable_retrieve NUMBER(4,0) DEFAULT NULL,
  custom_login_page varchar(255) DEFAULT NULL,
  enable_update_baseinfo NUMBER(4,0) DEFAULT NULL,
  enable_update_password NUMBER(4,0) DEFAULT NULL,
  enable_get_ecuser NUMBER(4,0) DEFAULT NULL,
  get_ecuser_outsysid varchar(32) DEFAULT NULL,
  code_sms_id varchar(32) DEFAULT NULL,
  enable_userlink NUMBER(4,0) DEFAULT NULL,
  userlink_outsysid varchar(32) DEFAULT NULL,
  userlink_url varchar(100) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_base_setting IS '系统基本信息设置'
;
COMMENT ON COLUMN em_sys_base_setting.id IS '主键'
;
COMMENT ON COLUMN em_sys_base_setting.sys_outer_url IS '本系统的外部地址'
;
COMMENT ON COLUMN em_sys_base_setting.sys_inner_url IS '本系统的内部地址'
;
COMMENT ON COLUMN em_sys_base_setting.upload_path IS '文件上传路径'
;
COMMENT ON COLUMN em_sys_base_setting.cache_auth_type IS '认证缓存类型'
;
COMMENT ON COLUMN em_sys_base_setting.cache_common_type IS '普通缓存类型'
;
COMMENT ON COLUMN em_sys_base_setting.login_mode_app IS '移动端登录方式(多选，逗号分隔)：1-账号密码、2-手机验证码'
;
COMMENT ON COLUMN em_sys_base_setting.login_mode_pc IS 'PC端登录方式(多选，逗号分隔)：1-账号密码、2-手机验证码、3-扫描二维码'
;
COMMENT ON COLUMN em_sys_base_setting.enable_register IS '是否开启注册：1-是、0-否'
;
COMMENT ON COLUMN em_sys_base_setting.enable_retrieve IS '是否开启找回密码：1-是、0-否'
;
COMMENT ON COLUMN em_sys_base_setting.custom_login_page IS '客户端自定义登录页面地址'
;
COMMENT ON COLUMN em_sys_base_setting.enable_update_baseinfo IS '是否开启客户端修改个人基本信息：1-是、0-否'
;
COMMENT ON COLUMN em_sys_base_setting.enable_update_password IS '是否开启客户端修改个人密码：1-是、0-否'
;
COMMENT ON COLUMN em_sys_base_setting.enable_get_ecuser IS '是否开启从Ecology系统获取基础用户信息：1-是、0-否'
;
COMMENT ON COLUMN em_sys_base_setting.get_ecuser_outsysid IS '从Ecology系统获取基础用户信息的系统ID'
;
COMMENT ON COLUMN em_sys_base_setting.code_sms_id IS '发送短信验证码时使用的短信服务ID'
;
COMMENT ON COLUMN em_sys_base_setting.enable_userlink IS '是否开启人员卡片按钮功能：1-是、0-否'
;
COMMENT ON COLUMN em_sys_base_setting.userlink_outsysid IS '人员卡片按钮功能，使用集成系统方式配置来打开，此处配置相应集成系统id'
;
COMMENT ON COLUMN em_sys_base_setting.userlink_url IS '人员卡片按钮功能，使用url配置方式直接打开，此处配置相关的url数据'
;
COMMENT ON COLUMN em_sys_base_setting.status IS '状态'
;
COMMENT ON COLUMN em_sys_base_setting.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_base_setting.create_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_base_setting.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_base_setting.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_base_setting.tenant_id IS '企业租户ID'
;
INSERT INTO em_sys_base_setting VALUES ('1730789008395314602',NULL,NULL,'','EHCACHE','EHCACHE','1','1,3',0,1,NULL,0,0,0,NULL,NULL,NULL,NULL,NULL,1,'1',sysdate,NULL,NULL,'1')
;
CREATE TABLE em_sys_base_user (
  id varchar(32) NOT NULL PRIMARY KEY,
  user_type NUMBER(4,0) DEFAULT NULL,
  user_name varchar(100) DEFAULT NULL,
  name_simple_pingyin varchar(500) DEFAULT NULL,
  name_full_pingyin varchar(500) DEFAULT NULL,
  loginid varchar(50) DEFAULT NULL,
  user_password varchar(100) DEFAULT NULL,
  salt varchar(20) DEFAULT NULL,
  nick_name varchar(100) DEFAULT NULL,
  mobile varchar(50) DEFAULT NULL,
  mobile_prefix varchar(32) DEFAULT NULL,
  email varchar(100) DEFAULT NULL,
  avatar varchar(255) DEFAULT NULL,
  gender NUMBER(4,0) DEFAULT '0',
  birthday date DEFAULT NULL,
  status NUMBER(4,0) DEFAULT NULL,
  main_tenant_id varchar(32) DEFAULT NULL,
  web_theme_id varchar(32) DEFAULT NULL,
  pc_theme_id varchar(32) DEFAULT NULL,
  app_theme_id varchar(32) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  work_cond_icon varchar(50) DEFAULT NULL,
  work_cond_txt varchar(50) DEFAULT NULL,
  server_base_user_id varchar(200) DEFAULT NULL,
  issysadmin NUMBER(4,0) DEFAULT '0',
  regist_time TIMESTAMP DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_base_user IS '基础用户表'
;
COMMENT ON COLUMN em_sys_base_user.id IS '主键ID'
;
COMMENT ON COLUMN em_sys_base_user.user_type IS '用户类型 1-真实用户，2-应用管理，3-接口管理组'
;
COMMENT ON COLUMN em_sys_base_user.user_name IS '姓名'
;
COMMENT ON COLUMN em_sys_base_user.name_simple_pingyin IS '名字拼音简拼'
;
COMMENT ON COLUMN em_sys_base_user.name_full_pingyin IS '名字拼音全拼'
;
COMMENT ON COLUMN em_sys_base_user.loginid IS '登录名'
;
COMMENT ON COLUMN em_sys_base_user.user_password IS '登录密码'
;
COMMENT ON COLUMN em_sys_base_user.salt IS '盐-用于密码加密'
;
COMMENT ON COLUMN em_sys_base_user.nick_name IS '昵称'
;
COMMENT ON COLUMN em_sys_base_user.mobile IS '手机'
;
COMMENT ON COLUMN em_sys_base_user.mobile_prefix IS '国际手机区号'
;
COMMENT ON COLUMN em_sys_base_user.email IS '邮箱'
;
COMMENT ON COLUMN em_sys_base_user.avatar IS '头像'
;
COMMENT ON COLUMN em_sys_base_user.gender IS '性别 1表示男性，2表示女性，0表示未知'
;
COMMENT ON COLUMN em_sys_base_user.birthday IS '生日'
;
COMMENT ON COLUMN em_sys_base_user.status IS '状态 1-已注册，2-未注册，3-删除'
;
COMMENT ON COLUMN em_sys_base_user.main_tenant_id IS '主租户ID'
;
COMMENT ON COLUMN em_sys_base_user.web_theme_id IS '设定的web端默认主题'
;
COMMENT ON COLUMN em_sys_base_user.pc_theme_id IS '设定的pc端默认主题'
;
COMMENT ON COLUMN em_sys_base_user.app_theme_id IS '设定的app移动端默认主题'
;
COMMENT ON COLUMN em_sys_base_user.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_base_user.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_base_user.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_base_user.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_base_user.work_cond_icon IS '工作状态图标'
;
COMMENT ON COLUMN em_sys_base_user.work_cond_txt IS '工作状态内容'
;
COMMENT ON COLUMN em_sys_base_user.issysadmin IS '是否为系统管理'
;
COMMENT ON COLUMN em_sys_base_user.regist_time IS '注册时间'
;
INSERT INTO em_sys_base_user VALUES ('1',1,'系统管理员',NULL,NULL,'sysadmin','509a737dc9b573d498d69a20ba686152804e7dfa7bcbc6ab6694db5b79ec88e1','1pGTbYLZl9vPTxi0kwbr',NULL,NULL,NULL,NULL,'',0,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL)
;
INSERT INTO em_sys_base_user VALUES ('ding',4,'必达',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',0,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL)
;
INSERT INTO em_sys_base_user VALUES ('s_assist_1931849862568069295',4,'文件小助手','wjxzs','wenjianxiaozhushou','sysassist','','',NULL,NULL,NULL,NULL,'',0,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL)
;
INSERT INTO em_sys_base_user VALUES ('s_notice_1931849795786088294',4,'系统公告','xtgg','xitonggonggao','sysnotice','','',NULL,NULL,NULL,NULL,'',0,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL)
;
INSERT INTO em_sys_base_user VALUES ('s_phone_1931849953024369296',4,'系统电话','xtdh','xitongdianhua','sysphone','','',NULL,NULL,NULL,NULL,'',0,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL)
;
CREATE TABLE em_sys_baseuser_attend (
  id varchar(32) NOT NULL PRIMARY KEY,
  base_user_id varchar(32) DEFAULT NULL,
  attend_user_id varchar(32) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_baseuser_attend IS '关注人'
;
COMMENT ON COLUMN em_sys_baseuser_attend.id IS '主键ID'
;
COMMENT ON COLUMN em_sys_baseuser_attend.base_user_id IS '人员基础用户ID'
;
COMMENT ON COLUMN em_sys_baseuser_attend.attend_user_id IS '关注人员的基础用户ID'
;
COMMENT ON COLUMN em_sys_baseuser_attend.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_baseuser_attend.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_baseuser_attend.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_baseuser_attend.update_time IS '修改时间'
;
CREATE INDEX em_sys_b_a_bui_idx ON em_sys_baseuser_attend(base_user_id)
;
CREATE INDEX em_sys_b_a_ct_idx ON em_sys_baseuser_attend(create_time)
;
CREATE TABLE em_sys_baseuser_contact (
  id varchar(32) NOT NULL PRIMARY KEY,
  base_user_id varchar(32) DEFAULT NULL,
  contact_user_id varchar(32) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_baseuser_contact IS '常用联系人'
;
COMMENT ON COLUMN em_sys_baseuser_contact.id IS '主键ID'
;
COMMENT ON COLUMN em_sys_baseuser_contact.base_user_id IS '人员基础用户ID'
;
COMMENT ON COLUMN em_sys_baseuser_contact.contact_user_id IS '联系人员的基础用户ID'
;
COMMENT ON COLUMN em_sys_baseuser_contact.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_baseuser_contact.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_baseuser_contact.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_baseuser_contact.update_time IS '修改时间'
;
CREATE INDEX em_sys_b_c_bui_idx ON em_sys_baseuser_contact(base_user_id)
;
CREATE INDEX em_sys_b_c_ct_idx ON em_sys_baseuser_contact(create_time)
;
CREATE TABLE em_sys_baseuser_token (
  access_token varchar(100) NOT NULL PRIMARY KEY,
  base_user_id varchar(32) NOT NULL,
  login_type NUMBER(4,0) DEFAULT NULL,
  client_type NUMBER(4,0) DEFAULT '0',
  lang_type varchar(10) DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  expire_time TIMESTAMP DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_baseuser_token IS '基础用户Token'
;
COMMENT ON COLUMN em_sys_baseuser_token.access_token IS '访问token'
;
COMMENT ON COLUMN em_sys_baseuser_token.base_user_id IS '基础用户ID'
;
COMMENT ON COLUMN em_sys_baseuser_token.login_type IS '登录类型：1表示客户端，2表示管理端，3表示接口'
;
COMMENT ON COLUMN em_sys_baseuser_token.client_type IS '登录客户端类型：1表示PC，2表示IOS，3表示安卓，4表示web'
;
COMMENT ON COLUMN em_sys_baseuser_token.lang_type IS '语言类型'
;
COMMENT ON COLUMN em_sys_baseuser_token.tenant_id IS '当前管理的租户ID'
;
COMMENT ON COLUMN em_sys_baseuser_token.status IS '状态：1-正常，3-删除'
;
COMMENT ON COLUMN em_sys_baseuser_token.expire_time IS '过期时间'
;
CREATE INDEX em_sys_b_t_bui_idx ON em_sys_baseuser_token(base_user_id)
;
create index em_idx_expire_time  on em_sys_baseuser_token (expire_time)
;

CREATE TABLE em_sys_cache_configuration (
  id NUMBER(11,0) NOT NULL PRIMARY KEY,
  cacheName varchar(191) DEFAULT NULL,
  maxEntriesLocalHeap NUMBER(20,0) DEFAULT NULL,
  maxEntriesLocalDisk NUMBER(20,0) DEFAULT NULL,
  eternal NUMBER(4,0) DEFAULT NULL,
  clearOnFlush NUMBER(4,0) DEFAULT NULL,
  timeToIdleSeconds NUMBER(20,0) DEFAULT NULL,
  timeToLiveSeconds NUMBER(20,0) DEFAULT NULL,
  diskSpoolBufferSizeMB NUMBER(11,0) DEFAULT NULL,
  persistenceStrategy varchar(255) DEFAULT NULL CHECK (persistenceStrategy IN ('LOCALTEMPSWAP','LOCALRESTARTABLE','NONE','DISTRIBUTED')),
  diskExpiryThreadIntervalSecond NUMBER(20,0) DEFAULT NULL,
  memoryStoreEvictionPolicy varchar(255) DEFAULT NULL CHECK (memoryStoreEvictionPolicy IN ('LRU','LFU','FIFO')),
  transactionalMode varchar(255) DEFAULT NULL CHECK (transactionalMode IN ('OFF','LOCAL','XA','XA_STRICT')),
  isDefaultCache NUMBER(4,0) DEFAULT NULL,
  allow_remove NUMBER(4,0) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_cache_configuration IS '缓存信息表'
;
COMMENT ON COLUMN em_sys_cache_configuration.cacheName IS '缓存名称'
;
COMMENT ON COLUMN em_sys_cache_configuration.maxEntriesLocalHeap IS '同maxElementsInMemory，内存中缓存的element的最大数目'
;
COMMENT ON COLUMN em_sys_cache_configuration.maxEntriesLocalDisk IS '同maxElementsOnDisk，磁盘上缓存的element的最大数目'
;
COMMENT ON COLUMN em_sys_cache_configuration.eternal IS '缓存中的element是否永久有效'
;
COMMENT ON COLUMN em_sys_cache_configuration.clearOnFlush IS '缓存满了是否删除'
;
COMMENT ON COLUMN em_sys_cache_configuration.timeToIdleSeconds IS '缓存过期前的空闲时间'
;
COMMENT ON COLUMN em_sys_cache_configuration.timeToLiveSeconds IS '缓存过期前的生存时间'
;
COMMENT ON COLUMN em_sys_cache_configuration.diskSpoolBufferSizeMB IS '磁盘缓存的缓存区大小'
;
COMMENT ON COLUMN em_sys_cache_configuration.persistenceStrategy IS '缓存持久化策略'
;
COMMENT ON COLUMN em_sys_cache_configuration.diskExpiryThreadIntervalSecond IS '磁盘缓存的清理线程运行间隔'
;
COMMENT ON COLUMN em_sys_cache_configuration.memoryStoreEvictionPolicy IS '移除缓存中element的策略'
;
COMMENT ON COLUMN em_sys_cache_configuration.transactionalMode IS '缓存事务模式'
;
COMMENT ON COLUMN em_sys_cache_configuration.isDefaultCache IS '是否为默认缓存'
;
COMMENT ON COLUMN em_sys_cache_configuration.allow_remove IS '是否允许手动清空缓存：0-不允许、1-允许'
;
CREATE UNIQUE INDEX em_sys_c_c_cn_idx ON em_sys_cache_configuration(cacheName)
;
CREATE SEQUENCE em_sys_cache_configuration_seq start with 0 increment by 1 minvalue 0
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,NULL,1000,100000,0,1,1800,1800,1024,'LOCALTEMPSWAP',120,'LRU','OFF',1,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:sys',10,0,0,1,1800,1800,1024,NULL,120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:mobileArea',10000,10000000,0,1,1800,1800,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:province',10000,10000000,0,1,1800,1800,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:city',10000,10000000,0,1,1800,1800,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:tradecate',10000,10000000,0,1,1800,1800,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:tradetype',10000,10000000,0,1,1800,1800,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:task',5000,0,0,1,1800,1800,1024,NULL,120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:hrmRightData',10000,10000000,0,1,1800,1800,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:sysDefaultTheme',10000,10000000,0,1,1800,1800,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:duplicateToken',10000,10000000,0,1,1800,1800,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:auth:outsys_sessionkey',10000,10000000,0,1,432000,432000,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:ecologyFile',10000,10000000,0,1,604800,604800,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:hrmSetting',10000,10000000,1,1,7200,7200,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:isClientUseToday',10000,10000000,0,1,86400,86400,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:tenant_info',10000,10000000,1,1,7200,7200,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:tenant_convert',10000,10000000,1,1,7200,7200,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:agent_info',10000,10000000,1,1,7200,7200,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:agent_convert',10000,10000000,1,1,7200,7200,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:baseuser_info',10000,10000000,1,1,7200,7200,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:sys_baseusers',10000,10000000,1,1,7200,7200,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:baseuser_tenants',10000,10000000,1,1,7200,7200,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:hrmtenant_depts',10000,10000000,1,1,7200,7200,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:hrmdept_info',10000,10000000,1,1,7200,7200,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:hrmdept_convert',10000,10000000,1,1,7200,7200,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:hrmuser_depts',10000,10000000,1,1,7200,7200,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:hrmdept_users',10000,10000000,1,1,7200,7200,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:hrmuser_info',10000,10000000,1,1,7200,7200,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:hrmuser_convert',10000,10000000,1,1,7200,7200,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:hrmbaseuser_convert',10000,10000000,1,1,7200,7200,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:hrmtag_info',10000,10000000,1,1,7200,7200,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:hrmtag_convert',10000,10000000,1,1,7200,7200,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:hrmuser_attrs',10000,10000000,1,1,7200,7200,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
INSERT INTO em_sys_cache_configuration VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:hrmtag_members',10000,10000000,1,1,7200,7200,1024,'LOCALTEMPSWAP',120,'FIFO','OFF',0,1)
;
CREATE TABLE em_sys_city (
  city_code NUMBER(11,0) NOT NULL PRIMARY KEY,
  city_name varchar(50) NOT NULL,
  province_code NUMBER(11,0) NOT NULL
)
;
COMMENT ON TABLE em_sys_city IS '城市表'
;
COMMENT ON COLUMN em_sys_city.city_code IS '代码'
;
COMMENT ON COLUMN em_sys_city.city_name IS '名称'
;
COMMENT ON COLUMN em_sys_city.province_code IS '所属省份代码'
;
CREATE INDEX em_sys_city_pc_idx ON em_sys_city(province_code)
;
INSERT INTO em_sys_city VALUES (1,'北京市',1)
;
INSERT INTO em_sys_city VALUES (2,'天津市',2)
;
INSERT INTO em_sys_city VALUES (3,'上海市',3)
;
INSERT INTO em_sys_city VALUES (4,'重庆市',4)
;
INSERT INTO em_sys_city VALUES (5,'石家庄市',5)
;
INSERT INTO em_sys_city VALUES (6,'唐山市',5)
;
INSERT INTO em_sys_city VALUES (7,'秦皇岛市',5)
;
INSERT INTO em_sys_city VALUES (8,'邯郸市',5)
;
INSERT INTO em_sys_city VALUES (9,'邢台市',5)
;
INSERT INTO em_sys_city VALUES (10,'保定市',5)
;
INSERT INTO em_sys_city VALUES (11,'张家口市',5)
;
INSERT INTO em_sys_city VALUES (12,'承德市',5)
;
INSERT INTO em_sys_city VALUES (13,'沧州市',5)
;
INSERT INTO em_sys_city VALUES (14,'廊坊市',5)
;
INSERT INTO em_sys_city VALUES (15,'衡水市',5)
;
INSERT INTO em_sys_city VALUES (16,'太原市',6)
;
INSERT INTO em_sys_city VALUES (17,'大同市',6)
;
INSERT INTO em_sys_city VALUES (18,'阳泉市',6)
;
INSERT INTO em_sys_city VALUES (19,'长治市',6)
;
INSERT INTO em_sys_city VALUES (20,'晋城市',6)
;
INSERT INTO em_sys_city VALUES (21,'朔州市',6)
;
INSERT INTO em_sys_city VALUES (22,'晋中市',6)
;
INSERT INTO em_sys_city VALUES (23,'运城市',6)
;
INSERT INTO em_sys_city VALUES (24,'忻州市',6)
;
INSERT INTO em_sys_city VALUES (25,'临汾市',6)
;
INSERT INTO em_sys_city VALUES (26,'吕梁市',6)
;
INSERT INTO em_sys_city VALUES (27,'台北市',7)
;
INSERT INTO em_sys_city VALUES (28,'高雄市',7)
;
INSERT INTO em_sys_city VALUES (29,'基隆市',7)
;
INSERT INTO em_sys_city VALUES (30,'台中市',7)
;
INSERT INTO em_sys_city VALUES (31,'台南市',7)
;
INSERT INTO em_sys_city VALUES (32,'新竹市',7)
;
INSERT INTO em_sys_city VALUES (33,'嘉义市',7)
;
INSERT INTO em_sys_city VALUES (34,'台北县',7)
;
INSERT INTO em_sys_city VALUES (35,'宜兰县',7)
;
INSERT INTO em_sys_city VALUES (36,'桃园县',7)
;
INSERT INTO em_sys_city VALUES (37,'新竹县',7)
;
INSERT INTO em_sys_city VALUES (38,'苗栗县',7)
;
INSERT INTO em_sys_city VALUES (39,'台中县',7)
;
INSERT INTO em_sys_city VALUES (40,'彰化县',7)
;
INSERT INTO em_sys_city VALUES (41,'南投县',7)
;
INSERT INTO em_sys_city VALUES (42,'云林县',7)
;
INSERT INTO em_sys_city VALUES (43,'嘉义县',7)
;
INSERT INTO em_sys_city VALUES (44,'台南县',7)
;
INSERT INTO em_sys_city VALUES (45,'高雄县',7)
;
INSERT INTO em_sys_city VALUES (46,'屏东县',7)
;
INSERT INTO em_sys_city VALUES (47,'澎湖县',7)
;
INSERT INTO em_sys_city VALUES (48,'台东县',7)
;
INSERT INTO em_sys_city VALUES (49,'花莲县',7)
;
INSERT INTO em_sys_city VALUES (50,'沈阳市',8)
;
INSERT INTO em_sys_city VALUES (51,'大连市',8)
;
INSERT INTO em_sys_city VALUES (52,'鞍山市',8)
;
INSERT INTO em_sys_city VALUES (53,'抚顺市',8)
;
INSERT INTO em_sys_city VALUES (54,'本溪市',8)
;
INSERT INTO em_sys_city VALUES (55,'丹东市',8)
;
INSERT INTO em_sys_city VALUES (56,'锦州市',8)
;
INSERT INTO em_sys_city VALUES (57,'营口市',8)
;
INSERT INTO em_sys_city VALUES (58,'阜新市',8)
;
INSERT INTO em_sys_city VALUES (59,'辽阳市',8)
;
INSERT INTO em_sys_city VALUES (60,'盘锦市',8)
;
INSERT INTO em_sys_city VALUES (61,'铁岭市',8)
;
INSERT INTO em_sys_city VALUES (62,'朝阳市',8)
;
INSERT INTO em_sys_city VALUES (63,'葫芦岛市',8)
;
INSERT INTO em_sys_city VALUES (64,'长春市',9)
;
INSERT INTO em_sys_city VALUES (65,'吉林市',9)
;
INSERT INTO em_sys_city VALUES (66,'四平市',9)
;
INSERT INTO em_sys_city VALUES (67,'辽源市',9)
;
INSERT INTO em_sys_city VALUES (68,'通化市',9)
;
INSERT INTO em_sys_city VALUES (69,'白山市',9)
;
INSERT INTO em_sys_city VALUES (70,'松原市',9)
;
INSERT INTO em_sys_city VALUES (71,'白城市',9)
;
INSERT INTO em_sys_city VALUES (72,'延边朝鲜族自治州',9)
;
INSERT INTO em_sys_city VALUES (73,'哈尔滨市',10)
;
INSERT INTO em_sys_city VALUES (74,'齐齐哈尔市',10)
;
INSERT INTO em_sys_city VALUES (75,'鹤岗市',10)
;
INSERT INTO em_sys_city VALUES (76,'双鸭山市',10)
;
INSERT INTO em_sys_city VALUES (77,'鸡西市',10)
;
INSERT INTO em_sys_city VALUES (78,'大庆市',10)
;
INSERT INTO em_sys_city VALUES (79,'伊春市',10)
;
INSERT INTO em_sys_city VALUES (80,'牡丹江市',10)
;
INSERT INTO em_sys_city VALUES (81,'佳木斯市',10)
;
INSERT INTO em_sys_city VALUES (82,'七台河市',10)
;
INSERT INTO em_sys_city VALUES (83,'黑河市',10)
;
INSERT INTO em_sys_city VALUES (84,'绥化市',10)
;
INSERT INTO em_sys_city VALUES (85,'大兴安岭地区',10)
;
INSERT INTO em_sys_city VALUES (86,'南京市',11)
;
INSERT INTO em_sys_city VALUES (87,'无锡市',11)
;
INSERT INTO em_sys_city VALUES (88,'徐州市',11)
;
INSERT INTO em_sys_city VALUES (89,'常州市',11)
;
INSERT INTO em_sys_city VALUES (90,'苏州市',11)
;
INSERT INTO em_sys_city VALUES (91,'南通市',11)
;
INSERT INTO em_sys_city VALUES (92,'连云港市',11)
;
INSERT INTO em_sys_city VALUES (93,'淮安市',11)
;
INSERT INTO em_sys_city VALUES (94,'盐城市',11)
;
INSERT INTO em_sys_city VALUES (95,'扬州市',11)
;
INSERT INTO em_sys_city VALUES (96,'镇江市',11)
;
INSERT INTO em_sys_city VALUES (97,'泰州市',11)
;
INSERT INTO em_sys_city VALUES (98,'宿迁市',11)
;
INSERT INTO em_sys_city VALUES (99,'杭州市',12)
;
INSERT INTO em_sys_city VALUES (100,'宁波市',12)
;
INSERT INTO em_sys_city VALUES (101,'温州市',12)
;
INSERT INTO em_sys_city VALUES (102,'嘉兴市',12)
;
INSERT INTO em_sys_city VALUES (103,'湖州市',12)
;
INSERT INTO em_sys_city VALUES (104,'绍兴市',12)
;
INSERT INTO em_sys_city VALUES (105,'金华市',12)
;
INSERT INTO em_sys_city VALUES (106,'衢州市',12)
;
INSERT INTO em_sys_city VALUES (107,'舟山市',12)
;
INSERT INTO em_sys_city VALUES (108,'台州市',12)
;
INSERT INTO em_sys_city VALUES (109,'丽水市',12)
;
INSERT INTO em_sys_city VALUES (110,'合肥市',13)
;
INSERT INTO em_sys_city VALUES (111,'芜湖市',13)
;
INSERT INTO em_sys_city VALUES (112,'蚌埠市',13)
;
INSERT INTO em_sys_city VALUES (113,'淮南市',13)
;
INSERT INTO em_sys_city VALUES (114,'马鞍山市',13)
;
INSERT INTO em_sys_city VALUES (115,'淮北市',13)
;
INSERT INTO em_sys_city VALUES (116,'铜陵市',13)
;
INSERT INTO em_sys_city VALUES (117,'安庆市',13)
;
INSERT INTO em_sys_city VALUES (118,'黄山市',13)
;
INSERT INTO em_sys_city VALUES (119,'滁州市',13)
;
INSERT INTO em_sys_city VALUES (120,'阜阳市',13)
;
INSERT INTO em_sys_city VALUES (121,'宿州市',13)
;
INSERT INTO em_sys_city VALUES (122,'巢湖市',13)
;
INSERT INTO em_sys_city VALUES (123,'六安市',13)
;
INSERT INTO em_sys_city VALUES (124,'亳州市',13)
;
INSERT INTO em_sys_city VALUES (125,'池州市',13)
;
INSERT INTO em_sys_city VALUES (126,'宣城市',13)
;
INSERT INTO em_sys_city VALUES (127,'福州市',14)
;
INSERT INTO em_sys_city VALUES (128,'厦门市',14)
;
INSERT INTO em_sys_city VALUES (129,'莆田市',14)
;
INSERT INTO em_sys_city VALUES (130,'三明市',14)
;
INSERT INTO em_sys_city VALUES (131,'泉州市',14)
;
INSERT INTO em_sys_city VALUES (132,'漳州市',14)
;
INSERT INTO em_sys_city VALUES (133,'南平市',14)
;
INSERT INTO em_sys_city VALUES (134,'龙岩市',14)
;
INSERT INTO em_sys_city VALUES (135,'宁德市',14)
;
INSERT INTO em_sys_city VALUES (136,'南昌市',15)
;
INSERT INTO em_sys_city VALUES (137,'景德镇市',15)
;
INSERT INTO em_sys_city VALUES (138,'萍乡市',15)
;
INSERT INTO em_sys_city VALUES (139,'九江市',15)
;
INSERT INTO em_sys_city VALUES (140,'新余市',15)
;
INSERT INTO em_sys_city VALUES (141,'鹰潭市',15)
;
INSERT INTO em_sys_city VALUES (142,'赣州市',15)
;
INSERT INTO em_sys_city VALUES (143,'吉安市',15)
;
INSERT INTO em_sys_city VALUES (144,'宜春市',15)
;
INSERT INTO em_sys_city VALUES (145,'抚州市',15)
;
INSERT INTO em_sys_city VALUES (146,'上饶市',15)
;
INSERT INTO em_sys_city VALUES (147,'济南市',16)
;
INSERT INTO em_sys_city VALUES (148,'青岛市',16)
;
INSERT INTO em_sys_city VALUES (149,'淄博市',16)
;
INSERT INTO em_sys_city VALUES (150,'枣庄市',16)
;
INSERT INTO em_sys_city VALUES (151,'东营市',16)
;
INSERT INTO em_sys_city VALUES (152,'烟台市',16)
;
INSERT INTO em_sys_city VALUES (153,'潍坊市',16)
;
INSERT INTO em_sys_city VALUES (154,'济宁市',16)
;
INSERT INTO em_sys_city VALUES (155,'泰安市',16)
;
INSERT INTO em_sys_city VALUES (156,'威海市',16)
;
INSERT INTO em_sys_city VALUES (157,'日照市',16)
;
INSERT INTO em_sys_city VALUES (158,'莱芜市',16)
;
INSERT INTO em_sys_city VALUES (159,'临沂市',16)
;
INSERT INTO em_sys_city VALUES (160,'德州市',16)
;
INSERT INTO em_sys_city VALUES (161,'聊城市',16)
;
INSERT INTO em_sys_city VALUES (162,'滨州市',16)
;
INSERT INTO em_sys_city VALUES (163,'菏泽市',16)
;
INSERT INTO em_sys_city VALUES (164,'郑州市',17)
;
INSERT INTO em_sys_city VALUES (165,'开封市',17)
;
INSERT INTO em_sys_city VALUES (166,'洛阳市',17)
;
INSERT INTO em_sys_city VALUES (167,'平顶山市',17)
;
INSERT INTO em_sys_city VALUES (168,'安阳市',17)
;
INSERT INTO em_sys_city VALUES (169,'鹤壁市',17)
;
INSERT INTO em_sys_city VALUES (170,'新乡市',17)
;
INSERT INTO em_sys_city VALUES (171,'焦作市',17)
;
INSERT INTO em_sys_city VALUES (172,'濮阳市',17)
;
INSERT INTO em_sys_city VALUES (173,'许昌市',17)
;
INSERT INTO em_sys_city VALUES (174,'漯河市',17)
;
INSERT INTO em_sys_city VALUES (175,'三门峡市',17)
;
INSERT INTO em_sys_city VALUES (176,'南阳市',17)
;
INSERT INTO em_sys_city VALUES (177,'商丘市',17)
;
INSERT INTO em_sys_city VALUES (178,'信阳市',17)
;
INSERT INTO em_sys_city VALUES (179,'周口市',17)
;
INSERT INTO em_sys_city VALUES (180,'驻马店市',17)
;
INSERT INTO em_sys_city VALUES (181,'济源市',17)
;
INSERT INTO em_sys_city VALUES (182,'武汉市',18)
;
INSERT INTO em_sys_city VALUES (183,'黄石市',18)
;
INSERT INTO em_sys_city VALUES (184,'十堰市',18)
;
INSERT INTO em_sys_city VALUES (185,'荆州市',18)
;
INSERT INTO em_sys_city VALUES (186,'宜昌市',18)
;
INSERT INTO em_sys_city VALUES (187,'襄樊市',18)
;
INSERT INTO em_sys_city VALUES (188,'鄂州市',18)
;
INSERT INTO em_sys_city VALUES (189,'荆门市',18)
;
INSERT INTO em_sys_city VALUES (190,'孝感市',18)
;
INSERT INTO em_sys_city VALUES (191,'黄冈市',18)
;
INSERT INTO em_sys_city VALUES (192,'咸宁市',18)
;
INSERT INTO em_sys_city VALUES (193,'随州市',18)
;
INSERT INTO em_sys_city VALUES (194,'仙桃市',18)
;
INSERT INTO em_sys_city VALUES (195,'天门市',18)
;
INSERT INTO em_sys_city VALUES (196,'潜江市',18)
;
INSERT INTO em_sys_city VALUES (197,'神农架林区',18)
;
INSERT INTO em_sys_city VALUES (198,'恩施土家族苗族自治州',18)
;
INSERT INTO em_sys_city VALUES (199,'长沙市',19)
;
INSERT INTO em_sys_city VALUES (200,'株洲市',19)
;
INSERT INTO em_sys_city VALUES (201,'湘潭市',19)
;
INSERT INTO em_sys_city VALUES (202,'衡阳市',19)
;
INSERT INTO em_sys_city VALUES (203,'邵阳市',19)
;
INSERT INTO em_sys_city VALUES (204,'岳阳市',19)
;
INSERT INTO em_sys_city VALUES (205,'常德市',19)
;
INSERT INTO em_sys_city VALUES (206,'张家界市',19)
;
INSERT INTO em_sys_city VALUES (207,'益阳市',19)
;
INSERT INTO em_sys_city VALUES (208,'郴州市',19)
;
INSERT INTO em_sys_city VALUES (209,'永州市',19)
;
INSERT INTO em_sys_city VALUES (210,'怀化市',19)
;
INSERT INTO em_sys_city VALUES (211,'娄底市',19)
;
INSERT INTO em_sys_city VALUES (212,'湘西土家族苗族自治州',19)
;
INSERT INTO em_sys_city VALUES (213,'广州市',20)
;
INSERT INTO em_sys_city VALUES (214,'深圳市',20)
;
INSERT INTO em_sys_city VALUES (215,'珠海市',20)
;
INSERT INTO em_sys_city VALUES (216,'汕头市',20)
;
INSERT INTO em_sys_city VALUES (217,'韶关市',20)
;
INSERT INTO em_sys_city VALUES (218,'佛山市',20)
;
INSERT INTO em_sys_city VALUES (219,'江门市',20)
;
INSERT INTO em_sys_city VALUES (220,'湛江市',20)
;
INSERT INTO em_sys_city VALUES (221,'茂名市',20)
;
INSERT INTO em_sys_city VALUES (222,'肇庆市',20)
;
INSERT INTO em_sys_city VALUES (223,'惠州市',20)
;
INSERT INTO em_sys_city VALUES (224,'梅州市',20)
;
INSERT INTO em_sys_city VALUES (225,'汕尾市',20)
;
INSERT INTO em_sys_city VALUES (226,'河源市',20)
;
INSERT INTO em_sys_city VALUES (227,'阳江市',20)
;
INSERT INTO em_sys_city VALUES (228,'清远市',20)
;
INSERT INTO em_sys_city VALUES (229,'东莞市',20)
;
INSERT INTO em_sys_city VALUES (230,'中山市',20)
;
INSERT INTO em_sys_city VALUES (231,'潮州市',20)
;
INSERT INTO em_sys_city VALUES (232,'揭阳市',20)
;
INSERT INTO em_sys_city VALUES (233,'云浮市',20)
;
INSERT INTO em_sys_city VALUES (234,'兰州市',21)
;
INSERT INTO em_sys_city VALUES (235,'金昌市',21)
;
INSERT INTO em_sys_city VALUES (236,'白银市',21)
;
INSERT INTO em_sys_city VALUES (237,'天水市',21)
;
INSERT INTO em_sys_city VALUES (238,'嘉峪关市',21)
;
INSERT INTO em_sys_city VALUES (239,'武威市',21)
;
INSERT INTO em_sys_city VALUES (240,'张掖市',21)
;
INSERT INTO em_sys_city VALUES (241,'平凉市',21)
;
INSERT INTO em_sys_city VALUES (242,'酒泉市',21)
;
INSERT INTO em_sys_city VALUES (243,'庆阳市',21)
;
INSERT INTO em_sys_city VALUES (244,'定西市',21)
;
INSERT INTO em_sys_city VALUES (245,'陇南市',21)
;
INSERT INTO em_sys_city VALUES (246,'临夏回族自治州',21)
;
INSERT INTO em_sys_city VALUES (247,'甘南藏族自治州',21)
;
INSERT INTO em_sys_city VALUES (248,'成都市',22)
;
INSERT INTO em_sys_city VALUES (249,'自贡市',22)
;
INSERT INTO em_sys_city VALUES (250,'攀枝花市',22)
;
INSERT INTO em_sys_city VALUES (251,'泸州市',22)
;
INSERT INTO em_sys_city VALUES (252,'德阳市',22)
;
INSERT INTO em_sys_city VALUES (253,'绵阳市',22)
;
INSERT INTO em_sys_city VALUES (254,'广元市',22)
;
INSERT INTO em_sys_city VALUES (255,'遂宁市',22)
;
INSERT INTO em_sys_city VALUES (256,'内江市',22)
;
INSERT INTO em_sys_city VALUES (257,'乐山市',22)
;
INSERT INTO em_sys_city VALUES (258,'南充市',22)
;
INSERT INTO em_sys_city VALUES (259,'眉山市',22)
;
INSERT INTO em_sys_city VALUES (260,'宜宾市',22)
;
INSERT INTO em_sys_city VALUES (261,'广安市',22)
;
INSERT INTO em_sys_city VALUES (262,'达州市',22)
;
INSERT INTO em_sys_city VALUES (263,'雅安市',22)
;
INSERT INTO em_sys_city VALUES (264,'巴中市',22)
;
INSERT INTO em_sys_city VALUES (265,'资阳市',22)
;
INSERT INTO em_sys_city VALUES (266,'阿坝藏族羌族自治州',22)
;
INSERT INTO em_sys_city VALUES (267,'甘孜藏族自治州',22)
;
INSERT INTO em_sys_city VALUES (268,'凉山彝族自治州',22)
;
INSERT INTO em_sys_city VALUES (269,'贵阳市',23)
;
INSERT INTO em_sys_city VALUES (270,'六盘水市',23)
;
INSERT INTO em_sys_city VALUES (271,'遵义市',23)
;
INSERT INTO em_sys_city VALUES (272,'安顺市',23)
;
INSERT INTO em_sys_city VALUES (273,'铜仁地区',23)
;
INSERT INTO em_sys_city VALUES (274,'毕节地区',23)
;
INSERT INTO em_sys_city VALUES (275,'黔西南布依族苗族自治州',23)
;
INSERT INTO em_sys_city VALUES (276,'黔东南苗族侗族自治州',23)
;
INSERT INTO em_sys_city VALUES (277,'黔南布依族苗族自治州',23)
;
INSERT INTO em_sys_city VALUES (278,'海口市',24)
;
INSERT INTO em_sys_city VALUES (279,'三亚市',24)
;
INSERT INTO em_sys_city VALUES (280,'五指山市',24)
;
INSERT INTO em_sys_city VALUES (281,'琼海市',24)
;
INSERT INTO em_sys_city VALUES (282,'儋州市',24)
;
INSERT INTO em_sys_city VALUES (283,'文昌市',24)
;
INSERT INTO em_sys_city VALUES (284,'万宁市',24)
;
INSERT INTO em_sys_city VALUES (285,'东方市',24)
;
INSERT INTO em_sys_city VALUES (286,'澄迈县',24)
;
INSERT INTO em_sys_city VALUES (287,'定安县',24)
;
INSERT INTO em_sys_city VALUES (288,'屯昌县',24)
;
INSERT INTO em_sys_city VALUES (289,'临高县',24)
;
INSERT INTO em_sys_city VALUES (290,'白沙黎族自治县',24)
;
INSERT INTO em_sys_city VALUES (291,'昌江黎族自治县',24)
;
INSERT INTO em_sys_city VALUES (292,'乐东黎族自治县',24)
;
INSERT INTO em_sys_city VALUES (293,'陵水黎族自治县',24)
;
INSERT INTO em_sys_city VALUES (294,'保亭黎族苗族自治县',24)
;
INSERT INTO em_sys_city VALUES (295,'琼中黎族苗族自治县',24)
;
INSERT INTO em_sys_city VALUES (296,'昆明市',25)
;
INSERT INTO em_sys_city VALUES (297,'曲靖市',25)
;
INSERT INTO em_sys_city VALUES (298,'玉溪市',25)
;
INSERT INTO em_sys_city VALUES (299,'保山市',25)
;
INSERT INTO em_sys_city VALUES (300,'昭通市',25)
;
INSERT INTO em_sys_city VALUES (301,'丽江市',25)
;
INSERT INTO em_sys_city VALUES (302,'思茅市',25)
;
INSERT INTO em_sys_city VALUES (303,'临沧市',25)
;
INSERT INTO em_sys_city VALUES (304,'文山壮族苗族自治州',25)
;
INSERT INTO em_sys_city VALUES (305,'红河哈尼族彝族自治州',25)
;
INSERT INTO em_sys_city VALUES (306,'西双版纳傣族自治州',25)
;
INSERT INTO em_sys_city VALUES (307,'楚雄彝族自治州',25)
;
INSERT INTO em_sys_city VALUES (308,'大理白族自治州',25)
;
INSERT INTO em_sys_city VALUES (309,'德宏傣族景颇族自治州',25)
;
INSERT INTO em_sys_city VALUES (310,'怒江傈傈族自治州',25)
;
INSERT INTO em_sys_city VALUES (311,'迪庆藏族自治州',25)
;
INSERT INTO em_sys_city VALUES (312,'西宁市',26)
;
INSERT INTO em_sys_city VALUES (313,'海东地区',26)
;
INSERT INTO em_sys_city VALUES (314,'海北藏族自治州',26)
;
INSERT INTO em_sys_city VALUES (315,'黄南藏族自治州',26)
;
INSERT INTO em_sys_city VALUES (316,'海南藏族自治州',26)
;
INSERT INTO em_sys_city VALUES (317,'果洛藏族自治州',26)
;
INSERT INTO em_sys_city VALUES (318,'玉树藏族自治州',26)
;
INSERT INTO em_sys_city VALUES (319,'海西蒙古族藏族自治州',26)
;
INSERT INTO em_sys_city VALUES (320,'西安市',27)
;
INSERT INTO em_sys_city VALUES (321,'铜川市',27)
;
INSERT INTO em_sys_city VALUES (322,'宝鸡市',27)
;
INSERT INTO em_sys_city VALUES (323,'咸阳市',27)
;
INSERT INTO em_sys_city VALUES (324,'渭南市',27)
;
INSERT INTO em_sys_city VALUES (325,'延安市',27)
;
INSERT INTO em_sys_city VALUES (326,'汉中市',27)
;
INSERT INTO em_sys_city VALUES (327,'榆林市',27)
;
INSERT INTO em_sys_city VALUES (328,'安康市',27)
;
INSERT INTO em_sys_city VALUES (329,'商洛市',27)
;
INSERT INTO em_sys_city VALUES (330,'南宁市',28)
;
INSERT INTO em_sys_city VALUES (331,'柳州市',28)
;
INSERT INTO em_sys_city VALUES (332,'桂林市',28)
;
INSERT INTO em_sys_city VALUES (333,'梧州市',28)
;
INSERT INTO em_sys_city VALUES (334,'北海市',28)
;
INSERT INTO em_sys_city VALUES (335,'防城港市',28)
;
INSERT INTO em_sys_city VALUES (336,'钦州市',28)
;
INSERT INTO em_sys_city VALUES (337,'贵港市',28)
;
INSERT INTO em_sys_city VALUES (338,'玉林市',28)
;
INSERT INTO em_sys_city VALUES (339,'百色市',28)
;
INSERT INTO em_sys_city VALUES (340,'贺州市',28)
;
INSERT INTO em_sys_city VALUES (341,'河池市',28)
;
INSERT INTO em_sys_city VALUES (342,'来宾市',28)
;
INSERT INTO em_sys_city VALUES (343,'崇左市',28)
;
INSERT INTO em_sys_city VALUES (344,'拉萨市',29)
;
INSERT INTO em_sys_city VALUES (345,'那曲地区',29)
;
INSERT INTO em_sys_city VALUES (346,'昌都地区',29)
;
INSERT INTO em_sys_city VALUES (347,'山南地区',29)
;
INSERT INTO em_sys_city VALUES (348,'日喀则地区',29)
;
INSERT INTO em_sys_city VALUES (349,'阿里地区',29)
;
INSERT INTO em_sys_city VALUES (350,'林芝地区',29)
;
INSERT INTO em_sys_city VALUES (351,'银川市',30)
;
INSERT INTO em_sys_city VALUES (352,'石嘴山市',30)
;
INSERT INTO em_sys_city VALUES (353,'吴忠市',30)
;
INSERT INTO em_sys_city VALUES (354,'固原市',30)
;
INSERT INTO em_sys_city VALUES (355,'中卫市',30)
;
INSERT INTO em_sys_city VALUES (356,'乌鲁木齐市',31)
;
INSERT INTO em_sys_city VALUES (357,'克拉玛依市',31)
;
INSERT INTO em_sys_city VALUES (358,'石河子市　',31)
;
INSERT INTO em_sys_city VALUES (359,'阿拉尔市',31)
;
INSERT INTO em_sys_city VALUES (360,'图木舒克市',31)
;
INSERT INTO em_sys_city VALUES (361,'五家渠市',31)
;
INSERT INTO em_sys_city VALUES (362,'吐鲁番市',31)
;
INSERT INTO em_sys_city VALUES (363,'阿克苏市',31)
;
INSERT INTO em_sys_city VALUES (364,'喀什市',31)
;
INSERT INTO em_sys_city VALUES (365,'哈密市',31)
;
INSERT INTO em_sys_city VALUES (366,'和田市',31)
;
INSERT INTO em_sys_city VALUES (367,'阿图什市',31)
;
INSERT INTO em_sys_city VALUES (368,'库尔勒市',31)
;
INSERT INTO em_sys_city VALUES (369,'昌吉市　',31)
;
INSERT INTO em_sys_city VALUES (370,'阜康市',31)
;
INSERT INTO em_sys_city VALUES (371,'米泉市',31)
;
INSERT INTO em_sys_city VALUES (372,'博乐市',31)
;
INSERT INTO em_sys_city VALUES (373,'伊宁市',31)
;
INSERT INTO em_sys_city VALUES (374,'奎屯市',31)
;
INSERT INTO em_sys_city VALUES (375,'塔城市',31)
;
INSERT INTO em_sys_city VALUES (376,'乌苏市',31)
;
INSERT INTO em_sys_city VALUES (377,'阿勒泰市',31)
;
INSERT INTO em_sys_city VALUES (378,'呼和浩特市',32)
;
INSERT INTO em_sys_city VALUES (379,'包头市',32)
;
INSERT INTO em_sys_city VALUES (380,'乌海市',32)
;
INSERT INTO em_sys_city VALUES (381,'赤峰市',32)
;
INSERT INTO em_sys_city VALUES (382,'通辽市',32)
;
INSERT INTO em_sys_city VALUES (383,'鄂尔多斯市',32)
;
INSERT INTO em_sys_city VALUES (384,'呼伦贝尔市',32)
;
INSERT INTO em_sys_city VALUES (385,'巴彦淖尔市',32)
;
INSERT INTO em_sys_city VALUES (386,'乌兰察布市',32)
;
INSERT INTO em_sys_city VALUES (387,'锡林郭勒盟',32)
;
INSERT INTO em_sys_city VALUES (388,'兴安盟',32)
;
INSERT INTO em_sys_city VALUES (389,'阿拉善盟',32)
;
INSERT INTO em_sys_city VALUES (390,'澳门特别行政区',33)
;
INSERT INTO em_sys_city VALUES (391,'香港特别行政区',34)
;
CREATE TABLE em_sys_client_version (
  id varchar(32) NOT NULL PRIMARY KEY,
  client_type NUMBER(4,0) DEFAULT NULL,
  cversion varchar(50) DEFAULT NULL,
  vnumber varchar(100) DEFAULT NULL,
  content varchar(1000) DEFAULT NULL,
  linkurl varchar(200) DEFAULT NULL,
  force_update NUMBER(4,0) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT NULL,
  publish_time TIMESTAMP DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_client_version IS '系统客户端版本表'
;
COMMENT ON COLUMN em_sys_client_version.id IS '主键'
;
COMMENT ON COLUMN em_sys_client_version.client_type IS '客户端类型：1-windows，2-mac，3-ios，4-android'
;
COMMENT ON COLUMN em_sys_client_version.cversion IS '版本号'
;
COMMENT ON COLUMN em_sys_client_version.vnumber IS '客户端版本序号'
;
COMMENT ON COLUMN em_sys_client_version.content IS '更新内容'
;
COMMENT ON COLUMN em_sys_client_version.linkurl IS '下载链接地址'
;
COMMENT ON COLUMN em_sys_client_version.force_update IS '是否强制升级：1-是，0-否'
;
COMMENT ON COLUMN em_sys_client_version.status IS '状态：1-发布，2-草稿，3-删除'
;
COMMENT ON COLUMN em_sys_client_version.publish_time IS '发布时间'
;
COMMENT ON COLUMN em_sys_client_version.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_client_version.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_client_version.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_client_version.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_client_version.tenant_id IS '企业租户ID'
;
CREATE TABLE em_sys_config_data (
  id varchar(32) NOT NULL PRIMARY KEY,
  data_name varchar(100) DEFAULT NULL,
  data_value varchar(100) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_config_data IS '系统配置数据表'
;
COMMENT ON COLUMN em_sys_config_data.id IS '主键'
;
COMMENT ON COLUMN em_sys_config_data.data_name IS '数据名称'
;
COMMENT ON COLUMN em_sys_config_data.data_value IS '数据内容'
;
COMMENT ON COLUMN em_sys_config_data.status IS '状态：1-正常，3-删除'
;
COMMENT ON COLUMN em_sys_config_data.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_config_data.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_config_data.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_config_data.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_config_data.tenant_id IS '企业租户ID'
;
CREATE TABLE em_sys_country_mobile_prefix (
  id NUMBER(11,0) NOT NULL PRIMARY KEY,
  country varchar(255) DEFAULT NULL,
  mobile_prefix varchar(255) DEFAULT NULL,
  area varchar(255) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_country_mobile_prefix IS '国际电话号码区号'
;
COMMENT ON COLUMN em_sys_country_mobile_prefix.country IS '国家名称'
;
COMMENT ON COLUMN em_sys_country_mobile_prefix.mobile_prefix IS '区号'
;
COMMENT ON COLUMN em_sys_country_mobile_prefix.area IS '所在的洲'
;
CREATE SEQUENCE em_sys_country_m_p_seq start with 0 increment by 1 minvalue 0
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'中国','+86','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'香港','+852','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'澳门','+853','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'台湾','+886','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'马来西亚','+60','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'印度尼西亚','+62','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'菲律宾','+63','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'新加坡','+65','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'泰国','+66','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'日本','+81','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'韩国','+82','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'塔吉克斯坦','+7','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'哈萨克斯坦','+7','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'越南','+84','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'土耳其','+90','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'印度','+91','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'巴基斯坦','+92','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'阿富汗','+93','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'斯里兰卡','+94','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'缅甸','+95','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'伊朗','+98','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'亚美尼亚','+374','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'东帝汶','+670','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'文莱','+673','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'朝鲜','+850','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'柬埔寨','+855','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'老挝','+856','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'孟加拉国','+880','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'马尔代夫','+960','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'黎巴嫩','+961','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'约旦','+962','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'叙利亚','+963','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'伊拉克','+964','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'科威特','+965','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'沙特阿拉伯','+966','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'也门','+967','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'阿曼','+968','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'巴勒斯坦','+970','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'阿联酋','+971','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'以色列','+972','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'巴林','+973','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'卡塔尔','+974','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'不丹','+975','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'蒙古','+976','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'尼泊尔','+977','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'土库曼斯坦','+993','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'阿塞拜疆','+994','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'乔治亚','+995','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'吉尔吉斯斯坦','+996','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'乌兹别克斯坦','+998','亚洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'英国','+44','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'德国','+49','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'意大利','+39','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'法国','+33','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'俄罗斯','+7','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'希腊','+30','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'荷兰','+31','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'比利时','+32','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'西班牙','+34','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'匈牙利','+36','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'罗马尼亚','+40','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'瑞士','+41','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'奥地利','+43','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'丹麦','+45','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'瑞典','+46','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'挪威','+47','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'波兰','+48','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'圣马力诺','+223','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'匈牙利','+336','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'南斯拉夫','+338','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'直布罗陀','+350','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'葡萄牙','+351','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'卢森堡','+352','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'爱尔兰','+353','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'冰岛','+354','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'阿尔巴尼亚','+355','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'马耳他','+356','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'塞浦路斯','+357','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'芬兰','+358','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'保加利亚','+359','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'立陶宛','+370','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'拉脱维亚','+371','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'爱沙尼亚','+372','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'摩尔多瓦','+373','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'安道尔共和国','+376','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'乌克兰','+380','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'南斯拉夫','+381','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'克罗地亚','+385','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'斯洛文尼亚','+386','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'波黑','+387','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'马其顿','+389','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'梵蒂冈','+396','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'捷克','+420','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'斯洛伐克','+421','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'列支敦士登','+423','欧洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'秘鲁','+51','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'墨西哥','+52','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'古巴','+53','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'阿根廷','+54','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'巴西','+55','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'智利','+56','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'哥伦比亚','+57','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'委内瑞拉','+58','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'福克兰群岛','+500','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'伯利兹','+501','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'危地马拉','+502','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'萨尔瓦多','+503','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'洪都拉斯','+504','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'尼加拉瓜','+505','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'哥斯达黎加','+506','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'巴拿马','+507','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'圣彼埃尔','+508','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'海地','+509','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'瓜德罗普','+590','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'玻利维亚','+591','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'圭亚那','+592','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'厄瓜多尔','+593','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'法属圭亚那','+594','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'巴拉圭','+595','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'马提尼克','+596','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'苏里南','+597','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'乌拉圭','+598','南美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'埃及','+20','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'南非','+27','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'摩洛哥','+212','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'阿尔及利亚','+213','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'突尼斯','+216','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'利比亚','+218','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'冈比亚','+220','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'塞内加尔','+221','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'毛里塔尼亚','+222','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'马里','+223','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'几内亚','+224','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'科特迪瓦','+225','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'布基拉法索','+226','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'尼日尔','+227','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'多哥','+228','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'贝宁','+229','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'毛里求斯','+230','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'利比里亚','+231','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'塞拉利昂','+232','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'加纳','+233','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'尼日利亚','+234','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'乍得','+235','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'中非','+236','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'喀麦隆','+237','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'佛得角','+238','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'圣多美','+239','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'普林西比','+239','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'赤道几内亚','+240','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'加蓬','+241','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'刚果','+242','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'扎伊尔','+243','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'安哥拉','+244','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'几内亚比绍','+245','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'阿森松','+247','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'塞舌尔','+248','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'苏丹','+249','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'卢旺达','+250','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'埃塞俄比亚','+251','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'索马里','+252','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'吉布提','+253','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'肯尼亚','+254','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'坦桑尼亚','+255','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'乌干达','+256','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'布隆迪','+257','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'莫桑比克','+258','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'赞比亚','+260','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'马达加斯加','+261','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'留尼旺岛','+262','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'津巴布韦','+263','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'纳米比亚','+264','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'马拉维','+265','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'莱索托','+266','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'博茨瓦纳','+267','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'斯威士兰','+268','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'科摩罗','+269','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'圣赫勒拿','+290','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'厄立特里亚','+291','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'阿鲁巴岛','+297','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'法罗群岛','+298','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'摩纳哥','+377','非洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'澳大利亚','+61','大洋洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'新西兰','+64','大洋洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'关岛','+671','大洋洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'瑙鲁','+674','大洋洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'汤加','+676','大洋洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'所罗门群岛','+677','大洋洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'瓦努阿图','+678','大洋洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'斐济','+679','大洋洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'科克群岛','+682','大洋洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'纽埃岛','+683','大洋洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'东萨摩亚','+684','大洋洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'西萨摩亚','+685','大洋洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'基里巴斯','+686','大洋洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'图瓦卢','+688','大洋洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'科科斯岛','+619162','大洋洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'诺福克岛','+6723','大洋洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'圣诞岛','+619164','大洋洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'美国','+1','北美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'加拿大','+1','北美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'夏威夷','+1808','北美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'阿拉斯加','+1907','北美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'格陵兰岛','+299','北美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'中途岛','+1808','北美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'威克岛','+1808','北美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'维尔京群岛','+1809','北美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'波多黎各','+1809','北美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'巴哈马','+1809','北美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'安圭拉岛','+1809','北美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'圣卢西亚','+1809','北美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'巴巴多斯','+1809','北美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'牙买加','+1876','北美洲')
;
INSERT INTO em_sys_country_mobile_prefix VALUES (em_sys_country_m_p_seq.nextval,'南极洲','+64672','南极洲')
;
CREATE TABLE em_sys_errcode (
  errcode NUMBER(11,0) NOT NULL PRIMARY KEY,
  errmsg varchar(1000) NOT NULL,
  errmsg_en varchar(1000) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_errcode IS '错误码信息表'
;
COMMENT ON COLUMN em_sys_errcode.errcode IS '错误编码'
;
COMMENT ON COLUMN em_sys_errcode.errmsg IS '中文错误信息'
;
COMMENT ON COLUMN em_sys_errcode.errmsg_en IS '英文错误信息'
;
INSERT INTO em_sys_errcode VALUES (-3,'License不存在或者已经失效','License not found or is invalid')
;
INSERT INTO em_sys_errcode VALUES (-2,'未知错误','unknown error')
;
INSERT INTO em_sys_errcode VALUES (-1,'系统繁忙','system busy')
;
INSERT INTO em_sys_errcode VALUES (0,'请求成功','success')
;
INSERT INTO em_sys_errcode VALUES (1,'无权访问','')
;
INSERT INTO em_sys_errcode VALUES (101,'账号或密码错误','')
;
INSERT INTO em_sys_errcode VALUES (102,'账号或密码不能为空','')
;
INSERT INTO em_sys_errcode VALUES (103,'验证码错误','')
;
INSERT INTO em_sys_errcode VALUES (104,'loginid已存在','')
;
INSERT INTO em_sys_errcode VALUES (105,'密码错误','')
;
INSERT INTO em_sys_errcode VALUES (106,'短信发送失败','')
;
INSERT INTO em_sys_errcode VALUES (107,'重设密码key已过期','')
;
INSERT INTO em_sys_errcode VALUES (108,'重设密码key无效','')
;
INSERT INTO em_sys_errcode VALUES (109,'重设密码key已过期','')
;
INSERT INTO em_sys_errcode VALUES (110,'系统用户不存在','')
;
INSERT INTO em_sys_errcode VALUES (111,'登录二维码已失效','')
;
INSERT INTO em_sys_errcode VALUES (112,'登录验证规则配置的集成系统不存在','')
;
INSERT INTO em_sys_errcode VALUES (113,'登录验证规则地址配置错误','')
;
INSERT INTO em_sys_errcode VALUES (121,'不合法的ssokey参数','')
;
INSERT INTO em_sys_errcode VALUES (122,'ssokey参数不正确','')
;
INSERT INTO em_sys_errcode VALUES (123,'不合法的stamp参数','')
;
INSERT INTO em_sys_errcode VALUES (124,'ssokey验证失败','')
;
INSERT INTO em_sys_errcode VALUES (125,'access_token状态错误','')
;
INSERT INTO em_sys_errcode VALUES (126,'非客户端登录，无法重连','')
;
INSERT INTO em_sys_errcode VALUES (127,'用户已在其他设备登录','')
;
INSERT INTO em_sys_errcode VALUES (130,'服务器账号错误','')
;
INSERT INTO em_sys_errcode VALUES (131,'检测秘钥，返回数据格式错误','')
;
INSERT INTO em_sys_errcode VALUES (132,'短信模板配置id不存在','')
;
INSERT INTO em_sys_errcode VALUES (133,'开启必达短信功能，必须配置短信模板数据','')
;
INSERT INTO em_sys_errcode VALUES (134,'无效的素材类型','')
;
INSERT INTO em_sys_errcode VALUES (135,'media不能为空','')
;
INSERT INTO em_sys_errcode VALUES (136,'文件格式不支持','')
;
INSERT INTO em_sys_errcode VALUES (137,'文件大小超过限制','')
;
INSERT INTO em_sys_errcode VALUES (138,'该缓存不允许执行清空操作','')
;
INSERT INTO em_sys_errcode VALUES (139,'不存在的缓存名称','')
;
INSERT INTO em_sys_errcode VALUES (140,'错误的缓存类型','')
;
INSERT INTO em_sys_errcode VALUES (141,'相关数据不存在','')
;
INSERT INTO em_sys_errcode VALUES (142,'必须保留一条数据','')
;
INSERT INTO em_sys_errcode VALUES (151,'消息接收者不能为空','')
;
INSERT INTO em_sys_errcode VALUES (152,'定时发送，发送时间不能为空','')
;
INSERT INTO em_sys_errcode VALUES (153,'发送类型值错误','')
;
INSERT INTO em_sys_errcode VALUES (154,'消息类型值错误','')
;
INSERT INTO em_sys_errcode VALUES (155,'消息服务处理失败','')
;
INSERT INTO em_sys_errcode VALUES (156,'消息接收者均无效','')
;
INSERT INTO em_sys_errcode VALUES (157,'必达电话功能未开启','')
;
INSERT INTO em_sys_errcode VALUES (158,'必达短信功能，短信模板未配置','')
;
INSERT INTO em_sys_errcode VALUES (159,'必达短信功能未开启','')
;
INSERT INTO em_sys_errcode VALUES (160,'必达信息功能未开启','')
;
INSERT INTO em_sys_errcode VALUES (161,'外网访问地址不合法','')
;
INSERT INTO em_sys_errcode VALUES (162,'系统访问地址不合法','')
;
INSERT INTO em_sys_errcode VALUES (163,'接入平台显示名不能为空','')
;
INSERT INTO em_sys_errcode VALUES (164,'数据格式非json','')
;
INSERT INTO em_sys_errcode VALUES (165,'RSA error','')
;
INSERT INTO em_sys_errcode VALUES (166,'集成信息在通讯录同步中使用，无法删除','')
;
INSERT INTO em_sys_errcode VALUES (167,'集成信息在登录验证规则中使用，无法删除','')
;
INSERT INTO em_sys_errcode VALUES (168,'集成信息在基础设置中使用，无法删除','')
;
INSERT INTO em_sys_errcode VALUES (170,'集成访问地址链接失败','')
;
INSERT INTO em_sys_errcode VALUES (171,'消息服务调用错误','')
;
INSERT INTO em_sys_errcode VALUES (1001,'管理员类型不正确','')
;
INSERT INTO em_sys_errcode VALUES (1002,'该用户已是管理员或是创建人','')
;
INSERT INTO em_sys_errcode VALUES (1003,'企业通讯录成员不存在','')
;
INSERT INTO em_sys_errcode VALUES (1004,'删除的管理员不属于任何角色,没有角色权限信息','')
;
INSERT INTO em_sys_errcode VALUES (1005,'角色名称不能为空','')
;
INSERT INTO em_sys_errcode VALUES (1006,'角色中文名称或者英文名称已经存在','')
;
INSERT INTO em_sys_errcode VALUES (1007,'角色不存在','')
;
INSERT INTO em_sys_errcode VALUES (1008,'租户不存在','')
;
INSERT INTO em_sys_errcode VALUES (1009,'需要修改角色的id必须提供','')
;
INSERT INTO em_sys_errcode VALUES (1010,'不能将角色名字修改为空白','')
;
INSERT INTO em_sys_errcode VALUES (1011,'用户id列表不能为空','')
;
INSERT INTO em_sys_errcode VALUES (1012,'所转让的创建人不存在','')
;
INSERT INTO em_sys_errcode VALUES (1013,'企业创建人数量不正确','')
;
INSERT INTO em_sys_errcode VALUES (1014,'创建接口角色，至少需要选择一个应用','')
;
INSERT INTO em_sys_errcode VALUES (1600,'主题菜单必须设置','')
;
INSERT INTO em_sys_errcode VALUES (1601,'主题id不存在','')
;
INSERT INTO em_sys_errcode VALUES (1602,'数据信息不匹配,非企业内数据','')
;
INSERT INTO em_sys_errcode VALUES (1603,'主题客户端类型不正确','')
;
INSERT INTO em_sys_errcode VALUES (1604,'没有主题使用权限','')
;
INSERT INTO em_sys_errcode VALUES (1605,'主题名称不合法','')
;
INSERT INTO em_sys_errcode VALUES (1606,'导航是否显示文字值类型不合法','')
;
INSERT INTO em_sys_errcode VALUES (1607,'菜单名称不合法','')
;
INSERT INTO em_sys_errcode VALUES (1608,'导航功能值不能为空','')
;
INSERT INTO em_sys_errcode VALUES (1609,'导航菜单是否显示值类型错误','')
;
INSERT INTO em_sys_errcode VALUES (1610,'导航菜单是否默认值类型错误','')
;
INSERT INTO em_sys_errcode VALUES (1611,'按钮功能值不合法','')
;
INSERT INTO em_sys_errcode VALUES (1612,'按钮类型值不合法','')
;
INSERT INTO em_sys_errcode VALUES (1613,'字段不存在','')
;
INSERT INTO em_sys_errcode VALUES (1614,'字段重复设置','')
;
INSERT INTO em_sys_errcode VALUES (1700,'权限规则对象不能为空','')
;
INSERT INTO em_sys_errcode VALUES (1701,'权限规则明细不能为空','')
;
INSERT INTO em_sys_errcode VALUES (1702,'权限明细类型值不合法','')
;
INSERT INTO em_sys_errcode VALUES (1703,'查询权限设置数据重复','')
;
INSERT INTO em_sys_errcode VALUES (1704,'打电话权限设置数据重复','')
;
INSERT INTO em_sys_errcode VALUES (1705,'发信息权限设置数据重复','')
;
INSERT INTO em_sys_errcode VALUES (1706,'权限明细规则类型值不合法','')
;
INSERT INTO em_sys_errcode VALUES (1707,'权限明细规则用户数据不全有效','')
;
INSERT INTO em_sys_errcode VALUES (1708,'权限明细规则用户数据格式不正确','')
;
INSERT INTO em_sys_errcode VALUES (1709,'权限明细规则部门数据不全有效','')
;
INSERT INTO em_sys_errcode VALUES (1710,'权限明细规则部门数据格式不正确','')
;
INSERT INTO em_sys_errcode VALUES (1711,'权限明细规则标签数据不全有效','')
;
INSERT INTO em_sys_errcode VALUES (1712,'权限明细规则标签数据格式不正确','')
;
INSERT INTO em_sys_errcode VALUES (1713,'通讯录权限规则信息不存在','')
;
INSERT INTO em_sys_errcode VALUES (1714,'数据信息不匹配','')
;
INSERT INTO em_sys_errcode VALUES (1715,'规则设置不存在','')
;
INSERT INTO em_sys_errcode VALUES (1716,'默认主题状态不能修改','')
;
INSERT INTO em_sys_errcode VALUES (1717,'默认主题不能删除','')
;
INSERT INTO em_sys_errcode VALUES (1718,'非默认主题，无法恢复初始设置','')
;
INSERT INTO em_sys_errcode VALUES (1719,'应用正在主题中使用，无法删除','')
;
INSERT INTO em_sys_errcode VALUES (1720,'默认门户不能删除','')
;
INSERT INTO em_sys_errcode VALUES (1800,'是否显示在门户的其他应用类型值非法','')
;
INSERT INTO em_sys_errcode VALUES (1801,'名称包含非法字符','')
;
INSERT INTO em_sys_errcode VALUES (1802,'门户项中分组类型字段值非法','')
;
INSERT INTO em_sys_errcode VALUES (1803,'门户项中分组类型字段为其他应用数据设置重复','')
;
INSERT INTO em_sys_errcode VALUES (1804,'是否显示设置值非法','')
;
INSERT INTO em_sys_errcode VALUES (1805,'元素类型值非法','')
;
INSERT INTO em_sys_errcode VALUES (1806,'门户id不存在','')
;
INSERT INTO em_sys_errcode VALUES (1810,'应用正在门户中使用，无法删除','')
;
INSERT INTO em_sys_errcode VALUES (1811,'该门户正在工作台中使用，无法删除','')
;
INSERT INTO em_sys_errcode VALUES (1812,'非默认门户，无法恢复初始设置','')
;
INSERT INTO em_sys_errcode VALUES (1813,'是否显示在应用商店中,设置值不合法','')
;
INSERT INTO em_sys_errcode VALUES (1814,'是否显示在消息扩展功能中,设置值不合法','')
;
INSERT INTO em_sys_errcode VALUES (1816,'幻灯片类型元素，元素功能设置1值不合法','')
;
INSERT INTO em_sys_errcode VALUES (1817,'幻灯片类型元素，元素功能设置为配置模式时，配置数据不能为空','')
;
INSERT INTO em_sys_errcode VALUES (1818,'此门户不支持用户自定义','')
;
INSERT INTO em_sys_errcode VALUES (1819,'元素不存在','')
;
INSERT INTO em_sys_errcode VALUES (1850,'工作台设置类型值不正确','')
;
INSERT INTO em_sys_errcode VALUES (1851,'工作台设置类型非默认门户时，设置数据不能为空','')
;
INSERT INTO em_sys_errcode VALUES (1852,'工作台配置有误，门户不存在或已经被删除','')
;
INSERT INTO em_sys_errcode VALUES (2001,'接口参数不能为空','')
;
INSERT INTO em_sys_errcode VALUES (2002,'客户端显示和功能设置不能同时为空','')
;
INSERT INTO em_sys_errcode VALUES (2003,'客户端功能设置->设置项类型不能为空','')
;
INSERT INTO em_sys_errcode VALUES (2004,'客户端功能设置->显示名称为长度10个字以内的（汉字、英文字母或数字）,字符不能包括\\:?”<>｜','')
;
INSERT INTO em_sys_errcode VALUES (2005,'客户端功能设置->显示名称长度为10个字以内','')
;
INSERT INTO em_sys_errcode VALUES (2006,'客户端功能设置->设置类型不能为空','')
;
INSERT INTO em_sys_errcode VALUES (2007,'客户端重置->客户端类型不能为空','')
;
INSERT INTO em_sys_errcode VALUES (2008,'客户端重置->重置类型不能为空','')
;
INSERT INTO em_sys_errcode VALUES (2009,'客户端类型不能为空','')
;
INSERT INTO em_sys_errcode VALUES (2010,'客户端显示设置->设置项类型不能为空','')
;
INSERT INTO em_sys_errcode VALUES (2011,'客户端显示设置->设置项标识不能为空','')
;
INSERT INTO em_sys_errcode VALUES (2012,'客户端显示设置->设置内容不能为空','')
;
INSERT INTO em_sys_errcode VALUES (3001,'corpId不存在','')
;
INSERT INTO em_sys_errcode VALUES (3002,'企业名称已存在','')
;
INSERT INTO em_sys_errcode VALUES (3003,'企业不存在','')
;
INSERT INTO em_sys_errcode VALUES (3004,'企业名称已存在','')
;
INSERT INTO em_sys_errcode VALUES (3100,'工作状态修改记录id不能为空','')
;
INSERT INTO em_sys_errcode VALUES (3101,'工作状态修改记录id不能为空','')
;
INSERT INTO em_sys_errcode VALUES (3102,'工作状态描述图标不得长于45个字符','')
;
INSERT INTO em_sys_errcode VALUES (3103,'工作状态描述文字不得长于45个字符','')
;
INSERT INTO em_sys_errcode VALUES (5001,'未开启消息服务','')
;
INSERT INTO em_sys_errcode VALUES (5002,'连接消息服务获取token失败','')
;
INSERT INTO em_sys_errcode VALUES (5003,'群名称不合法','')
;
INSERT INTO em_sys_errcode VALUES (5004,'群英文名称不合法','')
;
INSERT INTO em_sys_errcode VALUES (5005,'群组类型不合法','')
;
INSERT INTO em_sys_errcode VALUES (5006,'企业类型群，CorpId不能为空','')
;
INSERT INTO em_sys_errcode VALUES (5007,'群组成员不存在','')
;
INSERT INTO em_sys_errcode VALUES (5008,'群组成员超过上限','')
;
INSERT INTO em_sys_errcode VALUES (5009,'成员列表不合法','')
;
INSERT INTO em_sys_errcode VALUES (5010,'消息成员服务同步失败','')
;
INSERT INTO em_sys_errcode VALUES (5011,'groupid不存在','')
;
INSERT INTO em_sys_errcode VALUES (5012,'没有群组管理权限.','')
;
INSERT INTO em_sys_errcode VALUES (5013,'用户不是群成员','')
;
INSERT INTO em_sys_errcode VALUES (5014,'群主不能被删除','')
;
INSERT INTO em_sys_errcode VALUES (5015,'没有权限删除其他管理人员','')
;
INSERT INTO em_sys_errcode VALUES (5016,'成员类型不能空','')
;
INSERT INTO em_sys_errcode VALUES (5017,'成员类型不合法','')
;
INSERT INTO em_sys_errcode VALUES (5018,'需先转让该群才能被设置为管理员或普通成员','')
;
INSERT INTO em_sys_errcode VALUES (5019,'未加入任何群组','')
;
INSERT INTO em_sys_errcode VALUES (5020,'没有发送公告权限','')
;
INSERT INTO em_sys_errcode VALUES (5021,'群信息创建服务操作失败','')
;
INSERT INTO em_sys_errcode VALUES (5022,'群主必须唯一','')
;
INSERT INTO em_sys_errcode VALUES (5023,'消息服务发送信息失败','')
;
INSERT INTO em_sys_errcode VALUES (5024,'用户id列表不能为空','')
;
INSERT INTO em_sys_errcode VALUES (5025,'人员id不正确','')
;
INSERT INTO em_sys_errcode VALUES (5026,'头像上传到素材库失败','')
;
INSERT INTO em_sys_errcode VALUES (5027,'群组id不能为空','')
;
INSERT INTO em_sys_errcode VALUES (5028,'群头像更新到消息服务失败','')
;
INSERT INTO em_sys_errcode VALUES (6001,'未开启音视频服务','')
;
INSERT INTO em_sys_errcode VALUES (6002,'生成信令token失败','')
;
INSERT INTO em_sys_errcode VALUES (6003,'生成加入频道key失败','')
;
INSERT INTO em_sys_errcode VALUES (6004,'音视频通话上报数据,通话标识不能为空','')
;
INSERT INTO em_sys_errcode VALUES (6005,'音视频通话上报数据,会话类型必须为(1-点对点，2-会议)','')
;
INSERT INTO em_sys_errcode VALUES (6006,'音视频通话上报数据,至少两位参与人员','')
;
INSERT INTO em_sys_errcode VALUES (6007,'未查询到音视频通话基本信息','')
;
INSERT INTO em_sys_errcode VALUES (6008,'语音通知号码不能为空','')
;
INSERT INTO em_sys_errcode VALUES (6009,'语音通知内容不能为空','')
;
INSERT INTO em_sys_errcode VALUES (6010,'语音通知发送成功','')
;
INSERT INTO em_sys_errcode VALUES (6011,'语音通知发送失败','')
;
INSERT INTO em_sys_errcode VALUES (6012,'获取语音通知配置信息失败','')
;
INSERT INTO em_sys_errcode VALUES (7001,'集成系统id无效','')
;
INSERT INTO em_sys_errcode VALUES (7002,'新成员账号字段设置值不合法','')
;
INSERT INTO em_sys_errcode VALUES (7003,'已存在成员本系统的匹配字段设置不合法','')
;
INSERT INTO em_sys_errcode VALUES (7004,'已存在成员集成系统的匹配字段设置不合法','')
;
INSERT INTO em_sys_errcode VALUES (7005,'离职成员的处理方式字段设置不合法','')
;
INSERT INTO em_sys_errcode VALUES (7006,'同步部门同步方式值不合法','')
;
INSERT INTO em_sys_errcode VALUES (7007,'系统内部地址未配置','')
;
INSERT INTO em_sys_errcode VALUES (7008,'集成id不存在','')
;
INSERT INTO em_sys_errcode VALUES (7009,'访问地址连接失败！','')
;
INSERT INTO em_sys_errcode VALUES (7010,'系统验证地址链接失败','')
;
INSERT INTO em_sys_errcode VALUES (7021,'获取Ecology系统sessionkey失败','')
;
INSERT INTO em_sys_errcode VALUES (7022,'保存文件时上传到Ecology系统未返回结果','')
;
INSERT INTO em_sys_errcode VALUES (7023,'保存文件时上传到Ecology系统失败','')
;
INSERT INTO em_sys_errcode VALUES (7024,'从Ecology系统下载文件失败','')
;
INSERT INTO em_sys_errcode VALUES (7030,'不合法的分组名字，分组名字已经存在','')
;
INSERT INTO em_sys_errcode VALUES (7031,'分组id已存在','')
;
INSERT INTO em_sys_errcode VALUES (7032,'缺少分组ID','')
;
INSERT INTO em_sys_errcode VALUES (7033,'不合法的分组ID','')
;
INSERT INTO em_sys_errcode VALUES (7034,'分组ID不存在','')
;
INSERT INTO em_sys_errcode VALUES (7041,'组类型错误，可见范围设置必须为通用组','')
;
INSERT INTO em_sys_errcode VALUES (8001,'未开启红包服务','')
;
INSERT INTO em_sys_errcode VALUES (8002,'生成红包token失败','')
;
INSERT INTO em_sys_errcode VALUES (9001,'未开启远程服务','')
;
INSERT INTO em_sys_errcode VALUES (40001,'登录凭证无效','invalid access_token')
;
INSERT INTO em_sys_errcode VALUES (40002,'不合法的登录凭证','')
;
INSERT INTO em_sys_errcode VALUES (40003,'不合法的UserID','')
;
INSERT INTO em_sys_errcode VALUES (40004,'不合法的媒体文件类型','')
;
INSERT INTO em_sys_errcode VALUES (40005,'不合法的文件类型','')
;
INSERT INTO em_sys_errcode VALUES (40006,'不合法的文件大小','')
;
INSERT INTO em_sys_errcode VALUES (40007,'不合法的媒体文件id','')
;
INSERT INTO em_sys_errcode VALUES (40008,'不合法的消息类型','')
;
INSERT INTO em_sys_errcode VALUES (40013,'不合法的corpid','')
;
INSERT INTO em_sys_errcode VALUES (40014,'不合法的access_token','')
;
INSERT INTO em_sys_errcode VALUES (40015,'不合法的菜单类型','')
;
INSERT INTO em_sys_errcode VALUES (40016,'不合法的按钮个数','')
;
INSERT INTO em_sys_errcode VALUES (40017,'不合法的按钮类型','')
;
INSERT INTO em_sys_errcode VALUES (40018,'不合法的按钮名字长度','')
;
INSERT INTO em_sys_errcode VALUES (40019,'不合法的按钮KEY长度','')
;
INSERT INTO em_sys_errcode VALUES (40020,'不合法的按钮URL长度','')
;
INSERT INTO em_sys_errcode VALUES (40021,'不合法的菜单版本号','')
;
INSERT INTO em_sys_errcode VALUES (40022,'不合法的子菜单级数','')
;
INSERT INTO em_sys_errcode VALUES (40023,'不合法的子菜单按钮个数','')
;
INSERT INTO em_sys_errcode VALUES (40024,'不合法的子菜单按钮类型','')
;
INSERT INTO em_sys_errcode VALUES (40025,'不合法的子菜单按钮名字长度','')
;
INSERT INTO em_sys_errcode VALUES (40026,'不合法的子菜单按钮KEY长度','')
;
INSERT INTO em_sys_errcode VALUES (40027,'不合法的子菜单按钮URL长度','')
;
INSERT INTO em_sys_errcode VALUES (40028,'不合法的自定义菜单使用成员','')
;
INSERT INTO em_sys_errcode VALUES (40029,'不合法的oauth_code','')
;
INSERT INTO em_sys_errcode VALUES (40031,'不合法的UserID列表','')
;
INSERT INTO em_sys_errcode VALUES (40032,'不合法的UserID列表长度','')
;
INSERT INTO em_sys_errcode VALUES (40033,'不合法的请求字符，不能包含uxxxx格式的字符','')
;
INSERT INTO em_sys_errcode VALUES (40035,'不合法的参数','')
;
INSERT INTO em_sys_errcode VALUES (40038,'不合法的请求格式','')
;
INSERT INTO em_sys_errcode VALUES (40039,'不合法的URL长度','')
;
INSERT INTO em_sys_errcode VALUES (40040,'不合法的插件token','')
;
INSERT INTO em_sys_errcode VALUES (40041,'不合法的插件id','')
;
INSERT INTO em_sys_errcode VALUES (40042,'不合法的插件会话','')
;
INSERT INTO em_sys_errcode VALUES (40048,'url中包含不合法domain','')
;
INSERT INTO em_sys_errcode VALUES (40054,'不合法的子菜单url域名','')
;
INSERT INTO em_sys_errcode VALUES (40055,'不合法的按钮url域名','')
;
INSERT INTO em_sys_errcode VALUES (40056,'不合法的agentid','')
;
INSERT INTO em_sys_errcode VALUES (40057,'不合法的callbackurl或者callbackurl验证失败','')
;
INSERT INTO em_sys_errcode VALUES (40058,'不合法的红包参数','')
;
INSERT INTO em_sys_errcode VALUES (40059,'不合法的上报地理位置标志位','')
;
INSERT INTO em_sys_errcode VALUES (40060,'设置上报地理位置标志位时没有设置callbackurl','')
;
INSERT INTO em_sys_errcode VALUES (40061,'设置应用头像失败','')
;
INSERT INTO em_sys_errcode VALUES (40062,'不合法的应用模式','')
;
INSERT INTO em_sys_errcode VALUES (40063,'参数为空','')
;
INSERT INTO em_sys_errcode VALUES (40064,'管理组名字已存在','')
;
INSERT INTO em_sys_errcode VALUES (40065,'不合法的管理组名字长度','')
;
INSERT INTO em_sys_errcode VALUES (40066,'不合法的部门列表','')
;
INSERT INTO em_sys_errcode VALUES (40067,'标题长度不合法','')
;
INSERT INTO em_sys_errcode VALUES (40068,'不合法的标签ID','')
;
INSERT INTO em_sys_errcode VALUES (40069,'不合法的标签ID列表','')
;
INSERT INTO em_sys_errcode VALUES (40070,'列表中所有标签（成员）ID都不合法','')
;
INSERT INTO em_sys_errcode VALUES (40071,'不合法的标签名字，标签名字已经存在','')
;
INSERT INTO em_sys_errcode VALUES (40072,'不合法的标签名字长度','')
;
INSERT INTO em_sys_errcode VALUES (40073,'不合法的openid','')
;
INSERT INTO em_sys_errcode VALUES (40074,'news消息不支持指定为高保密消息','')
;
INSERT INTO em_sys_errcode VALUES (40077,'不合法的预授权码','')
;
INSERT INTO em_sys_errcode VALUES (40078,'不合法的临时授权码','')
;
INSERT INTO em_sys_errcode VALUES (40079,'不合法的授权信息','')
;
INSERT INTO em_sys_errcode VALUES (40080,'不合法的suitesecret','')
;
INSERT INTO em_sys_errcode VALUES (40082,'不合法的suitetoken','')
;
INSERT INTO em_sys_errcode VALUES (40083,'不合法的suiteid','')
;
INSERT INTO em_sys_errcode VALUES (40084,'不合法的永久授权码','')
;
INSERT INTO em_sys_errcode VALUES (40085,'不合法的suiteticket','')
;
INSERT INTO em_sys_errcode VALUES (40086,'不合法的第三方应用appid','')
;
INSERT INTO em_sys_errcode VALUES (40091,'无效的凭证密钥','secret is invalid')
;
INSERT INTO em_sys_errcode VALUES (40092,'导入文件存在不合法的内容','')
;
INSERT INTO em_sys_errcode VALUES (40093,'不合法的跳转target','')
;
INSERT INTO em_sys_errcode VALUES (40094,'不合法的URL','')
;
INSERT INTO em_sys_errcode VALUES (40095,'修改失败，并发冲突','')
;
INSERT INTO em_sys_errcode VALUES (40100,'不合法的上报用户进入应用事件参数','')
;
INSERT INTO em_sys_errcode VALUES (40101,'客服端类型参数不正确','')
;
INSERT INTO em_sys_errcode VALUES (40155,'请勿添加其他公众号的主页链接','')
;
INSERT INTO em_sys_errcode VALUES (41001,'缺少access_token参数','')
;
INSERT INTO em_sys_errcode VALUES (41002,'缺少corpid参数','')
;
INSERT INTO em_sys_errcode VALUES (41003,'缺少refresh_token参数','')
;
INSERT INTO em_sys_errcode VALUES (41004,'缺少secret参数','')
;
INSERT INTO em_sys_errcode VALUES (41005,'缺少多媒体文件数据','')
;
INSERT INTO em_sys_errcode VALUES (41006,'缺少media_id参数','')
;
INSERT INTO em_sys_errcode VALUES (41007,'缺少子菜单数据','')
;
INSERT INTO em_sys_errcode VALUES (41008,'缺少oauth code','')
;
INSERT INTO em_sys_errcode VALUES (41009,'缺少UserID','')
;
INSERT INTO em_sys_errcode VALUES (41010,'缺少url','')
;
INSERT INTO em_sys_errcode VALUES (41011,'缺少agentid','')
;
INSERT INTO em_sys_errcode VALUES (41012,'缺少应用头像mediaid','')
;
INSERT INTO em_sys_errcode VALUES (41013,'缺少应用名字','')
;
INSERT INTO em_sys_errcode VALUES (41014,'缺少应用描述','')
;
INSERT INTO em_sys_errcode VALUES (41015,'缺少Content','')
;
INSERT INTO em_sys_errcode VALUES (41016,'缺少标题','')
;
INSERT INTO em_sys_errcode VALUES (41017,'缺少标签ID','')
;
INSERT INTO em_sys_errcode VALUES (41018,'缺少标签名字','')
;
INSERT INTO em_sys_errcode VALUES (41021,'缺少suiteid','')
;
INSERT INTO em_sys_errcode VALUES (41022,'缺少suitetoken','')
;
INSERT INTO em_sys_errcode VALUES (41023,'缺少suiteticket','')
;
INSERT INTO em_sys_errcode VALUES (41024,'缺少suitesecret','')
;
INSERT INTO em_sys_errcode VALUES (41025,'缺少永久授权码','')
;
INSERT INTO em_sys_errcode VALUES (41034,'缺少login_ticket','')
;
INSERT INTO em_sys_errcode VALUES (41035,'缺少跳转target','')
;
INSERT INTO em_sys_errcode VALUES (41040,'标签ID不存在','')
;
INSERT INTO em_sys_errcode VALUES (41041,'agentId不存在','')
;
INSERT INTO em_sys_errcode VALUES (42001,'登录超时请重新登录','')
;
INSERT INTO em_sys_errcode VALUES (42002,'refresh_token过期','')
;
INSERT INTO em_sys_errcode VALUES (42003,'oauth_code过期','')
;
INSERT INTO em_sys_errcode VALUES (42004,'插件token过期','')
;
INSERT INTO em_sys_errcode VALUES (42007,'预授权码失效','')
;
INSERT INTO em_sys_errcode VALUES (42008,'临时授权码失效','')
;
INSERT INTO em_sys_errcode VALUES (42009,'suitetoken失效','')
;
INSERT INTO em_sys_errcode VALUES (43001,'需要GET请求','')
;
INSERT INTO em_sys_errcode VALUES (43002,'需要POST请求','')
;
INSERT INTO em_sys_errcode VALUES (43003,'需要HTTPS','')
;
INSERT INTO em_sys_errcode VALUES (43004,'需要成员已关注','')
;
INSERT INTO em_sys_errcode VALUES (43005,'需要好友关系','')
;
INSERT INTO em_sys_errcode VALUES (43006,'需要订阅','')
;
INSERT INTO em_sys_errcode VALUES (43007,'需要授权','')
;
INSERT INTO em_sys_errcode VALUES (43008,'需要支付授权','')
;
INSERT INTO em_sys_errcode VALUES (43010,'需要处于接收消息模式','')
;
INSERT INTO em_sys_errcode VALUES (43011,'需要企业授权','')
;
INSERT INTO em_sys_errcode VALUES (43013,'应用对成员不可见','')
;
INSERT INTO em_sys_errcode VALUES (44001,'多媒体文件为空','')
;
INSERT INTO em_sys_errcode VALUES (44002,'POST的数据包为空','')
;
INSERT INTO em_sys_errcode VALUES (44003,'图文消息内容为空','')
;
INSERT INTO em_sys_errcode VALUES (44004,'文本消息内容为空','')
;
INSERT INTO em_sys_errcode VALUES (45001,'多媒体文件大小超过限制','')
;
INSERT INTO em_sys_errcode VALUES (45002,'消息内容大小超过限制','')
;
INSERT INTO em_sys_errcode VALUES (45003,'标题大小超过限制','')
;
INSERT INTO em_sys_errcode VALUES (45004,'描述大小超过限制','')
;
INSERT INTO em_sys_errcode VALUES (45005,'链接长度超过限制','')
;
INSERT INTO em_sys_errcode VALUES (45006,'图片链接长度超过限制','')
;
INSERT INTO em_sys_errcode VALUES (45007,'语音播放时间超过限制','')
;
INSERT INTO em_sys_errcode VALUES (45008,'图文消息的文章数量不能超过8条','')
;
INSERT INTO em_sys_errcode VALUES (45009,'接口调用超过限制','')
;
INSERT INTO em_sys_errcode VALUES (45010,'创建菜单个数超过限制','')
;
INSERT INTO em_sys_errcode VALUES (45015,'回复时间超过限制','')
;
INSERT INTO em_sys_errcode VALUES (45016,'系统分组，不允许修改','')
;
INSERT INTO em_sys_errcode VALUES (45017,'分组名字过长','')
;
INSERT INTO em_sys_errcode VALUES (45018,'分组数量超过上限','')
;
INSERT INTO em_sys_errcode VALUES (45022,'应用名字长度不合法，合法长度为2-16个字','')
;
INSERT INTO em_sys_errcode VALUES (45024,'帐号数量超过上限','')
;
INSERT INTO em_sys_errcode VALUES (45025,'同一个成员每周只能邀请一次','')
;
INSERT INTO em_sys_errcode VALUES (45026,'触发删除用户数的保护','')
;
INSERT INTO em_sys_errcode VALUES (45027,'mpnews每天只能发送100次','')
;
INSERT INTO em_sys_errcode VALUES (45028,'素材数量超过上限','')
;
INSERT INTO em_sys_errcode VALUES (45029,'media_id对该应用不可见','')
;
INSERT INTO em_sys_errcode VALUES (45032,'作者名字长度超过限制','')
;
INSERT INTO em_sys_errcode VALUES (45100,'标签数量超过上限','')
;
INSERT INTO em_sys_errcode VALUES (45200,'企业新增人员时，缺少部门数据','')
;
INSERT INTO em_sys_errcode VALUES (45201,'企业修改人员数据时,应企业人员丢失','')
;
INSERT INTO em_sys_errcode VALUES (45202,'授权用户信息丢失','')
;
INSERT INTO em_sys_errcode VALUES (45203,'默认企业修改人员数据时,对应企业用户丢失','')
;
INSERT INTO em_sys_errcode VALUES (45204,'默认企业修改人员数据时,对应基础用户丢失','')
;
INSERT INTO em_sys_errcode VALUES (46001,'不存在媒体数据','')
;
INSERT INTO em_sys_errcode VALUES (46002,'不存在的菜单版本','')
;
INSERT INTO em_sys_errcode VALUES (46003,'不存在的菜单数据','')
;
INSERT INTO em_sys_errcode VALUES (46004,'不存在的成员','')
;
INSERT INTO em_sys_errcode VALUES (47001,'解析JSON/XML内容错误','')
;
INSERT INTO em_sys_errcode VALUES (48001,'Api未授权','')
;
INSERT INTO em_sys_errcode VALUES (48002,'Api禁用(一般是管理组类型与Api不匹配，例如普通管理组调用会话服务的Api)','')
;
INSERT INTO em_sys_errcode VALUES (48003,'suitetoken无效','')
;
INSERT INTO em_sys_errcode VALUES (48004,'授权关系无效','')
;
INSERT INTO em_sys_errcode VALUES (48005,'Api已废弃','')
;
INSERT INTO em_sys_errcode VALUES (50001,'access_token对应应用的可信域名与跳转的域名不匹配','')
;
INSERT INTO em_sys_errcode VALUES (50002,'成员不在权限范围','')
;
INSERT INTO em_sys_errcode VALUES (50003,'应用已停用','')
;
INSERT INTO em_sys_errcode VALUES (50004,'成员状态不正确，需要成员为企业验证中状态','')
;
INSERT INTO em_sys_errcode VALUES (50005,'企业已禁用','')
;
INSERT INTO em_sys_errcode VALUES (51000,'无效的状态','')
;
INSERT INTO em_sys_errcode VALUES (60001,'部门长度不符合限制','')
;
INSERT INTO em_sys_errcode VALUES (60002,'部门层级深度超过限制','')
;
INSERT INTO em_sys_errcode VALUES (60003,'部门不存在','')
;
INSERT INTO em_sys_errcode VALUES (60004,'父部门不存在','')
;
INSERT INTO em_sys_errcode VALUES (60005,'不允许删除有成员的部门','')
;
INSERT INTO em_sys_errcode VALUES (60006,'不允许删除有子部门的部门','')
;
INSERT INTO em_sys_errcode VALUES (60007,'不允许删除根部门','')
;
INSERT INTO em_sys_errcode VALUES (60008,'部门ID或者部门名称已存在','')
;
INSERT INTO em_sys_errcode VALUES (60009,'部门名称含有非法字符','')
;
INSERT INTO em_sys_errcode VALUES (60010,'部门存在循环关系','')
;
INSERT INTO em_sys_errcode VALUES (60011,'权限不足，user/department/agent无权限(只有通迅录同步助手才有通迅录写权限，同时要开启写权限 )','')
;
INSERT INTO em_sys_errcode VALUES (60012,'不允许删除默认应用','')
;
INSERT INTO em_sys_errcode VALUES (60013,'不允许关闭应用','')
;
INSERT INTO em_sys_errcode VALUES (60014,'不允许开启应用','')
;
INSERT INTO em_sys_errcode VALUES (60015,'不允许修改默认应用可见范围','')
;
INSERT INTO em_sys_errcode VALUES (60016,'不允许删除存在成员的标签','')
;
INSERT INTO em_sys_errcode VALUES (60017,'不允许设置企业','')
;
INSERT INTO em_sys_errcode VALUES (60019,'不允许设置应用地理位置上报开关','')
;
INSERT INTO em_sys_errcode VALUES (60020,'访问ip不在白名单之中','')
;
INSERT INTO em_sys_errcode VALUES (60023,'已授权的应用不允许企业管理组调用接口修改菜单','')
;
INSERT INTO em_sys_errcode VALUES (60025,'主页型应用不支持的消息类型','')
;
INSERT INTO em_sys_errcode VALUES (60027,'不支持第三方修改主页型应用字段','')
;
INSERT INTO em_sys_errcode VALUES (60028,'应用已授权予第三方，不允许通过接口修改主页url','')
;
INSERT INTO em_sys_errcode VALUES (60029,'应用已授权予第三方，不允许通过接口修改可信域名','')
;
INSERT INTO em_sys_errcode VALUES (60031,'未设置管理组的登录授权域名','')
;
INSERT INTO em_sys_errcode VALUES (60102,'UserID已存在','')
;
INSERT INTO em_sys_errcode VALUES (60103,'手机号码不合法','')
;
INSERT INTO em_sys_errcode VALUES (60104,'手机号码已存在','')
;
INSERT INTO em_sys_errcode VALUES (60105,'邮箱不合法','')
;
INSERT INTO em_sys_errcode VALUES (60106,'邮箱已存在','')
;
INSERT INTO em_sys_errcode VALUES (60107,'微信号不合法','')
;
INSERT INTO em_sys_errcode VALUES (60108,'微信号已存在','')
;
INSERT INTO em_sys_errcode VALUES (60109,'QQ号已存在','')
;
INSERT INTO em_sys_errcode VALUES (60110,'用户同时归属部门超过20个','')
;
INSERT INTO em_sys_errcode VALUES (60111,'UserID不存在','')
;
INSERT INTO em_sys_errcode VALUES (60112,'成员姓名不合法','')
;
INSERT INTO em_sys_errcode VALUES (60113,'身份认证信息（微信号/手机/邮箱）不能同时为空','')
;
INSERT INTO em_sys_errcode VALUES (60114,'性别不合法','')
;
INSERT INTO em_sys_errcode VALUES (60115,'已关注成员微信不能修改','')
;
INSERT INTO em_sys_errcode VALUES (60116,'扩展属性已存在','')
;
INSERT INTO em_sys_errcode VALUES (60118,'成员无有效邀请字段，详情参考(邀请成员关注)的接口说明','')
;
INSERT INTO em_sys_errcode VALUES (60119,'成员已关注','')
;
INSERT INTO em_sys_errcode VALUES (60120,'成员已禁用','')
;
INSERT INTO em_sys_errcode VALUES (60121,'找不到该成员','')
;
INSERT INTO em_sys_errcode VALUES (60122,'邮箱已被外部管理员使用','')
;
INSERT INTO em_sys_errcode VALUES (60123,'无效的部门id','')
;
INSERT INTO em_sys_errcode VALUES (60124,'无效的父部门id','')
;
INSERT INTO em_sys_errcode VALUES (60125,'非法部门名字，长度超过限制、重名等，重名包括与csv文件中同级部门重名或者与旧组织架构包含成员的同级部门重名','')
;
INSERT INTO em_sys_errcode VALUES (60126,'创建部门失败','')
;
INSERT INTO em_sys_errcode VALUES (60127,'缺少部门id','')
;
INSERT INTO em_sys_errcode VALUES (60128,'字段不合法，可能存在主键冲突或者格式错误','')
;
INSERT INTO em_sys_errcode VALUES (60129,'用户设置了拒绝邀请','')
;
INSERT INTO em_sys_errcode VALUES (60131,'不合法的职位长度','')
;
INSERT INTO em_sys_errcode VALUES (60140,'标签id已存在','')
;
INSERT INTO em_sys_errcode VALUES (60141,'应用ID非法','')
;
INSERT INTO em_sys_errcode VALUES (60142,'应用名称非法','')
;
INSERT INTO em_sys_errcode VALUES (60143,'应用类型非法','')
;
INSERT INTO em_sys_errcode VALUES (60144,'应用名称已存在','')
;
INSERT INTO em_sys_errcode VALUES (60145,'应用状态错误','')
;
INSERT INTO em_sys_errcode VALUES (60146,'成员已激活，手机号需成员自行修改','')
;
INSERT INTO em_sys_errcode VALUES (61001,'根部门的父id不允许变更','')
;
INSERT INTO em_sys_errcode VALUES (70046,'消息链接，必须以http开头','')
;
INSERT INTO em_sys_errcode VALUES (70047,'分享链接，必须以http开头','')
;
INSERT INTO em_sys_errcode VALUES (70048,'消息提醒链接，必须以http开头','')
;
INSERT INTO em_sys_errcode VALUES (70049,'消息状态链接，必须以http开头','')
;
INSERT INTO em_sys_errcode VALUES (70051,'消息主页链接，必须以http开头','')
;
INSERT INTO em_sys_errcode VALUES (70052,'网页授权方式不合法','')
;
INSERT INTO em_sys_errcode VALUES (70053,'用户标识字段不能为空','')
;
INSERT INTO em_sys_errcode VALUES (70054,'SHA1授权方式,授权秘钥不能为空','')
;
INSERT INTO em_sys_errcode VALUES (70055,'AUTH_CODE授权ecology方式,集成系统id不能为空','')
;
INSERT INTO em_sys_errcode VALUES (70056,'AUTH_CODE授权ecology方式,集成系统id不存在','')
;
INSERT INTO em_sys_errcode VALUES (70057,'应用share地址未配置','')
;
INSERT INTO em_sys_errcode VALUES (70058,'应用share地址非http请求','')
;
INSERT INTO em_sys_errcode VALUES (70059,'应用不存在或已删除','')
;
INSERT INTO em_sys_errcode VALUES (70060,'授权标识字段为空','')
;
INSERT INTO em_sys_errcode VALUES (70061,'授权标识字段转为ecology同步字段时，同步用户为空','')
;
INSERT INTO em_sys_errcode VALUES (70062,'授权标识字段转为ecology同步字段时，ecology公钥错误','')
;
INSERT INTO em_sys_errcode VALUES (70063,'授权标识字段转为ecology同步字段时，应用配置的集成系统id不存在或已删除','')
;
INSERT INTO em_sys_errcode VALUES (70064,'授权标识字段对应企业人员不存在或已删除','')
;
INSERT INTO em_sys_errcode VALUES (70065,'授权标识字段对应的自定义字段值未设置','')
;
INSERT INTO em_sys_errcode VALUES (70066,'应用count地址未配置','')
;
INSERT INTO em_sys_errcode VALUES (70067,'应用count地址非http请求','')
;
INSERT INTO em_sys_errcode VALUES (70070,'分享消息内容为空','')
;
INSERT INTO em_sys_errcode VALUES (70071,'分享消息canforward值不合法','')
;
INSERT INTO em_sys_errcode VALUES (70072,'分享消息opentype值不合法','')
;
INSERT INTO em_sys_errcode VALUES (70073,'分享消息opentype_pc值不合法','')
;
INSERT INTO em_sys_errcode VALUES (70074,'分享消息extra格式错误','')
;
INSERT INTO em_sys_errcode VALUES (71001,'人员条件类型，规则类型值不合法','')
;
INSERT INTO em_sys_errcode VALUES (71002,'同步范围，条件类型值不合法','')
;
INSERT INTO em_sys_errcode VALUES (71003,'类型值除同分部部门与所有人外，规则类型值不能为空','')
;
INSERT INTO em_sys_errcode VALUES (71004,'类型值除同分部部门与所有人外，规则类型值显示名不能为空','')
;
INSERT INTO em_sys_errcode VALUES (71006,'集成系统id不能为空','')
;
INSERT INTO em_sys_errcode VALUES (71007,'已有同步任务正在进行中','')
;
INSERT INTO em_sys_errcode VALUES (71008,'秘钥存在重复','')
;
INSERT INTO em_sys_errcode VALUES (71010,'创建集成系统权限用户时，集成对象为空','')
;
INSERT INTO em_sys_errcode VALUES (72015,'没有操作发票的权限','')
;
INSERT INTO em_sys_errcode VALUES (72017,'发票抬头不一致','')
;
INSERT INTO em_sys_errcode VALUES (72023,'发票已被其他公众号锁定','')
;
INSERT INTO em_sys_errcode VALUES (72024,'发票状态错误','')
;
INSERT INTO em_sys_errcode VALUES (80001,'可信域名不匹配，或者可信域名没有IPC备案（后续将不能在该域名下正常使用jssdk）','')
;
INSERT INTO em_sys_errcode VALUES (81001,'部门下的结点数超过限制（3W）','')
;
INSERT INTO em_sys_errcode VALUES (81003,'邀请额度已用完','')
;
INSERT INTO em_sys_errcode VALUES (81004,'部门数量超过上限','')
;
INSERT INTO em_sys_errcode VALUES (82001,'发送消息或者邀请的参数全部为空或者全部不合法','')
;
INSERT INTO em_sys_errcode VALUES (82002,'不合法的PartyID列表长度','')
;
INSERT INTO em_sys_errcode VALUES (82003,'不合法的TagID列表长度','')
;
INSERT INTO em_sys_errcode VALUES (82004,'微信版本号过低','')
;
INSERT INTO em_sys_errcode VALUES (85002,'包含不合法的词语','')
;
INSERT INTO em_sys_errcode VALUES (86001,'不合法的会话ID','')
;
INSERT INTO em_sys_errcode VALUES (86003,'不存在的会话ID','')
;
INSERT INTO em_sys_errcode VALUES (86004,'不合法的会话名','')
;
INSERT INTO em_sys_errcode VALUES (86005,'不合法的会话管理员','')
;
INSERT INTO em_sys_errcode VALUES (86006,'不合法的成员列表大小','')
;
INSERT INTO em_sys_errcode VALUES (86007,'不存在的成员','')
;
INSERT INTO em_sys_errcode VALUES (86101,'需要会话管理员权限','')
;
INSERT INTO em_sys_errcode VALUES (86201,'缺少会话ID','')
;
INSERT INTO em_sys_errcode VALUES (86202,'缺少会话名','')
;
INSERT INTO em_sys_errcode VALUES (86203,'缺少会话管理员','')
;
INSERT INTO em_sys_errcode VALUES (86204,'缺少成员','')
;
INSERT INTO em_sys_errcode VALUES (86205,'非法的会话ID长度','')
;
INSERT INTO em_sys_errcode VALUES (86206,'非法的会话ID数值','')
;
INSERT INTO em_sys_errcode VALUES (86207,'会话管理员不在用户列表中','')
;
INSERT INTO em_sys_errcode VALUES (86208,'消息服务未开启','')
;
INSERT INTO em_sys_errcode VALUES (86209,'缺少操作者','')
;
INSERT INTO em_sys_errcode VALUES (86210,'缺少会话参数','')
;
INSERT INTO em_sys_errcode VALUES (86211,'缺少会话类型（单聊或者群聊）','')
;
INSERT INTO em_sys_errcode VALUES (86213,'缺少发件人','')
;
INSERT INTO em_sys_errcode VALUES (86214,'非法的会话类型','')
;
INSERT INTO em_sys_errcode VALUES (86215,'会话已存在','')
;
INSERT INTO em_sys_errcode VALUES (86216,'非法会话成员','')
;
INSERT INTO em_sys_errcode VALUES (86217,'会话操作者不在成员列表中','')
;
INSERT INTO em_sys_errcode VALUES (86218,'非法会话发件人','')
;
INSERT INTO em_sys_errcode VALUES (86219,'非法会话收件人','')
;
INSERT INTO em_sys_errcode VALUES (86220,'非法会话操作者','')
;
INSERT INTO em_sys_errcode VALUES (86221,'单聊模式下，发件人与收件人不能为同一人','')
;
INSERT INTO em_sys_errcode VALUES (86222,'不允许消息服务访问的API','')
;
INSERT INTO em_sys_errcode VALUES (86304,'不合法的消息类型','')
;
INSERT INTO em_sys_errcode VALUES (86305,'客服服务未启用','')
;
INSERT INTO em_sys_errcode VALUES (86306,'缺少发送人','')
;
INSERT INTO em_sys_errcode VALUES (86307,'缺少发送人类型','')
;
INSERT INTO em_sys_errcode VALUES (86308,'缺少发送人id','')
;
INSERT INTO em_sys_errcode VALUES (86309,'缺少接收人','')
;
INSERT INTO em_sys_errcode VALUES (86310,'缺少接收人类型','')
;
INSERT INTO em_sys_errcode VALUES (86311,'缺少接收人id','')
;
INSERT INTO em_sys_errcode VALUES (86312,'缺少消息类型','')
;
INSERT INTO em_sys_errcode VALUES (86313,'缺少客服，发送人或接收人类型，必须有一个为kf','')
;
INSERT INTO em_sys_errcode VALUES (86314,'客服不唯一，发送人或接收人类型，必须只有一个为kf','')
;
INSERT INTO em_sys_errcode VALUES (86315,'不合法的发送人类型','')
;
INSERT INTO em_sys_errcode VALUES (86316,'不合法的发送人id。Userid不存在、openid不存在、kf不存在','')
;
INSERT INTO em_sys_errcode VALUES (86317,'不合法的接收人类型','')
;
INSERT INTO em_sys_errcode VALUES (86318,'不合法的接收人id。Userid不存在、openid不存在、kf不存在','')
;
INSERT INTO em_sys_errcode VALUES (86319,'不合法的客服，kf不在客服列表中','')
;
INSERT INTO em_sys_errcode VALUES (86320,'不合法的客服类型','')
;
INSERT INTO em_sys_errcode VALUES (88001,'缺少seq参数','')
;
INSERT INTO em_sys_errcode VALUES (88002,'缺少offset参数','')
;
INSERT INTO em_sys_errcode VALUES (88003,'非法seq','')
;
INSERT INTO em_sys_errcode VALUES (90001,'未认证摇一摇周边','')
;
INSERT INTO em_sys_errcode VALUES (90002,'缺少摇一摇周边ticket参数','')
;
INSERT INTO em_sys_errcode VALUES (90003,'摇一摇周边ticket参数不合法','')
;
INSERT INTO em_sys_errcode VALUES (90004,'摇一摇周边ticket过期','')
;
INSERT INTO em_sys_errcode VALUES (90005,'未开启摇一摇周边服务','')
;
INSERT INTO em_sys_errcode VALUES (91004,'卡券已被核销','')
;
INSERT INTO em_sys_errcode VALUES (91011,'无效的code','')
;
INSERT INTO em_sys_errcode VALUES (91014,'缺少卡券详情','')
;
INSERT INTO em_sys_errcode VALUES (91015,'代金券缺少least_cost或者reduce_cost参数','')
;
INSERT INTO em_sys_errcode VALUES (91016,'折扣券缺少discount参数','')
;
INSERT INTO em_sys_errcode VALUES (91017,'礼品券缺少gift参数','')
;
INSERT INTO em_sys_errcode VALUES (91019,'缺少卡券sku参数','')
;
INSERT INTO em_sys_errcode VALUES (91020,'缺少卡券有效期','')
;
INSERT INTO em_sys_errcode VALUES (91021,'缺少卡券有效期类型','')
;
INSERT INTO em_sys_errcode VALUES (91022,'缺少卡券logo_url','')
;
INSERT INTO em_sys_errcode VALUES (91023,'缺少卡券code类型','')
;
INSERT INTO em_sys_errcode VALUES (91025,'缺少卡券title','')
;
INSERT INTO em_sys_errcode VALUES (91026,'缺少卡券color','')
;
INSERT INTO em_sys_errcode VALUES (91027,'缺少offset参数','')
;
INSERT INTO em_sys_errcode VALUES (91028,'缺少count参数','')
;
INSERT INTO em_sys_errcode VALUES (91029,'缺少card_id','')
;
INSERT INTO em_sys_errcode VALUES (91030,'缺少卡券code','')
;
INSERT INTO em_sys_errcode VALUES (91031,'缺少卡券notice','')
;
INSERT INTO em_sys_errcode VALUES (91032,'缺少卡券description','')
;
INSERT INTO em_sys_errcode VALUES (91033,'缺少ticket类型','')
;
INSERT INTO em_sys_errcode VALUES (91036,'不合法的有效期','')
;
INSERT INTO em_sys_errcode VALUES (91038,'变更库存值不合法','')
;
INSERT INTO em_sys_errcode VALUES (91039,'不合法的卡券id','')
;
INSERT INTO em_sys_errcode VALUES (91040,'不合法的ticket type','')
;
INSERT INTO em_sys_errcode VALUES (91041,'没有创建，上传卡券logo，以及核销卡券的权限','')
;
INSERT INTO em_sys_errcode VALUES (91042,'没有该卡券投放权限','')
;
INSERT INTO em_sys_errcode VALUES (91043,'没有修改或者删除该卡券的权限','')
;
INSERT INTO em_sys_errcode VALUES (91044,'不合法的卡券参数','')
;
INSERT INTO em_sys_errcode VALUES (91045,'缺少团购券groupon结构','')
;
INSERT INTO em_sys_errcode VALUES (91046,'缺少现金券cash结构','')
;
INSERT INTO em_sys_errcode VALUES (91047,'缺少折扣券discount 结构','')
;
INSERT INTO em_sys_errcode VALUES (91048,'缺少礼品券gift结构','')
;
INSERT INTO em_sys_errcode VALUES (91049,'缺少优惠券coupon结构','')
;
INSERT INTO em_sys_errcode VALUES (91050,'缺少卡券必填字段','')
;
INSERT INTO em_sys_errcode VALUES (91051,'商户名称超过12个汉字','')
;
INSERT INTO em_sys_errcode VALUES (91052,'卡券标题超过9个汉字','')
;
INSERT INTO em_sys_errcode VALUES (91053,'卡券提醒超过16个汉字','')
;
INSERT INTO em_sys_errcode VALUES (91054,'卡券描述超过1024个汉字','')
;
INSERT INTO em_sys_errcode VALUES (91055,'卡券副标题长度超过18个汉字','')
;
INSERT INTO em_sys_errcode VALUES (301001,'应用id已存在','')
;
INSERT INTO em_sys_errcode VALUES (301002,'accesstoken不允许操作其它应用。','')
;
INSERT INTO em_sys_errcode VALUES (301004,'不允许删除超级管理员','')
;
INSERT INTO em_sys_errcode VALUES (301005,'消息型应用不允许做此操作','')
;
INSERT INTO em_sys_errcode VALUES (301006,'不允许禁用超级管理员','')
;
INSERT INTO em_sys_errcode VALUES (301008,'主页型应用不允许做此操作','')
;
INSERT INTO em_sys_errcode VALUES (301009,'应用发送消息没有接收主体','')
;
INSERT INTO em_sys_errcode VALUES (301010,'部门名已存在','')
;
INSERT INTO em_sys_errcode VALUES (301012,'职位信息不合法','')
;
INSERT INTO em_sys_errcode VALUES (301013,'座机不合法','')
;
INSERT INTO em_sys_errcode VALUES (301014,'英文名称不合法','')
;
INSERT INTO em_sys_errcode VALUES (301021,'userid错误','')
;
INSERT INTO em_sys_errcode VALUES (301022,'获取打卡数据失败','')
;
INSERT INTO em_sys_errcode VALUES (301023,'useridlist非法或超过限额','')
;
INSERT INTO em_sys_errcode VALUES (301024,'获取打卡记录时间间隔超限','')
;
INSERT INTO em_sys_errcode VALUES (301101,'应用类型不是链接型','')
;
INSERT INTO em_sys_errcode VALUES (301102,'应用类型不是第三方打开APP','')
;
INSERT INTO em_sys_errcode VALUES (301103,'app类型应用不支持消息发送','')
;
INSERT INTO em_sys_errcode VALUES (302001,'批量同步成员存在userid为空的用户','')
;
INSERT INTO em_sys_errcode VALUES (302002,'管理员userid不存在','')
;
INSERT INTO em_sys_errcode VALUES (302003,'存在重复的userid','')
;
INSERT INTO em_sys_errcode VALUES (302004,'组织架构不合法（1不是一棵树，2 多个一样的partyid，3 partyid空，4 partyid name 空，5 同一个父节点下有两个子节点 部门名字一样 可能是以上情况，请一一排查）','')
;
INSERT INTO em_sys_errcode VALUES (400001,'response_type类型错误','response_type is invalid')
;
INSERT INTO em_sys_errcode VALUES (400002,'scpoe类型错误','scpoe is invalid')
;
INSERT INTO em_sys_errcode VALUES (400003,'已激活用户，手机号码不允许修改','')
;
INSERT INTO em_sys_errcode VALUES (400004,'姓名字段为空','')
;
INSERT INTO em_sys_errcode VALUES (400005,'帐号字段为空','')
;
INSERT INTO em_sys_errcode VALUES (400006,'手机字段为空','')
;
INSERT INTO em_sys_errcode VALUES (400007,'账号重复','')
;
INSERT INTO em_sys_errcode VALUES (400008,'手机已存在','')
;
INSERT INTO em_sys_errcode VALUES (400009,'邮箱已存在','')
;
INSERT INTO em_sys_errcode VALUES (400010,'部门关系无效','')
;
INSERT INTO em_sys_errcode VALUES (400011,'手机号码或邮箱重复','')
;
INSERT INTO em_sys_errcode VALUES (400012,'上级人员Id不存在。','')
;
INSERT INTO em_sys_errcode VALUES (400013,'safe参数不合法。','')
;
CREATE TABLE em_sys_trade_detail (
  category_code varchar(4) NOT NULL PRIMARY KEY,
  category_name varchar(100) NOT NULL,
  descrition varchar(1000) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_trade_detail IS '行业门类表'
;
COMMENT ON COLUMN em_sys_trade_detail.category_code IS '行业代码'
;
COMMENT ON COLUMN em_sys_trade_detail.category_name IS '行业类别名称'
;
COMMENT ON COLUMN em_sys_trade_detail.descrition IS '行业描述'
;
INSERT INTO em_sys_trade_detail VALUES ('A','农、林、牧、渔业','本门类包括01～05大类')
;
INSERT INTO em_sys_trade_detail VALUES ('B','采矿业','本类包括06～12大类，采矿业指对固体（如煤和矿物）、液体（如原油）或气体（如天然气）等自然产生的矿物的采掘；包括地下或地上采掘、矿井的运行，以及一般在矿址或矿址附近从事的旨在加工原材料的所有辅助性工作，例如碾磨、选矿和处理，均属本类活动；还包括使原料得以销售所需的准备工作；不包括水的蓄集、净化和分配，以及地质勘查、建筑工程活动')
;
INSERT INTO em_sys_trade_detail VALUES ('C','制造业','本门类包括13～43大类，指经物理变化或化学变化后成为新的产品，不论是动力机械制造，还是手工制作；也不论产品是批发销售，还是零售，均视为制造。建筑物中的各种制成品、零部件的生产应视为制造，但在建筑预制品工地，把主要部件组装成桥梁、仓库设备、铁路与高架公路、升降机与电梯、管道设备、喷水设备、暖气设备、通风设备与空调设备，照明与安装电线等组装活动，以及建筑物的装置，均列为建筑活动。本门类包括机电产品的再制造，指将废旧汽车零部件、工程机械、机床等进行专业化修复的批量化生产过程，再制造的产品达到与原有新产品相同的质量和性能')
;
INSERT INTO em_sys_trade_detail VALUES ('D','电力、热力、燃气及水生产和供应业','本门类包括44～46大类')
;
INSERT INTO em_sys_trade_detail VALUES ('E','建筑业','本门类包括47～50大类')
;
INSERT INTO em_sys_trade_detail VALUES ('F','批发和零售业','本门类包括51和52大类，指商品在流通环节中的批发活动和零售活动')
;
INSERT INTO em_sys_trade_detail VALUES ('G','交通运输、仓储和邮政业','本门类包括53～60大类')
;
INSERT INTO em_sys_trade_detail VALUES ('H','住宿和餐饮业','本门类包括61和62大类')
;
INSERT INTO em_sys_trade_detail VALUES ('I','信息传输、软件和信息技术服务业','本门类包括63～65大类')
;
INSERT INTO em_sys_trade_detail VALUES ('J','金融业','本门类包括66～69大类')
;
INSERT INTO em_sys_trade_detail VALUES ('K','房地产业','本门类包括70大类')
;
INSERT INTO em_sys_trade_detail VALUES ('L','租赁和商务服务业','本门类包括71和72大类')
;
INSERT INTO em_sys_trade_detail VALUES ('M','科学研究和技术服务业','本门类包括73～75大类')
;
INSERT INTO em_sys_trade_detail VALUES ('N','水利、环境和公共设施管理业','本门类包括76～78大类')
;
INSERT INTO em_sys_trade_detail VALUES ('O','居民服务、修理和其他服务业','本门类包括79～81大类')
;
INSERT INTO em_sys_trade_detail VALUES ('P','教育','本门类包括82大类')
;
INSERT INTO em_sys_trade_detail VALUES ('Q','卫生和社会工作','本门类包括83和84大类')
;
INSERT INTO em_sys_trade_detail VALUES ('R','文化、体育和娱乐业','本门类包括85～89大类')
;
INSERT INTO em_sys_trade_detail VALUES ('S','公共管理、社会保障和社会组织','本类包括90～95大类')
;
INSERT INTO em_sys_trade_detail VALUES ('T','国际组织','本门类包括96大类')
;
CREATE TABLE em_sys_trade (
  category_code varchar(4) NOT NULL PRIMARY KEY,
  category_name varchar(100) NOT NULL,
  descrition varchar(1000) DEFAULT NULL,
  pid varchar(4) NOT NULL
)
;
COMMENT ON TABLE em_sys_trade IS '行业大类表'
;
COMMENT ON COLUMN em_sys_trade.category_code IS '行业代码'
;
COMMENT ON COLUMN em_sys_trade.category_name IS '行业类别名称'
;
COMMENT ON COLUMN em_sys_trade.descrition IS '行业描述'
;
COMMENT ON COLUMN em_sys_trade.pid IS '上一级行业代码'
;
CREATE INDEX em_sys_trade_pid_index ON em_sys_trade(pid)
;
INSERT INTO em_sys_trade VALUES ('01','农业','指对各种农作物的种植','A')
;
INSERT INTO em_sys_trade VALUES ('02','林业','','A')
;
INSERT INTO em_sys_trade VALUES ('03','畜牧业','指为了获得各种畜禽产品而从事的动物饲养、捕捉活动','A')
;
INSERT INTO em_sys_trade VALUES ('04','渔业','','A')
;
INSERT INTO em_sys_trade VALUES ('05','农、林、牧、渔服务业','','A')
;
INSERT INTO em_sys_trade VALUES ('06','煤炭开采和洗选业','指对各种煤炭的开采、洗选、分级等生产活动；不包括煤制品的生产和煤炭勘探活动 ','B')
;
INSERT INTO em_sys_trade VALUES ('07','石油和天然气开采业','指在陆地或海洋，对天然原油、液态或气态天然气的开采，对煤矿瓦斯气（煤层气）的开采；为运输目的所进行的天然气液化和从天然气田气体中生产液化烃的活动，还包括对含沥青的页岩或油母页岩矿的开采，以及对焦油沙矿进行的同类作业','B')
;
INSERT INTO em_sys_trade VALUES ('08','黑色金属矿采选业','','B')
;
INSERT INTO em_sys_trade VALUES ('09','有色金属矿采选业','指对常用有色金属矿、贵金属矿，以及稀有稀土金属矿的开采、选矿活动','B')
;
INSERT INTO em_sys_trade VALUES ('10','非金属矿采选业','','B')
;
INSERT INTO em_sys_trade VALUES ('11','开采辅助活动','指为煤炭、石油和天然气等矿物开采提供的服务','B')
;
INSERT INTO em_sys_trade VALUES ('12','其他采矿业','','B')
;
INSERT INTO em_sys_trade VALUES ('13','农副食品加工业','指直接以农、林、牧、渔业产品为原料进行的谷物磨制、饲料加工、植物油和制糖加工、屠宰及肉类加工、水产品加工，以及蔬菜、水果和坚果等食品的加工','C')
;
INSERT INTO em_sys_trade VALUES ('14','食品制造业','','C')
;
INSERT INTO em_sys_trade VALUES ('15','酒、饮料和精制茶制造业','','C')
;
INSERT INTO em_sys_trade VALUES ('16','烟草制品业','','C')
;
INSERT INTO em_sys_trade VALUES ('17','纺织业','','C')
;
INSERT INTO em_sys_trade VALUES ('18','纺织服装、服饰业','','C')
;
INSERT INTO em_sys_trade VALUES ('19','皮革、毛皮、羽毛及其制品和制鞋业','','C')
;
INSERT INTO em_sys_trade VALUES ('20','木材加工和木、竹、藤、棕、草制品业','','C')
;
INSERT INTO em_sys_trade VALUES ('21','家具制造业','指用木材、金属、塑料、竹、藤等材料制作的，具有坐卧、凭倚、储藏、间隔等功能，可用于住宅、旅馆、办公室、学校、餐馆、医院、剧场、公园、船舰、飞机、机动车等任何场所的各种家具的制造','C')
;
INSERT INTO em_sys_trade VALUES ('22','造纸和纸制品业','','C')
;
INSERT INTO em_sys_trade VALUES ('23','印刷和记录媒介复制业','','C')
;
INSERT INTO em_sys_trade VALUES ('24','文教、工美、体育和娱乐用品制造业','','C')
;
INSERT INTO em_sys_trade VALUES ('25','石油加工、炼焦和核燃料加工业','','C')
;
INSERT INTO em_sys_trade VALUES ('26','化学原料和化学制品制造业','','C')
;
INSERT INTO em_sys_trade VALUES ('27','医药制造业','','C')
;
INSERT INTO em_sys_trade VALUES ('28','化学纤维制造业','','C')
;
INSERT INTO em_sys_trade VALUES ('29','橡胶和塑料制品业','','C')
;
INSERT INTO em_sys_trade VALUES ('30','非金属矿物制品业','','C')
;
INSERT INTO em_sys_trade VALUES ('31','黑色金属冶炼和压延加工业','','C')
;
INSERT INTO em_sys_trade VALUES ('32','有色金属冶炼和压延加工业','','C')
;
INSERT INTO em_sys_trade VALUES ('33','金属制品业','','C')
;
INSERT INTO em_sys_trade VALUES ('34','通用设备制造业','','C')
;
INSERT INTO em_sys_trade VALUES ('35','专用设备制造业','','C')
;
INSERT INTO em_sys_trade VALUES ('36','汽车制造业','','C')
;
INSERT INTO em_sys_trade VALUES ('37','铁路、船舶、航空航天和其他运输设备制造业','','C')
;
INSERT INTO em_sys_trade VALUES ('38','电气机械和器材制造业','','C')
;
INSERT INTO em_sys_trade VALUES ('39','计算机、通信和其他电子设备制造业','','C')
;
INSERT INTO em_sys_trade VALUES ('40','仪器仪表制造业','','C')
;
INSERT INTO em_sys_trade VALUES ('41','其他制造业','','C')
;
INSERT INTO em_sys_trade VALUES ('42','废弃资源综合利用业','指废弃资源和废旧材料回收加工','C')
;
INSERT INTO em_sys_trade VALUES ('43','金属制品、机械和设备修理业','','C')
;
INSERT INTO em_sys_trade VALUES ('44','电力、热力生产和供应业','','D')
;
INSERT INTO em_sys_trade VALUES ('45','燃气生产和供应业','','D')
;
INSERT INTO em_sys_trade VALUES ('46','水的生产和供应业','','D')
;
INSERT INTO em_sys_trade VALUES ('47','房屋建筑业','','E')
;
INSERT INTO em_sys_trade VALUES ('48','土木工程建筑业','指土木工程主体的施工活动；不包括施工前的工程准备活动','E')
;
INSERT INTO em_sys_trade VALUES ('49','建筑安装业','指建筑物主体工程竣工后，建筑物内各种设备的安装活动，以及施工中的线路敷设和管道安装活动；不包括工程收尾的装饰，如对墙面、地板、天花板、门窗等处理活动','E')
;
INSERT INTO em_sys_trade VALUES ('50','建筑装饰和其他建筑业','','E')
;
INSERT INTO em_sys_trade VALUES ('51','批发业','指向其他批发或零售单位（含个体经营者）及其他企事业单位、机关团体等批量销售生活用品、生产资料的活动，以及从事进出口贸易和贸易经纪与代理的活动，包括拥有货物所有权，并以本单位(公司)的名义进行交易活动,也包括不拥有货物的所有权，收取佣金的商品代理、商品代售活动；本类还包括各类商品批发市场中固定摊位的批发活动，以及以销售为目的的收购活动','F')
;
INSERT INTO em_sys_trade VALUES ('52','零售业','指百货商店、超级市场、专门零售商店、品牌专卖店、售货摊等主要面向最终消费者（如居民等）的销售活动，以互联网、邮政、电话、售货机等方式的销售活动，还包括在同一地点，后面加工生产，前面销售的店铺（如面包房）；谷物、种子、饲料、牲畜、矿产品、生产用原料、化工原料、农用化工产品、机械设备（乘用车、计算机及通信设备除外）等生产资料的销售不作为零售活动；多数零售商对其销售的货物拥有所有权，但有些则是充当委托人的代理人，进行委托销售或以收取佣金的方式进行销售','F')
;
INSERT INTO em_sys_trade VALUES ('53','铁路运输业','指铁路客运、货运及相关的调度、信号、机车、车辆、检修、工务等活动；不包括铁路系统所属的机车、车辆及信号通信设备的制造厂（公司）、建筑工程公司、商店、学校、科研所、医院等','G')
;
INSERT INTO em_sys_trade VALUES ('54','道路运输业','','G')
;
INSERT INTO em_sys_trade VALUES ('55','水上运输业','','G')
;
INSERT INTO em_sys_trade VALUES ('56','航空运输业','','G')
;
INSERT INTO em_sys_trade VALUES ('57','管道运输业','','G')
;
INSERT INTO em_sys_trade VALUES ('58','装卸搬运和运输代理业','','G')
;
INSERT INTO em_sys_trade VALUES ('59','仓储业','指专门从事货物仓储、货物运输中转仓储，以及以仓储为主的货物送配活动，还包括以仓储为目的的收购活动','G')
;
INSERT INTO em_sys_trade VALUES ('60','邮政业','','G')
;
INSERT INTO em_sys_trade VALUES ('61','住宿业','指为旅行者提供短期留宿场所的活动，有些单位只提供住宿，也有些单位提供住宿、饮食、商务、娱乐一体的服务，本类不包括主要按月或按年长期出租房屋住所的活动','H')
;
INSERT INTO em_sys_trade VALUES ('62','餐饮业','指通过即时制作加工、商业销售和服务性劳动等，向消费者提供食品和消费场所及设施的服务','H')
;
INSERT INTO em_sys_trade VALUES ('63','电信、广播电视和卫星传输服务','','I')
;
INSERT INTO em_sys_trade VALUES ('64','互联网和相关服务','','I')
;
INSERT INTO em_sys_trade VALUES ('65','软件和信息技术服务业','指对信息传输、信息制作、信息提供和信息接收过程中产生的技术问题或技术需求所提供的服务 ','I')
;
INSERT INTO em_sys_trade VALUES ('66','货币金融服务','','J')
;
INSERT INTO em_sys_trade VALUES ('67','资本市场服务','','J')
;
INSERT INTO em_sys_trade VALUES ('68','保险业','','J')
;
INSERT INTO em_sys_trade VALUES ('69','其他金融业','','J')
;
INSERT INTO em_sys_trade VALUES ('70','房地产业','','K')
;
INSERT INTO em_sys_trade VALUES ('71','租赁业','','L')
;
INSERT INTO em_sys_trade VALUES ('72','商务服务业','','L')
;
INSERT INTO em_sys_trade VALUES ('73','研究和试验发展','指为了增加知识（包括有关自然、工程、人类、文化和社会的知识），以及运用这些知识创造新的应用，所进行的系统的、创造性的活动；该活动仅限于对新发现、新理论的研究，新技术、新产品、新工艺的研制研究与试验发展，包括基础研究、应用研究和试验发展','M')
;
INSERT INTO em_sys_trade VALUES ('74','专业技术服务业','','M')
;
INSERT INTO em_sys_trade VALUES ('75','科技推广和应用服务业','','M')
;
INSERT INTO em_sys_trade VALUES ('76','水利管理业','','N')
;
INSERT INTO em_sys_trade VALUES ('77','生态保护和环境治理业','','N')
;
INSERT INTO em_sys_trade VALUES ('78','公共设施管理业','','N')
;
INSERT INTO em_sys_trade VALUES ('79','居民服务业','','O')
;
INSERT INTO em_sys_trade VALUES ('80','机动车、电子产品和日用产品修理业','','O')
;
INSERT INTO em_sys_trade VALUES ('81','其他服务业','','O')
;
INSERT INTO em_sys_trade VALUES ('82','教育','','P')
;
INSERT INTO em_sys_trade VALUES ('83','卫生','','Q')
;
INSERT INTO em_sys_trade VALUES ('84','社会工作','指提供慈善、救助、福利、护理、帮助等社会工作的活动','Q')
;
INSERT INTO em_sys_trade VALUES ('85','新闻和出版业','','R')
;
INSERT INTO em_sys_trade VALUES ('86','广播、电视、电影和影视录音制作业','指对广播、电视、电影、影视录音内容的制作、编导、主持、播出、放映等活动；不包括广播电视信号的传输和接收活动','R')
;
INSERT INTO em_sys_trade VALUES ('87','文化艺术业','','R')
;
INSERT INTO em_sys_trade VALUES ('88','体育','','R')
;
INSERT INTO em_sys_trade VALUES ('89','娱乐业','','R')
;
INSERT INTO em_sys_trade VALUES ('90','中国共产党机关','','S')
;
INSERT INTO em_sys_trade VALUES ('91','国家机构','','S')
;
INSERT INTO em_sys_trade VALUES ('92','人民政协、民主党派','','S')
;
INSERT INTO em_sys_trade VALUES ('93','社会保障','','S')
;
INSERT INTO em_sys_trade VALUES ('94','群众团体、社会团体和其他成员组织','','S')
;
INSERT INTO em_sys_trade VALUES ('95','基层群众自治组织','指通过选举产生的社区性组织，该组织为本地区提供一般性管理、调解、治安、优抚、计划生育等服务','S')
;
INSERT INTO em_sys_trade VALUES ('96','国际组织','','T')
;
CREATE TABLE em_sys_login_verify_rule (
  id varchar(32) NOT NULL PRIMARY KEY,
  verify_type NUMBER(4,0) DEFAULT '1',
  verify_url varchar(100) DEFAULT NULL,
  verify_parm varchar(50) DEFAULT NULL,
  priority NUMBER(11,0) DEFAULT '0',
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_login_verify_rule IS '系统账号密码登录验证规则表'
;
COMMENT ON COLUMN em_sys_login_verify_rule.id IS '主键ID'
;
COMMENT ON COLUMN em_sys_login_verify_rule.verify_type IS '验证方式：1-本系统 2-ecology系统'
;
COMMENT ON COLUMN em_sys_login_verify_rule.verify_url IS '验证地址，如ecology系统地址'
;
COMMENT ON COLUMN em_sys_login_verify_rule.verify_parm IS '验证所需的其他参数值'
;
COMMENT ON COLUMN em_sys_login_verify_rule.priority IS '规则优先级'
;
COMMENT ON COLUMN em_sys_login_verify_rule.status IS '状态 1-正常，2-禁用，3-删除'
;
COMMENT ON COLUMN em_sys_login_verify_rule.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_login_verify_rule.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_login_verify_rule.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_login_verify_rule.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_login_verify_rule.tenant_id IS '企业租户ID'
;
INSERT INTO em_sys_login_verify_rule VALUES ('1',1,NULL,NULL,0,1,NULL,NULL,NULL,NULL,NULL)
;
CREATE TABLE em_sys_msg_setting (
  id varchar(32) NOT NULL PRIMARY KEY,
  enable_push NUMBER(4,0) DEFAULT NULL,
  api_ip varchar(255) DEFAULT NULL,
  pc_api_ip varchar(255) DEFAULT NULL,
  app_api_ip varchar(255) DEFAULT NULL,
  server_encrypt NUMBER(4,0) DEFAULT '0',
  server_port varchar(10) DEFAULT NULL,
  server_key varchar(255) DEFAULT NULL,
  server_secrect varchar(255) DEFAULT NULL,
  msg_domain varchar(32) DEFAULT NULL,
  pc_encrypt NUMBER(4,0) DEFAULT '0',
  pc_port varchar(10) DEFAULT NULL,
  app_encrypt NUMBER(4,0) DEFAULT '0',
  app_port varchar(10) DEFAULT NULL,
  file_save_type NUMBER(4,0) DEFAULT '1',
  file_save_outsysid varchar(32) DEFAULT NULL,
  file_size_limit NUMBER(11,0) DEFAULT NULL,
  revoke_limit NUMBER(11,0) DEFAULT NULL,
  group_limit NUMBER(11,0) DEFAULT NULL,
  read_state NUMBER(4,0) DEFAULT NULL,
  online_state NUMBER(4,0) DEFAULT NULL,
  del_msg NUMBER(4,0) DEFAULT NULL,
  secret_chat NUMBER(4,0) DEFAULT NULL,
  watermark NUMBER(4,0) DEFAULT NULL,
  ding_chat NUMBER(4,0) DEFAULT NULL,
  ding_func varchar(10) DEFAULT NULL,
  ding_sms_id varchar(32) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_msg_setting IS '消息设置信息'
;
COMMENT ON COLUMN em_sys_msg_setting.enable_push IS '是否开启消息服务：0-禁用、1-开启'
;
COMMENT ON COLUMN em_sys_msg_setting.api_ip IS '消息引擎服务IP地址'
;
COMMENT ON COLUMN em_sys_msg_setting.pc_api_ip IS 'pc端服务ip地址'
;
COMMENT ON COLUMN em_sys_msg_setting.app_api_ip IS '移动端服务ip地址'
;
COMMENT ON COLUMN em_sys_msg_setting.server_encrypt IS '消息引擎供服务端调用是否加密'
;
COMMENT ON COLUMN em_sys_msg_setting.server_port IS '消息引擎供服务端调用端口'
;
COMMENT ON COLUMN em_sys_msg_setting.server_key IS '消息引擎供服务端调用接口账号'
;
COMMENT ON COLUMN em_sys_msg_setting.server_secrect IS '消息引擎供服务端调用接口秘钥'
;
COMMENT ON COLUMN em_sys_msg_setting.msg_domain IS 'msg_domain'
;
COMMENT ON COLUMN em_sys_msg_setting.pc_encrypt IS '消息引擎供PC客户端调用是否加密'
;
COMMENT ON COLUMN em_sys_msg_setting.pc_port IS '消息引擎供PC客户端调用端口'
;
COMMENT ON COLUMN em_sys_msg_setting.app_encrypt IS '消息引擎供移动客户端调用是否加密'
;
COMMENT ON COLUMN em_sys_msg_setting.app_port IS '消息引擎供移动客户端调用端口'
;
COMMENT ON COLUMN em_sys_msg_setting.file_save_type IS '聊天文件存储方式 1:本系统存储 2:同过ecology系统存储'
;
COMMENT ON COLUMN em_sys_msg_setting.file_save_outsysid IS '聊天文件存储到ecology系统时，对应的集成ecology系统id'
;
COMMENT ON COLUMN em_sys_msg_setting.file_size_limit IS '消息传输文件限制大小，单位M'
;
COMMENT ON COLUMN em_sys_msg_setting.revoke_limit IS '消息撤销时间限制，单位为秒，0表示不限制'
;
COMMENT ON COLUMN em_sys_msg_setting.group_limit IS '群成员人数上限'
;
COMMENT ON COLUMN em_sys_msg_setting.read_state IS '是否开启消息阅读状态 1-是 0-否'
;
COMMENT ON COLUMN em_sys_msg_setting.online_state IS '是否开启在线状态'
;
COMMENT ON COLUMN em_sys_msg_setting.del_msg IS '是否开启删除消息功能 1-是 0-否'
;
COMMENT ON COLUMN em_sys_msg_setting.secret_chat IS '是否开启密聊 1-是 0-否'
;
COMMENT ON COLUMN em_sys_msg_setting.watermark IS '是否开启聊天窗口水印 1-是 0-否'
;
COMMENT ON COLUMN em_sys_msg_setting.ding_chat IS '是否开启必达 1-是 0-否'
;
COMMENT ON COLUMN em_sys_msg_setting.ding_func IS '必达功能项 1-短信 2-电话,多个功能用逗号分隔，如1,2'
;
COMMENT ON COLUMN em_sys_msg_setting.ding_sms_id IS '必达功能中发送短信对应的短信服务ID'
;
COMMENT ON COLUMN em_sys_msg_setting.status IS '状态'
;
COMMENT ON COLUMN em_sys_msg_setting.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_msg_setting.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_msg_setting.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_msg_setting.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_msg_setting.tenant_id IS '企业租户ID'
;
INSERT INTO em_sys_msg_setting VALUES ('1730822459568907351',0,NULL,NULL,NULL,0,'8090',NULL,NULL,NULL,0,'7070',0,'5222',1,NULL,100,300,500,0,0,0,0,NULL,NULL,NULL,NULL,1,'1',sysdate,NULL,NULL,'1')
;
CREATE TABLE em_sys_notice (
  id varchar(32) NOT NULL PRIMARY KEY,
  title varchar(200) DEFAULT NULL,
  content CLOB,
  linkurl varchar(200) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT NULL,
  publish_time TIMESTAMP DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_notice IS '系统通知表'
;
COMMENT ON COLUMN em_sys_notice.id IS '主键'
;
COMMENT ON COLUMN em_sys_notice.title IS '通知名称'
;
COMMENT ON COLUMN em_sys_notice.content IS '通知内容'
;
COMMENT ON COLUMN em_sys_notice.linkurl IS '链接地址'
;
COMMENT ON COLUMN em_sys_notice.status IS '状态：1-发布，2-草稿，3-删除'
;
COMMENT ON COLUMN em_sys_notice.publish_time IS '发布时间'
;
COMMENT ON COLUMN em_sys_notice.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_notice.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_notice.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_notice.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_notice.tenant_id IS '企业租户ID'
;
CREATE TABLE em_sys_notice_read (
  id varchar(32) NOT NULL PRIMARY KEY,
  notice_id varchar(32) DEFAULT NULL,
  base_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_notice_read IS '系统通知阅读状态表'
;
COMMENT ON COLUMN em_sys_notice_read.id IS '主键'
;
COMMENT ON COLUMN em_sys_notice_read.notice_id IS '通知ID'
;
COMMENT ON COLUMN em_sys_notice_read.base_user_id IS '基础用户ID'
;
COMMENT ON COLUMN em_sys_notice_read.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_notice_read.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_notice_read.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_notice_read.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_notice_read.tenant_id IS '企业租户ID'
;
CREATE TABLE em_sys_province (
  province_code NUMBER(11,0) NOT NULL PRIMARY KEY,
  province_name varchar(50) NOT NULL
)
;
COMMENT ON TABLE em_sys_province IS '省份表'
;
COMMENT ON COLUMN em_sys_province.province_code IS '代码'
;
COMMENT ON COLUMN em_sys_province.province_name IS '名称'
;
INSERT INTO em_sys_province VALUES (1,'北京市')
;
INSERT INTO em_sys_province VALUES (2,'天津市')
;
INSERT INTO em_sys_province VALUES (3,'上海市')
;
INSERT INTO em_sys_province VALUES (4,'重庆市')
;
INSERT INTO em_sys_province VALUES (5,'河北省')
;
INSERT INTO em_sys_province VALUES (6,'山西省')
;
INSERT INTO em_sys_province VALUES (7,'台湾省')
;
INSERT INTO em_sys_province VALUES (8,'辽宁省')
;
INSERT INTO em_sys_province VALUES (9,'吉林省')
;
INSERT INTO em_sys_province VALUES (10,'黑龙江省')
;
INSERT INTO em_sys_province VALUES (11,'江苏省')
;
INSERT INTO em_sys_province VALUES (12,'浙江省')
;
INSERT INTO em_sys_province VALUES (13,'安徽省')
;
INSERT INTO em_sys_province VALUES (14,'福建省')
;
INSERT INTO em_sys_province VALUES (15,'江西省')
;
INSERT INTO em_sys_province VALUES (16,'山东省')
;
INSERT INTO em_sys_province VALUES (17,'河南省')
;
INSERT INTO em_sys_province VALUES (18,'湖北省')
;
INSERT INTO em_sys_province VALUES (19,'湖南省')
;
INSERT INTO em_sys_province VALUES (20,'广东省')
;
INSERT INTO em_sys_province VALUES (21,'甘肃省')
;
INSERT INTO em_sys_province VALUES (22,'四川省')
;
INSERT INTO em_sys_province VALUES (23,'贵州省')
;
INSERT INTO em_sys_province VALUES (24,'海南省')
;
INSERT INTO em_sys_province VALUES (25,'云南省')
;
INSERT INTO em_sys_province VALUES (26,'青海省')
;
INSERT INTO em_sys_province VALUES (27,'陕西省')
;
INSERT INTO em_sys_province VALUES (28,'广西壮族自治区')
;
INSERT INTO em_sys_province VALUES (29,'西藏自治区')
;
INSERT INTO em_sys_province VALUES (30,'宁夏回族自治区')
;
INSERT INTO em_sys_province VALUES (31,'新疆维吾尔自治区')
;
INSERT INTO em_sys_province VALUES (32,'内蒙古自治区')
;
INSERT INTO em_sys_province VALUES (33,'澳门特别行政区')
;
INSERT INTO em_sys_province VALUES (34,'香港特别行政区')
;
CREATE TABLE em_sys_redpacket_setting (
  id varchar(32) NOT NULL PRIMARY KEY,
  enabled NUMBER(4,0) DEFAULT NULL,
  app_key varchar(100) DEFAULT NULL,
  custom_id varchar(100) DEFAULT NULL,
  custom_name varchar(100) DEFAULT '1',
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_redpacket_setting IS '红包服务设置信息'
;
COMMENT ON COLUMN em_sys_redpacket_setting.enabled IS '是否开启红包服务：0-禁用、1-开启'
;
COMMENT ON COLUMN em_sys_redpacket_setting.app_key IS '接入的秘钥'
;
COMMENT ON COLUMN em_sys_redpacket_setting.custom_id IS '商户ID'
;
COMMENT ON COLUMN em_sys_redpacket_setting.custom_name IS '商户名称'
;
COMMENT ON COLUMN em_sys_redpacket_setting.status IS '状态'
;
COMMENT ON COLUMN em_sys_redpacket_setting.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_redpacket_setting.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_redpacket_setting.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_redpacket_setting.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_redpacket_setting.tenant_id IS '企业租户ID'
;
INSERT INTO em_sys_redpacket_setting VALUES ('1',0,NULL,NULL,NULL,1,'1',sysdate,NULL,NULL,'1')
;
CREATE TABLE em_sys_remote_setting (
  id varchar(32) NOT NULL PRIMARY KEY,
  enabled NUMBER(4,0) DEFAULT NULL,
  sever_type NUMBER(4,0) DEFAULT NULL,
  app_id varchar(100) DEFAULT NULL,
  app_key varchar(100) DEFAULT NULL,
  phsrc varchar(100) DEFAULT NULL,
  sha1 varchar(100) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_remote_setting IS '远程协助服务设置信息'
;
COMMENT ON COLUMN em_sys_remote_setting.enabled IS '是否开启远程协助服务：0-禁用、1-开启'
;
COMMENT ON COLUMN em_sys_remote_setting.sever_type IS '服务器类型：1-公有 2-私有'
;
COMMENT ON COLUMN em_sys_remote_setting.app_id IS '接入的appid'
;
COMMENT ON COLUMN em_sys_remote_setting.app_key IS '接入的appkey'
;
COMMENT ON COLUMN em_sys_remote_setting.phsrc IS '连接私有服务器PHSRC值'
;
COMMENT ON COLUMN em_sys_remote_setting.sha1 IS '连接私有服务器的sha1值'
;
COMMENT ON COLUMN em_sys_remote_setting.status IS '状态'
;
COMMENT ON COLUMN em_sys_remote_setting.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_remote_setting.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_remote_setting.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_remote_setting.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_remote_setting.tenant_id IS '企业租户ID'
;
INSERT INTO em_sys_remote_setting VALUES ('1',0,NULL,NULL,NULL,NULL,NULL,1,'1',sysdate,NULL,NULL,'1')
;
CREATE TABLE em_sys_security_setting (
  id varchar(32) NOT NULL PRIMARY KEY,
  enable_login_captcha NUMBER(4,0) DEFAULT NULL,
  enable_register_captcha NUMBER(4,0) DEFAULT NULL,
  maximum_login_attempts NUMBER(11,0) DEFAULT NULL,
  minimum_password_length NUMBER(11,0) DEFAULT NULL,
  enable_special_password NUMBER(4,0) DEFAULT NULL,
  enable_access_restrictions NUMBER(4,0) DEFAULT NULL,
  ip_whitelists CLOB,
  status NUMBER(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_security_setting IS '系统安全设置'
;
COMMENT ON COLUMN em_sys_security_setting.enable_login_captcha IS '是否启动登录图片验证码：0-禁用、1-启用'
;
COMMENT ON COLUMN em_sys_security_setting.enable_register_captcha IS '是否启动注册图片验证码：0-禁用、1-启用'
;
COMMENT ON COLUMN em_sys_security_setting.maximum_login_attempts IS '登录操作最大尝试次数'
;
COMMENT ON COLUMN em_sys_security_setting.minimum_password_length IS '最小密码长度'
;
COMMENT ON COLUMN em_sys_security_setting.enable_special_password IS '是否必须大小写及特殊字符'
;
COMMENT ON COLUMN em_sys_security_setting.enable_access_restrictions IS '是否启用后台访问限制：0-禁用、1-启用'
;
COMMENT ON COLUMN em_sys_security_setting.ip_whitelists IS 'IP白名单'
;
COMMENT ON COLUMN em_sys_security_setting.status IS '状态'
;
COMMENT ON COLUMN em_sys_security_setting.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_security_setting.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_security_setting.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_security_setting.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_security_setting.tenant_id IS '企业租户ID'
;
INSERT INTO em_sys_security_setting VALUES ('1730822406126507349', 1, 1, 10, 8, 1, 0, NULL, 1,'1',sysdate,NULL,NULL,'1')
;
CREATE TABLE em_sys_sqlfile (
  id NUMBER(11,0) NOT NULL PRIMARY KEY,
  sqlfilename varchar(200) DEFAULT NULL,
  rundate varchar(10) DEFAULT NULL,
  runtime varchar(8) DEFAULT NULL,
  tenantid varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_sqlfile IS 'sql文件执行记录表'
;
COMMENT ON COLUMN em_sys_sqlfile.sqlfilename IS '文件名称'
;
COMMENT ON COLUMN em_sys_sqlfile.rundate IS '执行日期'
;
COMMENT ON COLUMN em_sys_sqlfile.runtime IS '执行时间'
;
COMMENT ON COLUMN em_sys_sqlfile.tenantid IS '租户id'
;
CREATE SEQUENCE em_sys_sqlfile_seq start with 0 increment by 1 minvalue 0
;
CREATE TABLE em_sys_task (
  id varchar(32) NOT NULL PRIMARY KEY,
  enabled NUMBER(4,0) DEFAULT NULL,
  class_name varchar(255) DEFAULT NULL,
  start_time TIMESTAMP DEFAULT NULL,
  end_time TIMESTAMP DEFAULT NULL,
  last_execute_time TIMESTAMP DEFAULT NULL,
  cycle NUMBER(20,0) DEFAULT NULL,
  description varchar(255) DEFAULT NULL,
  is_executing NUMBER(4,0) DEFAULT NULL,
  execute_result NUMBER(4,0) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_task IS '系统任务表'
;
COMMENT ON COLUMN em_sys_task.id IS '主键'
;
COMMENT ON COLUMN em_sys_task.enabled IS '是否启动：1-启用、0-停用'
;
COMMENT ON COLUMN em_sys_task.class_name IS '任务的JAVA类'
;
COMMENT ON COLUMN em_sys_task.start_time IS '任务开始时间'
;
COMMENT ON COLUMN em_sys_task.end_time IS '任务结束时间'
;
COMMENT ON COLUMN em_sys_task.last_execute_time IS '最后执行时间'
;
COMMENT ON COLUMN em_sys_task.cycle IS '执行周期（单位：毫秒）'
;
COMMENT ON COLUMN em_sys_task.description IS '任务描述'
;
COMMENT ON COLUMN em_sys_task.is_executing IS '任务是否执行中：0-非执行中、1-执行中'
;
COMMENT ON COLUMN em_sys_task.execute_result IS '任务执行结果：0-跳过执行、1-正常执行'
;
COMMENT ON COLUMN em_sys_task.status IS '状态 1-正常，2-禁用，3-删除'
;
COMMENT ON COLUMN em_sys_task.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_task.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_task.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_task.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_task.tenant_id IS '企业租户ID'
;
INSERT INTO em_sys_task VALUES ('1a3c23db138c44ddb617b9133c852312',1,'com.weaver.emobile.module.sys.scheduling.ServerIdSyncTask',to_date('2017-11-10 02:00:00','yyyy-mm-dd hh24:mi:ss'),NULL,NULL,86400000,'将基础用户数据和消息服务器人员关联同步起来',NULL,NULL,1,'1',sysdate,NULL,NULL,'1')
;
INSERT INTO em_sys_task VALUES ('2gae5e2ffa6a40458441674798c16f5e',1,'com.weaver.emobile.module.msg.scheduling.TimingMsgSendTask',to_date('2018-08-29 14:30:00','yyyy-mm-dd hh24:mi:ss'),NULL,NULL,60000,'定时消息发送定时任务，包含必达定时和应用消息定时任务',NULL,NULL,1,'1',sysdate,NULL,NULL,'1')
;
INSERT INTO em_sys_task VALUES ('53b624001a8c40a8a45bed2e68d8095b',1,'com.weaver.emobile.module.sys.scheduling.SysNoticePushTask',to_date('2018-10-29 03:30:00','yyyy-mm-dd hh24:mi:ss'),NULL,NULL,86400000,'系统消息推送任务',NULL,NULL,1,'1',sysdate,NULL,NULL,'1')
;
INSERT INTO em_sys_task VALUES ('69f1063cecae11e8ab1b005056c00008',1,'com.weaver.emobile.module.sys.scheduling.CacheDirectoryCleanJob',to_date('2018-11-21 03:00:00','yyyy-mm-dd hh24:mi:ss'),NULL,NULL,86400000,'清理从ecology那边下载下来的超过30天的临时文件',NULL,NULL,1,'1',sysdate,NULL,NULL,'1')
;
INSERT INTO em_sys_task VALUES ('c561aa9aecb311e8ab1b005056c00008',1,'com.weaver.emobile.module.log.job.LogCleanJob',to_date('2018-11-21 03:00:00','yyyy-mm-dd hh24:mi:ss'),NULL,NULL,86400000,'清理em_log_operation表里面60天以前的数据',NULL,NULL,1,'1',sysdate,NULL,NULL,'1')
;
CREATE TABLE em_sys_tenant (
  id varchar(32) NOT NULL PRIMARY KEY,
  corp_id varchar(50) DEFAULT NULL,
  tenant_name varchar(50) DEFAULT NULL,
  logo varchar(255) DEFAULT NULL,
  maxuser NUMBER(11,0) DEFAULT NULL,
  province_id varchar(32) DEFAULT NULL,
  city_id varchar(32) DEFAULT NULL,
  trade_cate_id varchar(32) DEFAULT NULL,
  trade_type_id varchar(32) DEFAULT NULL,
  contact_name varchar(100) DEFAULT NULL,
  contact_email varchar(100) DEFAULT NULL,
  contact_address varchar(100) DEFAULT NULL,
  contact_telephone varchar(32) DEFAULT NULL,
  domain_url varchar(100) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_tenant IS '企业租户表'
;
COMMENT ON COLUMN em_sys_tenant.id IS '主键ID'
;
COMMENT ON COLUMN em_sys_tenant.corp_id IS '企业CorpId'
;
COMMENT ON COLUMN em_sys_tenant.tenant_name IS '名称'
;
COMMENT ON COLUMN em_sys_tenant.logo IS '图标'
;
COMMENT ON COLUMN em_sys_tenant.maxuser IS '最大用户数'
;
COMMENT ON COLUMN em_sys_tenant.province_id IS '省份ID'
;
COMMENT ON COLUMN em_sys_tenant.city_id IS '城市ID'
;
COMMENT ON COLUMN em_sys_tenant.trade_cate_id IS '行业种类ID'
;
COMMENT ON COLUMN em_sys_tenant.trade_type_id IS '行业类型ID'
;
COMMENT ON COLUMN em_sys_tenant.contact_name IS '联系人姓名'
;
COMMENT ON COLUMN em_sys_tenant.contact_email IS '联系邮箱'
;
COMMENT ON COLUMN em_sys_tenant.contact_address IS '详细地址'
;
COMMENT ON COLUMN em_sys_tenant.contact_telephone IS '联系电话'
;
COMMENT ON COLUMN em_sys_tenant.domain_url IS '绑定域名地址'
;
COMMENT ON COLUMN em_sys_tenant.status IS '状态: 1-正常，2-禁用，3-删除'
;
COMMENT ON COLUMN em_sys_tenant.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_tenant.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_tenant.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_tenant.update_time IS '修改时间'
;
INSERT INTO em_sys_tenant VALUES ('1',CONCAT('t' ,REPLACE(sys_guid(),'-','')),'默认企业',NULL,-1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'1',sysdate,NULL,NULL)
;
CREATE TABLE em_sys_tenant_admin (
  id varchar(32) NOT NULL PRIMARY KEY,
  base_user_id varchar(32) DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL,
  admin_type NUMBER(4,0) DEFAULT NULL,
  agent_base_id varchar(32) DEFAULT NULL,
  admin_password varchar(100) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_tenant_admin IS '基础用户租户管理关联表'
;
COMMENT ON COLUMN em_sys_tenant_admin.id IS '主键ID'
;
COMMENT ON COLUMN em_sys_tenant_admin.base_user_id IS '基础用户ID'
;
COMMENT ON COLUMN em_sys_tenant_admin.tenant_id IS '企业租户ID'
;
COMMENT ON COLUMN em_sys_tenant_admin.admin_type IS '管理员类型：1-创建人，2-超级管理员，3-分级管理员，4-外部管理员，5-应用管理员，6-接口管理员'
;
COMMENT ON COLUMN em_sys_tenant_admin.agent_base_id IS '应用管理对应的应用ID'
;
COMMENT ON COLUMN em_sys_tenant_admin.admin_password IS '管理密码'
;
COMMENT ON COLUMN em_sys_tenant_admin.status IS '状态：1-正常，3-删除'
;
COMMENT ON COLUMN em_sys_tenant_admin.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_tenant_admin.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_tenant_admin.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_tenant_admin.update_time IS '修改时间'
;
CREATE INDEX em_sys_tenant_admin_bui_idx ON em_sys_tenant_admin(base_user_id)
;
CREATE INDEX em_sys_tenant_admin_abi_idx ON em_sys_tenant_admin(agent_base_id)
;
CREATE INDEX em_sys_tenant_admin_ti_idx ON em_sys_tenant_admin(tenant_id)
;
INSERT INTO em_sys_tenant_admin VALUES ('1','1','1',1,NULL,NULL,1,'1',sysdate,NULL,NULL)
;
CREATE TABLE em_sys_upgrade_record (
  id NUMBER(11,0) NOT NULL PRIMARY KEY,
  version varchar(255) DEFAULT NULL,
  script CLOB,
  begin_time TIMESTAMP DEFAULT NULL,
  end_time TIMESTAMP DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_upgrade_record IS '数据库升级记录表'
;
COMMENT ON COLUMN em_sys_upgrade_record.id IS '主键'
;
COMMENT ON COLUMN em_sys_upgrade_record.version IS '版本'
;
COMMENT ON COLUMN em_sys_upgrade_record.script IS '本次升级执行的脚本'
;
COMMENT ON COLUMN em_sys_upgrade_record.begin_time IS '开始时间'
;
COMMENT ON COLUMN em_sys_upgrade_record.end_time IS '结束时间'
;
CREATE SEQUENCE em_sys_upgrade_record_seq start with 0 increment by 1 minvalue 0
;
CREATE TABLE em_sys_verify_token (
  verify_token varchar(100) NOT NULL PRIMARY KEY,
  expire_time TIMESTAMP DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_verify_token IS '外部系统访问验证token数据表'
;
COMMENT ON COLUMN em_sys_verify_token.verify_token IS '验证的token值'
;
COMMENT ON COLUMN em_sys_verify_token.expire_time IS '过期时间'
;
COMMENT ON COLUMN em_sys_verify_token.status IS '状态 1-正常，2-无效，3-删除'
;
COMMENT ON COLUMN em_sys_verify_token.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_verify_token.tenant_id IS '企业租户ID'
;
CREATE TABLE em_sys_video_setting (
  id varchar(32) NOT NULL PRIMARY KEY,
  enabled NUMBER(4,0) DEFAULT NULL,
  app_id varchar(100) DEFAULT NULL,
  app_certificate varchar(100) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_video_setting IS '音视频设置信息'
;
COMMENT ON COLUMN em_sys_video_setting.enabled IS '是否开启消息服务：0-禁用、1-开启'
;
COMMENT ON COLUMN em_sys_video_setting.app_id IS '接入的appId'
;
COMMENT ON COLUMN em_sys_video_setting.app_certificate IS '接入的appCertificate'
;
COMMENT ON COLUMN em_sys_video_setting.status IS '状态'
;
COMMENT ON COLUMN em_sys_video_setting.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_video_setting.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_video_setting.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_video_setting.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_video_setting.tenant_id IS '企业租户ID'
;
INSERT INTO em_sys_video_setting VALUES ('1',0,NULL,NULL,1,'1',sysdate,NULL,NULL,'1')
;
CREATE TABLE em_sys_work_cond (
  id NUMBER(11,0) NOT NULL PRIMARY KEY,
  work_cond_icon varchar(50) DEFAULT NULL,
  work_cond_txt varchar(50) DEFAULT NULL,
  base_user_id varchar(50) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_work_cond IS '基础用户工作状态默认数据表'
;
COMMENT ON COLUMN em_sys_work_cond.work_cond_icon IS '工作状态图标'
;
COMMENT ON COLUMN em_sys_work_cond.work_cond_txt IS '工作状态内容'
;
COMMENT ON COLUMN em_sys_work_cond.base_user_id IS '基础用户id'
;
CREATE SEQUENCE em_sys_work_cond_seq start with 0 increment by 1 minvalue 0
;
INSERT INTO em_sys_work_cond VALUES (em_sys_work_cond_seq.nextval,'/common/images/workcond/leave.png','离开',NULL)
;
INSERT INTO em_sys_work_cond VALUES (em_sys_work_cond_seq.nextval,'/common/images/workcond/busy.png','忙碌',NULL)
;
INSERT INTO em_sys_work_cond VALUES (em_sys_work_cond_seq.nextval,'/common/images/workcond/ill.png','生病中',NULL)
;
INSERT INTO em_sys_work_cond VALUES (em_sys_work_cond_seq.nextval,'/common/images/workcond/evection.png','出差中',NULL)
;
INSERT INTO em_sys_work_cond VALUES (em_sys_work_cond_seq.nextval,'/common/images/workcond/meeting.png','会议中',NULL)
;
INSERT INTO em_sys_work_cond VALUES (em_sys_work_cond_seq.nextval,'/common/images/workcond/vacation.png','休假中',NULL)
;
CREATE TABLE em_video_chat_base (
  id varchar(32) NOT NULL PRIMARY KEY,
  chat_name varchar(100) DEFAULT NULL,
  chat_uid varchar(100) DEFAULT NULL,
  chat_type NUMBER(4,0) DEFAULT NULL,
  chat_member_count NUMBER(11,0) DEFAULT NULL,
  chat_member_ids CLOB,
  last_call_sender_id varchar(32) DEFAULT NULL,
  last_call_type NUMBER(4,0) DEFAULT NULL,
  last_call_time NUMBER(20,0) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_video_chat_base IS '音视频会话基本信息表'
;
COMMENT ON COLUMN em_video_chat_base.id IS '主键ID'
;
COMMENT ON COLUMN em_video_chat_base.chat_name IS '会话名称'
;
COMMENT ON COLUMN em_video_chat_base.chat_uid IS '会话标识，相同参与人的会话标识相同，即为同一个会话'
;
COMMENT ON COLUMN em_video_chat_base.chat_type IS '会话类型：1-点对点，2-会议'
;
COMMENT ON COLUMN em_video_chat_base.chat_member_count IS '会话所有成员数'
;
COMMENT ON COLUMN em_video_chat_base.chat_member_ids IS '会话所有成员ID逗号分隔'
;
COMMENT ON COLUMN em_video_chat_base.last_call_sender_id IS '最后一次的通话发起人ID，对应em_sys_base_user表的主键'
;
COMMENT ON COLUMN em_video_chat_base.last_call_type IS '最后一次的通话类型 1-音频 2-视频 3-sip电话 4-普通电话'
;
COMMENT ON COLUMN em_video_chat_base.last_call_time IS '最后一次的通话时间'
;
COMMENT ON COLUMN em_video_chat_base.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_video_chat_base.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_video_chat_base.create_time IS '创建时间'
;
COMMENT ON COLUMN em_video_chat_base.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_video_chat_base.update_time IS '修改时间'
;
COMMENT ON COLUMN em_video_chat_base.tenant_id IS '企业租户ID'
;
CREATE INDEX em_video_chat_base_cu_idx ON em_video_chat_base(chat_uid)
;
CREATE TABLE em_video_chat_call (
  id varchar(32) NOT NULL PRIMARY KEY,
  chat_base_id varchar(32) DEFAULT NULL,
  chat_type NUMBER(4,0) DEFAULT NULL,
  call_sender_id varchar(32) DEFAULT NULL,
  call_type NUMBER(4,0) DEFAULT NULL,
  call_status NUMBER(4,0) DEFAULT NULL,
  call_time NUMBER(20,0) DEFAULT NULL,
  call_duration NUMBER(11,0) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_video_chat_call IS '音视频会话通话记录表'
;
COMMENT ON COLUMN em_video_chat_call.id IS '主键ID'
;
COMMENT ON COLUMN em_video_chat_call.chat_base_id IS '会话基本信息表ID'
;
COMMENT ON COLUMN em_video_chat_call.chat_type IS '会话类型：1-点对点，2-会议'
;
COMMENT ON COLUMN em_video_chat_call.call_sender_id IS '通话发起人ID，对应em_sys_base_user表的主键'
;
COMMENT ON COLUMN em_video_chat_call.call_type IS '通话类型 1-音频 2-视频 3-sip电话 4-普通电话'
;
COMMENT ON COLUMN em_video_chat_call.call_status IS '通话状态：1-进行中，2-结束'
;
COMMENT ON COLUMN em_video_chat_call.call_time IS '通话时间'
;
COMMENT ON COLUMN em_video_chat_call.call_duration IS '通话时长，单位为秒'
;
COMMENT ON COLUMN em_video_chat_call.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_video_chat_call.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_video_chat_call.create_time IS '创建时间'
;
COMMENT ON COLUMN em_video_chat_call.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_video_chat_call.update_time IS '修改时间'
;
COMMENT ON COLUMN em_video_chat_call.tenant_id IS '企业租户ID'
;
CREATE INDEX em_video_chat_call_cbi_idx ON em_video_chat_call(chat_base_id)
;
CREATE INDEX em_video_chat_call_csi_idx ON em_video_chat_call(call_sender_id)
;
CREATE TABLE em_video_chat_call_attend (
  id varchar(32) NOT NULL PRIMARY KEY,
  chat_call_id varchar(32) DEFAULT NULL,
  attend_member_id varchar(32) DEFAULT NULL,
  attend_type NUMBER(4,0) DEFAULT NULL,
  attend_target_ids CLOB,
  attend_time NUMBER(20,0) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_video_chat_call_attend IS '音视频会话通话记录参与明细表'
;
COMMENT ON COLUMN em_video_chat_call_attend.id IS '主键ID'
;
COMMENT ON COLUMN em_video_chat_call_attend.chat_call_id IS '会话通话记录表ID'
;
COMMENT ON COLUMN em_video_chat_call_attend.attend_member_id IS '通话参与人ID，对应em_sys_base_user表的主键'
;
COMMENT ON COLUMN em_video_chat_call_attend.attend_type IS '参与类型 1-发起，2-加入，3-退出，4-踢出'
;
COMMENT ON COLUMN em_video_chat_call_attend.attend_target_ids IS '会话记录目标成员ID逗号分隔'
;
COMMENT ON COLUMN em_video_chat_call_attend.attend_time IS '参与时间'
;
COMMENT ON COLUMN em_video_chat_call_attend.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_video_chat_call_attend.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_video_chat_call_attend.create_time IS '创建时间'
;
COMMENT ON COLUMN em_video_chat_call_attend.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_video_chat_call_attend.update_time IS '修改时间'
;
COMMENT ON COLUMN em_video_chat_call_attend.tenant_id IS '企业租户ID'
;
CREATE INDEX em_video_c_c_a_cci_idx ON em_video_chat_call_attend(chat_call_id)
;
CREATE INDEX em_video_c_c_a_ami_idx ON em_video_chat_call_attend(attend_member_id)
;
CREATE TABLE em_video_chat_mine (
  id varchar(32) NOT NULL PRIMARY KEY,
  chat_member_id varchar(32) DEFAULT NULL,
  chat_base_id varchar(32) DEFAULT NULL,
  chat_target_id varchar(32) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT '1',
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_video_chat_mine IS '音视频会话成员会话列表信息表'
;
COMMENT ON COLUMN em_video_chat_mine.id IS '主键ID'
;
COMMENT ON COLUMN em_video_chat_mine.chat_member_id IS '会话成员ID，对应em_sys_base_user表的主键'
;
COMMENT ON COLUMN em_video_chat_mine.chat_base_id IS '会话基本信息表ID'
;
COMMENT ON COLUMN em_video_chat_mine.chat_target_id IS '点对点类型会话目标人员ID'
;
COMMENT ON COLUMN em_video_chat_mine.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_video_chat_mine.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_video_chat_mine.create_time IS '创建时间'
;
COMMENT ON COLUMN em_video_chat_mine.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_video_chat_mine.update_time IS '修改时间'
;
COMMENT ON COLUMN em_video_chat_mine.tenant_id IS '企业租户ID'
;
CREATE INDEX em_video_chat_mine_cmi_idx ON em_video_chat_mine(chat_member_id)
;
CREATE INDEX em_video_chat_mine_cbi_idx ON em_video_chat_mine(chat_base_id)
;
CREATE TABLE qrtz_job_details
  (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    JOB_NAME  VARCHAR2(200) NOT NULL,
    JOB_GROUP VARCHAR2(200) NOT NULL,
    DESCRIPTION VARCHAR2(250) NULL,
    JOB_CLASS_NAME   VARCHAR2(250) NOT NULL, 
    IS_DURABLE VARCHAR2(8) NOT NULL,
    IS_NONCONCURRENT VARCHAR2(8) NOT NULL,
    IS_UPDATE_DATA VARCHAR2(8) NOT NULL,
    REQUESTS_RECOVERY VARCHAR2(8) NOT NULL,
    JOB_DATA BLOB NULL,
    CONSTRAINT QRTZ_JOB_DETAILS_PK PRIMARY KEY (SCHED_NAME,JOB_NAME,JOB_GROUP)
)
;
CREATE TABLE qrtz_triggers
  (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    TRIGGER_NAME VARCHAR2(200) NOT NULL,
    TRIGGER_GROUP VARCHAR2(200) NOT NULL,
    JOB_NAME  VARCHAR2(200) NOT NULL, 
    JOB_GROUP VARCHAR2(200) NOT NULL,
    DESCRIPTION VARCHAR2(250) NULL,
    NEXT_FIRE_TIME NUMBER(13) NULL,
    PREV_FIRE_TIME NUMBER(13) NULL,
    PRIORITY NUMBER(13) NULL,
    TRIGGER_STATE VARCHAR2(16) NOT NULL,
    TRIGGER_TYPE VARCHAR2(8) NOT NULL,
    START_TIME NUMBER(13) NOT NULL,
    END_TIME NUMBER(13) NULL,
    CALENDAR_NAME VARCHAR2(200) NULL,
    MISFIRE_INSTR NUMBER(2) NULL,
    JOB_DATA BLOB NULL,
    CONSTRAINT QRTZ_TRIGGERS_PK PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP),
    CONSTRAINT QRTZ_TRIGGER_TO_JOBS_FK FOREIGN KEY (SCHED_NAME,JOB_NAME,JOB_GROUP) 
      REFERENCES QRTZ_JOB_DETAILS(SCHED_NAME,JOB_NAME,JOB_GROUP) 
)
;
CREATE TABLE qrtz_simple_triggers
  (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    TRIGGER_NAME VARCHAR2(200) NOT NULL,
    TRIGGER_GROUP VARCHAR2(200) NOT NULL,
    REPEAT_COUNT NUMBER(7) NOT NULL,
    REPEAT_INTERVAL NUMBER(12) NOT NULL,
    TIMES_TRIGGERED NUMBER(10) NOT NULL,
    CONSTRAINT QRTZ_SIMPLE_TRIG_PK PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP),
    CONSTRAINT QRTZ_SIMPLE_TRIG_TO_TRIG_FK FOREIGN KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP) 
	REFERENCES QRTZ_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
)
;
CREATE TABLE qrtz_cron_triggers
  (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    TRIGGER_NAME VARCHAR2(200) NOT NULL,
    TRIGGER_GROUP VARCHAR2(200) NOT NULL,
    CRON_EXPRESSION VARCHAR2(120) NOT NULL,
    TIME_ZONE_ID VARCHAR2(80),
    CONSTRAINT QRTZ_CRON_TRIG_PK PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP),
    CONSTRAINT QRTZ_CRON_TRIG_TO_TRIG_FK FOREIGN KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP) 
      REFERENCES QRTZ_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
)
;
CREATE TABLE qrtz_simprop_triggers
  (          
    SCHED_NAME VARCHAR2(120) NOT NULL,
    TRIGGER_NAME VARCHAR2(200) NOT NULL,
    TRIGGER_GROUP VARCHAR2(200) NOT NULL,
    STR_PROP_1 VARCHAR2(512) NULL,
    STR_PROP_2 VARCHAR2(512) NULL,
    STR_PROP_3 VARCHAR2(512) NULL,
    INT_PROP_1 NUMBER(10) NULL,
    INT_PROP_2 NUMBER(10) NULL,
    LONG_PROP_1 NUMBER(13) NULL,
    LONG_PROP_2 NUMBER(13) NULL,
    DEC_PROP_1 NUMERIC(13,4) NULL,
    DEC_PROP_2 NUMERIC(13,4) NULL,
    BOOL_PROP_1 VARCHAR2(1) NULL,
    BOOL_PROP_2 VARCHAR2(1) NULL,
    CONSTRAINT QRTZ_SIMPROP_TRIG_PK PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP),
    CONSTRAINT QRTZ_SIMPROP_TRIG_TO_TRIG_FK FOREIGN KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP) 
      REFERENCES QRTZ_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
)
;
CREATE TABLE qrtz_blob_triggers
  (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    TRIGGER_NAME VARCHAR2(200) NOT NULL,
    TRIGGER_GROUP VARCHAR2(200) NOT NULL,
    BLOB_DATA BLOB NULL,
    CONSTRAINT QRTZ_BLOB_TRIG_PK PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP),
    CONSTRAINT QRTZ_BLOB_TRIG_TO_TRIG_FK FOREIGN KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP) 
        REFERENCES QRTZ_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
)
;
CREATE TABLE qrtz_calendars
  (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    CALENDAR_NAME  VARCHAR2(200) NOT NULL, 
    CALENDAR BLOB NOT NULL,
    CONSTRAINT QRTZ_CALENDARS_PK PRIMARY KEY (SCHED_NAME,CALENDAR_NAME)
)
;
CREATE TABLE qrtz_paused_trigger_grps
  (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    TRIGGER_GROUP  VARCHAR2(200) NOT NULL, 
    CONSTRAINT QRTZ_PAUSED_TRIG_GRPS_PK PRIMARY KEY (SCHED_NAME,TRIGGER_GROUP)
)
;
CREATE TABLE qrtz_fired_triggers 
  (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    ENTRY_ID VARCHAR2(95) NOT NULL,
    TRIGGER_NAME VARCHAR2(200) NOT NULL,
    TRIGGER_GROUP VARCHAR2(200) NOT NULL,
    INSTANCE_NAME VARCHAR2(200) NOT NULL,
    FIRED_TIME NUMBER(13) NOT NULL,
    SCHED_TIME NUMBER(13) NOT NULL,
    PRIORITY NUMBER(13) NOT NULL,
    STATE VARCHAR2(16) NOT NULL,
    JOB_NAME VARCHAR2(200) NULL,
    JOB_GROUP VARCHAR2(200) NULL,
    IS_NONCONCURRENT VARCHAR2(1) NULL,
    REQUESTS_RECOVERY VARCHAR2(1) NULL,
    CONSTRAINT QRTZ_FIRED_TRIGGER_PK PRIMARY KEY (SCHED_NAME,ENTRY_ID)
)
;
CREATE TABLE qrtz_scheduler_state 
  (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    INSTANCE_NAME VARCHAR2(200) NOT NULL,
    LAST_CHECKIN_TIME NUMBER(13) NOT NULL,
    CHECKIN_INTERVAL NUMBER(13) NOT NULL,
    CONSTRAINT QRTZ_SCHEDULER_STATE_PK PRIMARY KEY (SCHED_NAME,INSTANCE_NAME)
)
;
CREATE TABLE qrtz_locks
  (
    SCHED_NAME VARCHAR2(120) NOT NULL,
    LOCK_NAME  VARCHAR2(40) NOT NULL, 
    CONSTRAINT QRTZ_LOCKS_PK PRIMARY KEY (SCHED_NAME,LOCK_NAME)
)
;

create index idx_qrtz_j_req_recovery on qrtz_job_details(SCHED_NAME,REQUESTS_RECOVERY)
;
create index idx_qrtz_j_grp on qrtz_job_details(SCHED_NAME,JOB_GROUP)
;
create index idx_qrtz_t_jg on qrtz_triggers(SCHED_NAME,JOB_GROUP)
;
create index idx_qrtz_t_c on qrtz_triggers(SCHED_NAME,CALENDAR_NAME)
;
create index idx_qrtz_t_g on qrtz_triggers(SCHED_NAME,TRIGGER_GROUP)
;
create index idx_qrtz_t_state on qrtz_triggers(SCHED_NAME,TRIGGER_STATE)
;
create index idx_qrtz_t_n_state on qrtz_triggers(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP,TRIGGER_STATE)
;
create index idx_qrtz_t_n_g_state on qrtz_triggers(SCHED_NAME,TRIGGER_GROUP,TRIGGER_STATE)
;
create index idx_qrtz_t_next_fire_time on qrtz_triggers(SCHED_NAME,NEXT_FIRE_TIME)
;
create index idx_qrtz_t_nft_st on qrtz_triggers(SCHED_NAME,TRIGGER_STATE,NEXT_FIRE_TIME)
;
create index idx_qrtz_t_nft_misfire on qrtz_triggers(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME)
;
create index idx_qrtz_t_nft_st_misfire on qrtz_triggers(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME,TRIGGER_STATE)
;
create index idx_qrtz_t_nft_st_misfire_grp on qrtz_triggers(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME,TRIGGER_GROUP,TRIGGER_STATE)
;

create index idx_qrtz_ft_trig_inst_name on qrtz_fired_triggers(SCHED_NAME,INSTANCE_NAME)
;
create index idx_qrtz_ft_inst_job_req_rcvry on qrtz_fired_triggers(SCHED_NAME,INSTANCE_NAME,REQUESTS_RECOVERY)
;
create index idx_qrtz_ft_j_g on qrtz_fired_triggers(SCHED_NAME,JOB_NAME,JOB_GROUP)
;
create index idx_qrtz_ft_jg on qrtz_fired_triggers(SCHED_NAME,JOB_GROUP)
;
create index idx_qrtz_ft_t_g on qrtz_fired_triggers(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
;
create index idx_qrtz_ft_tg on qrtz_fired_triggers(SCHED_NAME,TRIGGER_GROUP)
;


CREATE TABLE SPRING_SESSION (
	PRIMARY_ID CHAR(36) NOT NULL,
	SESSION_ID CHAR(36) NOT NULL,
	CREATION_TIME NUMBER(19,0) NOT NULL,
	LAST_ACCESS_TIME NUMBER(19,0) NOT NULL,
	MAX_INACTIVE_INTERVAL NUMBER(10,0) NOT NULL,
	EXPIRY_TIME NUMBER(19,0) NOT NULL,
	PRINCIPAL_NAME VARCHAR2(100),
	CONSTRAINT SPRING_SESSION_PK PRIMARY KEY (PRIMARY_ID)
)
;

CREATE UNIQUE INDEX SPRING_SESSION_IX1 ON SPRING_SESSION (SESSION_ID)
;
CREATE INDEX SPRING_SESSION_IX2 ON SPRING_SESSION (EXPIRY_TIME)
;
CREATE INDEX SPRING_SESSION_IX3 ON SPRING_SESSION (PRINCIPAL_NAME)
;

CREATE TABLE SPRING_SESSION_ATTRIBUTES (
	SESSION_PRIMARY_ID CHAR(36) NOT NULL,
	ATTRIBUTE_NAME VARCHAR2(200) NOT NULL,
	ATTRIBUTE_BYTES BLOB NOT NULL,
	CONSTRAINT SPRING_SESSION_ATTRIBUTES_PK PRIMARY KEY (SESSION_PRIMARY_ID, ATTRIBUTE_NAME),
	CONSTRAINT SPRING_SESSION_ATTRIBUTES_FK FOREIGN KEY (SESSION_PRIMARY_ID) REFERENCES SPRING_SESSION(PRIMARY_ID) ON DELETE CASCADE
)
;
