CREATE TABLE em_sys_lang_base (
  id varchar(32) PRIMARY KEY,
  lang_name varchar(100) DEFAULT NULL ,
  lang_tag varchar(100) DEFAULT NULL,
  isdefault number(4,0) DEFAULT NULL ,
  show_order number(10,2) DEFAULT NULL ,
  status number(4,0) DEFAULT NULL ,
  create_user_id varchar(32) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL ,
  update_user_id varchar(32) DEFAULT NULL ,
  update_time TIMESTAMP DEFAULT NULL ,
  tenant_id varchar(32) DEFAULT NULL
) 
;
COMMENT ON TABLE em_sys_lang_base IS '系统多语言设置'
;
COMMENT ON COLUMN em_sys_lang_base.lang_name 	 IS '语言名称'
;
COMMENT ON COLUMN em_sys_lang_base.lang_tag  	 IS '语言标识：zh_CN-汉语(简体)，zh_TW-汉语(繁体)，en-英语，ja-日语，ko-韩语，vi-越南语'
;
COMMENT ON COLUMN em_sys_lang_base.isdefault      IS '是否默认：1-是、0-否'
;
COMMENT ON COLUMN em_sys_lang_base.show_order     IS '显示顺序'
;
COMMENT ON COLUMN em_sys_lang_base.status         IS '状态：1-正常、3-删除'
;
COMMENT ON COLUMN em_sys_lang_base.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_lang_base.create_time    IS '创建时间'
;
COMMENT ON COLUMN em_sys_lang_base.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_lang_base.update_time    IS '修改时间'
;
COMMENT ON COLUMN em_sys_lang_base.tenant_id      IS '企业租户ID'
;


INSERT INTO em_sys_lang_base VALUES ('1', '简体中文', 'zh_CN', 1, 1, 1, '1', sysdate, null, null, '1')
;
INSERT INTO em_sys_lang_base VALUES ('2', '繁體中文', 'zh_TW', 0, 2, 1, '1', sysdate, null, null, '1')
;
INSERT INTO em_sys_lang_base VALUES ('3', 'English', 'en', 0, 3, 1, '1', sysdate, null, null, '1')
;


CREATE TABLE em_sys_lang_clientset (
  id varchar(32) NOT NULL  PRIMARY KEY ,
  client_type number(4,0) DEFAULT NULL,
  lang_tag varchar(10) DEFAULT NULL,
  set_name varchar(100) DEFAULT NULL,
  set_value varchar(200) DEFAULT NULL,
  status number(4,0) DEFAULT NULL ,
  create_user_id varchar(32) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_lang_clientset IS '客户端多语言设置'
;
COMMENT ON COLUMN em_sys_lang_clientset.client_type 	 IS '客户端类型 1-移动APP，2-PC端'
;
COMMENT ON COLUMN em_sys_lang_clientset.lang_tag  	 IS '语言标识：zh_CN-汉语(简体)，zh_TW-汉语(繁体)，en-英语，ja-日语，ko-韩语，vi-越南语'
;
COMMENT ON COLUMN em_sys_lang_clientset.set_name      IS '设置项名称'
;
COMMENT ON COLUMN em_sys_lang_clientset.set_value     IS '设置项内容'
;
COMMENT ON COLUMN em_sys_lang_clientset.status        IS '状态：1-正常、3-删除'
;
COMMENT ON COLUMN em_sys_lang_clientset.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_lang_clientset.create_time    IS '创建时间'
;
COMMENT ON COLUMN em_sys_lang_clientset.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_lang_clientset.update_time    IS '修改时间'
;
COMMENT ON COLUMN em_sys_lang_clientset.tenant_id      IS '企业租户ID'
;