
CREATE TABLE em_cp_user_sync_cond (
  id varchar(32) NOT NULL PRIMARY KEY,
  outsys_id varchar(32) DEFAULT NULL,
  cond_type number(4,0) DEFAULT NULL,
  auth_type number(4,0) DEFAULT NULL,
  auth_type_name varchar(32) DEFAULT NULL,
  auth_value varchar(32) DEFAULT NULL,
  auth_value_name varchar(32) DEFAULT NULL,
  auth_seclevel varchar(32) DEFAULT NULL,
  auth_seclevel_max varchar(32) DEFAULT NULL,
  showorder int DEFAULT NULL,
  status number(4,0) DEFAULT 1 ,
  create_user_id varchar(32) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL ,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_user_sync_cond IS '企业号通讯录成员与集成系统人员同步条件表'
;
COMMENT ON COLUMN em_cp_user_sync_cond.id  IS '主键ID'
;
COMMENT ON COLUMN em_cp_user_sync_cond.outsys_id  IS '集成系统ID'
;
COMMENT ON COLUMN em_cp_user_sync_cond.cond_type  IS '条件类型：1-人员，2-部门，3-分部'
;
COMMENT ON COLUMN em_cp_user_sync_cond.auth_type  IS '规则类型：0-人员，1-分部，2-部门，3-角色，4-所有人'
;
COMMENT ON COLUMN em_cp_user_sync_cond.auth_type_name  IS '规则类型显示名'
;
COMMENT ON COLUMN em_cp_user_sync_cond.auth_value  IS '规则类型值'
;
COMMENT ON COLUMN em_cp_user_sync_cond.auth_value_name  IS '规则类型值显示名'
;
COMMENT ON COLUMN em_cp_user_sync_cond.auth_seclevel  IS '规则安全级别最小值'
;
COMMENT ON COLUMN em_cp_user_sync_cond.auth_seclevel_max  IS '规则安全级别最大值'
;
COMMENT ON COLUMN em_cp_user_sync_cond.showorder  IS '显示顺序'
;
COMMENT ON COLUMN em_cp_user_sync_cond.status  IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_cp_user_sync_cond.create_user_id  IS '创建人'
;
COMMENT ON COLUMN em_cp_user_sync_cond.create_time  IS '创建时间'
;
COMMENT ON COLUMN em_cp_user_sync_cond.update_user_id  IS '修改人'
;
COMMENT ON COLUMN em_cp_user_sync_cond.update_time  IS '修改时间'
;
COMMENT ON COLUMN em_cp_user_sync_cond.tenant_id  IS '企业租户ID'
;

CREATE INDEX em_cp_user_sync_cond_oi_idx ON em_cp_user_sync_cond(outsys_id)
;