
CREATE TABLE em_sys_login_setting (
  id varchar(32) NOT NULL PRIMARY KEY ,
  welcome_bg_img varchar(32) DEFAULT NULL ,
  welcome_speech_txt varchar(100) DEFAULT NULL ,
  welcome_speech_color varchar(10) DEFAULT NULL ,
  login_logo varchar(32) DEFAULT NULL ,
  login_bg_color varchar(10) DEFAULT NULL ,
  login_bg_img varchar(32) DEFAULT NULL ,
  login_foot_txt varchar(100) DEFAULT NULL ,
  login_foot_color varchar(10) DEFAULT NULL ,
  custom_login_page varchar(200) DEFAULT NULL ,
  status number(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL ,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL 
) 
;
COMMENT ON TABLE em_sys_login_setting IS '系统登录前设置'
;
COMMENT ON COLUMN em_sys_login_setting.id  IS '主键ID'
;
COMMENT ON COLUMN em_sys_login_setting.welcome_bg_img  IS '欢迎页背景图片'
;
COMMENT ON COLUMN em_sys_login_setting.welcome_speech_txt  IS '欢迎词'
;
COMMENT ON COLUMN em_sys_login_setting.welcome_speech_color  IS '欢迎词字体颜色'
;
COMMENT ON COLUMN em_sys_login_setting.login_logo  IS '登录页LOGO'
;
COMMENT ON COLUMN em_sys_login_setting.login_bg_color  IS '登录页背景颜色'
;
COMMENT ON COLUMN em_sys_login_setting.login_bg_img  IS '登录页背景图片'
;
COMMENT ON COLUMN em_sys_login_setting.login_foot_txt  IS '登录页底部文字'
;
COMMENT ON COLUMN em_sys_login_setting.login_foot_color  IS '登录页底部文字颜色'
;
COMMENT ON COLUMN em_sys_login_setting.custom_login_page  IS '自定义登录页面地址'
;
COMMENT ON COLUMN em_sys_login_setting.status  IS '状态：1-正常、3-删除'
;
COMMENT ON COLUMN em_sys_login_setting.create_user_id  IS '创建人'
;
COMMENT ON COLUMN em_sys_login_setting.create_time  IS '创建时间'
;
COMMENT ON COLUMN em_sys_login_setting.update_user_id  IS '修改人'
;
COMMENT ON COLUMN em_sys_login_setting.update_time  IS '修改时间'
;
COMMENT ON COLUMN em_sys_login_setting.tenant_id  IS '企业租户ID'
;
INSERT INTO em_sys_login_setting VALUES ('1', '', '', '', '', '', '', '', '', '', 1, '1', sysdate, null, null, '1')
;
