CREATE TABLE em_ca_baseuser_cert  (
  id varchar(32) NOT NULL PRIMARY KEY,
  base_user_id varchar(32) ,
  device_id varchar(100) ,
  cert_id varchar(100) ,
  status number(4,0) DEFAULT NULL ,
  create_time timestamp DEFAULT NULL ,
  create_user_id varchar(32) DEFAULT NULL ,
  update_time timestamp DEFAULT NULL ,
  update_user_id varchar(32) DEFAULT NULL ,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_ca_baseuser_cert IS '用户CA证书信息记录表'
;
COMMENT ON COLUMN em_ca_baseuser_cert.id  IS '主键ID'
;
COMMENT ON COLUMN em_ca_baseuser_cert.base_user_id  IS '基础用户ID'
;
COMMENT ON COLUMN em_ca_baseuser_cert.device_id  IS '设备标识'
;
COMMENT ON COLUMN em_ca_baseuser_cert.cert_id  IS '证书标识'
;
COMMENT ON COLUMN em_ca_baseuser_cert.status  IS '状态：1-正常、3-删除'
;
COMMENT ON COLUMN em_ca_baseuser_cert.create_user_id  IS '创建人'
;
COMMENT ON COLUMN em_ca_baseuser_cert.create_time  IS '创建时间'
;
COMMENT ON COLUMN em_ca_baseuser_cert.update_user_id  IS '修改人'
;
COMMENT ON COLUMN em_ca_baseuser_cert.update_time  IS '修改时间'
;
COMMENT ON COLUMN em_ca_baseuser_cert.tenant_id  IS '企业租户ID'
;