CREATE TABLE em_cp_checkin_sync_set (
  id varchar(32) NOT NULL PRIMARY KEY,
  sync_name varchar(50) DEFAULT NULL,
  sys_task_id varchar(32) DEFAULT NULL,
  cp_corp_id varchar(32) DEFAULT NULL,
  data_starttime varchar(50) DEFAULT NULL,
  data_endtime varchar(50) DEFAULT NULL,
  outsys_id varchar(32) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
CREATE INDEX em_cp_checkin_sync_set_oi_idx ON em_cp_checkin_sync_set(outsys_id)
;
COMMENT ON TABLE em_cp_checkin_sync_set IS '企业号考勤打卡数据同步设置表'
;
COMMENT ON COLUMN em_cp_checkin_sync_set.id IS '主键ID'
;
COMMENT ON COLUMN em_cp_checkin_sync_set.sync_name IS '同步设置名称'
;
COMMENT ON COLUMN em_cp_checkin_sync_set.sys_task_id IS '定时同步任务ID'
;
COMMENT ON COLUMN em_cp_checkin_sync_set.cp_corp_id IS '企业号基本信息ID'
;
COMMENT ON COLUMN em_cp_checkin_sync_set.data_starttime IS '打卡数据开始时间'
;
COMMENT ON COLUMN em_cp_checkin_sync_set.data_endtime IS '打卡数据结束时间'
;
COMMENT ON COLUMN em_cp_checkin_sync_set.outsys_id IS '集成系统ID'
;
COMMENT ON COLUMN em_cp_checkin_sync_set.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_checkin_sync_set.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_checkin_sync_set.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_cp_checkin_sync_set.update_time IS '修改时间'
;
COMMENT ON COLUMN em_cp_checkin_sync_set.tenant_id IS '企业租户ID'
;

CREATE TABLE em_cp_checkin_sync_cond (
  id varchar(32) NOT NULL PRIMARY KEY,
  outsys_id varchar(32) DEFAULT NULL,
  cond_type number(4,0) DEFAULT NULL,
  auth_type number(4,0) DEFAULT NULL,
  auth_type_name varchar(32) DEFAULT NULL,
  auth_value varchar(32) DEFAULT NULL,
  auth_value_name varchar(32) DEFAULT NULL,
  auth_seclevel varchar(32) DEFAULT NULL,
  auth_seclevel_max varchar(32) DEFAULT NULL,
  showorder number(11,0) DEFAULT NULL,
  status number(4,0) DEFAULT 1,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
CREATE INDEX em_cp_checkin_sync_cond_oi_idx ON em_cp_checkin_sync_cond(outsys_id)
;
COMMENT ON TABLE em_cp_checkin_sync_cond IS '企业号考勤打卡数据同步条件表'
;
COMMENT ON COLUMN em_cp_checkin_sync_cond.id IS '主键ID'
;
COMMENT ON COLUMN em_cp_checkin_sync_cond.outsys_id IS '集成系统ID'
;
COMMENT ON COLUMN em_cp_checkin_sync_cond.cond_type IS '条件类型：1-人员，2-部门，3-分部'
;
COMMENT ON COLUMN em_cp_checkin_sync_cond.auth_type IS '规则类型：0-人员，1-分部，2-部门，3-角色，4-所有人'
;
COMMENT ON COLUMN em_cp_checkin_sync_cond.auth_type_name IS '规则类型显示名'
;
COMMENT ON COLUMN em_cp_checkin_sync_cond.auth_value IS '规则类型值'
;
COMMENT ON COLUMN em_cp_checkin_sync_cond.auth_value_name IS '规则类型值显示名'
;
COMMENT ON COLUMN em_cp_checkin_sync_cond.auth_seclevel IS '规则安全级别最小值'
;
COMMENT ON COLUMN em_cp_checkin_sync_cond.auth_seclevel_max IS '规则安全级别最大值'
;
COMMENT ON COLUMN em_cp_checkin_sync_cond.showorder IS '显示顺序'
;
COMMENT ON COLUMN em_cp_checkin_sync_cond.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_cp_checkin_sync_cond.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_checkin_sync_cond.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_checkin_sync_cond.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_cp_checkin_sync_cond.update_time IS '修改时间'
;
COMMENT ON COLUMN em_cp_checkin_sync_cond.tenant_id IS '企业租户ID'
;

CREATE TABLE em_cp_checkin_sync_state (
  id varchar(32) NOT NULL PRIMARY KEY,
  cp_corp_id varchar(32) DEFAULT NULL,
  sync_state number(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_checkin_sync_state IS '企业号考勤打卡数据同步状态表'
;
COMMENT ON COLUMN em_cp_checkin_sync_state.id IS '主键ID'
;
COMMENT ON COLUMN em_cp_checkin_sync_state.cp_corp_id IS '企业号基本信息ID'
;
COMMENT ON COLUMN em_cp_checkin_sync_state.sync_state IS '同步状态：1-未同步，2-同步中'
;
COMMENT ON COLUMN em_cp_checkin_sync_state.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_checkin_sync_state.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_checkin_sync_state.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_cp_checkin_sync_state.update_time IS '修改时间'
;
COMMENT ON COLUMN em_cp_checkin_sync_state.tenant_id IS '企业租户ID'
;

CREATE TABLE em_cp_checkin_sync_log (
  id varchar(32) NOT NULL PRIMARY KEY,
  cp_corp_id varchar(32) DEFAULT NULL,
  outsys_id varchar(32) DEFAULT NULL,
  log_txt clob DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_checkin_sync_log IS '企业号考勤打卡数据同步日志记录表'
;
COMMENT ON COLUMN em_cp_checkin_sync_log.id IS '主键ID'
;
COMMENT ON COLUMN em_cp_checkin_sync_log.cp_corp_id IS '企业号基本信息ID'
;
COMMENT ON COLUMN em_cp_checkin_sync_log.outsys_id IS '集成系统ID'
;
COMMENT ON COLUMN em_cp_checkin_sync_log.log_txt IS '同步结果'
;
COMMENT ON COLUMN em_cp_checkin_sync_log.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_checkin_sync_log.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_checkin_sync_log.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_cp_checkin_sync_log.update_time IS '修改时间'
;
COMMENT ON COLUMN em_cp_checkin_sync_log.tenant_id IS '企业租户ID'
;