CREATE TABLE em_sys_url_mapping (
  id varchar(32) NOT NULL PRIMARY KEY,
  url_type number(4,0) DEFAULT NULL,
  outsys_id varchar(32) DEFAULT NULL,
  request_type number(4,0) DEFAULT NULL,
  request_param varchar(1000) DEFAULT NULL,
  mapping_url varchar(100) DEFAULT NULL,
  mapping_host varchar(100) DEFAULT NULL,
  mapping_port varchar(100) DEFAULT NULL,
  mapping_encrypt number(4,0) DEFAULT NULL,
  priority number(11,0),
  status number(4,0) DEFAULT 1,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_url_mapping IS '系统访问地址映射关系表'
;
COMMENT ON COLUMN em_sys_url_mapping.id IS '主键ID'
;
COMMENT ON COLUMN em_sys_url_mapping.url_type IS '地址类型：1-EC、2-APP消息、3-PC消息'
;
COMMENT ON COLUMN em_sys_url_mapping.outsys_id IS '当url_type为1时，表示对应的ecology系统id'
;
COMMENT ON COLUMN em_sys_url_mapping.request_type IS '请求判断类型：1-根据EM访问地址判断、2-根据客户端IP判断'
;
COMMENT ON COLUMN em_sys_url_mapping.request_param IS '请求参数，当request_type为1时表示请求的EM地址，当request_type为2时表示客户端的IP，多个IP用分号隔开'
;
COMMENT ON COLUMN em_sys_url_mapping.mapping_url IS '映射的EC系统访问地址'
;
COMMENT ON COLUMN em_sys_url_mapping.mapping_host IS '映射的消息服务地址'
;
COMMENT ON COLUMN em_sys_url_mapping.mapping_port IS '映射的消息服务端口号'
;
COMMENT ON COLUMN em_sys_url_mapping.mapping_encrypt IS '映射的消息服务连接是否加密'
;
COMMENT ON COLUMN em_sys_url_mapping.priority IS '优先级，数值越大优先级越高'
;
COMMENT ON COLUMN em_sys_url_mapping.status IS '状态'
;
COMMENT ON COLUMN em_sys_url_mapping.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_url_mapping.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_url_mapping.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_url_mapping.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_url_mapping.tenant_id IS '企业租户ID'
;