CREATE TABLE em_sys_clienttask_setting  (
  id VARCHAR(32) NOT NULL PRIMARY KEY,
  task_type number(4,0)  DEFAULT NULL,
  task_cycle number(11,0) DEFAULT NULL,
  task_time_type number(4,0) DEFAULT NULL,
  task_time_start VARCHAR(20) DEFAULT NULL,
  task_time_end VARCHAR(20) DEFAULT NULL,
  task_range_type number(4,0) DEFAULT NULL ,
  status number(4,0) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL ,
  create_user_id VARCHAR(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL ,
  update_user_id VARCHAR(32) DEFAULT NULL,
  tenant_id VARCHAR(32) DEFAULT NULL 
) 
;
COMMENT ON TABLE em_sys_clienttask_setting IS '客户端定时任务设置表'
;
COMMENT ON COLUMN em_sys_clienttask_setting.id IS '主键ID'
;
COMMENT ON COLUMN em_sys_clienttask_setting.task_type IS '任务类型：1-上报活跃、2-上报定位、3-上报步数、4-请求弹窗'
;
COMMENT ON COLUMN em_sys_clienttask_setting.task_cycle IS '任务执行周期，单位为秒'
;
COMMENT ON COLUMN em_sys_clienttask_setting.task_time_type IS '任务执行时间类型，1-所有时间、2-指定时间段'
;
COMMENT ON COLUMN em_sys_clienttask_setting.task_time_start IS '任务执行指定时间段的开始时间'
;
COMMENT ON COLUMN em_sys_clienttask_setting.task_time_end IS '任务执行指定时间段的结束时间'
;
COMMENT ON COLUMN em_sys_clienttask_setting.task_range_type IS '任务执行适用范围类型：1-包含，2-排除'
;
COMMENT ON COLUMN em_sys_clienttask_setting.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_sys_clienttask_setting.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_clienttask_setting.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_clienttask_setting.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_clienttask_setting.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_clienttask_setting.tenant_id IS '企业租户ID'
;


CREATE TABLE em_sys_clienttask_right (
  id VARCHAR(32) NOT NULL PRIMARY KEY,
  task_id VARCHAR(32)  DEFAULT NULL ,
  hrm_data_id VARCHAR(32) DEFAULT NULL ,
  hrm_data_type number(4,0) DEFAULT NULL ,
  status number(4,0) DEFAULT 1 ,
  create_user_id VARCHAR(32) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL ,
  update_user_id VARCHAR(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id VARCHAR(32) DEFAULT NULL 
) 
;

CREATE INDEX clienttask_right_hrm_id_index ON em_sys_clienttask_right(hrm_data_id)
;
CREATE INDEX clienttask_right_tid_index ON em_sys_clienttask_right(tenant_id)
;
COMMENT ON TABLE em_sys_clienttask_right IS '客户端定时任务使用权限设置表'
;
COMMENT ON COLUMN em_sys_clienttask_right.id IS '主键ID'
;
COMMENT ON COLUMN em_sys_clienttask_right.task_id IS '对应任务id'
;
COMMENT ON COLUMN em_sys_clienttask_right.hrm_data_id IS '通讯录成员或部门表ID'
;
COMMENT ON COLUMN em_sys_clienttask_right.hrm_data_type IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;
COMMENT ON COLUMN em_sys_clienttask_right.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_sys_clienttask_right.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_clienttask_right.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_clienttask_right.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_clienttask_right.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_clienttask_right.tenant_id IS '企业租户ID'
;

CREATE TABLE em_sys_baseuser_location  ( 
  id VARCHAR(32) NOT NULL PRIMARY KEY,
  client_type number(4,0) DEFAULT 0 ,
  device_id VARCHAR(500),
  longitude VARCHAR(100) ,
  latitude VARCHAR(100),
  status number(4,0) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL ,
  create_user_id VARCHAR(32) DEFAULT NULL ,
  update_time TIMESTAMP DEFAULT NULL ,
  update_user_id VARCHAR(32) DEFAULT NULL ,
  tenant_id VARCHAR(32) DEFAULT NULL 
) 
;
COMMENT ON TABLE em_sys_baseuser_location IS '用户定位信息记录表'
;
COMMENT ON COLUMN em_sys_baseuser_location.id IS '主键ID'
;
COMMENT ON COLUMN em_sys_baseuser_location.client_type IS '设备类型：1-PC客户端，2-ios，3-android，4-web'
;
COMMENT ON COLUMN em_sys_baseuser_location.device_id IS '设备标识'
;
COMMENT ON COLUMN em_sys_baseuser_location.longitude IS '经度'
;
COMMENT ON COLUMN em_sys_baseuser_location.latitude IS '纬度'
;
COMMENT ON COLUMN em_sys_baseuser_location.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_sys_baseuser_location.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_baseuser_location.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_baseuser_location.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_baseuser_location.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_baseuser_location.tenant_id IS '企业租户ID'
;