ALTER TABLE em_log_access RENAME TO em_log_access_bak
;
CREATE TABLE em_log_access (
  id VARCHAR(32) NOT NULL  PRIMARY KEY,
  base_user_id VARCHAR(32) DEFAULT NULL,
  base_user_name VARCHAR(255) DEFAULT NULL ,
  base_user_status number(4,0)  DEFAULT NULL ,
  operation VARCHAR(255) DEFAULT NULL ,
  access_token VARCHAR(100) DEFAULT NULL ,
  login_type number(4,0)  DEFAULT NULL,
  login_mode number(4,0)  DEFAULT NULL ,
  client_type number(4,0)  DEFAULT NULL,
  client_version VARCHAR(50) DEFAULT NULL ,
  device_id VARCHAR(255) DEFAULT NULL ,
  lang_type VARCHAR(20)  DEFAULT NULL, 
  os_version VARCHAR(800) DEFAULT NULL,
  client_model VARCHAR(100) DEFAULT NULL,
  ip VARCHAR(255) DEFAULT NULL ,
  user_agent VARCHAR(500) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL ,
  tenant_id VARCHAR(32) DEFAULT NULL
) 
;
CREATE INDEX log_access_token_index2 ON em_log_access(access_token)
;
CREATE INDEX log_access_baseuseridindex2   ON em_log_access(base_user_id)
;
CREATE INDEX log_access_createtimeindex2   ON em_log_access(create_time)
;
CREATE INDEX log_access_tenantidindex2     ON em_log_access(tenant_id)
;
COMMENT ON TABLE em_log_access IS '访问日志'
;
COMMENT ON COLUMN em_log_access.id IS '主键ID'
;
COMMENT ON COLUMN em_log_access.base_user_id IS '用户ID'
;
COMMENT ON COLUMN em_log_access.base_user_name IS '用户名'
;
COMMENT ON COLUMN em_log_access.base_user_status IS '用户状态 1-已注册，2-未注册，3-删除'
;
COMMENT ON COLUMN em_log_access.operation IS '操作：login-登录，logout-登出'
;
COMMENT ON COLUMN em_log_access.access_token IS '访问token'
;
COMMENT ON COLUMN em_log_access.login_type IS '登录类型：1-客户端，2-管理端，3-接口'
;
COMMENT ON COLUMN em_log_access.login_mode IS '登录方式：1-账号密码登录，2-短信验证码登录，3-扫码登录'
;
COMMENT ON COLUMN em_log_access.client_type IS '客户端类型： 1-PC客户端，2-IOS客户端，3-安卓客户端，4-web版'
;
COMMENT ON COLUMN em_log_access.client_version IS '客户端版本'
;
COMMENT ON COLUMN em_log_access.device_id IS '客户端硬件标识'
;
COMMENT ON COLUMN em_log_access.lang_type IS '语言类型'
;
COMMENT ON COLUMN em_log_access.os_version IS '客户端操作系统版本'
;
COMMENT ON COLUMN em_log_access.client_model IS '客户端设备型号'
;
COMMENT ON COLUMN em_log_access.ip IS 'IP地址'
;
COMMENT ON COLUMN em_log_access.user_agent is '访问头信息'
;
COMMENT ON COLUMN em_log_access.create_time IS '日志创建时间'
;
COMMENT ON COLUMN em_log_access.tenant_id  IS '企业租户ID'
;
