drop TABLE em_sys_baseuser_location
;
CREATE SEQUENCE em_sys_baseuser_location_SEQ  MINVALUE 1 MAXVALUE 9223372036854775807 INCREMENT BY 1  START WITH 1 NOCACHE
;
CREATE TABLE em_sys_baseuser_location  ( 
  id NUMBER(9) NOT NULL PRIMARY KEY,
  client_type number(4,0) DEFAULT 0 ,
  device_id VARCHAR(500),
  longitude VARCHAR(100) ,
  latitude VARCHAR(100),
  status number(4,0) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL ,
  create_user_id VARCHAR(32) DEFAULT NULL ,
  update_time TIMESTAMP DEFAULT NULL ,
  update_user_id VARCHAR(32) DEFAULT NULL ,
  tenant_id VARCHAR(32) DEFAULT NULL 
) 
;
COMMENT ON TABLE em_sys_baseuser_location IS '用户定位信息记录表'
;
CREATE INDEX baseuser_location_ct_index ON em_sys_baseuser_location(create_time)
;
COMMENT ON COLUMN em_sys_baseuser_location.id IS '主键ID'
;
COMMENT ON COLUMN em_sys_baseuser_location.client_type IS '设备类型：1-PC客户端，2-ios，3-android，4-web'
;
COMMENT ON COLUMN em_sys_baseuser_location.device_id IS '设备标识'
;
COMMENT ON COLUMN em_sys_baseuser_location.longitude IS '经度'
;
COMMENT ON COLUMN em_sys_baseuser_location.latitude IS '纬度'
;
COMMENT ON COLUMN em_sys_baseuser_location.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_sys_baseuser_location.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_baseuser_location.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_baseuser_location.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_baseuser_location.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_baseuser_location.tenant_id IS '企业租户ID'
;