CREATE TABLE em_cp_pay_unifiedorder (
  id varchar(32) NOT NULL PRIMARY KEY,
  cp_corp_id varchar(32) DEFAULT NULL,
  open_user_id varchar(128) DEFAULT NULL,
  mchid varchar(32) DEFAULT NULL,
  trade_type varchar(16) DEFAULT NULL,
  out_trade_no varchar(32) DEFAULT NULL,
  total_fee number(11,0) DEFAULT NULL,
  body varchar(128) DEFAULT NULL,
  attach varchar(127) DEFAULT NULL,
  nonce_str varchar(32) DEFAULT NULL,
  notify_url varchar(256) DEFAULT NULL,
  spbill_create_ip varchar(16) DEFAULT NULL,
  sign varchar(32) DEFAULT NULL,
  order_status number(4, 0) DEFAULT NULL,
  status number(4, 0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;

COMMENT ON TABLE em_cp_pay_unifiedorder IS '企业号支付订单'
;
COMMENT ON COLUMN em_cp_pay_unifiedorder.id IS '主键ID'
;
COMMENT ON COLUMN em_cp_pay_unifiedorder.cp_corp_id IS '企业号基本信息ID'
;
COMMENT ON COLUMN em_cp_pay_unifiedorder.open_user_id IS '用户在企业号内的唯一标识'
;
COMMENT ON COLUMN em_cp_pay_unifiedorder.mchid IS '商户ID'
;
COMMENT ON COLUMN em_cp_pay_unifiedorder.trade_type IS '交易类型'
;
COMMENT ON COLUMN em_cp_pay_unifiedorder.out_trade_no IS '订单号'
;
COMMENT ON COLUMN em_cp_pay_unifiedorder.total_fee IS '总金额'
;
COMMENT ON COLUMN em_cp_pay_unifiedorder.body IS '商品描述'
;
COMMENT ON COLUMN em_cp_pay_unifiedorder.attach IS '附加数据'
;
COMMENT ON COLUMN em_cp_pay_unifiedorder.nonce_str IS '随机字符串'
;
COMMENT ON COLUMN em_cp_pay_unifiedorder.notify_url IS '通知地址'
;
COMMENT ON COLUMN em_cp_pay_unifiedorder.spbill_create_ip IS '终端IP'
;
COMMENT ON COLUMN em_cp_pay_unifiedorder.sign IS '签名'
;
COMMENT ON COLUMN em_cp_pay_unifiedorder.order_status IS '订单状态，0：下单成功，1：下单失败，2：支付成功，3：支付失败'
;
COMMENT ON COLUMN em_cp_pay_unifiedorder.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_cp_pay_unifiedorder.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_pay_unifiedorder.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_pay_unifiedorder.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_cp_pay_unifiedorder.update_time IS '修改时间'
;
COMMENT ON COLUMN em_cp_pay_unifiedorder.tenant_id IS '企业租户ID'
;
