CREATE TABLE em_cp_secondauth (
  id varchar(32) NOT NULL PRIMARY KEY,
  cp_corp_id varchar(32) DEFAULT NULL,
  link_url varchar(1000) DEFAULT NULL,
  status number(4, 0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;

COMMENT ON TABLE em_cp_secondauth IS '企业号二次验证'
;
COMMENT ON COLUMN em_cp_secondauth.id IS '主键ID'
;
COMMENT ON COLUMN em_cp_secondauth.cp_corp_id IS '企业号基本信息ID'
;
COMMENT ON COLUMN em_cp_secondauth.link_url IS '自定义二次验证链接地址'
;
COMMENT ON COLUMN em_cp_secondauth.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_cp_secondauth.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_secondauth.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_secondauth.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_cp_secondauth.update_time IS '修改时间'
;
COMMENT ON COLUMN em_cp_secondauth.tenant_id IS '企业租户ID'
;
