
CREATE TABLE em_msg_expression_item (
  id varchar(32) NOT NULL ,
  item_name varchar(100) DEFAULT NULL,
  item_icon varchar(32) DEFAULT NULL,
  showorder number(4,0)  DEFAULT NULL,
  status number(4,0) DEFAULT '1' ,
  create_user_id varchar(32) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL ,
  tenant_id varchar(32) DEFAULT NULL
)
;

CREATE INDEX expression_itemorder_index ON em_msg_expression_item(showorder)
;

COMMENT ON TABLE em_msg_expression_item IS '消息自定义表情分组表'
;
COMMENT ON COLUMN em_msg_expression_item.id IS '主键ID'
;
COMMENT ON COLUMN em_msg_expression_item.item_name IS '分组名称'
;
COMMENT ON COLUMN em_msg_expression_item.item_icon IS '分组图标ID'
;
COMMENT ON COLUMN em_msg_expression_item.showorder IS '显示顺序'
;


CREATE TABLE em_msg_expression_data (
  id varchar(32) NOT NULL ,
  item_id varchar(32) DEFAULT NULL ,
  data_icon varchar(32) DEFAULT NULL ,
  showorder number(4,0)  DEFAULT NULL ,
  status number(4,0) DEFAULT 1,
  create_user_id varchar(32) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL ,
  update_user_id varchar(32) DEFAULT NULL ,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
) 
;
CREATE INDEX expression_dataorder_index ON em_msg_expression_data(showorder)
;

COMMENT ON TABLE em_msg_expression_data IS '消息自定义表情数据表'
;
COMMENT ON COLUMN em_msg_expression_data.id IS '主键ID'
;
COMMENT ON COLUMN em_msg_expression_data.item_id IS '所属表情分组ID'
;
COMMENT ON COLUMN em_msg_expression_data.data_icon IS '表情数据图标ID'
;