CREATE TABLE em_oss_template (
  id varchar(32) NOT NULL PRIMARY KEY,
  name varchar(255) DEFAULT NULL,
  strategy varchar(255) DEFAULT NULL CHECK (strategy IN ('ALIYUN','QCLOUD','QINIU')),
  setting CLOB,
  status NUMBER(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_oss_template is 'OSS模板设置表'
;
COMMENT ON COLUMN em_oss_template.id IS '主键'
;
COMMENT ON COLUMN em_oss_template.name IS 'OSS模板名称'
;
COMMENT ON COLUMN em_oss_template.strategy IS 'OSS模板策略'
;
COMMENT ON COLUMN em_oss_template.setting IS 'OSS模板设置参数（JSON数据）'
;
COMMENT ON COLUMN em_oss_template.status IS '状态'
;
COMMENT ON COLUMN em_oss_template.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_oss_template.create_time IS '创建时间'
;
COMMENT ON COLUMN em_oss_template.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_oss_template.update_time IS '修改时间'
;
COMMENT ON COLUMN em_oss_template.tenant_id IS '企业租户ID'
;