CREATE TABLE em_cp_user_sync_field (
  id varchar(32) NOT NULL PRIMARY KEY,
  cp_syncset_id varchar(32) DEFAULT NULL,
  user_field_name varchar(50) DEFAULT NULL,
  user_field_key varchar(50) DEFAULT NULL,
  user_field_type number(4, 0) DEFAULT 0,
  outsys_field_name varchar(50) DEFAULT NULL,
  outsys_field_key varchar(50) DEFAULT NULL,
  outsys_field_type number(4, 0) DEFAULT 0,
  showorder number(11,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;

COMMENT ON TABLE em_cp_user_sync_field IS '企业号人员同步字段配置'
;
COMMENT ON COLUMN em_cp_user_sync_field.id IS '主键ID'
;
COMMENT ON COLUMN em_cp_user_sync_field.cp_syncset_id IS '企业号同步设置ID'
;
COMMENT ON COLUMN em_cp_user_sync_field.user_field_name IS '企业号字段名称'
;
COMMENT ON COLUMN em_cp_user_sync_field.user_field_key IS '企业号字段唯一标识'
;
COMMENT ON COLUMN em_cp_user_sync_field.user_field_type IS '企业号字段类型，0：基础字段，1：自定义字段'
;
COMMENT ON COLUMN em_cp_user_sync_field.outsys_field_name IS '集成系统字段名称'
;
COMMENT ON COLUMN em_cp_user_sync_field.outsys_field_key IS '集成系统字段唯一标识'
;
COMMENT ON COLUMN em_cp_user_sync_field.outsys_field_type IS '集成系统字段类型，0：基础字段，1：自定义字段'
;
COMMENT ON COLUMN em_cp_user_sync_field.showorder IS '显示排序'
;
COMMENT ON COLUMN em_cp_user_sync_field.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_user_sync_field.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_user_sync_field.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_cp_user_sync_field.update_time IS '修改时间'
;
COMMENT ON COLUMN em_cp_user_sync_field.tenant_id IS '企业租户ID'
;
