CREATE TABLE em_video_zhumu_user (
  id varchar(32) NOT NULL PRIMARY KEY,
  base_user_id varchar(32) DEFAULT NULL ,
  zcode varchar(50) DEFAULT NULL,
  email varchar(100) DEFAULT NULL,
  pmi varchar(50) DEFAULT NULL ,
  status  NUMBER(4,0) DEFAULT 1 ,
  create_user_id varchar(32) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL ,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL 
) 
;
CREATE INDEX em_zhumu_user_baseid_index ON em_video_zhumu_user(base_user_id)
;

COMMENT ON TABLE em_video_zhumu_user is '瞩目视频会议人员标识表'
;
COMMENT ON COLUMN em_video_zhumu_user.id IS 'ID'
;
COMMENT ON COLUMN em_video_zhumu_user.base_user_id IS '基础用户ID'
;
COMMENT ON COLUMN em_video_zhumu_user.zcode IS '瞩目人员标识'
;
COMMENT ON COLUMN em_video_zhumu_user.email IS '邮箱'
;
COMMENT ON COLUMN em_video_zhumu_user.pmi IS '个人会议号'
;
COMMENT ON COLUMN em_video_zhumu_user.status IS '状态'
;
COMMENT ON COLUMN em_video_zhumu_user.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_video_zhumu_user.create_time IS '修改时间'
;
COMMENT ON COLUMN em_video_zhumu_user.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_video_zhumu_user.update_time IS '修改时间'
;
COMMENT ON COLUMN em_video_zhumu_user.tenant_id IS '企业租户ID'
;

CREATE TABLE em_video_zhumu_meeting (
  id varchar(32) NOT NULL  PRIMARY KEY,
  base_user_id varchar(32) DEFAULT NULL,
  meeting_id varchar(50) DEFAULT NULL,
  meeting_password varchar(20) DEFAULT NULL,
  meeting_topic varchar(50) DEFAULT NULL ,
  meeting_type NUMBER(4,0) DEFAULT NULL ,
  meeting_start_time TIMESTAMP DEFAULT NULL ,
  meeting_duration varchar(20) DEFAULT NULL ,
  option_jbh  NUMBER(4,0) DEFAULT NULL,
  option_start_type varchar(10) DEFAULT NULL,
  option_no_video_host NUMBER(4,0) DEFAULT NULL ,
  option_no_video_participants NUMBER(4,0) DEFAULT NULL ,
  option_audio varchar(10) DEFAULT NULL ,
  status NUMBER(4,0) DEFAULT 1 ,
  create_user_id varchar(32) DEFAULT NULL ,
  create_time TIMESTAMP DEFAULT NULL ,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL ,
  tenant_id varchar(32) DEFAULT NULL
) 
;
CREATE INDEX em_zhumu_meeting_baseid_index ON em_video_zhumu_meeting(base_user_id)
;

COMMENT ON TABLE em_video_zhumu_meeting is '瞩目视频会议会议信息表'
;
COMMENT ON COLUMN em_video_zhumu_meeting.status IS '状态'
;
COMMENT ON COLUMN em_video_zhumu_meeting.id IS 'ID'
;
COMMENT ON COLUMN em_video_zhumu_meeting.base_user_id IS '会议主持人对应的基础用户ID'
;
COMMENT ON COLUMN em_video_zhumu_meeting.meeting_id IS '瞩目会议ID'
;
COMMENT ON COLUMN em_video_zhumu_meeting.meeting_password IS '会议密码'
;
COMMENT ON COLUMN em_video_zhumu_meeting.meeting_topic IS '瞩目会议名称'
;
COMMENT ON COLUMN em_video_zhumu_meeting.meeting_type IS '会议类型：1-即时会议，2-计划会议，3-长期会议'
;
COMMENT ON COLUMN em_video_zhumu_meeting.meeting_start_time IS '会议开始时间'
;
COMMENT ON COLUMN em_video_zhumu_meeting.meeting_duration IS '会议持续时间'
;
COMMENT ON COLUMN em_video_zhumu_meeting.option_jbh IS '是否可以在主持人开始会议之前加入会议：1-是，0-否'
;
COMMENT ON COLUMN em_video_zhumu_meeting.option_start_type IS '会议开始类型，可以是"video"或者 "screen_share". (不赞成)'
;
COMMENT ON COLUMN em_video_zhumu_meeting.option_no_video_host IS '当主持人加入会议时关闭视频：1-是，0-否'
;
COMMENT ON COLUMN em_video_zhumu_meeting.option_no_video_participants IS '当参与人加入会议室不打开视频：1-是，0-否'
;
COMMENT ON COLUMN em_video_zhumu_meeting.option_audio IS '会议语音选项。可以是"both", "telephony", “voip”'
;
COMMENT ON COLUMN em_video_zhumu_meeting.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_video_zhumu_meeting.create_time IS '修改时间'
;
COMMENT ON COLUMN em_video_zhumu_meeting.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_video_zhumu_meeting.update_time IS '修改时间'
;
COMMENT ON COLUMN em_video_zhumu_meeting.tenant_id IS '企业租户ID'
;
