CREATE TABLE em_sys_msg_sensitive (

  id varchar(32) NOT NULL PRIMARY KEY,

  sensitive_word_filter number(4,0) DEFAULT NULL,

  sensitive_word_dealtype number(4,0) DEFAULT NULL,

  sensitive_word_content clob DEFAULT NULL,

  status number(4,0) DEFAULT 1,

  create_user_id varchar(32) DEFAULT NULL,

  create_time TIMESTAMP DEFAULT NULL,

  update_user_id varchar(32) DEFAULT NULL,

  update_time TIMESTAMP DEFAULT NULL,

  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_msg_sensitive IS '消息敏感词过滤设置表'
;
COMMENT ON COLUMN em_sys_msg_sensitive.id IS '主键'
;
COMMENT ON COLUMN em_sys_msg_sensitive.sensitive_word_filter IS '是否开启敏感词过滤功能，1表示开启 0表示关闭'
;
COMMENT ON COLUMN em_sys_msg_sensitive.sensitive_word_dealtype IS '敏感词处理方式，1表示禁止发送并提示，2表示自动替换为*'
;
COMMENT ON COLUMN em_sys_msg_sensitive.sensitive_word_content IS '敏感词内容，多个用逗号分隔'
;
COMMENT ON COLUMN em_sys_msg_sensitive.status IS '状态'
;
COMMENT ON COLUMN em_sys_msg_sensitive.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_msg_sensitive.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_msg_sensitive.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_msg_sensitive.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_msg_sensitive.tenant_id IS '企业租户ID'
;

insert into em_sys_msg_sensitive values('1',0,1,null,1,1,sysdate,null,null,'1')
;