CREATE TABLE em_agent_msg_log_resend (
  id VARCHAR(32) NOT NULL PRIMARY KEY,
  msg_log_id VARCHAR(32) DEFAULT NULL,
  open_agent_id NUMBER(11, 0) DEFAULT NULL,
  target_type NUMBER(4, 0) DEFAULT '0',
  cp_corp_id VARCHAR(32) DEFAULT NULL,
  cp_agent_id VARCHAR(32) DEFAULT NULL,
  touser CLOB DEFAULT NULL,
  toparty CLOB DEFAULT NULL,
  todept CLOB DEFAULT NULL,
  totag CLOB DEFAULT NULL,
  msgtype VARCHAR(10) DEFAULT NULL,
  safe NUMBER(4, 0) DEFAULT '0',
  datainfo CLOB DEFAULT NULL,
  requsetinfo CLOB DEFAULT NULL,
  errcode NUMBER(11, 0) DEFAULT NULL,
  errmsg VARCHAR(1000) DEFAULT NULL,
  invaliduser CLOB DEFAULT NULL,
  invalidparty CLOB DEFAULT NULL,
  invaliddept CLOB DEFAULT NULL,
  invalidtag CLOB DEFAULT NULL,
  realityreceivers CLOB DEFAULT NULL,
  source_msg_id VARCHAR(100) DEFAULT NULL,
  server_msg_id VARCHAR(100) DEFAULT NULL,
  send_type NUMBER(4, 0) DEFAULT '0',
  send_time TIMESTAMP DEFAULT NULL,
  log_group_id VARCHAR(100) DEFAULT NULL,
  status NUMBER(4, 0) DEFAULT '1',
  create_user_id VARCHAR(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  tenant_id VARCHAR(32) DEFAULT NULL
)
;

COMMENT ON TABLE em_agent_msg_log_resend IS '企业应用重发消息记录表'
;
COMMENT ON COLUMN em_agent_msg_log_resend.id IS '主键ID'
;
COMMENT ON COLUMN em_agent_msg_log_resend.msg_log_id IS '第一次推送消息的消息记录ID'
;
COMMENT ON COLUMN em_agent_msg_log_resend.open_agent_id IS '企业应用openid'
;
COMMENT ON COLUMN em_agent_msg_log_resend.target_type IS '推送目标类型，0-无，1-E-mobile，2-企业号'
;
COMMENT ON COLUMN em_agent_msg_log_resend.cp_corp_id IS '推送目标的企业号ID，当目标类型为2时有效'
;
COMMENT ON COLUMN em_agent_msg_log_resend.cp_agent_id IS '推送目标的企业号应用ID，当目标类型为2时有效'
;
COMMENT ON COLUMN em_agent_msg_log_resend.touser IS '成员ID列表（消息接收者，多个接收者用‘|’分隔，最多支持1000个）。特殊情况：指定为@all，则向该企业应用的全部成员发送'
;
COMMENT ON COLUMN em_agent_msg_log_resend.toparty IS '部门ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数'
;
COMMENT ON COLUMN em_agent_msg_log_resend.todept IS '部门ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数'
;
COMMENT ON COLUMN em_agent_msg_log_resend.totag IS '标签ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数'
;
COMMENT ON COLUMN em_agent_msg_log_resend.msgtype IS '消息类型 text-文本，image-图片，voice-语音，video-视频，file-文件，news-图文'
;
COMMENT ON COLUMN em_agent_msg_log_resend.safe IS '表示是否是保密消息，0表示否，1表示是，默认0'
;
COMMENT ON COLUMN em_agent_msg_log_resend.datainfo IS '发送数据的详细信息，json格式的完整内容'
;
COMMENT ON COLUMN em_agent_msg_log_resend.requsetinfo IS '请求数据vo'
;
COMMENT ON COLUMN em_agent_msg_log_resend.errcode IS '发送结果状态码'
;
COMMENT ON COLUMN em_agent_msg_log_resend.errmsg IS '错误信息'
;
COMMENT ON COLUMN em_agent_msg_log_resend.invaliduser IS '无效的成员ID列表'
;
COMMENT ON COLUMN em_agent_msg_log_resend.invalidparty IS '无效的部门ID列表'
;
COMMENT ON COLUMN em_agent_msg_log_resend.invaliddept IS '无效的部门ID列表'
;
COMMENT ON COLUMN em_agent_msg_log_resend.invalidtag IS '无效的标签ID列表'
;
COMMENT ON COLUMN em_agent_msg_log_resend.realityreceivers IS '消息发送实际上所有接收人id'
;
COMMENT ON COLUMN em_agent_msg_log_resend.source_msg_id IS '消息数据原始ID，接口传入，不传则系统自动生成'
;
COMMENT ON COLUMN em_agent_msg_log_resend.server_msg_id IS '消息数据在消息服务端的ID'
;
COMMENT ON COLUMN em_agent_msg_log_resend.send_type IS '消息发送类型，1-立即发送，2-定时发送'
;
COMMENT ON COLUMN em_agent_msg_log_resend.send_time IS '消息发送时间，如果为定时发送，这里为定时发送时间'
;
COMMENT ON COLUMN em_agent_msg_log_resend.log_group_id IS '操作批次id'
;
COMMENT ON COLUMN em_agent_msg_log_resend.status IS '状态：1-正常，3-删除'
;
COMMENT ON COLUMN em_agent_msg_log_resend.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_agent_msg_log_resend.create_time IS '创建时间'
;
COMMENT ON COLUMN em_agent_msg_log_resend.tenant_id IS '企业租户ID'
;

CREATE INDEX agent_msg_log_resend_oai_idx ON em_agent_msg_log_resend(open_agent_id)
;
CREATE INDEX agent_msg_log_resend_ti_idx ON em_agent_msg_log_resend(tenant_id)
;
CREATE INDEX agent_msg_log_resend_somi_idx ON em_agent_msg_log_resend(source_msg_id)
;
CREATE INDEX agent_msg_log_resend_semi_idx ON em_agent_msg_log_resend(server_msg_id)
;
