CREATE TABLE em_cp_msgaudit_file (
  id varchar(32) NOT NULL PRIMARY KEY,
  file_name varchar(1000) DEFAULT NULL,
  file_extension varchar(255) DEFAULT NULL,
  file_content_type varchar(255) DEFAULT NULL,
  file_size NUMBER(20,0) DEFAULT NULL,
  file_path varchar(255) DEFAULT NULL,
  status NUMBER(4) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_msgaudit_file IS '会话内容存档文件'
;
COMMENT ON COLUMN em_cp_msgaudit_file.id IS '主键'
;
COMMENT ON COLUMN em_cp_msgaudit_file.file_name IS '文件名称'
;
COMMENT ON COLUMN em_cp_msgaudit_file.file_extension IS '文件扩展名'
;
COMMENT ON COLUMN em_cp_msgaudit_file.file_content_type IS '文件类型'
;
COMMENT ON COLUMN em_cp_msgaudit_file.file_size IS '文件大小'
;
COMMENT ON COLUMN em_cp_msgaudit_file.file_path IS '文件路径'
;
COMMENT ON COLUMN em_cp_msgaudit_file.status IS '状态'
;
COMMENT ON COLUMN em_cp_msgaudit_file.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_msgaudit_file.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_msgaudit_file.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_cp_msgaudit_file.update_time IS '修改时间'
;
COMMENT ON COLUMN em_cp_msgaudit_file.tenant_id IS '租户ID'
;
CREATE TABLE em_cp_msgaudit_member (
  id varchar(32) NOT NULL PRIMARY KEY,
  corp_id varchar(32) DEFAULT NULL,
  member_id varchar(255) DEFAULT NULL,
  status NUMBER(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_msgaudit_member IS '会话内容存档成员'
;
COMMENT ON COLUMN em_cp_msgaudit_member.id IS '主键'
;
COMMENT ON COLUMN em_cp_msgaudit_member.corp_id IS '企业ID'
;
COMMENT ON COLUMN em_cp_msgaudit_member.member_id IS '接口成员ID'
;
COMMENT ON COLUMN em_cp_msgaudit_member.status IS '状态'
;
COMMENT ON COLUMN em_cp_msgaudit_member.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_msgaudit_member.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_msgaudit_member.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_cp_msgaudit_member.update_time IS '修改时间'
;
COMMENT ON COLUMN em_cp_msgaudit_member.tenant_id IS '租户ID'
;
CREATE INDEX em_cp_msgaudit_member_mi_idx ON em_cp_msgaudit_member(member_id)
;
CREATE INDEX em_cp_msgaudit_member_cmi_idx ON em_cp_msgaudit_member(corp_id, member_id)
;
CREATE TABLE em_cp_msgaudit_message (
  id varchar(32) NOT NULL PRIMARY KEY,
  corp_id varchar(32) DEFAULT NULL,
  seq NUMBER(20,0) DEFAULT NULL,
  room_id varchar(32) DEFAULT NULL,
  msg_id varchar(255) DEFAULT NULL,
  msg_action varchar(32) DEFAULT NULL,
  msg_from varchar(255) DEFAULT NULL,
  to_list CLOB,
  msg_type varchar(32) DEFAULT NULL,
  msg_time TIMESTAMP DEFAULT NULL,
  content CLOB,
  sdk_file_id CLOB,
  file_id varchar(32) DEFAULT NULL,
  msg_json CLOB,
  status NUMBER(4,0) DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_msgaudit_message IS '会话内容存档消息'
;
COMMENT ON COLUMN em_cp_msgaudit_message.id IS '主键'
;
COMMENT ON COLUMN em_cp_msgaudit_message.corp_id IS '企业ID'
;
COMMENT ON COLUMN em_cp_msgaudit_message.seq IS 'seq'
;
COMMENT ON COLUMN em_cp_msgaudit_message.room_id IS '会话ID'
;
COMMENT ON COLUMN em_cp_msgaudit_message.msg_id IS '接口消息ID'
;
COMMENT ON COLUMN em_cp_msgaudit_message.msg_action IS '消息动作：send-发送消息、recall-撤回消息、switch-切换企业日志'
;
COMMENT ON COLUMN em_cp_msgaudit_message.msg_from IS '消息发送方id'
;
COMMENT ON COLUMN em_cp_msgaudit_message.to_list IS '消息接收方列表，可能是多个，同一个企业内容为userid，非相同企业为external_userid'
;
COMMENT ON COLUMN em_cp_msgaudit_message.msg_type IS '消息类型'
;
COMMENT ON COLUMN em_cp_msgaudit_message.msg_time IS '消息发送时间'
;
COMMENT ON COLUMN em_cp_msgaudit_message.content IS '消息内容'
;
COMMENT ON COLUMN em_cp_msgaudit_message.sdk_file_id IS '接口媒体资源的id信息'
;
COMMENT ON COLUMN em_cp_msgaudit_message.file_id IS '文件ID'
;
COMMENT ON COLUMN em_cp_msgaudit_message.msg_json IS '消息原始JSON数据'
;
COMMENT ON COLUMN em_cp_msgaudit_message.status IS '状态'
;
COMMENT ON COLUMN em_cp_msgaudit_message.tenant_id IS '租户ID'
;
CREATE INDEX em_cp_msgaudit_message_ri_idx ON em_cp_msgaudit_message(room_id)
;
CREATE INDEX em_cp_msgaudit_message_mi_idx ON em_cp_msgaudit_message(msg_id)
;
CREATE TABLE em_cp_msgaudit_room (
  id varchar(32) NOT NULL PRIMARY KEY,
  corp_id varchar(32) DEFAULT NULL,
  room_id varchar(255) DEFAULT NULL,
  room_type NUMBER(4,0) DEFAULT NULL,
  room_name varchar(255) DEFAULT NULL,
  room_creator varchar(255) DEFAULT NULL,
  room_create_time TIMESTAMP DEFAULT NULL,
  room_notice CLOB,
  status NUMBER(4,0) DEFAULT NULL,
  create_user_id varchar(255) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_msgaudit_room IS '会话内容存档会话'
;
COMMENT ON COLUMN em_cp_msgaudit_room.id IS '主键'
;
COMMENT ON COLUMN em_cp_msgaudit_room.corp_id IS '企业ID'
;
COMMENT ON COLUMN em_cp_msgaudit_room.room_id IS '接口会话ID'
;
COMMENT ON COLUMN em_cp_msgaudit_room.room_type IS '会话类型：1-单聊、2-群聊'
;
COMMENT ON COLUMN em_cp_msgaudit_room.room_name IS '群名称'
;
COMMENT ON COLUMN em_cp_msgaudit_room.room_creator IS '群创建者'
;
COMMENT ON COLUMN em_cp_msgaudit_room.room_create_time IS '群创建时间'
;
COMMENT ON COLUMN em_cp_msgaudit_room.room_notice IS '群公告'
;
COMMENT ON COLUMN em_cp_msgaudit_room.status IS '状态'
;
COMMENT ON COLUMN em_cp_msgaudit_room.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_msgaudit_room.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_msgaudit_room.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_cp_msgaudit_room.update_time IS '修改时间'
;
COMMENT ON COLUMN em_cp_msgaudit_room.tenant_id IS '租户ID'
;
CREATE INDEX em_cp_msgaudit_room_ci_idx ON em_cp_msgaudit_room(corp_id)
;
CREATE INDEX em_cp_msgaudit_room_ci_ri_idx ON em_cp_msgaudit_room(corp_id, room_id)
;
CREATE TABLE em_cp_msgaudit_room_member (
  id varchar(32) NOT NULL PRIMARY KEY,
  room_id varchar(32) DEFAULT NULL,
  member_id varchar(32) DEFAULT NULL,
  join_time TIMESTAMP DEFAULT NULL,
  status NUMBER(4,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_msgaudit_room_member IS '会话内容存档会话成员关联关系'
;
COMMENT ON COLUMN em_cp_msgaudit_room_member.id IS '主键'
;
COMMENT ON COLUMN em_cp_msgaudit_room_member.room_id IS '会话ID'
;
COMMENT ON COLUMN em_cp_msgaudit_room_member.member_id IS '成员ID'
;
COMMENT ON COLUMN em_cp_msgaudit_room_member.join_time IS '加入时间'
;
COMMENT ON COLUMN em_cp_msgaudit_room_member.status IS '状态'
;
COMMENT ON COLUMN em_cp_msgaudit_room_member.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_msgaudit_room_member.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_msgaudit_room_member.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_cp_msgaudit_room_member.update_time IS '修改时间'
;
COMMENT ON COLUMN em_cp_msgaudit_room_member.tenant_id IS '租户ID'
;
CREATE INDEX em_cp_msgaudit_rm_ri_idx ON em_cp_msgaudit_room_member(room_id)
;
CREATE INDEX em_cp_msgaudit_rm_ri_mi_idx ON em_cp_msgaudit_room_member(room_id, member_id)
;
CREATE TABLE em_cp_msgaudit_sync_record (
  id varchar(32) NOT NULL PRIMARY KEY,
  corp_id varchar(32) DEFAULT NULL,
  first_seq NUMBER(20,0) DEFAULT NULL,
  last_seq NUMBER(20,0) DEFAULT NULL,
  message_count NUMBER(20,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_msgaudit_sync_record IS '会话内容存档同步记录'
;
COMMENT ON COLUMN em_cp_msgaudit_sync_record.id IS '主键'
;
COMMENT ON COLUMN em_cp_msgaudit_sync_record.corp_id IS '企业ID'
;
COMMENT ON COLUMN em_cp_msgaudit_sync_record.first_seq IS '开始seq'
;
COMMENT ON COLUMN em_cp_msgaudit_sync_record.last_seq IS '结束seq'
;
COMMENT ON COLUMN em_cp_msgaudit_sync_record.message_count IS '同步消息数量'
;
COMMENT ON COLUMN em_cp_msgaudit_sync_record.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_msgaudit_sync_record.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_msgaudit_sync_record.tenant_id IS '租户ID'
;
CREATE INDEX em_cp_msgaudit_sr_ci_idx ON em_cp_msgaudit_sync_record(corp_id)
;
CREATE INDEX em_cp_msgaudit_sr_ct_idx ON em_cp_msgaudit_sync_record(create_time)
;
CREATE TABLE em_cp_msgaudit_sync_setting (
  id varchar(32) NOT NULL PRIMARY KEY,
  corp_id varchar(32) DEFAULT NULL,
  seq NUMBER(20,0) DEFAULT NULL,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_msgaudit_sync_setting IS '会话内容存档同步设置'
;
COMMENT ON COLUMN em_cp_msgaudit_sync_setting.id IS '主键'
;
COMMENT ON COLUMN em_cp_msgaudit_sync_setting.corp_id IS '企业ID'
;
COMMENT ON COLUMN em_cp_msgaudit_sync_setting.seq IS '最大seq'
;
COMMENT ON COLUMN em_cp_msgaudit_sync_setting.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_msgaudit_sync_setting.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_msgaudit_sync_setting.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_cp_msgaudit_sync_setting.update_time IS '修改时间'
;
COMMENT ON COLUMN em_cp_msgaudit_sync_setting.tenant_id IS'租户ID'
;
CREATE INDEX em_cp_msgaudit_ss_corp_id on em_cp_msgaudit_sync_setting(corp_id)
;