create table EM_CP_DEPT_SIMULATED
(
    ID               VARCHAR2(32) not null primary key,
    CP_CORP_ID       VARCHAR2(32)   default NULL,
    OPEN_DEPT_ID     VARCHAR2(100)  default NULL,
    DEPT_NAME        VARCHAR2(100)  default NULL,
    PARENT_ID        VARCHAR2(100)  default NULL,
    ALL_PARENT_IDS   VARCHAR2(1000) default NULL,
    OUTSYS_ID        VARCHAR2(32)   default NULL,
    OUTSYS_DEPT_TYPE NUMBER(4)      default NULL,
    OUTSYS_DEPT_ID   VARCHAR2(32)   default NULL,
    SHOWORDER        NUMBER(20)     default NULL,
    STATUS           NUMBER(4)      default NULL,
    CREATE_USER_ID   VARCHAR2(32)   default NULL,
    CREATE_TIME      TIMESTAMP(6)   default NULL,
    UPDATE_USER_ID   VARCHAR2(32)   default NULL,
    UPDATE_TIME      TIMESTAMP(6)   default NULL,
    TENANT_ID        VARCHAR2(32)   default NULL
)
;

comment on table EM_CP_DEPT_SIMULATED is '企业号通讯录部门表'
;

comment on column EM_CP_DEPT_SIMULATED.ID is '主键ID'
;

comment on column EM_CP_DEPT_SIMULATED.CP_CORP_ID is '企业号基本信息ID'
;

comment on column EM_CP_DEPT_SIMULATED.OPEN_DEPT_ID is '企业号中的部门ID'
;

comment on column EM_CP_DEPT_SIMULATED.DEPT_NAME is '部门名称'
;

comment on column EM_CP_DEPT_SIMULATED.PARENT_ID is '上级部门ID'
;

comment on column EM_CP_DEPT_SIMULATED.ALL_PARENT_IDS is '所有上级部门ID用逗号分隔'
;

comment on column EM_CP_DEPT_SIMULATED.OUTSYS_ID is '对应集成系统的ID'
;

comment on column EM_CP_DEPT_SIMULATED.OUTSYS_DEPT_TYPE is '对应集成系统部门类型：1-分部，2-部门'
;

comment on column EM_CP_DEPT_SIMULATED.OUTSYS_DEPT_ID is '对应集成系统部门ID'
;

comment on column EM_CP_DEPT_SIMULATED.SHOWORDER is '显示顺序'
;

comment on column EM_CP_DEPT_SIMULATED.STATUS is '状态：1-正常、3-删除'
;

comment on column EM_CP_DEPT_SIMULATED.CREATE_USER_ID is '创建人'
;

comment on column EM_CP_DEPT_SIMULATED.CREATE_TIME is '创建时间'
;

comment on column EM_CP_DEPT_SIMULATED.UPDATE_USER_ID is '修改人'
;

comment on column EM_CP_DEPT_SIMULATED.UPDATE_TIME is '修改时间'
;

comment on column EM_CP_DEPT_SIMULATED.TENANT_ID is '企业租户ID'
;

create index EM_CP_DEPT_SIMULATED_ODI_IDX
    on EM_CP_DEPT_SIMULATED (OPEN_DEPT_ID)
;

create index EM_CP_DEPT_SIMULATED_PI_IDX
    on EM_CP_DEPT_SIMULATED (PARENT_ID)
;

create index EM_CP_DEPT_SIMULATED_TI_IDX
    on EM_CP_DEPT_SIMULATED (TENANT_ID)
;
