create table em_sys_localization(
    ID               VARCHAR2(32) not null primary key,
    islocal       	 NUMBER(4)   DEFAULT 0,
    appzipfile    	 VARCHAR2(500)  default NULL,
    indexpage        VARCHAR2(500)  default NULL,
    query        	 VARCHAR2(500)  default NULL,
    baseurl   		VARCHAR2(500) default NULL,
    version        	VARCHAR2(200)   default NULL,
    minversion  	VARCHAR2(200)     default NULL,
    funtype        	NUMBER(4)    NOT NULL,
    targetid   		VARCHAR2(32)   default NULL
)
;
comment on table em_sys_localization is '系统支持本地化配置数据表'
;
comment on column em_sys_localization.ID is '主键ID'
;
comment on column em_sys_localization.islocal is '是否开启本地化：1-是，0-否（默认）'
;
comment on column em_sys_localization.appzipfile is '压缩文件下载路径'
;
comment on column em_sys_localization.indexpage is '压缩文件解压后的首页地址，第一层文件夹为解压后的文件夹名称'
;
comment on column em_sys_localization.query is '附加参数，会追加到访问路径后面'
;
comment on column em_sys_localization.baseurl is '离线应用的其他接口如果传输的是相对路径，那么会使用此地址作为请求的基础地址'
;
comment on column em_sys_localization.version is '版本号，字符串类型的整数值'
;
comment on column em_sys_localization.minversion is '小版本，字符串类型的整数值'
;
comment on column em_sys_localization.funtype is '本地化配置功能使用位置，类型，1-应用，2-打开人员卡片信息，3-修改密码等，如果该对象存在继承者，这个字段无效(目前类型为1的 保存在应用表 em_agent_base)'
;
comment on column em_sys_localization.targetid is '本地化配置功能使用位置，类型，1-应用，此时对于的应用id'
;