CREATE TABLE em_log_client_report(
  id VARCHAR(32) NOT NULL  PRIMARY KEY,
	base_user_id VARCHAR(32) NOT NULL,
	base_user_name VARCHAR(32),
	client_type NUMBER(4,0) DEFAULT 0,
	client_version VARCHAR(50),
	device_id VARCHAR(200),
	client_model VARCHAR(200),
	os_version VARCHAR(200),
	log_file_id VARCHAR(32),
	ip VARCHAR(200),
	create_time TIMESTAMP,
	tenant_id VARCHAR(32)
)
;
COMMENT ON TABLE em_log_client_report IS '客户端上报日志记录表'
;
COMMENT ON COLUMN em_log_client_report.id IS '主键'
;
COMMENT ON COLUMN em_log_client_report.base_user_id IS '用户ID'
;
COMMENT ON COLUMN em_log_client_report.base_user_name IS '用户名'
;
COMMENT ON COLUMN em_log_client_report.client_type IS '客户端类型： 1-PC客户端，2-IOS客户端，3-安卓客户端'
;
COMMENT ON COLUMN em_log_client_report.client_version IS '客户端版本号'
;
COMMENT ON COLUMN em_log_client_report.device_id IS '客户端硬件标识'
;
COMMENT ON COLUMN em_log_client_report.client_model IS '客户端设备型号'
;
COMMENT ON COLUMN em_log_client_report.os_version IS '客户端操作系统版本'
;
COMMENT ON COLUMN em_log_client_report.log_file_id IS '日志文件ID'
;
COMMENT ON COLUMN em_log_client_report.ip IS '客户端IP地址'
;
COMMENT ON COLUMN em_log_client_report.create_time IS '上报时间'
;
COMMENT ON COLUMN em_log_client_report.tenant_id IS '租户ID'
;