CREATE TABLE em_cp_domain_file (
  id  VARCHAR ( 32 ) NOT NULL PRIMARY KEY ,
  cp_corp_id  VARCHAR ( 32 ) NOT NULL ,
  media_id  VARCHAR ( 50 ) NOT NULL ,
  file_name   VARCHAR(2000) DEFAULT NULL ,
  STATUS NUMBER(4,0)  DEFAULT 1,
  create_user_id VARCHAR(32) DEFAULT NULL,
  create_time TIMESTAMP DEFAULT NULL,
  update_user_id VARCHAR(32) DEFAULT NULL,
  update_time TIMESTAMP DEFAULT NULL,
  tenant_id VARCHAR(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_cp_domain_file IS '可信域名文件上传记录'
;
COMMENT ON COLUMN em_cp_domain_file.id IS '主键ID'
;
COMMENT ON COLUMN em_cp_domain_file.cp_corp_id IS '文件所属的企业号主键id'
;
COMMENT ON COLUMN em_cp_domain_file.media_id IS '文件主键id'
;
COMMENT ON COLUMN em_cp_domain_file.file_name IS '文件带格式的名称'
;
COMMENT ON COLUMN em_cp_domain_file.status IS '状态'
;
COMMENT ON COLUMN em_cp_domain_file.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_cp_domain_file.create_time IS '创建时间'
;
COMMENT ON COLUMN em_cp_domain_file.update_user_id IS '最后修改人'
;
COMMENT ON COLUMN em_cp_domain_file.update_time IS '最后修改时间'
;
COMMENT ON COLUMN em_cp_domain_file.tenant_id IS '租户ID'
;
CREATE INDEX em_cp_domain_file_cp_corpid ON em_cp_domain_file(cp_corp_id)
;
DELETE FROM em_sys_cache_configuration WHERE cacheName ='emobile:common:cpdomain'
;
INSERT  INTO em_sys_cache_configuration(id,cacheName,maxEntriesLocalHeap,maxEntriesLocalDisk,eternal,clearOnFlush,timeToIdleSeconds,timeToLiveSeconds,diskSpoolBufferSizeMB,persistenceStrategy,diskExpiryThreadIntervalSecond,memoryStoreEvictionPolicy,transactionalMode,isDefaultCache,allow_remove) VALUES (em_sys_cache_configuration_seq.nextval,'emobile:common:cpdomain',100000,10000000,0,1,1800,1800,1024,'LOCALTEMPSWAP',120,'LRU','OFF',0,1)
;