CREATE TABLE em_sys_baseuser_device_right (
    id varchar(32) NOT NULL  PRIMARY KEY,
    hrm_data_id varchar(32) DEFAULT NULL,
    hrm_data_type number(4,0) DEFAULT NULL ,
    status number(4,0) DEFAULT 1 ,
    create_user_id varchar(32) DEFAULT NULL ,
    create_time TIMESTAMP DEFAULT NULL ,
    update_user_id varchar(32) DEFAULT NULL ,
    update_time TIMESTAMP DEFAULT NULL,
    tenant_id varchar(32) DEFAULT NULL
)
;
CREATE  INDEX  bind_device_right_h_idx ON em_sys_baseuser_device_right(hrm_data_id)
;
CREATE  INDEX bind_device_right_t_idx ON em_sys_baseuser_device_right(tenant_id)
;
COMMENT ON TABLE em_sys_baseuser_device_right IS '绑定设备适用范围设置表'
;
COMMENT ON COLUMN em_sys_baseuser_device_right.id IS 'id'
;
COMMENT ON COLUMN em_sys_baseuser_device_right.hrm_data_id IS '通讯录成员或部门表ID'
;
COMMENT ON COLUMN em_sys_baseuser_device_right.hrm_data_type IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;
COMMENT ON COLUMN em_sys_baseuser_device_right.status IS '状态 1-正常，3-删除'
;
COMMENT ON COLUMN em_sys_baseuser_device_right.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_sys_baseuser_device_right.create_time IS '创建时间'
;
COMMENT ON COLUMN em_sys_baseuser_device_right.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_sys_baseuser_device_right.update_time IS '修改时间'
;
COMMENT ON COLUMN em_sys_baseuser_device_right.tenant_id IS '企业租户ID'
;