CREATE TABLE em_oss_template_newtemp (
    id varchar(32) NOT NULL PRIMARY KEY,
    name varchar(255) DEFAULT NULL,
    strategy varchar(255) DEFAULT NULL CHECK (strategy IN ('ALIYUN','QCLOUD','QINIU','HUAWEIYUN','WPS')),
    setting CLOB,
    status NUMBER(4,0) DEFAULT NULL,
    create_user_id varchar(32) DEFAULT NULL,
    create_time TIMESTAMP DEFAULT NULL,
    update_user_id varchar(32) DEFAULT NULL,
    update_time TIMESTAMP DEFAULT NULL,
    tenant_id varchar(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_oss_template_newtemp is 'OSS模板设置表'
;
COMMENT ON COLUMN em_oss_template_newtemp.id IS '主键'
;
COMMENT ON COLUMN em_oss_template_newtemp.name IS 'OSS模板名称'
;
COMMENT ON COLUMN em_oss_template_newtemp.strategy IS 'OSS模板策略'
;
COMMENT ON COLUMN em_oss_template_newtemp.setting IS 'OSS模板设置参数（JSON数据）'
;
COMMENT ON COLUMN em_oss_template_newtemp.status IS '状态'
;
COMMENT ON COLUMN em_oss_template_newtemp.create_user_id IS '创建人'
;
COMMENT ON COLUMN em_oss_template_newtemp.create_time IS '创建时间'
;
COMMENT ON COLUMN em_oss_template_newtemp.update_user_id IS '修改人'
;
COMMENT ON COLUMN em_oss_template_newtemp.update_time IS '修改时间'
;
COMMENT ON COLUMN em_oss_template_newtemp.tenant_id IS '企业租户ID'
;

insert into em_oss_template_newtemp SELECT * from em_oss_template
;

DROP TABLE EM_OSS_TEMPLATE
;

ALTER TABLE em_oss_template_newtemp rename to em_oss_template
;

