CREATE TABLE em_agent_base_msgrobot (
  id varchar(32) PRIMARY KEY,   
  agent_base_id varchar(32) NOT NULL,
  bind_baseuser_id  VARCHAR(32) DEFAULT NULL,
  callback_url  VARCHAR(1000) DEFAULT NULL,
  msg_type  VARCHAR(1000) DEFAULT NULL ,
  token  VARCHAR(200) DEFAULT NULL ,
  secret  VARCHAR(200) DEFAULT NULL ,
  read_status  NUMBER(4,0) DEFAULT 1,
  server_id VARCHAR(32) DEFAULT NULL 
) 
;

COMMENT ON TABLE em_agent_base_msgrobot IS '消息机器人'
;
COMMENT ON COLUMN em_agent_base_msgrobot.id  IS '主键Id保持和agent_base_id一致方便逻辑处理'
;
COMMENT ON COLUMN em_agent_base_msgrobot.agent_base_id  IS '应用ID'
;
COMMENT ON COLUMN em_agent_base_msgrobot.bind_baseuser_id  IS '绑定基础用户'
;
COMMENT ON COLUMN em_agent_base_msgrobot.callback_url  IS  '机器人回调地址(http 接口地址)'
;
COMMENT ON COLUMN em_agent_base_msgrobot.msg_type  IS  '消息类型,RC:TxtMsg，RC:ImgMsg等'
;
COMMENT ON COLUMN em_agent_base_msgrobot.token  IS   '签名token'
;
COMMENT ON COLUMN em_agent_base_msgrobot.secret  IS   '加密密钥'
;
COMMENT ON COLUMN em_agent_base_msgrobot.read_status  IS  '阅读状态处理：1-关闭阅读状态、2-回调成功为已读、3-由机器人回执'
;
COMMENT ON COLUMN em_agent_base_msgrobot.server_id  IS '同步到消息服务的id,如果绑定基础用户应该是bind_baseuser_id，如果没有绑定用户应该是agent_base_id'
;

create index idx_agent_msgrobot_agentbaseid on em_agent_base_msgrobot(agent_base_id)
;
