CREATE TABLE EM_SYS_SQLFILE (
	ID SERIAL NOT NULL,
	SQLFILENAME VARCHAR(200) DEFAULT NULL,
	RUNDATE VARCHAR(10) DEFAULT NULL,
	RUNTIME VARCHAR(8) DEFAULT NULL,
	TENANTID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_SQLFILE IS 'sql文件执行记录表'
;

COMMENT ON COLUMN EM_SYS_SQLFILE.SQLFILENAME IS '文件名称'
;

COMMENT ON COLUMN EM_SYS_SQLFILE.RUNDATE IS '执行日期'
;

COMMENT ON COLUMN EM_SYS_SQLFILE.RUNTIME IS '执行时间'
;

COMMENT ON COLUMN EM_SYS_SQLFILE.TENANTID IS '租户id'
;

CREATE TABLE EM_CP_USER_SYNC_STATE (
	ID VARCHAR(32) NOT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	SYNC_TYPE SMALLINT DEFAULT NULL,
	SYNC_STATE SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_CP_USER_SYNC_STATE IS '企业号通讯录成员同步状态表'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_STATE.ID IS '主键ID'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_STATE.CP_CORP_ID IS '企业号基本信息ID'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_STATE.SYNC_TYPE IS '同步类型：1-从企业号同步 ，2-从集成系统同步'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_STATE.SYNC_STATE IS '同步状态：1-未同步，2-同步中'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_STATE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_STATE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_STATE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_STATE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_STATE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_MSG_GROUP_NOTICE (
	ID VARCHAR(32) NOT NULL,
	GROUP_ID VARCHAR(32) DEFAULT NULL,
	REMARK TEXT,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_MSG_GROUP_NOTICE IS '企业消息群组公告表'
;

COMMENT ON COLUMN EM_MSG_GROUP_NOTICE.ID IS '主键ID'
;

COMMENT ON COLUMN EM_MSG_GROUP_NOTICE.GROUP_ID IS '所属群组ID'
;

COMMENT ON COLUMN EM_MSG_GROUP_NOTICE.REMARK IS '公告内容'
;

COMMENT ON COLUMN EM_MSG_GROUP_NOTICE.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_MSG_GROUP_NOTICE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_MSG_GROUP_NOTICE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_MSG_GROUP_NOTICE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_MSG_GROUP_NOTICE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_MSG_GROUP_NOTICE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_AGENT_MSG_LOG_ALL (
	ID VARCHAR(32) NOT NULL,
	OPEN_AGENT_ID INT DEFAULT NULL,
	TARGET_TYPE SMALLINT DEFAULT '0',
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	CP_AGENT_ID VARCHAR(32) DEFAULT NULL,
	TOUSER TEXT,
	TOPARTY TEXT,
	TODEPT TEXT,
	TOTAG TEXT,
	MSGTYPE VARCHAR(10) DEFAULT NULL,
	SAFE SMALLINT DEFAULT '0',
	DATAINFO TEXT,
	REQUSETINFO TEXT,
	ERRCODE INT DEFAULT NULL,
	ERRMSG VARCHAR(1000) DEFAULT NULL,
	INVALIDUSER TEXT,
	INVALIDPARTY TEXT,
	INVALIDDEPT TEXT,
	INVALIDTAG TEXT,
	REALITYRECEIVERS TEXT,
	SOURCE_MSG_ID VARCHAR(100) DEFAULT NULL,
	SERVER_MSG_ID VARCHAR(100) DEFAULT NULL,
	SEND_TYPE SMALLINT DEFAULT '0',
	SEND_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	LOG_GROUP_ID VARCHAR(100) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;
COMMENT ON TABLE EM_AGENT_MSG_LOG_ALL IS '企业应用发送消息记录表'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.ID IS '主键ID'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.OPEN_AGENT_ID IS '企业应用openid'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.TARGET_TYPE IS '推送目标类型，0-无，1-E-mobile，2-企业号'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.CP_CORP_ID IS '推送目标的企业号ID，当目标类型为2时有效'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.CP_AGENT_ID IS '推送目标的企业号应用ID，当目标类型为2时有效'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.TOUSER IS '成员ID列表（消息接收者，多个接收者用‘|’分隔，最多支持1000个）。特殊情况：指定为@all，则向该企业应用的全部成员发送'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.TOPARTY IS '部门ID列表（包含下级），多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.TODEPT IS '部门ID列表（不包含下级），多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.TOTAG IS '标签ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.MSGTYPE IS '消息类型 text-文本，image-图片，voice-语音，video-视频，file-文件，news-图文'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.SAFE IS '表示是否是保密消息，0表示否，1表示是，默认0'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.DATAINFO IS '发送数据的详细信息，json格式的完整内容'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.REQUSETINFO IS '请求数据vo'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.ERRCODE IS '发送结果状态码'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.ERRMSG IS '错误信息'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.INVALIDUSER IS '无效的成员ID列表'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.INVALIDPARTY IS '无效的部门（包含下级）ID列表'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.INVALIDDEPT IS '无效的部门（不包含下级）ID列表'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.INVALIDTAG IS '无效的标签ID列表'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.REALITYRECEIVERS IS '消息发送实际上所有接收人id表'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.SOURCE_MSG_ID IS '消息数据原始ID，接口传入，不传则系统自动生成'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.SERVER_MSG_ID IS '消息数据在消息服务端的ID'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.SEND_TYPE IS '消息发送类型，1-立即发送，2-定时发送'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.SEND_TIME IS '消息发送时间，如果为定时发送，这里为定时发送时间'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.LOG_GROUP_ID IS '操作批次id'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_ALL.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_CHECKIN_SYNC_STATE (
	ID VARCHAR(32) NOT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	SYNC_STATE SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_CP_CHECKIN_SYNC_STATE IS '企业号考勤打卡数据同步状态表'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_STATE.ID IS '主键ID'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_STATE.CP_CORP_ID IS '企业号基本信息ID'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_STATE.SYNC_STATE IS '同步状态：1-未同步，2-同步中'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_STATE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_STATE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_STATE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_STATE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_STATE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_WORK_COND (
	ID SERIAL NOT NULL,
	WORK_COND_ICON VARCHAR(50) DEFAULT NULL,
	WORK_COND_TXT VARCHAR(1000) DEFAULT NULL,
	BASE_USER_ID VARCHAR(50) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_WORK_COND IS '基础用户工作状态默认数据表'
;

COMMENT ON COLUMN EM_SYS_WORK_COND.WORK_COND_ICON IS '工作状态图标'
;

COMMENT ON COLUMN EM_SYS_WORK_COND.BASE_USER_ID IS '基础用户id'
;


CREATE TABLE EM_CP_EXTERNAL_CONTACT (
	ID VARCHAR(32) NOT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	EXTERNAL_USER_ID VARCHAR(32) DEFAULT NULL,
	NAME VARCHAR(255) DEFAULT NULL,
	AVATAR VARCHAR(255) DEFAULT NULL,
	TYPE SMALLINT DEFAULT NULL,
	GENDER SMALLINT DEFAULT NULL,
	UNION_ID VARCHAR(255) DEFAULT NULL,
	POSITION VARCHAR(255) DEFAULT NULL,
	CORP_NAME VARCHAR(255) DEFAULT NULL,
	CORP_FULL_NAME VARCHAR(255) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_CP_EXTERNAL_CONTACT IS '外部联系人信息'
;

COMMENT ON COLUMN EM_CP_EXTERNAL_CONTACT.ID IS '主键'
;

COMMENT ON COLUMN EM_CP_EXTERNAL_CONTACT.CP_CORP_ID IS '企业号基本信息ID'
;

COMMENT ON COLUMN EM_CP_EXTERNAL_CONTACT.EXTERNAL_USER_ID IS '外部联系人的userid'
;

COMMENT ON COLUMN EM_CP_EXTERNAL_CONTACT.NAME IS '外部联系人的名称'
;

COMMENT ON COLUMN EM_CP_EXTERNAL_CONTACT.AVATAR IS '外部联系人头像，第三方不可获取'
;

COMMENT ON COLUMN EM_CP_EXTERNAL_CONTACT.TYPE IS '外部联系人的类型，1表示该外部联系人是微信用户，2表示该外部联系人是企业微信用户'
;

COMMENT ON COLUMN EM_CP_EXTERNAL_CONTACT.GENDER IS '外部联系人性别 0-未知 1-男性 2-女性'
;

COMMENT ON COLUMN EM_CP_EXTERNAL_CONTACT.UNION_ID IS '外部联系人在微信开放平台的唯一身份标识'
;

COMMENT ON COLUMN EM_CP_EXTERNAL_CONTACT.POSITION IS '外部联系人的职位'
;

COMMENT ON COLUMN EM_CP_EXTERNAL_CONTACT.CORP_NAME IS '外部联系人所在企业的简称'
;

COMMENT ON COLUMN EM_CP_EXTERNAL_CONTACT.CORP_FULL_NAME IS '外部联系人所在企业的主体名称'
;

COMMENT ON COLUMN EM_CP_EXTERNAL_CONTACT.STATUS IS '状态'
;

COMMENT ON COLUMN EM_CP_EXTERNAL_CONTACT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_EXTERNAL_CONTACT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_EXTERNAL_CONTACT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_EXTERNAL_CONTACT.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_EXTERNAL_CONTACT.TENANT_ID IS '租户ID'
;


CREATE TABLE EM_HRM_USER_SYNC_COND (
	ID VARCHAR(32) NOT NULL,
	OUTSYS_ID VARCHAR(32) DEFAULT NULL,
	COND_TYPE SMALLINT DEFAULT NULL,
	AUTH_TYPE SMALLINT DEFAULT NULL,
	AUTH_TYPE_NAME VARCHAR(255) DEFAULT NULL,
	AUTH_VALUE VARCHAR(32) DEFAULT NULL,
	AUTH_VALUE_NAME VARCHAR(255) DEFAULT NULL,
	AUTH_SECLEVEL VARCHAR(32) DEFAULT NULL,
	SHOWORDER INT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_HRM_USER_SYNC_COND IS '通讯录成员与集成系统人员同步条件表'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_COND.ID IS '主键ID'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_COND.OUTSYS_ID IS '集成系统ID'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_COND.COND_TYPE IS '条件类型：1-人员，2-部门，3-分部'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_COND.AUTH_TYPE IS '规则类型：0-人员，1-分部，2-部门，3-角色，4-所有人'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_COND.AUTH_TYPE_NAME IS '规则类型显示名'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_COND.AUTH_VALUE IS '规则类型值'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_COND.AUTH_VALUE_NAME IS '规则类型值显示名'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_COND.AUTH_SECLEVEL IS '规则安全级别'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_COND.SHOWORDER IS '显示顺序'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_COND.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_COND.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_COND.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_COND.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_COND.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_COND.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SC_PORTAL_CATEGORY (
	ID VARCHAR(32) NOT NULL,
	PORTAL_BASE_ID VARCHAR(32) DEFAULT NULL,
	CATEGORY_TYPE SMALLINT DEFAULT NULL,
	CATEGORY_NAME VARCHAR(50) DEFAULT NULL,
	ENGLISH_NAME VARCHAR(50) DEFAULT NULL,
	ISSHOWTITLE SMALLINT DEFAULT NULL,
	SHOWORDER INT DEFAULT NULL,
	ICON_DEFAULT VARCHAR(200) DEFAULT NULL,
	SET_VALUE VARCHAR(50) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_SC_PORTAL_CATEGORY IS '企业客户端门户分组信息表'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY.PORTAL_BASE_ID IS '主题ID'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY.CATEGORY_TYPE IS '分组类型：1-普通分组，2-其他应用，3-常用功能分组'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY.CATEGORY_NAME IS '分组名称'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY.ENGLISH_NAME IS '分组英文名称'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY.ISSHOWTITLE IS '是否显示分组标题：1-显示，0-不显示'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY.SHOWORDER IS '显示顺序'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY.ICON_DEFAULT IS '默认显示图标'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY.SET_VALUE IS '分组设置，针对常用功能分组设置显示的常用功能数量'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_MSG_RULE (
	ID VARCHAR(32) NOT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	RULE_NAME VARCHAR(50) DEFAULT NULL,
	RULE_DESC VARCHAR(500) DEFAULT NULL,
	CP_AGENT_ID VARCHAR(32) DEFAULT NULL,
	RELATE_AGENT_ID TEXT,
	MSG_TYPE SMALLINT DEFAULT NULL,
	OPEN_SENDER_ID VARCHAR(100) DEFAULT NULL,
	TEMPLATE_ID VARCHAR(100) DEFAULT NULL,
	TEMPLATE_CONTENT VARCHAR(100) DEFAULT NULL,
	TEMPLATE_TITLE VARCHAR(100) DEFAULT NULL,
	TEMPLATE_DESC VARCHAR(100) DEFAULT NULL,
	PUBACC_KEY VARCHAR(100) DEFAULT NULL,
	PUBACC_SECRET VARCHAR(100) DEFAULT NULL,
	SMS_APP_ID VARCHAR(100) DEFAULT NULL,
	SMS_SECRET VARCHAR(100) DEFAULT NULL,
	SMS_CONNECT_KEY VARCHAR(100) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	IS_REMIND SMALLINT DEFAULT '1',
	TASKCARD_BTN VARCHAR(1000) DEFAULT NULL,
	STATUS_BAR VARCHAR(1000) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_CP_MSG_RULE IS '企业号消息推送规则设置表'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.ID IS '主键ID'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.CP_CORP_ID IS '所属企业号ID'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.RULE_NAME IS '规则名称'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.RULE_DESC IS '规则描述信息'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.CP_AGENT_ID IS '推送目标，即企业号应用ID'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.RELATE_AGENT_ID IS '关联的本地消息型应用ID'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.MSG_TYPE IS '消息类型 1：文本  2：图文'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.OPEN_SENDER_ID IS '消息发送人ID'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.TEMPLATE_ID IS '消息模板ID'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.TEMPLATE_CONTENT IS '消息内容模板，对应文本类型'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.TEMPLATE_TITLE IS '消息标题模板，对应图文类型'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.TEMPLATE_DESC IS '消息描述模板，对应图文类型'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.PUBACC_KEY IS '云之家公共号账号'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.PUBACC_SECRET IS '云之家公共号秘钥'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.SMS_APP_ID IS '和飞信消息应用id'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.SMS_SECRET IS '和飞信消息应用鉴权秘钥'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.SMS_CONNECT_KEY IS '和飞信消息应用接入号'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.TENANT_ID IS '企业租户ID'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.IS_REMIND IS 'WeLink待办消息是否推送提醒消息：0-否 ，1-是'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.TASKCARD_BTN IS '企业微信任务卡片消息按钮配置'
;

COMMENT ON COLUMN EM_CP_MSG_RULE.STATUS_BAR IS '钉钉OA消息状态栏配置'
;


CREATE TABLE EM_SC_FUNC (
	ID VARCHAR(32) NOT NULL,
	CLIENT_TYPE SMALLINT DEFAULT NULL,
	SET_TYPE SMALLINT DEFAULT NULL,
	ICON_UNSELECTED VARCHAR(32) DEFAULT NULL,
	ICON_SELECTED VARCHAR(32) DEFAULT NULL,
	SHOW_NAME VARCHAR(20) DEFAULT NULL,
	SHOW_NAME_EN VARCHAR(20) DEFAULT NULL,
	SHOW_ORDER DECIMAL(10, 2) DEFAULT NULL,
	FUNC_TYPE INT DEFAULT NULL,
	FUNC_VALUE VARCHAR(200) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_SC_FUNC IS '企业客户端功能设置表'
;

COMMENT ON COLUMN EM_SC_FUNC.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SC_FUNC.CLIENT_TYPE IS '客户端类型 1-移动APP，2-PC客户端，3-web客户端'
;

COMMENT ON COLUMN EM_SC_FUNC.SET_TYPE IS '设置项类型 1-顶部右上角功能，2-导航栏功能'
;

COMMENT ON COLUMN EM_SC_FUNC.ICON_UNSELECTED IS '未选中图标'
;

COMMENT ON COLUMN EM_SC_FUNC.ICON_SELECTED IS '已选中图标'
;

COMMENT ON COLUMN EM_SC_FUNC.SHOW_NAME IS '显示名称'
;

COMMENT ON COLUMN EM_SC_FUNC.SHOW_NAME_EN IS '英文显示名称'
;

COMMENT ON COLUMN EM_SC_FUNC.SHOW_ORDER IS '显示顺序'
;

COMMENT ON COLUMN EM_SC_FUNC.FUNC_TYPE IS '功能类型'
;

COMMENT ON COLUMN EM_SC_FUNC.FUNC_VALUE IS '功能扩展值'
;

COMMENT ON COLUMN EM_SC_FUNC.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_SC_FUNC.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SC_FUNC.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SC_FUNC.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SC_FUNC.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SC_FUNC.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SH_RIGHT_DATA (
	ID VARCHAR(32) NOT NULL,
	RIGHT_BASE_ID VARCHAR(32) DEFAULT NULL,
	RIGHT_TYPE INT DEFAULT '1',
	RIGHT_FIELD_ID VARCHAR(32) DEFAULT NULL,
	PERMIT_TYPE SMALLINT DEFAULT '1',
	HRM_DATA_TYPE SMALLINT DEFAULT NULL,
	HRM_DATA_ID VARCHAR(32) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_SH_RIGHT_DATA IS '企业通讯录权限规则数据表'
;

COMMENT ON COLUMN EM_SH_RIGHT_DATA.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SH_RIGHT_DATA.RIGHT_BASE_ID IS '权限设置基础ID'
;

COMMENT ON COLUMN EM_SH_RIGHT_DATA.RIGHT_TYPE IS '权限类型：1-查看，2-发消息，3-打电话，9-查看具体字段'
;

COMMENT ON COLUMN EM_SH_RIGHT_DATA.RIGHT_FIELD_ID IS '查看具体字段的ID，当值为1时表示手机号，否则为em_hrm_user_attr表的ID值'
;

COMMENT ON COLUMN EM_SH_RIGHT_DATA.PERMIT_TYPE IS '允许或禁止：1-允许，2-禁止'
;

COMMENT ON COLUMN EM_SH_RIGHT_DATA.HRM_DATA_TYPE IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级），5-本部门（含下级），6-本部门（不含下级）'
;

COMMENT ON COLUMN EM_SH_RIGHT_DATA.HRM_DATA_ID IS '通讯录成员或部门表ID'
;

COMMENT ON COLUMN EM_SH_RIGHT_DATA.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_SH_RIGHT_DATA.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SH_RIGHT_DATA.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SH_RIGHT_DATA.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SH_RIGHT_DATA.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SH_RIGHT_DATA.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_VIDEO_SETTING (
	ID VARCHAR(32) NOT NULL,
	ENABLED SMALLINT DEFAULT NULL,
	APP_ID VARCHAR(100) DEFAULT NULL,
	APP_CERTIFICATE VARCHAR(100) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_VIDEO_SETTING IS '音视频设置信息'
;

COMMENT ON COLUMN EM_SYS_VIDEO_SETTING.ENABLED IS '是否开启消息服务：0-禁用、1-开启'
;

COMMENT ON COLUMN EM_SYS_VIDEO_SETTING.APP_ID IS '接入的appId'
;

COMMENT ON COLUMN EM_SYS_VIDEO_SETTING.APP_CERTIFICATE IS '接入的appCertificate'
;

COMMENT ON COLUMN EM_SYS_VIDEO_SETTING.STATUS IS '状态'
;

COMMENT ON COLUMN EM_SYS_VIDEO_SETTING.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_VIDEO_SETTING.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_VIDEO_SETTING.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_VIDEO_SETTING.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_VIDEO_SETTING.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_BASE_USER (
	ID VARCHAR(32) NOT NULL,
	USER_TYPE SMALLINT DEFAULT NULL,
	USER_NAME VARCHAR(100) DEFAULT NULL,
	NAME_SIMPLE_PINGYIN VARCHAR(500) DEFAULT NULL,
	NAME_FULL_PINGYIN VARCHAR(500) DEFAULT NULL,
	LOGINID VARCHAR(50) DEFAULT NULL,
	USER_PASSWORD VARCHAR(100) DEFAULT NULL,
	SALT VARCHAR(20) DEFAULT NULL,
	NICK_NAME VARCHAR(100) DEFAULT NULL,
	MOBILE VARCHAR(1000) DEFAULT NULL,
	MOBILE_PREFIX VARCHAR(32) DEFAULT NULL,
	EMAIL VARCHAR(100) DEFAULT NULL,
	AVATAR VARCHAR(255) DEFAULT NULL,
	GENDER SMALLINT DEFAULT '0',
	BIRTHDAY DATE DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	MAIN_TENANT_ID VARCHAR(32) DEFAULT NULL,
	WEB_THEME_ID VARCHAR(32) DEFAULT NULL,
	PC_THEME_ID VARCHAR(32) DEFAULT NULL,
	APP_THEME_ID VARCHAR(32) DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	WORK_COND_ICON VARCHAR(50) DEFAULT NULL,
	WORK_COND_TXT VARCHAR(1000) DEFAULT NULL,
	SERVER_BASE_USER_ID VARCHAR(200) DEFAULT NULL,
	IM_BASE_USER_ID VARCHAR(200) DEFAULT NULL,
	ISSYSADMIN SMALLINT DEFAULT '0',
	REGIST_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_BASE_USER IS '基础用户表'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.USER_TYPE IS '用户类型 1-真实用户，2-应用管理，3-接口管理组'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.USER_NAME IS '姓名'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.NAME_SIMPLE_PINGYIN IS '名字拼音简拼'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.NAME_FULL_PINGYIN IS '名字拼音全拼'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.LOGINID IS '登录名'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.USER_PASSWORD IS '登录密码'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.SALT IS '盐-用于密码加密'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.NICK_NAME IS '昵称'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.MOBILE_PREFIX IS '国际手机区号'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.EMAIL IS '邮箱'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.AVATAR IS '头像'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.GENDER IS '性别 1表示男性，2表示女性，0表示未知'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.BIRTHDAY IS '生日'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.STATUS IS '状态 1-已注册，2-未注册，3-删除'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.MAIN_TENANT_ID IS '主租户ID'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.WEB_THEME_ID IS '设定的web端默认主题'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.PC_THEME_ID IS '设定的pc端默认主题'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.APP_THEME_ID IS '设定的app移动端默认主题'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.WORK_COND_ICON IS '工作状态图标'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.IM_BASE_USER_ID IS '同步到im消息的同步数据id'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.ISSYSADMIN IS '是否为系统管理'
;

COMMENT ON COLUMN EM_SYS_BASE_USER.REGIST_TIME IS '注册时间'
;


CREATE TABLE EM_SYS_SEARCH_SETTING (
	ID VARCHAR(32) NOT NULL,
	ENABLE_SEARCH SMALLINT DEFAULT NULL,
	INPUT_SEARCH_TYPE SMALLINT DEFAULT NULL,
	INPUT_SEARCH_CONTACT SMALLINT DEFAULT '0',
	INPUT_SEARCH_GROUP SMALLINT DEFAULT '0',
	DETAIL_SEARCH_GROUP SMALLINT DEFAULT NULL,
	DETAIL_SEARCH_MSG SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	INPUT_SEARCH_AGENT SMALLINT DEFAULT '0',
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_SEARCH_SETTING IS '搜索设置信息'
;

COMMENT ON COLUMN EM_SYS_SEARCH_SETTING.ENABLE_SEARCH IS '是否开启搜索功能：0-禁用、1-开启(默认)'
;

COMMENT ON COLUMN EM_SYS_SEARCH_SETTING.INPUT_SEARCH_TYPE IS '搜索框搜索方式：1-默认、2-自定义'
;

COMMENT ON COLUMN EM_SYS_SEARCH_SETTING.INPUT_SEARCH_CONTACT IS '搜索框是否搜索通讯录：0-不搜索、1-搜索，搜索方式为默认时有效'
;

COMMENT ON COLUMN EM_SYS_SEARCH_SETTING.INPUT_SEARCH_GROUP IS '搜索框是否搜索群组：0-不搜索、1-搜索，搜索方式为默认时有效'
;

COMMENT ON COLUMN EM_SYS_SEARCH_SETTING.DETAIL_SEARCH_GROUP IS '是否开启详细搜索群组：0-不开启，1-开启(默认)'
;

COMMENT ON COLUMN EM_SYS_SEARCH_SETTING.DETAIL_SEARCH_MSG IS '是否开启详细搜索消息：0-不开启，1-开启(默认)'
;

COMMENT ON COLUMN EM_SYS_SEARCH_SETTING.STATUS IS '状态'
;

COMMENT ON COLUMN EM_SYS_SEARCH_SETTING.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_SEARCH_SETTING.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_SEARCH_SETTING.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_SEARCH_SETTING.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_SEARCH_SETTING.TENANT_ID IS '企业租户ID'
;

COMMENT ON COLUMN EM_SYS_SEARCH_SETTING.INPUT_SEARCH_AGENT IS '搜索框是否搜索应用：0-不搜索、1-搜索，搜索方式为默认时有效'
;


CREATE TABLE EM_AGENT_BASE_MSGMENU (
	ID VARCHAR(32) NOT NULL,
	AGENT_BASE_ID VARCHAR(32) NOT NULL,
	ISSYS SMALLINT DEFAULT '0',
	MSGTYPE VARCHAR(500) DEFAULT NULL,
	ISMULTIPLE SMALLINT DEFAULT NULL,
	OPEN_TYPE SMALLINT DEFAULT NULL,
	WIN_WIDTH INT DEFAULT NULL,
	WIN_HEIGHT INT DEFAULT NULL,
	SHOWORDER DECIMAL(10, 2) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_AGENT_BASE_MSGMENU IS '消息菜单配置信息表'
;

COMMENT ON COLUMN EM_AGENT_BASE_MSGMENU.ID IS '主键ID'
;

COMMENT ON COLUMN EM_AGENT_BASE_MSGMENU.AGENT_BASE_ID IS '应用ID'
;

COMMENT ON COLUMN EM_AGENT_BASE_MSGMENU.ISSYS IS '是否系统默认,系统默认的菜单按钮不允许修改'
;

COMMENT ON COLUMN EM_AGENT_BASE_MSGMENU.MSGTYPE IS '适用消息类型：1-文本消息，2-图片消息，3-表情消息，4-语音消息，5-位置消息，6-文件，适用于多个类型时用逗号分隔表示'
;

COMMENT ON COLUMN EM_AGENT_BASE_MSGMENU.ISMULTIPLE IS '是否支持消息多选，1-是，0-否'
;

COMMENT ON COLUMN EM_AGENT_BASE_MSGMENU.OPEN_TYPE IS '菜单点击打开目标方式，1-窗口，2-浏览器'
;

COMMENT ON COLUMN EM_AGENT_BASE_MSGMENU.WIN_WIDTH IS '如果是打开窗口，窗口宽带，单位像素px'
;

COMMENT ON COLUMN EM_AGENT_BASE_MSGMENU.WIN_HEIGHT IS '如果是打开窗口，窗口高度，单位像素px'
;

COMMENT ON COLUMN EM_AGENT_BASE_MSGMENU.SHOWORDER IS '显示顺序'
;


CREATE TABLE EM_MSG_GROUP_DEPT (
	ID VARCHAR(32) NOT NULL,
	GROUP_ID VARCHAR(50) DEFAULT NULL,
	DEPT_ID VARCHAR(32) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_MSG_GROUP_DEPT IS '部门群数据表'
;

COMMENT ON COLUMN EM_MSG_GROUP_DEPT.GROUP_ID IS '群组ID'
;

COMMENT ON COLUMN EM_MSG_GROUP_DEPT.DEPT_ID IS '部门ID'
;

COMMENT ON COLUMN EM_MSG_GROUP_DEPT.STATUS IS '状态'
;

COMMENT ON COLUMN EM_MSG_GROUP_DEPT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_MSG_GROUP_DEPT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_MSG_GROUP_DEPT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_MSG_GROUP_DEPT.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_MSG_GROUP_DEPT.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_MSG_GROUP_MEMBER (
	ID VARCHAR(32) NOT NULL,
	GROUP_ID VARCHAR(32) DEFAULT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	MEMBER_TYPE SMALLINT DEFAULT '3',
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_MSG_GROUP_MEMBER IS '企业消息群组成员表'
;

COMMENT ON COLUMN EM_MSG_GROUP_MEMBER.ID IS '主键ID'
;

COMMENT ON COLUMN EM_MSG_GROUP_MEMBER.GROUP_ID IS '所属群组ID'
;

COMMENT ON COLUMN EM_MSG_GROUP_MEMBER.BASE_USER_ID IS '成员基础用户ID'
;

COMMENT ON COLUMN EM_MSG_GROUP_MEMBER.MEMBER_TYPE IS '成员类型 1-群主，2-管理员，3-普通成员'
;

COMMENT ON COLUMN EM_MSG_GROUP_MEMBER.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_MSG_GROUP_MEMBER.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_MSG_GROUP_MEMBER.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_MSG_GROUP_MEMBER.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_MSG_GROUP_MEMBER.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_MSG_GROUP_MEMBER.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_MSG_SETTING (
	ID VARCHAR(32) NOT NULL,
	ENABLE_PUSH SMALLINT DEFAULT NULL,
	API_IP VARCHAR(255) DEFAULT NULL,
	PC_API_IP VARCHAR(255) DEFAULT NULL,
	APP_API_IP VARCHAR(255) DEFAULT NULL,
	SERVER_ENCRYPT SMALLINT DEFAULT '0',
	SERVER_PORT VARCHAR(10) DEFAULT NULL,
	SERVER_KEY VARCHAR(255) DEFAULT NULL,
	SERVER_SECRECT VARCHAR(255) DEFAULT NULL,
	MSG_DOMAIN VARCHAR(32) DEFAULT NULL,
	PC_ENCRYPT SMALLINT DEFAULT '0',
	PC_PORT VARCHAR(10) DEFAULT NULL,
	APP_ENCRYPT SMALLINT DEFAULT '0',
	APP_PORT VARCHAR(10) DEFAULT NULL,
	FILE_SAVE_TYPE SMALLINT DEFAULT '1',
	FILE_SAVE_OUTSYSID VARCHAR(32) DEFAULT NULL,
	FILE_AUTO_DEL SMALLINT DEFAULT NULL,
	FILE_DEL_DAYS INT DEFAULT NULL,
	FILE_SIZE_LIMIT INT DEFAULT NULL,
	FILE_PREVIEW SMALLINT DEFAULT NULL,
	FILE_PREVIEW_OUTSYSID VARCHAR(50) DEFAULT NULL,
	FILE_PREVIEW_TYPES VARCHAR(100) DEFAULT NULL,
	REVOKE_LIMIT INT DEFAULT NULL,
	GROUP_LIMIT INT DEFAULT NULL,
	READ_STATE SMALLINT DEFAULT NULL,
	READ_STATE_LIMIT INT DEFAULT NULL,
	ONLINE_STATE SMALLINT DEFAULT NULL,
	DEL_MSG SMALLINT DEFAULT NULL,
	SECRET_CHAT SMALLINT DEFAULT NULL,
	WATERMARK SMALLINT DEFAULT NULL,
	DING_CHAT SMALLINT DEFAULT NULL,
	DING_FUNC VARCHAR(10) DEFAULT NULL,
	DING_SMS_ID VARCHAR(32) DEFAULT NULL,
	COMM_PHRASE SMALLINT DEFAULT NULL,
	PC_SHAKE SMALLINT DEFAULT NULL,
	CREATE_CHAT SMALLINT DEFAULT NULL,
	ENABLE_GET_PHRASE SMALLINT DEFAULT NULL,
	GET_PHRASE_OUTSYSID VARCHAR(100) DEFAULT NULL,
	UNITE_FORWARD SMALLINT DEFAULT NULL,
	UNITE_COUNT SMALLINT DEFAULT NULL,
	CREATE_GROUP SMALLINT DEFAULT NULL,
	CHAT_PHOTO SMALLINT DEFAULT NULL,
	CHAT_FILE SMALLINT DEFAULT NULL,
	CHAT_FILE_RECEIVE SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_MSG_SETTING IS '消息设置信息'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.ENABLE_PUSH IS '是否开启消息服务：0-禁用、1-开启'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.API_IP IS '消息引擎服务IP地址'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.PC_API_IP IS 'pc端服务ip地址'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.APP_API_IP IS '移动端服务ip地址'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.SERVER_ENCRYPT IS '消息引擎供服务端调用是否加密'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.SERVER_PORT IS '消息引擎供服务端调用端口'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.SERVER_KEY IS '消息引擎供服务端调用接口账号'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.SERVER_SECRECT IS '消息引擎供服务端调用接口秘钥'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.MSG_DOMAIN IS 'msg_domain'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.PC_ENCRYPT IS '消息引擎供PC客户端调用是否加密'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.PC_PORT IS '消息引擎供PC客户端调用端口'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.APP_ENCRYPT IS '消息引擎供移动客户端调用是否加密'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.APP_PORT IS '消息引擎供移动客户端调用端口'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.FILE_SAVE_TYPE IS '聊天文件存储方式 1:本系统存储 2:同过ecology系统存储'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.FILE_SAVE_OUTSYSID IS '聊天文件存储到ecology系统时，对应的集成ecology系统id'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.FILE_AUTO_DEL IS '是否开启定时删除聊天文件：1-是、0-否，默认为否'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.FILE_DEL_DAYS IS '定时删除聊天文件周期，即删除n天之前的文件数据'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.FILE_SIZE_LIMIT IS '消息传输文件限制大小，单位M'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.FILE_PREVIEW IS '是否开启在线预览功能，0表示未开启，1表示开启'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.FILE_PREVIEW_OUTSYSID IS '文档预览使用的集成系统id'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.FILE_PREVIEW_TYPES IS '可以预览的文件类型，返回多个后缀名称，用逗号分隔，例如：doc,docx,xls,xlsx,ppt'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.REVOKE_LIMIT IS '消息撤销时间限制，单位为秒，0表示不限制'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.GROUP_LIMIT IS '群成员人数上限'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.READ_STATE IS '是否开启消息阅读状态 1-是 0-否'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.READ_STATE_LIMIT IS '自动关闭阅读状态的群组人数'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.ONLINE_STATE IS '是否开启在线状态'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.DEL_MSG IS '是否开启删除消息功能 1-是 0-否'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.SECRET_CHAT IS '是否开启密聊 1-是 0-否'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.WATERMARK IS '是否开启聊天窗口水印 1-是 0-否'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.DING_CHAT IS '是否开启必达 1-是 0-否'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.DING_FUNC IS '必达功能项 1-短信 2-电话,多个功能用逗号分隔，如1,2'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.DING_SMS_ID IS '必达功能中发送短信对应的短信服务ID'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.COMM_PHRASE IS '是否开启常用短语 1-是 0-否'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.PC_SHAKE IS '是否开启PC端抖一抖功能 1-是 0-否'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.ENABLE_GET_PHRASE IS '是否开启从集成系统获取常用短语数据：1-是、0-否'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.GET_PHRASE_OUTSYSID IS '从集成系统获取常用短语数据对应的系统ID'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.UNITE_FORWARD IS '是否开启合并转发 默认开启'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.UNITE_COUNT IS '合并最大数量  默认50 最大不超过100'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.CREATE_GROUP IS '是否创建群聊'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.CHAT_PHOTO IS '是否开启聊天图片,全部开启(1)、只开启移动端(2)、只开启PC端(3)、全部关闭(4)'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.CHAT_FILE IS '是否开启聊天文件,全部开启(1)、只开启移动端(2)、只开启PC端(3)、全部关闭(4)'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.CHAT_FILE_RECEIVE IS '是否开启下载文件,全部开启(1)、只开启移动端(2)、只开启PC端(3)、全部关闭(4)'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.STATUS IS '状态'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_MSG_SETTING.TENANT_ID IS '企业租户ID'
;


CREATE TABLE QRTZ_PAUSED_TRIGGER_GRPS (
	SCHED_NAME VARCHAR(120) NOT NULL,
	TRIGGER_GROUP VARCHAR(190) NOT NULL,
	PRIMARY KEY (SCHED_NAME, TRIGGER_GROUP)
)
;


CREATE TABLE EM_CP_USER_EXTERNAL_CONTACT (
	ID VARCHAR(32) NOT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	OPEN_USER_ID VARCHAR(32) DEFAULT NULL,
	EXTERNAL_USER_ID VARCHAR(32) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_CP_USER_EXTERNAL_CONTACT IS '企业内部人员于外部联系人关联关系'
;

COMMENT ON COLUMN EM_CP_USER_EXTERNAL_CONTACT.ID IS '主键'
;

COMMENT ON COLUMN EM_CP_USER_EXTERNAL_CONTACT.CP_CORP_ID IS '企业号基本信息ID'
;

COMMENT ON COLUMN EM_CP_USER_EXTERNAL_CONTACT.OPEN_USER_ID IS '用户在企业号内的唯一标识'
;

COMMENT ON COLUMN EM_CP_USER_EXTERNAL_CONTACT.EXTERNAL_USER_ID IS '外部联系人的userid'
;

COMMENT ON COLUMN EM_CP_USER_EXTERNAL_CONTACT.STATUS IS '状态'
;

COMMENT ON COLUMN EM_CP_USER_EXTERNAL_CONTACT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_USER_EXTERNAL_CONTACT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_USER_EXTERNAL_CONTACT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_USER_EXTERNAL_CONTACT.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_USER_EXTERNAL_CONTACT.TENANT_ID IS '租户ID'
;


CREATE TABLE EM_SYS_HRM_SETTING (
	ID VARCHAR(32) NOT NULL,
	ENABLE_MOBILE_CONTACTS SMALLINT DEFAULT '1',
	ENABLE_MY_GROUP SMALLINT DEFAULT '1',
	ENABLE_MY_ATTEND SMALLINT DEFAULT '1',
	ENABLE_ORG SMALLINT DEFAULT '1',
	ENABLE_MY_DEPT SMALLINT DEFAULT '1',
	ENABLE_MY_BRANCH SMALLINT DEFAULT NULL,
	ENABLE_MY_SUB SMALLINT DEFAULT '1',
	ENABLE_COMM_GROUP SMALLINT DEFAULT '1',
	ENABLE_COMM_CONTACTS SMALLINT DEFAULT '1',
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_HRM_SETTING IS '通讯录设置'
;

COMMENT ON COLUMN EM_SYS_HRM_SETTING.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SYS_HRM_SETTING.ENABLE_MOBILE_CONTACTS IS '是否开启手机联系人(0-禁用,1-开启)'
;

COMMENT ON COLUMN EM_SYS_HRM_SETTING.ENABLE_MY_GROUP IS '是否开启我的群组(0-禁用,1-开启)'
;

COMMENT ON COLUMN EM_SYS_HRM_SETTING.ENABLE_MY_ATTEND IS '是否开启我的关注(0-禁用,1-开启)'
;

COMMENT ON COLUMN EM_SYS_HRM_SETTING.ENABLE_ORG IS '是否开启组织架构(0-禁用,1-开启)'
;

COMMENT ON COLUMN EM_SYS_HRM_SETTING.ENABLE_MY_DEPT IS '是否开启我的部门(0-禁用,1-开启)'
;

COMMENT ON COLUMN EM_SYS_HRM_SETTING.ENABLE_MY_BRANCH IS '是否开启我的分部门(0-禁用,1-开启)'
;

COMMENT ON COLUMN EM_SYS_HRM_SETTING.ENABLE_MY_SUB IS '是否开启我的下属(0-禁用,1-开启)'
;

COMMENT ON COLUMN EM_SYS_HRM_SETTING.ENABLE_COMM_GROUP IS '是否开启常用组(0-禁用,1-开启)'
;

COMMENT ON COLUMN EM_SYS_HRM_SETTING.ENABLE_COMM_CONTACTS IS '是否开启常用联系人(0-禁用,1-开启)'
;

COMMENT ON COLUMN EM_SYS_HRM_SETTING.STATUS IS '状态'
;

COMMENT ON COLUMN EM_SYS_HRM_SETTING.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_HRM_SETTING.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_HRM_SETTING.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_HRM_SETTING.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_HRM_SETTING.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_SQL_EXECUTE_RECORD (
	ID VARCHAR(32) NOT NULL,
	EXECUTE_SQL TEXT,
	UPDATE_COUNT BIGINT DEFAULT NULL,
	CONSUME_TIME BIGINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_SQL_EXECUTE_RECORD IS 'sql执行记录'
;

COMMENT ON COLUMN EM_SYS_SQL_EXECUTE_RECORD.ID IS '主键'
;

COMMENT ON COLUMN EM_SYS_SQL_EXECUTE_RECORD.EXECUTE_SQL IS '执行的sql内容'
;

COMMENT ON COLUMN EM_SYS_SQL_EXECUTE_RECORD.UPDATE_COUNT IS 'sql影响行数'
;

COMMENT ON COLUMN EM_SYS_SQL_EXECUTE_RECORD.CONSUME_TIME IS 'sql执行耗时'
;

COMMENT ON COLUMN EM_SYS_SQL_EXECUTE_RECORD.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_SQL_EXECUTE_RECORD.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_SQL_EXECUTE_RECORD.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_LOGIN_SETTING (
	ID VARCHAR(32) NOT NULL,
	LOGIN_TYPE SMALLINT DEFAULT NULL,
	LOGIN_DEFAULT_RIGHT SMALLINT DEFAULT NULL,
	WELCOME_BG_IMG VARCHAR(200) DEFAULT NULL,
	WELCOME_TIME SMALLINT DEFAULT NULL,
	WELCOME_CYCLE_TIME SMALLINT DEFAULT NULL,
	CURRENT_WELCOME_IMG VARCHAR(32) DEFAULT NULL,
	CURRENT_WELCOME_IMG_SAVE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	WELCOME_SPEECH_TXT VARCHAR(100) DEFAULT NULL,
	WELCOME_SPEECH_COLOR VARCHAR(10) DEFAULT NULL,
	LOGIN_LOGO VARCHAR(32) DEFAULT NULL,
	LOGIN_BG_COLOR VARCHAR(10) DEFAULT NULL,
	LOGIN_BG_IMG VARCHAR(32) DEFAULT NULL,
	LOGIN_BTN_BG_COLOR VARCHAR(10) DEFAULT NULL,
	LOGIN_BTN_TXT_COLOR VARCHAR(10) DEFAULT NULL,
	LOGIN_FUNC_TXT_COLOR VARCHAR(10) DEFAULT NULL,
	LOGIN_FOOT_TXT VARCHAR(100) DEFAULT NULL,
	LOGIN_FOOT_COLOR VARCHAR(10) DEFAULT NULL,
	LOGIN_INPUT_COLOR VARCHAR(200) DEFAULT NULL,
	CUSTOM_LOGIN_PAGE VARCHAR(200) DEFAULT NULL,
	CUSTOM_LOGIN_SETTING VARCHAR(200) DEFAULT NULL,
	ENABLE_DEVICE_BIND SMALLINT DEFAULT NULL,
	ENABLE_AUTO_BIND SMALLINT DEFAULT NULL,
	ENABLE_BIND_VERIFY SMALLINT DEFAULT NULL,
	BIND_VERIFY_TYPE SMALLINT DEFAULT NULL,
	IS_DEVICE_BIND SMALLINT DEFAULT '-1',
	DEVICE_BIND_SMS_ID VARCHAR(32) DEFAULT NULL,
	SEND_EMAIL_TYPE SMALLINT DEFAULT '1',
	DEVICE_BIND_EMAIL_SYS_ID VARCHAR(32) DEFAULT NULL,
	DEVICE_BIND_LIMIT INT DEFAULT NULL,
	PRIVACY_ENABLE_LOGIN SMALLINT DEFAULT NULL,
	PRIVACY_LOGIN_CHECK SMALLINT DEFAULT NULL,
	PRIVACY_LOGIN_DEFAULT SMALLINT DEFAULT NULL,
	PRIVACY_LOGIN_TXT VARCHAR(2000) DEFAULT NULL,
	PRIVACY_LOGIN_COLOR VARCHAR(20) DEFAULT NULL,
	PRIVACY_LOGIN_LINK VARCHAR(200) DEFAULT NULL,
	PRIVACY_LOGIN_TIPS VARCHAR(800) DEFAULT NULL,
	PRIVACY_ENABLE_ABOUT SMALLINT DEFAULT NULL,
	PRIVACY_ABOUT_TXT VARCHAR(400) DEFAULT NULL,
	PRIVACY_ABOUT_LINK VARCHAR(200) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	RIGHT_TYPE SMALLINT NOT NULL DEFAULT '1',
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_LOGIN_SETTING IS '系统登录前设置'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.LOGIN_TYPE IS '登录类型 1- 本系统登录，2-ec登录，3-自定义登录页面'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.LOGIN_DEFAULT_RIGHT IS '默认用户是否有登录权限'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.WELCOME_TIME IS '欢迎页播放时间，单位秒'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.WELCOME_CYCLE_TIME IS '欢迎页轮播时间'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.CURRENT_WELCOME_IMG IS '当前欢迎页图片mediaId'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.CURRENT_WELCOME_IMG_SAVE_TIME IS '当前欢迎页的保存时间'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.WELCOME_SPEECH_TXT IS '欢迎词'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.WELCOME_SPEECH_COLOR IS '欢迎词字体颜色'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.LOGIN_LOGO IS '登录页LOGO'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.LOGIN_BG_COLOR IS '登录页背景颜色'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.LOGIN_BG_IMG IS '登录页背景图片'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.LOGIN_BTN_BG_COLOR IS '登录按钮背景颜色'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.LOGIN_BTN_TXT_COLOR IS '登录按钮文字颜色'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.LOGIN_FUNC_TXT_COLOR IS '功能按钮文字颜色'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.LOGIN_FOOT_TXT IS '登录页底部文字'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.LOGIN_FOOT_COLOR IS '登录页底部文字颜色'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.LOGIN_INPUT_COLOR IS '输入框文字颜色'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.CUSTOM_LOGIN_PAGE IS '自定义登录页面地址'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.CUSTOM_LOGIN_SETTING IS '当为自定义登录时使用的登录逻辑实现设置impl,或登录http请求地址'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.ENABLE_DEVICE_BIND IS '是否开启硬件绑定功能： 1-是、 0-否'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.ENABLE_AUTO_BIND IS '是否开启首次登录自动绑定： 1-是、 0-否'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.ENABLE_BIND_VERIFY IS '是否开启新设备绑定验证:1-是、0-否'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.BIND_VERIFY_TYPE IS '新设备绑定验证类型，1-短信(默认)，2-邮件'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.IS_DEVICE_BIND IS '是否开启单个设备绑定单个账号 -1-关闭 大于0代表允许绑定的数量'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.DEVICE_BIND_SMS_ID IS '新设备绑定发送短信验证码时使用的短信服务ID'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.SEND_EMAIL_TYPE IS '邮件类型，1：内部邮件，2：外部邮件'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.DEVICE_BIND_EMAIL_SYS_ID IS '新设备绑定验证类型，1-短信(默认)，2-邮件'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.DEVICE_BIND_LIMIT IS '绑定设备数量限制，-1或空,0表示不限制'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.PRIVACY_ENABLE_LOGIN IS '是否开启APP登录界面上隐私协议'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.PRIVACY_LOGIN_CHECK IS '隐私选择框是否允许修改,1-是，0-否'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.PRIVACY_LOGIN_DEFAULT IS '隐私选择框默认值,1-是，0-否'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.PRIVACY_LOGIN_TXT IS '协议文字内容'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.PRIVACY_LOGIN_COLOR IS '协议文字颜色'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.PRIVACY_LOGIN_LINK IS '隐私协议链接地址'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.PRIVACY_LOGIN_TIPS IS '隐私协议未勾选时提示文字'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.PRIVACY_ENABLE_ABOUT IS '是否开启app关于界面上隐私协议'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.PRIVACY_ABOUT_TXT IS '关于界面协议菜单名称'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.PRIVACY_ABOUT_LINK IS '关于界面协议链接地址'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.STATUS IS '状态：1-正常、3-删除'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.TENANT_ID IS '企业租户ID'
;

COMMENT ON COLUMN EM_SYS_LOGIN_SETTING.RIGHT_TYPE IS '绑定设备适用范围： 1-排除、 2-包含'
;


CREATE TYPE CACHE_COMMON_TYPE_ENUM_ AS ENUM('EHCACHE', 'REDIS', 'NONE')
;

CREATE TYPE CACHE_AUTH_TYPE_ENUM_ AS ENUM('EHCACHE', 'REDIS', 'NONE')
;

CREATE TABLE EM_SYS_BASE_SETTING (
	ID VARCHAR(32) NOT NULL,
	SYS_OUTER_URL VARCHAR(100) DEFAULT NULL,
	SYS_INNER_URL VARCHAR(100) DEFAULT NULL,
	UPLOAD_PATH VARCHAR(255) DEFAULT NULL,
	ENABLE_FILE_BACKUP SMALLINT DEFAULT NULL,
	FILE_BACKUP_PATH TEXT,
	FILE_BACKUP_TASK_ID VARCHAR(32) DEFAULT NULL,
	ENABLE_FILE_STORAGE SMALLINT DEFAULT NULL,
	FILE_STORAGE_TEMPLATE_ID VARCHAR(32) DEFAULT NULL,
	CACHE_AUTH_TYPE CACHE_AUTH_TYPE_ENUM_ DEFAULT NULL,
	CACHE_COMMON_TYPE CACHE_COMMON_TYPE_ENUM_ DEFAULT NULL,
	LOGIN_MODE_APP VARCHAR(32) DEFAULT NULL,
	LOGIN_MODE_PC VARCHAR(32) DEFAULT NULL,
	ENABLE_REGISTER SMALLINT DEFAULT NULL,
	ENABLE_RETRIEVE SMALLINT DEFAULT NULL,
	CUSTOM_LOGIN_PAGE VARCHAR(255) DEFAULT NULL,
	ENABLE_UPDATE_BASEINFO SMALLINT DEFAULT NULL,
	UPDATE_BASEINFO_TYPE SMALLINT DEFAULT NULL,
	UPDATE_BASEINFO_SETTING VARCHAR(100) DEFAULT NULL,
	ENABLE_UPDATE_PASSWORD SMALLINT DEFAULT NULL,
	UPDATE_PASSWORD_TYPE SMALLINT DEFAULT NULL,
	UPDATE_PASSWORD_SETTING VARCHAR(100) DEFAULT NULL,
	ENABLE_MULTI_ACCOUNT SMALLINT DEFAULT NULL,
	MULTI_ACCOUNT_SETTING VARCHAR(100) DEFAULT NULL,
	ENABLE_MAIN_ACCOUNT SMALLINT DEFAULT NULL,
	ENABLE_GET_ECUSER SMALLINT DEFAULT NULL,
	GET_ECUSER_OUTSYSID VARCHAR(32) DEFAULT NULL,
	CODE_SMS_ID VARCHAR(32) DEFAULT NULL,
	ENABLE_USERLINK SMALLINT DEFAULT NULL,
	USERLINK_OUTSYSID VARCHAR(32) DEFAULT NULL,
	USERLINK_URL VARCHAR(100) DEFAULT NULL,
	ENABLE_USERCARD SMALLINT DEFAULT NULL,
	USERCARD_OUTSYSID VARCHAR(32) DEFAULT NULL,
	USERCARD_URL VARCHAR(100) DEFAULT NULL,
	ENABLE_GET_PHRASE SMALLINT DEFAULT NULL,
	GET_PHRASE_OUTSYSID VARCHAR(32) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_BASE_SETTING IS '系统基本信息设置'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.ID IS '主键'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.SYS_OUTER_URL IS '本系统的外部地址'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.SYS_INNER_URL IS '本系统的内部地址'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.UPLOAD_PATH IS '文件上传路径'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.ENABLE_FILE_BACKUP IS '是否开启文件备份：0-否，1-是'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.FILE_BACKUP_PATH IS '文件备份目录'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.FILE_BACKUP_TASK_ID IS '文件备份任务ID'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.ENABLE_FILE_STORAGE IS '是否开启文件云存储：0-否，1-是'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.FILE_STORAGE_TEMPLATE_ID IS '文件云存储服务模板ID'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.CACHE_AUTH_TYPE IS '认证缓存类型'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.CACHE_COMMON_TYPE IS '普通缓存类型'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.LOGIN_MODE_APP IS '移动端登录方式(多选，逗号分隔)：1-账号密码、2-手机验证码'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.LOGIN_MODE_PC IS 'PC端登录方式(多选，逗号分隔)：1-账号密码、2-手机验证码、3-扫描二维码'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.ENABLE_REGISTER IS '是否开启注册：1-是、0-否'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.ENABLE_RETRIEVE IS '是否开启找回密码：1-是、0-否'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.CUSTOM_LOGIN_PAGE IS '客户端自定义登录页面地址'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.ENABLE_UPDATE_BASEINFO IS '是否开启客户端修改个人基本信息：1-是、0-否'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.UPDATE_BASEINFO_TYPE IS '客户端修改个人基本信息方式：1-本系统、2-EC'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.UPDATE_BASEINFO_SETTING IS '客户端修改个人基本信息页面对应的EC系统ID'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.ENABLE_UPDATE_PASSWORD IS '是否开启客户端修改个人密码：1-是、0-否'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.UPDATE_PASSWORD_TYPE IS '客户端修改密码信息方式：1-本系统、2-EC'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.UPDATE_PASSWORD_SETTING IS '客户端修改密码信息页面对应的EC系统ID'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.ENABLE_MULTI_ACCOUNT IS '是否开启账号切换功能：1-是、0-否'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.MULTI_ACCOUNT_SETTING IS '账号切换功能页面对应的EC系统ID'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.ENABLE_MAIN_ACCOUNT IS '是否开启消息转主账号：1-是、0-否'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.ENABLE_GET_ECUSER IS '是否开启从Ecology系统获取基础用户信息：1-是、0-否'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.GET_ECUSER_OUTSYSID IS '从Ecology系统获取基础用户信息的系统ID'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.CODE_SMS_ID IS '发送短信验证码时使用的短信服务ID'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.ENABLE_USERLINK IS '是否开启人员卡片按钮功能：1-是、0-否'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.USERLINK_OUTSYSID IS '人员卡片按钮功能，使用集成系统方式配置来打开，此处配置相应集成系统id'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.USERLINK_URL IS '人员卡片按钮功能，使用url配置方式直接打开，此处配置相关的url数据'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.ENABLE_USERCARD IS '是否开启APP人员卡片按钮功能：1-是、0-否'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.USERCARD_OUTSYSID IS 'APP人员卡片按钮功能，使用集成系统方式配置来打开，此处配置相应集成系统id'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.USERCARD_URL IS 'APP人员卡片按钮功能，使用url配置方式直接打开，此处配置相关的url数据'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.ENABLE_GET_PHRASE IS '是否开启从集成系统获取常用短语数据：1-是、0-否'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.GET_PHRASE_OUTSYSID IS '从集成系统获取常用短语数据对应的系统ID'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.STATUS IS '状态'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.CREATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_BASE_SETTING.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_BASEUSER_TOKEN (
	ACCESS_TOKEN VARCHAR(100) NOT NULL,
	BASE_USER_ID VARCHAR(32) NOT NULL,
	PDATA VARCHAR(1000) DEFAULT NULL,
	CDATA VARCHAR(1000) DEFAULT NULL,
	LOGIN_TYPE SMALLINT DEFAULT NULL,
	CLIENT_TYPE SMALLINT DEFAULT '0',
	LANG_TYPE VARCHAR(10) DEFAULT NULL,
	EXTRA VARCHAR(2000) DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	EXPIRE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	PRIMARY KEY (ACCESS_TOKEN)
)
;



COMMENT ON TABLE EM_SYS_BASEUSER_TOKEN IS '基础用户Token'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_TOKEN.ACCESS_TOKEN IS '访问token'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_TOKEN.BASE_USER_ID IS '基础用户ID'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_TOKEN.PDATA IS '加密字段'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_TOKEN.CDATA IS '请求的jscookieId'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_TOKEN.LOGIN_TYPE IS '登录类型：1表示客户端，2表示管理端，3表示接口'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_TOKEN.CLIENT_TYPE IS '登录客户端类型：1表示PC，2表示IOS，3表示安卓，4表示web'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_TOKEN.LANG_TYPE IS '语言类型'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_TOKEN.EXTRA IS '登陆者记录的额外数据（map数据格式）'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_TOKEN.TENANT_ID IS '当前管理的租户ID'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_TOKEN.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_TOKEN.EXPIRE_TIME IS '过期时间'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_TOKEN.UPDATE_TIME IS '更新时间'
;


CREATE TABLE EM_HRM_TAG (
	ID VARCHAR(32) NOT NULL,
	OPEN_TAG_ID INT DEFAULT NULL,
	TAG_NAME VARCHAR(100) DEFAULT NULL,
	ENGLISH_NAME VARCHAR(100) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	RELATE_ROLE_ID VARCHAR(32) DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_HRM_TAG IS '企业通信录标签表'
;

COMMENT ON COLUMN EM_HRM_TAG.ID IS '主键ID'
;

COMMENT ON COLUMN EM_HRM_TAG.OPEN_TAG_ID IS 'API交互时的唯一标识，采用某企业内自增长逻辑，即按tenantid自增长'
;

COMMENT ON COLUMN EM_HRM_TAG.TAG_NAME IS '标签名称'
;

COMMENT ON COLUMN EM_HRM_TAG.ENGLISH_NAME IS '英文名称'
;

COMMENT ON COLUMN EM_HRM_TAG.STATUS IS '状态 1-正常，2-禁用，3-删除'
;

COMMENT ON COLUMN EM_HRM_TAG.RELATE_ROLE_ID IS '标签所属角色ID，关联em_setting_role表的主键，如果为0则表示超级管理员创建'
;

COMMENT ON COLUMN EM_HRM_TAG.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_HRM_TAG.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_HRM_TAG.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_HRM_TAG.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_HRM_TAG.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_LOG_OPERATION (
	ID VARCHAR(32) NOT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	BASE_USER_NAME VARCHAR(255) DEFAULT NULL,
	HRM_USER_ID VARCHAR(32) DEFAULT NULL,
	HRM_USER_NAME VARCHAR(255) DEFAULT NULL,
	ADMIN_TYPE INT DEFAULT NULL,
	MODULE SMALLINT DEFAULT NULL,
	OPERATION VARCHAR(255) DEFAULT NULL,
	METHOD VARCHAR(255) DEFAULT NULL,
	HEADERS TEXT,
	PARAMS TEXT,
	DATA_NAME VARCHAR(255) DEFAULT NULL,
	COST_TIME INT DEFAULT NULL,
	ERROR_CODE INT DEFAULT NULL,
	ERROR_MSG TEXT,
	RETURN_JSON_DATA TEXT,
	IP VARCHAR(255) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;
COMMENT ON TABLE EM_LOG_OPERATION IS '操作日志'
;

COMMENT ON COLUMN EM_LOG_OPERATION.ID IS '主键'
;

COMMENT ON COLUMN EM_LOG_OPERATION.BASE_USER_ID IS '用户ID'
;

COMMENT ON COLUMN EM_LOG_OPERATION.BASE_USER_NAME IS '用户名'
;

COMMENT ON COLUMN EM_LOG_OPERATION.HRM_USER_ID IS '通讯录用户ID'
;

COMMENT ON COLUMN EM_LOG_OPERATION.HRM_USER_NAME IS '通讯录用户名'
;

COMMENT ON COLUMN EM_LOG_OPERATION.ADMIN_TYPE IS '管理员类型'
;

COMMENT ON COLUMN EM_LOG_OPERATION.MODULE IS '模块ID'
;

COMMENT ON COLUMN EM_LOG_OPERATION.OPERATION IS '操作'
;

COMMENT ON COLUMN EM_LOG_OPERATION.METHOD IS '请求方法'
;

COMMENT ON COLUMN EM_LOG_OPERATION.HEADERS IS '请求头参数'
;

COMMENT ON COLUMN EM_LOG_OPERATION.PARAMS IS '请求参数'
;

COMMENT ON COLUMN EM_LOG_OPERATION.DATA_NAME IS '操作的数据名称'
;

COMMENT ON COLUMN EM_LOG_OPERATION.COST_TIME IS '操作时长'
;

COMMENT ON COLUMN EM_LOG_OPERATION.ERROR_CODE IS '错误码'
;

COMMENT ON COLUMN EM_LOG_OPERATION.ERROR_MSG IS '错误信息'
;

COMMENT ON COLUMN EM_LOG_OPERATION.RETURN_JSON_DATA IS '接口返回数据'
;

COMMENT ON COLUMN EM_LOG_OPERATION.IP IS 'IP地址'
;

COMMENT ON COLUMN EM_LOG_OPERATION.CREATE_TIME IS '日志创建时间'
;

COMMENT ON COLUMN EM_LOG_OPERATION.TENANT_ID IS '租户ID'
;


CREATE TABLE EM_SYS_CLIENT_VERSION_RIGHT (
	ID VARCHAR(32) NOT NULL,
	VERSION_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_TYPE SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_SYS_CLIENT_VERSION_RIGHT IS '系统客户端版本可见范围表'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION_RIGHT.VERSION_ID IS '版本ID，版本数据主键ID'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION_RIGHT.HRM_DATA_ID IS '通讯录成员或部门表ID'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION_RIGHT.HRM_DATA_TYPE IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION_RIGHT.STATUS IS '状态'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION_RIGHT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION_RIGHT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION_RIGHT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION_RIGHT.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION_RIGHT.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_VIDEO_ZHUMU_MEETING (
	ID VARCHAR(32) NOT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	MEETING_ID VARCHAR(50) DEFAULT NULL,
	MEETING_PASSWORD VARCHAR(20) DEFAULT NULL,
	PASSWORD_CIPHERTEXT VARCHAR(500) DEFAULT NULL,
	MEETING_TOPIC VARCHAR(50) DEFAULT NULL,
	MEETING_TYPE SMALLINT DEFAULT NULL,
	MEETING_START_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	MEETING_DURATION VARCHAR(20) DEFAULT NULL,
	OPTION_JBH SMALLINT DEFAULT NULL,
	OPTION_START_TYPE VARCHAR(10) DEFAULT NULL,
	OPTION_NO_VIDEO_HOST SMALLINT DEFAULT NULL,
	OPTION_NO_VIDEO_PARTICIPANTS SMALLINT DEFAULT NULL,
	OPTION_AUDIO VARCHAR(10) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_VIDEO_ZHUMU_MEETING IS '瞩目视频会议会议信息表'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_MEETING.BASE_USER_ID IS '会议主持人对应的基础用户ID'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_MEETING.MEETING_ID IS '瞩目会议ID'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_MEETING.MEETING_PASSWORD IS '会议密码'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_MEETING.PASSWORD_CIPHERTEXT IS '会议密码密文，经过加密返回的密码'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_MEETING.MEETING_TOPIC IS '瞩目会议名称'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_MEETING.MEETING_TYPE IS '会议类型：1-即时会议，2-计划会议，3-长期会议'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_MEETING.MEETING_START_TIME IS '会议开始时间'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_MEETING.MEETING_DURATION IS '会议持续时间'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_MEETING.OPTION_JBH IS '是否可以在主持人开始会议之前加入会议：1-是，0-否'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_MEETING.OPTION_START_TYPE IS '会议开始类型，可以是video或者 screen_share. (不赞成)'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_MEETING.OPTION_NO_VIDEO_HOST IS '当主持人加入会议时关闭视频：1-是，0-否'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_MEETING.OPTION_NO_VIDEO_PARTICIPANTS IS '当参与人加入会议室不打开视频：1-是，0-否'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_MEETING.OPTION_AUDIO IS '会议语音选项。可以是both, telephony, “voip”'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_MEETING.STATUS IS '状态'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_MEETING.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_MEETING.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_MEETING.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_MEETING.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_MEETING.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_MSG_EXPRESSION_DATA (
	ID VARCHAR(32) NOT NULL,
	ITEM_ID VARCHAR(32) DEFAULT NULL,
	DATA_ICON VARCHAR(32) DEFAULT NULL,
	SHOWORDER INT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_MSG_EXPRESSION_DATA IS '消息自定义表情数据表'
;

COMMENT ON COLUMN EM_MSG_EXPRESSION_DATA.ID IS '主键'
;

COMMENT ON COLUMN EM_MSG_EXPRESSION_DATA.ITEM_ID IS '所属表情分组ID'
;

COMMENT ON COLUMN EM_MSG_EXPRESSION_DATA.DATA_ICON IS '表情数据图标ID'
;

COMMENT ON COLUMN EM_MSG_EXPRESSION_DATA.SHOWORDER IS '显示顺序'
;

COMMENT ON COLUMN EM_MSG_EXPRESSION_DATA.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_MSG_EXPRESSION_DATA.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_MSG_EXPRESSION_DATA.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_MSG_EXPRESSION_DATA.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_MSG_EXPRESSION_DATA.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_MSG_EXPRESSION_DATA.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_VIDEO_CHAT_CALL (
	ID VARCHAR(32) NOT NULL,
	CHAT_BASE_ID VARCHAR(32) DEFAULT NULL,
	CHAT_TYPE SMALLINT DEFAULT NULL,
	CALL_SENDER_ID VARCHAR(32) DEFAULT NULL,
	CALL_TYPE SMALLINT DEFAULT NULL,
	CALL_STATUS SMALLINT DEFAULT NULL,
	CALL_TIME BIGINT DEFAULT NULL,
	CALL_DURATION INT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_VIDEO_CHAT_CALL IS '音视频会话通话记录表'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL.ID IS '主键ID'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL.CHAT_BASE_ID IS '会话基本信息表ID'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL.CHAT_TYPE IS '会话类型：1-点对点，2-会议'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL.CALL_SENDER_ID IS '通话发起人ID，对应em_sys_base_user表的主键'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL.CALL_TYPE IS '通话类型 1-音频 2-视频 3-sip电话 4-普通电话'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL.CALL_STATUS IS '通话状态：1-进行中，2-结束'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL.CALL_TIME IS '通话时间'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL.CALL_DURATION IS '通话时长，单位为秒'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_CHECKIN_SYNC_LOG (
	ID VARCHAR(32) NOT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	OUTSYS_ID VARCHAR(32) DEFAULT NULL,
	LOG_TXT TEXT,
	SYNC_SET TEXT,
	CP_DATA TEXT,
	TO_OUTSYS_DATA TEXT,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_CP_CHECKIN_SYNC_LOG IS '企业号考勤打卡数据同步日志记录表'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_LOG.ID IS '主键ID'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_LOG.CP_CORP_ID IS '企业号基本信息ID'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_LOG.OUTSYS_ID IS '集成系统ID'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_LOG.SYNC_SET IS '考勤同步设置'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_LOG.CP_DATA IS '企业号的考勤数据'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_LOG.TO_OUTSYS_DATA IS '提交给集成系统的考勤数据'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_LOG.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_LOG.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_LOG.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_LOG.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_LOG.TENANT_ID IS '企业租户ID'
;


CREATE TABLE QRTZ_SIMPROP_TRIGGERS (
	SCHED_NAME VARCHAR(120) NOT NULL,
	TRIGGER_NAME VARCHAR(190) NOT NULL,
	TRIGGER_GROUP VARCHAR(190) NOT NULL,
	STR_PROP_1 VARCHAR(512) DEFAULT NULL,
	STR_PROP_2 VARCHAR(512) DEFAULT NULL,
	STR_PROP_3 VARCHAR(512) DEFAULT NULL,
	INT_PROP_1 INT DEFAULT NULL,
	INT_PROP_2 INT DEFAULT NULL,
	LONG_PROP_1 BIGINT DEFAULT NULL,
	LONG_PROP_2 BIGINT DEFAULT NULL,
	DEC_PROP_1 DECIMAL(13, 4) DEFAULT NULL,
	DEC_PROP_2 DECIMAL(13, 4) DEFAULT NULL,
	BOOL_PROP_1 VARCHAR(8) DEFAULT NULL,
	BOOL_PROP_2 VARCHAR(8) DEFAULT NULL,
	PRIMARY KEY (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
)
;



CREATE TABLE EM_CP_PAY_CONFIG (
	ID VARCHAR(32) NOT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	MCHID VARCHAR(32) DEFAULT NULL,
	APIKEY VARCHAR(32) DEFAULT NULL,
	CERTFILE VARCHAR(32) DEFAULT NULL,
	CERTPASSWORD VARCHAR(255) DEFAULT NULL,
	HANDLING_FEE_RATE INT DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_CP_PAY_CONFIG IS '企业号支付配置'
;

COMMENT ON COLUMN EM_CP_PAY_CONFIG.ID IS '主键'
;

COMMENT ON COLUMN EM_CP_PAY_CONFIG.CP_CORP_ID IS '企业号基本信息ID'
;

COMMENT ON COLUMN EM_CP_PAY_CONFIG.MCHID IS '商户ID'
;

COMMENT ON COLUMN EM_CP_PAY_CONFIG.APIKEY IS '支付key'
;

COMMENT ON COLUMN EM_CP_PAY_CONFIG.CERTFILE IS '支付证书文件ID'
;

COMMENT ON COLUMN EM_CP_PAY_CONFIG.CERTPASSWORD IS '支持证书密码'
;

COMMENT ON COLUMN EM_CP_PAY_CONFIG.HANDLING_FEE_RATE IS '支付手续费：千分比'
;

COMMENT ON COLUMN EM_CP_PAY_CONFIG.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_CP_PAY_CONFIG.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_PAY_CONFIG.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_PAY_CONFIG.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_PAY_CONFIG.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_PAY_CONFIG.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SC_SHOW (
	ID VARCHAR(32) NOT NULL,
	CLIENT_TYPE SMALLINT DEFAULT NULL,
	SET_TYPE SMALLINT DEFAULT NULL,
	SET_TAG SMALLINT DEFAULT NULL,
	SET_VALUE VARCHAR(500) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_SC_SHOW IS '企业客户端显示设置表'
;

COMMENT ON COLUMN EM_SC_SHOW.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SC_SHOW.CLIENT_TYPE IS '客户端类型 1-移动APP，2-PC客户端，3-web客户端'
;

COMMENT ON COLUMN EM_SC_SHOW.SET_TYPE IS '设置项类型 1-登录前显示，2-登录后显示'
;

COMMENT ON COLUMN EM_SC_SHOW.SET_TAG IS '设置项标识 1-欢迎页背景图片，2-欢迎词内容，3-欢迎词字体颜色，4-登录页logo，5-登录页背景色，6-登录页底部信息内容，7-登录页底部信息字体颜色，21-顶部背景色，22-顶部文字颜色，23-顶部功能菜单背景色，24-顶部功能菜单文字颜色，25-导航栏背景色，26-导航栏文字未选中颜色，27-导航栏文字已选中颜色'
;

COMMENT ON COLUMN EM_SC_SHOW.SET_VALUE IS '设置内容'
;

COMMENT ON COLUMN EM_SC_SHOW.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_SC_SHOW.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SC_SHOW.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SC_SHOW.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SC_SHOW.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SC_SHOW.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_SIGN_SETTING (
	ID VARCHAR(32) NOT NULL,
	ENABLED SMALLINT DEFAULT NULL,
	IOS_REVISION_MODE SMALLINT DEFAULT NULL,
	IOS_SIGN_TYPE SMALLINT DEFAULT NULL,
	IOS_WPS_SECRET TEXT,
	IOS_OFFICE_SECRET TEXT,
	AND_REVISION_MODE SMALLINT DEFAULT NULL,
	AND_SIGN_TYPE SMALLINT DEFAULT NULL,
	AND_WPS_SECRET TEXT,
	AND_OFFICE_SECRET TEXT,
	PDF_IOS_SIGN_TYPE SMALLINT DEFAULT '0',
	PDF_ANDROID_SIGN_TYPE SMALLINT DEFAULT '0',
	PDF_IOS_OFFICE_SECRET TEXT,
	PDF_ANDROID_OFFICE_SECRET TEXT,
	PDF_IOS_WPS_SECRET TEXT,
	PDF_ANDROID_WPS_SECRET TEXT,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_SIGN_SETTING IS '手写签批设置信息'
;

COMMENT ON COLUMN EM_SYS_SIGN_SETTING.ENABLED IS '是否开启手写签批：0-禁用、1-开启'
;

COMMENT ON COLUMN EM_SYS_SIGN_SETTING.IOS_REVISION_MODE IS 'ios默认打开修订模式： 1-是、 0-否'
;

COMMENT ON COLUMN EM_SYS_SIGN_SETTING.IOS_SIGN_TYPE IS 'IOS签批方式：1-WPS、2-金格office'
;

COMMENT ON COLUMN EM_SYS_SIGN_SETTING.IOS_WPS_SECRET IS '改secret为text类型'
;

COMMENT ON COLUMN EM_SYS_SIGN_SETTING.IOS_OFFICE_SECRET IS '改secret为text类型'
;

COMMENT ON COLUMN EM_SYS_SIGN_SETTING.AND_REVISION_MODE IS 'Android默认打开修订模式： 1-是、 0-否'
;

COMMENT ON COLUMN EM_SYS_SIGN_SETTING.AND_SIGN_TYPE IS 'Android签批方式：1-WPS、2-金格office、3-永中office'
;

COMMENT ON COLUMN EM_SYS_SIGN_SETTING.AND_WPS_SECRET IS '改secret为text类型'
;

COMMENT ON COLUMN EM_SYS_SIGN_SETTING.AND_OFFICE_SECRET IS '改secret为text类型'
;

COMMENT ON COLUMN EM_SYS_SIGN_SETTING.PDF_IOS_SIGN_TYPE IS 'pdf ios 签批方式 1-金格office'
;

COMMENT ON COLUMN EM_SYS_SIGN_SETTING.PDF_ANDROID_SIGN_TYPE IS 'pdf android 签批方式 1-金格office'
;

COMMENT ON COLUMN EM_SYS_SIGN_SETTING.PDF_IOS_OFFICE_SECRET IS 'pdf ios 金格秘钥'
;

COMMENT ON COLUMN EM_SYS_SIGN_SETTING.PDF_ANDROID_OFFICE_SECRET IS 'pdf android 金格秘钥'
;

COMMENT ON COLUMN EM_SYS_SIGN_SETTING.PDF_IOS_WPS_SECRET IS 'pdf ios wps秘钥'
;

COMMENT ON COLUMN EM_SYS_SIGN_SETTING.PDF_ANDROID_WPS_SECRET IS 'pdf android wps秘钥'
;

COMMENT ON COLUMN EM_SYS_SIGN_SETTING.STATUS IS '状态'
;

COMMENT ON COLUMN EM_SYS_SIGN_SETTING.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_SIGN_SETTING.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_SIGN_SETTING.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_SIGN_SETTING.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_SIGN_SETTING.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SC_THEME_BASE (
	ID VARCHAR(32) NOT NULL,
	CLIENT_TYPE SMALLINT DEFAULT NULL,
	THEME_NAME VARCHAR(100) DEFAULT NULL,
	SHOW_TYPE SMALLINT DEFAULT '0',
	SHOWORDER DECIMAL(10, 2) DEFAULT '0.00',
	NAV_BGCOLOR VARCHAR(50) DEFAULT NULL,
	NAV_TEXTCOLOR_DEFAULT VARCHAR(50) DEFAULT NULL,
	NAV_TEXTCOLOR_SELECTED VARCHAR(50) DEFAULT NULL,
	NAV_SHOWTEXT SMALLINT DEFAULT '1',
	ISDEFAULT SMALLINT DEFAULT '0',
	OTHER_TAG VARCHAR(100) DEFAULT NULL,
	LOCK_THEME SMALLINT DEFAULT '0',
	LOCK_THEME_START_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	LOCK_THEME_END_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_SC_THEME_BASE IS '企业客户端主题基础信息表'
;

COMMENT ON COLUMN EM_SC_THEME_BASE.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SC_THEME_BASE.CLIENT_TYPE IS '客户端类型 1-移动APP，2-PC客户端，3-web客户端'
;

COMMENT ON COLUMN EM_SC_THEME_BASE.THEME_NAME IS '主题名称'
;

COMMENT ON COLUMN EM_SC_THEME_BASE.SHOW_TYPE IS '显示模式，针对PC端：1-纵向、2-横向'
;

COMMENT ON COLUMN EM_SC_THEME_BASE.SHOWORDER IS '显示顺序'
;

COMMENT ON COLUMN EM_SC_THEME_BASE.NAV_BGCOLOR IS '移动端底部导航背景颜色'
;

COMMENT ON COLUMN EM_SC_THEME_BASE.NAV_TEXTCOLOR_DEFAULT IS '移动端底部导航文字默认颜色'
;

COMMENT ON COLUMN EM_SC_THEME_BASE.NAV_TEXTCOLOR_SELECTED IS '移动端底部导航文字选中颜色'
;

COMMENT ON COLUMN EM_SC_THEME_BASE.NAV_SHOWTEXT IS '移动端底部导航是否显示文字 1-显示，0-不显示'
;

COMMENT ON COLUMN EM_SC_THEME_BASE.ISDEFAULT IS '是否默认主题：1-是、0-否'
;

COMMENT ON COLUMN EM_SC_THEME_BASE.OTHER_TAG IS '主题关联标识'
;

COMMENT ON COLUMN EM_SC_THEME_BASE.LOCK_THEME IS '锁定主题 0-关闭 1-开启'
;

COMMENT ON COLUMN EM_SC_THEME_BASE.LOCK_THEME_START_TIME IS '锁定主题开始时间'
;

COMMENT ON COLUMN EM_SC_THEME_BASE.LOCK_THEME_END_TIME IS '锁定主题结束时间'
;

COMMENT ON COLUMN EM_SC_THEME_BASE.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_SC_THEME_BASE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SC_THEME_BASE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SC_THEME_BASE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SC_THEME_BASE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SC_THEME_BASE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_HRM_GROUP (
	ID VARCHAR(32) NOT NULL,
	OPEN_GROUP_ID INT DEFAULT NULL,
	GROUP_NAME VARCHAR(100) DEFAULT NULL,
	ENGLISH_NAME VARCHAR(100) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	RELATE_ROLE_ID VARCHAR(32) DEFAULT NULL,
	GROUP_TYPE SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_HRM_GROUP IS '企业通信录分组表'
;

COMMENT ON COLUMN EM_HRM_GROUP.ID IS '主键ID'
;

COMMENT ON COLUMN EM_HRM_GROUP.OPEN_GROUP_ID IS 'API交互时的唯一标识，采用某企业内自增长逻辑，即按tenantid自增长'
;

COMMENT ON COLUMN EM_HRM_GROUP.GROUP_NAME IS '分组名称'
;

COMMENT ON COLUMN EM_HRM_GROUP.ENGLISH_NAME IS '英文名称'
;

COMMENT ON COLUMN EM_HRM_GROUP.STATUS IS '状态 1-正常，2-禁用，3-删除'
;

COMMENT ON COLUMN EM_HRM_GROUP.RELATE_ROLE_ID IS '分组所属角色ID，关联em_setting_role表的主键，如果为0则表示超级管理员创建'
;

COMMENT ON COLUMN EM_HRM_GROUP.GROUP_TYPE IS '类型，1-通用分组，2-私人分组'
;

COMMENT ON COLUMN EM_HRM_GROUP.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_HRM_GROUP.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_HRM_GROUP.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_HRM_GROUP.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_HRM_GROUP.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_LOG_ONLINEUSER_ACCESS (
	ID VARCHAR(32) NOT NULL,
	ONLINEUSER_NUMBER INT DEFAULT NULL,
	ONLINEUSER_ACCESS_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	ONLINEUSER_MODULE VARCHAR(100) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_LOG_ONLINEUSER_ACCESS IS '在线人员访问统计'
;

COMMENT ON COLUMN EM_LOG_ONLINEUSER_ACCESS.ID IS '主键'
;

COMMENT ON COLUMN EM_LOG_ONLINEUSER_ACCESS.ONLINEUSER_NUMBER IS '在线人员数量'
;

COMMENT ON COLUMN EM_LOG_ONLINEUSER_ACCESS.ONLINEUSER_ACCESS_TIME IS '当前访问统计的时间'
;

COMMENT ON COLUMN EM_LOG_ONLINEUSER_ACCESS.ONLINEUSER_MODULE IS '在线人员统计模块'
;


CREATE TABLE EM_VIDEO_ZHUMU_M_ATTENDEE (
	ID VARCHAR(32) NOT NULL,
	MEETING_ID VARCHAR(32) DEFAULT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_VIDEO_ZHUMU_M_ATTENDEE IS '瞩目视频会议参会人员表'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_M_ATTENDEE.MEETING_ID IS '会议ID，会议表主键ID'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_M_ATTENDEE.BASE_USER_ID IS '基础用户ID'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_M_ATTENDEE.STATUS IS '状态'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_M_ATTENDEE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_M_ATTENDEE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_M_ATTENDEE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_M_ATTENDEE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_M_ATTENDEE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_VIDEO_CHAT_MINE (
	ID VARCHAR(32) NOT NULL,
	CHAT_MEMBER_ID VARCHAR(32) DEFAULT NULL,
	CHAT_BASE_ID VARCHAR(32) DEFAULT NULL,
	CHAT_TARGET_ID VARCHAR(32) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_VIDEO_CHAT_MINE IS '音视频会话成员会话列表信息表'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_MINE.ID IS '主键ID'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_MINE.CHAT_MEMBER_ID IS '会话成员ID，对应em_sys_base_user表的主键'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_MINE.CHAT_BASE_ID IS '会话基本信息表ID'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_MINE.CHAT_TARGET_ID IS '点对点类型会话目标人员ID'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_MINE.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_MINE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_MINE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_MINE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_MINE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_MINE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_BASEUSER_PHRASE (
	ID VARCHAR(32) NOT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	PHRASE_NAME VARCHAR(100) DEFAULT NULL,
	PHRASE_CONTENT VARCHAR(300) DEFAULT NULL,
	PHRASE_TYPE INT DEFAULT NULL,
	SHOWORDER INT DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_SYS_BASEUSER_PHRASE IS '基础用户常用短语表'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_PHRASE.BASE_USER_ID IS '基础用户ID'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_PHRASE.PHRASE_NAME IS '短语简称'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_PHRASE.PHRASE_TYPE IS '短语类型：1-私人 2-公共'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_PHRASE.SHOWORDER IS '显示顺序'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_PHRASE.STATUS IS '状态：1-正常、3-删除'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_PHRASE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_PHRASE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_PHRASE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_PHRASE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_PHRASE.TENANT_ID IS '企业租户ID'
;


CREATE TYPE MEDIA_TYPE_ENUM_ AS ENUM('image', 'voice', 'video', 'file')
;

CREATE TABLE EM_SYS_BASE_FILE (
	ID VARCHAR(32) NOT NULL,
	FILE_NAME VARCHAR(500) DEFAULT NULL,
	FILE_EXTENSION VARCHAR(255) DEFAULT NULL,
	FILE_CONTENT_TYPE VARCHAR(255) DEFAULT NULL,
	FILE_SIZE BIGINT DEFAULT NULL,
	FILE_PATH VARCHAR(1000) DEFAULT NULL,
	FILE_FROM SMALLINT DEFAULT NULL,
	FILE_DELETE SMALLINT DEFAULT NULL,
	IS_OPEN SMALLINT DEFAULT NULL,
	MEDIA_TYPE MEDIA_TYPE_ENUM_ DEFAULT NULL,
	PARENT_ID VARCHAR(32) DEFAULT NULL,
	THUMBNAIL SMALLINT DEFAULT NULL,
	BACKUP_STATUS SMALLINT DEFAULT NULL,
	BACKUP_PATH TEXT,
	STORAGE_STATUS SMALLINT DEFAULT NULL,
	STORAGE_PATH TEXT,
	STORAGE_TEMPLATE_ID VARCHAR(32) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_BASE_FILE IS '文件记录表'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.ID IS '主键'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.FILE_EXTENSION IS '文件扩展名'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.FILE_CONTENT_TYPE IS '文件类型'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.FILE_SIZE IS '文件大小'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.FILE_PATH IS '文件路径'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.FILE_FROM IS '文件来源类型：1-聊天文件、2-人脸图片、3-群组头像、0-其他配置文件'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.FILE_DELETE IS '文件是否已从硬盘删除：0-否、1-是，默认否'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.IS_OPEN IS '文件是否开放访问：0-不开放、1-开放'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.MEDIA_TYPE IS '素材类型'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.PARENT_ID IS '父文件ID'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.THUMBNAIL IS '缩略图类型'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.BACKUP_STATUS IS '文件备份状态：0-未备份，1-已备份'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.BACKUP_PATH IS '文件备份路径'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.STORAGE_STATUS IS '文件云存储状态：0-未存储，1-已存储，2-存储中，3-存储失败'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.STORAGE_PATH IS '文件云存储路径'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.STORAGE_TEMPLATE_ID IS '文件云存储服务模板ID'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.STATUS IS '状态'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_BASE_FILE.TENANT_ID IS '企业租户ID'
;


CREATE TYPE STRATEGY_ENUM_1 AS ENUM('ALIYUN', 'EMAY', 'ECOLOGY')
;

CREATE TABLE EM_SMS_TEMPLATE (
	ID VARCHAR(32) NOT NULL,
	NAME VARCHAR(255) DEFAULT NULL,
	STRATEGY STRATEGY_ENUM_1 DEFAULT NULL,
	SETTING TEXT,
	IS_DEFALUT SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SMS_TEMPLATE IS '短信服务设置表'
;

COMMENT ON COLUMN EM_SMS_TEMPLATE.ID IS '主键'
;

COMMENT ON COLUMN EM_SMS_TEMPLATE.NAME IS '短信模板名称'
;

COMMENT ON COLUMN EM_SMS_TEMPLATE.STRATEGY IS '短信模板策略'
;

COMMENT ON COLUMN EM_SMS_TEMPLATE.SETTING IS '短信模板设置参数（JSON数据）'
;

COMMENT ON COLUMN EM_SMS_TEMPLATE.IS_DEFALUT IS '是否设为默认：1-是，其他-否'
;

COMMENT ON COLUMN EM_SMS_TEMPLATE.STATUS IS '状态'
;

COMMENT ON COLUMN EM_SMS_TEMPLATE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SMS_TEMPLATE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SMS_TEMPLATE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SMS_TEMPLATE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SMS_TEMPLATE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_FACE_AWAKE_RANGE (
	ID VARCHAR(32) NOT NULL,
	HRM_DATA_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_TYPE SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_SYS_FACE_AWAKE_RANGE IS '人脸唤醒验证使用范围设置表'
;

COMMENT ON COLUMN EM_SYS_FACE_AWAKE_RANGE.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SYS_FACE_AWAKE_RANGE.HRM_DATA_ID IS '通讯录成员或部门表ID'
;

COMMENT ON COLUMN EM_SYS_FACE_AWAKE_RANGE.HRM_DATA_TYPE IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;

COMMENT ON COLUMN EM_SYS_FACE_AWAKE_RANGE.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_SYS_FACE_AWAKE_RANGE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_FACE_AWAKE_RANGE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_FACE_AWAKE_RANGE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_FACE_AWAKE_RANGE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_FACE_AWAKE_RANGE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_DEPT (
	ID VARCHAR(32) NOT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	OPEN_DEPT_ID VARCHAR(100) DEFAULT NULL,
	DEPT_NAME VARCHAR(255) DEFAULT NULL,
	ENGLISH_NAME VARCHAR(255) DEFAULT NULL,
	PARENT_ID VARCHAR(100) DEFAULT NULL,
	ALL_PARENT_IDS VARCHAR(1000) DEFAULT NULL,
	OUTSYS_ID VARCHAR(32) DEFAULT NULL,
	OUTSYS_DEPT_TYPE SMALLINT DEFAULT NULL,
	OUTSYS_DEPT_ID VARCHAR(32) DEFAULT NULL,
	SHOWORDER BIGINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	DEPT_MANAGE VARCHAR(50) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_CP_DEPT IS '企业号通讯录部门表'
;

COMMENT ON COLUMN EM_CP_DEPT.ID IS '主键ID'
;

COMMENT ON COLUMN EM_CP_DEPT.CP_CORP_ID IS '企业号基本信息ID'
;

COMMENT ON COLUMN EM_CP_DEPT.OPEN_DEPT_ID IS '企业号中的部门ID'
;

COMMENT ON COLUMN EM_CP_DEPT.PARENT_ID IS '上级部门ID'
;

COMMENT ON COLUMN EM_CP_DEPT.ALL_PARENT_IDS IS '所有上级部门ID用逗号分隔'
;

COMMENT ON COLUMN EM_CP_DEPT.OUTSYS_ID IS '对应集成系统的ID'
;

COMMENT ON COLUMN EM_CP_DEPT.OUTSYS_DEPT_TYPE IS '对应集成系统部门类型：1-分部，2-部门'
;

COMMENT ON COLUMN EM_CP_DEPT.OUTSYS_DEPT_ID IS '对应集成系统部门ID'
;

COMMENT ON COLUMN EM_CP_DEPT.SHOWORDER IS '显示顺序'
;

COMMENT ON COLUMN EM_CP_DEPT.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_CP_DEPT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_DEPT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_DEPT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_DEPT.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_DEPT.TENANT_ID IS '企业租户ID'
;

COMMENT ON COLUMN EM_CP_DEPT.DEPT_MANAGE IS '部门主管userid'
;


CREATE TABLE EM_MSG_DING (
	ID VARCHAR(32) NOT NULL,
	SEND_USER_ID VARCHAR(32) DEFAULT NULL,
	TOUSERIDS TEXT,
	MSG_CONTENT VARCHAR(1000) DEFAULT NULL,
	MSG_TYPE SMALLINT DEFAULT '1',
	SEND_TYPE SMALLINT DEFAULT '1',
	SEND_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	SEND_RESULT SMALLINT DEFAULT '1',
	MSG_DING_ID VARCHAR(50) DEFAULT NULL,
	MESSAGEID VARCHAR(50) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_MSG_DING IS '必达消息数据表'
;

COMMENT ON COLUMN EM_MSG_DING.ID IS '主键ID'
;

COMMENT ON COLUMN EM_MSG_DING.SEND_USER_ID IS '发送人id'
;

COMMENT ON COLUMN EM_MSG_DING.TOUSERIDS IS '接收人员id，多个用逗号分隔'
;

COMMENT ON COLUMN EM_MSG_DING.MSG_CONTENT IS '消息内容'
;

COMMENT ON COLUMN EM_MSG_DING.MSG_TYPE IS '消息类型：1-应用内，2-短信，3-电话'
;

COMMENT ON COLUMN EM_MSG_DING.SEND_TYPE IS '发送类型：1-立即发送，2-定时发送'
;

COMMENT ON COLUMN EM_MSG_DING.SEND_TIME IS '定时发送的时间，格式为YYYY-MM-DD HH:MM:ss'
;

COMMENT ON COLUMN EM_MSG_DING.SEND_RESULT IS '发送结果：1-发生成功，2-等待发送，3-发送失败'
;

COMMENT ON COLUMN EM_MSG_DING.MSG_DING_ID IS '对应消息服务中的数据ID'
;

COMMENT ON COLUMN EM_MSG_DING.MESSAGEID IS '消息转必达id'
;

COMMENT ON COLUMN EM_MSG_DING.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_MSG_DING.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_MSG_DING.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_MSG_DING.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_MSG_DING.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_MSG_DING.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_HRM_TAG_USER (
	ID VARCHAR(32) NOT NULL,
	HRM_TAG_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_TYPE SMALLINT DEFAULT NULL,
	SECLEVEL_MIN INT DEFAULT NULL,
	SECLEVEL_MAX INT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_HRM_TAG_USER IS '企业通讯录标签与成员及部门关联表'
;

COMMENT ON COLUMN EM_HRM_TAG_USER.ID IS '主键ID'
;

COMMENT ON COLUMN EM_HRM_TAG_USER.HRM_TAG_ID IS '通讯录标签表ID'
;

COMMENT ON COLUMN EM_HRM_TAG_USER.HRM_DATA_ID IS '通讯录成员或部门表ID'
;

COMMENT ON COLUMN EM_HRM_TAG_USER.HRM_DATA_TYPE IS '通讯录数据类型：1-成员，2-部门(不包含下级部门)，3-部门(包含下级部门)'
;

COMMENT ON COLUMN EM_HRM_TAG_USER.SECLEVEL_MIN IS '安全级别最小值'
;

COMMENT ON COLUMN EM_HRM_TAG_USER.SECLEVEL_MAX IS '安全级别最大值'
;

COMMENT ON COLUMN EM_HRM_TAG_USER.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_HRM_TAG_USER.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_HRM_TAG_USER.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_HRM_TAG_USER.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_HRM_TAG_USER.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_HRM_TAG_USER.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SH_DATA_INTERFACE (
	ID VARCHAR(32) NOT NULL,
	ORG_SET SMALLINT DEFAULT NULL,
	ORG_OUTSYSID VARCHAR(32) DEFAULT NULL,
	CARD_SET SMALLINT DEFAULT NULL,
	CARD_OUTSYSID VARCHAR(32) DEFAULT NULL,
	GROUP_SET SMALLINT DEFAULT NULL,
	GROUP_OUTSYSID VARCHAR(32) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SH_DATA_INTERFACE IS '通讯录接口设置表'
;

COMMENT ON COLUMN EM_SH_DATA_INTERFACE.ID IS '主键'
;

COMMENT ON COLUMN EM_SH_DATA_INTERFACE.ORG_SET IS '组织数据获取方式：1-本系统，2-Ecology系统'
;

COMMENT ON COLUMN EM_SH_DATA_INTERFACE.ORG_OUTSYSID IS '组织数据获取对应的集成Ecology系统ID'
;

COMMENT ON COLUMN EM_SH_DATA_INTERFACE.CARD_SET IS '人员卡片获取方式：1-本系统，2-Ecology系统'
;

COMMENT ON COLUMN EM_SH_DATA_INTERFACE.CARD_OUTSYSID IS '人员卡片获取对应的集成Ecology系统ID'
;

COMMENT ON COLUMN EM_SH_DATA_INTERFACE.GROUP_SET IS '常用组获取方式：1-本系统，2-Ecology系统'
;

COMMENT ON COLUMN EM_SH_DATA_INTERFACE.GROUP_OUTSYSID IS '常用组获取对应的集成Ecology系统ID'
;

COMMENT ON COLUMN EM_SH_DATA_INTERFACE.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_SH_DATA_INTERFACE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SH_DATA_INTERFACE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SH_DATA_INTERFACE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SH_DATA_INTERFACE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SH_DATA_INTERFACE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_HRM_USER_SYNC_SET (
	ID VARCHAR(32) NOT NULL,
	OUTSYS_ID VARCHAR(32) DEFAULT NULL,
	SYS_TASK_ID VARCHAR(32) DEFAULT NULL,
	ROOT_DEPT_ID VARCHAR(32) DEFAULT NULL,
	BASEID_TYPE SMALLINT DEFAULT '1',
	USERID_FIELD SMALLINT DEFAULT '1',
	MATCH_USER_FIELD SMALLINT DEFAULT '1',
	MATCH_OUTSYS_FIELD SMALLINT DEFAULT '1',
	USER_DEL_TYPE SMALLINT DEFAULT '1',
	DEPT_SYNC_TYPE SMALLINT DEFAULT '1',
	ISALLUSER SMALLINT DEFAULT '0',
	ISEXTERNAL SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_HRM_USER_SYNC_SET IS '通讯录成员与集成系统人员同步设置表'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_SET.ID IS '主键ID'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_SET.OUTSYS_ID IS '集成系统ID'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_SET.SYS_TASK_ID IS '定时同步任务ID'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_SET.ROOT_DEPT_ID IS '顶级部门ID，对应em_hrm_dept表主键ID'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_SET.BASEID_TYPE IS '新成员生成基础用户信息时ID的规则：1-使用系统默认的uuid ，2-使用ecology系统的数据库ID'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_SET.USERID_FIELD IS '新成员账号字段：1-数据库ID ，2-登录账号，3-手机号'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_SET.MATCH_USER_FIELD IS '已存在成员本系统的匹配字段：1-账号 ，2-手机号，3-邮箱'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_SET.MATCH_OUTSYS_FIELD IS '已存在成员集成系统的匹配字段：1-数据库ID ，2-登录账号，3-手机，4-邮箱'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_SET.USER_DEL_TYPE IS '离职成员的处理方式：1-禁用 ，2-删除'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_SET.DEPT_SYNC_TYPE IS '部门同步方式：1-同步部门 2-不同步部门且将人员移动到顶级部门下 3-不同步部门且人员部门信息不变'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_SET.ISALLUSER IS '是否同步无账号人员：0-否 ，1-是'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_SET.ISEXTERNAL IS '是否同步外部用户，0-否，1-是'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_SET.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_SET.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_SET.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_SET.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_SET.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_AGENT (
	ID VARCHAR(32) NOT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	AGENT_NAME VARCHAR(50) DEFAULT NULL,
	AGENT_TYPE SMALLINT DEFAULT NULL,
	OPEN_AGENT_ID VARCHAR(50) DEFAULT NULL,
	ASSOCIATE_CPAGENTID VARCHAR(100) DEFAULT NULL,
	AGENT_KEY VARCHAR(100) DEFAULT NULL,
	AGENT_SECRET VARCHAR(100) DEFAULT NULL,
	AGENT_DESC VARCHAR(500) DEFAULT NULL,
	CALLBACK_TOKEN VARCHAR(500) DEFAULT NULL,
	CALLBACK_AESKEY VARCHAR(500) DEFAULT NULL,
	REDIRECT_DOMAIN VARCHAR(500) DEFAULT NULL,
	REPORT_LOCATION_FLAG SMALLINT DEFAULT '0',
	REPORT_USER SMALLINT DEFAULT '0',
	REPORT_MSG SMALLINT DEFAULT '0',
	AUTH_TYPE SMALLINT DEFAULT '1',
	AUTH_SECRET VARCHAR(100) DEFAULT NULL,
	SMS_CONNECT_KEY VARCHAR(50) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_CP_AGENT IS '企业号应用信息表'
;

COMMENT ON COLUMN EM_CP_AGENT.CP_CORP_ID IS '企业号基本信息ID'
;

COMMENT ON COLUMN EM_CP_AGENT.AGENT_NAME IS '应用名称'
;

COMMENT ON COLUMN EM_CP_AGENT.AGENT_TYPE IS '应用类型：1-普通应用 2-企业考勤数据同步应用'
;

COMMENT ON COLUMN EM_CP_AGENT.OPEN_AGENT_ID IS '应用ID'
;

COMMENT ON COLUMN EM_CP_AGENT.ASSOCIATE_CPAGENTID IS '关联指向应用主键id'
;

COMMENT ON COLUMN EM_CP_AGENT.AGENT_KEY IS '应用KEY'
;

COMMENT ON COLUMN EM_CP_AGENT.AGENT_SECRET IS '应用秘钥'
;

COMMENT ON COLUMN EM_CP_AGENT.AGENT_DESC IS '应用描述信息'
;

COMMENT ON COLUMN EM_CP_AGENT.CALLBACK_TOKEN IS '回调令牌'
;

COMMENT ON COLUMN EM_CP_AGENT.CALLBACK_AESKEY IS '回调秘钥'
;

COMMENT ON COLUMN EM_CP_AGENT.REDIRECT_DOMAIN IS '可信域名'
;

COMMENT ON COLUMN EM_CP_AGENT.REPORT_LOCATION_FLAG IS '是否上报地理位置：1-是，0-否'
;

COMMENT ON COLUMN EM_CP_AGENT.REPORT_USER IS '是否上报用户状态：1-是，0-否'
;

COMMENT ON COLUMN EM_CP_AGENT.REPORT_MSG IS '是否上报用户消息：1-是，0-否'
;

COMMENT ON COLUMN EM_CP_AGENT.AUTH_TYPE IS '身份认证类型 1-auth2，2-SHA1，3-auth_code'
;

COMMENT ON COLUMN EM_CP_AGENT.AUTH_SECRET IS '身份认证秘钥，主要针对auth_type为2的情况'
;

COMMENT ON COLUMN EM_CP_AGENT.SMS_CONNECT_KEY IS '和飞信消息应用接入号'
;

COMMENT ON COLUMN EM_CP_AGENT.STATUS IS '状态：1-正常、3-删除'
;

COMMENT ON COLUMN EM_CP_AGENT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_AGENT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_AGENT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_AGENT.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_AGENT.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SMS_RECORD (
	ID VARCHAR(32) NOT NULL DEFAULT '',
	MOBILE TEXT,
	CONTENT TEXT,
	SMS_TYPE SMALLINT DEFAULT NULL,
	STRATEGY VARCHAR(255) DEFAULT NULL,
	SUCCESS SMALLINT DEFAULT NULL,
	REMARK TEXT,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_SMS_RECORD IS '短信记录表'
;

COMMENT ON COLUMN EM_SMS_RECORD.ID IS '主键'
;

COMMENT ON COLUMN EM_SMS_RECORD.MOBILE IS '手机号'
;

COMMENT ON COLUMN EM_SMS_RECORD.CONTENT IS '短信内容'
;

COMMENT ON COLUMN EM_SMS_RECORD.SMS_TYPE IS '短信类型：1-验证码、2-普通短消息'
;

COMMENT ON COLUMN EM_SMS_RECORD.STRATEGY IS '策略'
;

COMMENT ON COLUMN EM_SMS_RECORD.SUCCESS IS '是否发送成功：0-失败、1-成功'
;

COMMENT ON COLUMN EM_SMS_RECORD.REMARK IS '备注'
;

COMMENT ON COLUMN EM_SMS_RECORD.STATUS IS '状态'
;

COMMENT ON COLUMN EM_SMS_RECORD.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SMS_RECORD.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SMS_RECORD.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SMS_RECORD.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SMS_RECORD.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_CA_SETTING (
	ID VARCHAR(32) NOT NULL,
	ENABLED SMALLINT DEFAULT NULL,
	API_URL VARCHAR(200) DEFAULT NULL,
	APP_ID VARCHAR(100) DEFAULT NULL,
	AUTH_KEY_ID VARCHAR(100) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_CA_SETTING IS 'CA集成设置信息'
;

COMMENT ON COLUMN EM_SYS_CA_SETTING.ENABLED IS '是否开启CA集成功能：0-禁用、1-开启'
;

COMMENT ON COLUMN EM_SYS_CA_SETTING.API_URL IS '接口地址'
;

COMMENT ON COLUMN EM_SYS_CA_SETTING.APP_ID IS '接入的appId'
;

COMMENT ON COLUMN EM_SYS_CA_SETTING.AUTH_KEY_ID IS '接入的authKeyID'
;

COMMENT ON COLUMN EM_SYS_CA_SETTING.STATUS IS '状态'
;

COMMENT ON COLUMN EM_SYS_CA_SETTING.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_CA_SETTING.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_CA_SETTING.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_CA_SETTING.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_CA_SETTING.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SC_SCAN_RULE (
	ID VARCHAR(32) NOT NULL,
	RULE_NAME VARCHAR(50) DEFAULT NULL,
	CLIENT_TYPE SMALLINT DEFAULT '0',
	MATCHING_MODE SMALLINT DEFAULT NULL,
	MATCHING_KEYWORD VARCHAR(500) DEFAULT NULL,
	ACTION_TYPE SMALLINT DEFAULT NULL,
	ACTION_SETTING1 VARCHAR(500) DEFAULT NULL,
	ACTION_SETTING2 VARCHAR(500) DEFAULT NULL,
	ACTION_SETTING3 VARCHAR(500) DEFAULT NULL,
	CLOSE_SCAN SMALLINT DEFAULT '1',
	PLAY_SOUND SMALLINT DEFAULT '1',
	PRIORITY INT DEFAULT '0',
	STATUS SMALLINT DEFAULT NULL,
	PUBLISH_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SC_SCAN_RULE IS '客户端扫码规则表'
;

COMMENT ON COLUMN EM_SC_SCAN_RULE.ID IS '主键'
;

COMMENT ON COLUMN EM_SC_SCAN_RULE.RULE_NAME IS '规则名称'
;

COMMENT ON COLUMN EM_SC_SCAN_RULE.CLIENT_TYPE IS '适用客户端类型：1-全部，2-ios，3-android'
;

COMMENT ON COLUMN EM_SC_SCAN_RULE.MATCHING_MODE IS '匹配方式：1-包含，2-开头，3-结束，4-完全匹配，5-正则表达式，6-全部'
;

COMMENT ON COLUMN EM_SC_SCAN_RULE.MATCHING_KEYWORD IS '匹配关键字'
;

COMMENT ON COLUMN EM_SC_SCAN_RULE.ACTION_TYPE IS '执行动作类型：1-访问地址，2-浮出显示内容，3-新窗口显示内容，4-请求第三方服务，5-添加名片，6-打开某个应用，7-调用本地功能，8-不做任何操作，9-自定义'
;

COMMENT ON COLUMN EM_SC_SCAN_RULE.ACTION_SETTING1 IS '执行动作参数1'
;

COMMENT ON COLUMN EM_SC_SCAN_RULE.ACTION_SETTING2 IS '执行动作参数2'
;

COMMENT ON COLUMN EM_SC_SCAN_RULE.ACTION_SETTING3 IS '执行动作参数3'
;

COMMENT ON COLUMN EM_SC_SCAN_RULE.CLOSE_SCAN IS '是否关闭扫码器：1-是，0-否'
;

COMMENT ON COLUMN EM_SC_SCAN_RULE.PLAY_SOUND IS '是否播放提示音：1-是，0-否'
;

COMMENT ON COLUMN EM_SC_SCAN_RULE.PRIORITY IS '优先级，值越小优先级越高'
;

COMMENT ON COLUMN EM_SC_SCAN_RULE.STATUS IS '状态：1-正常，2-禁用，3-删除'
;

COMMENT ON COLUMN EM_SC_SCAN_RULE.PUBLISH_TIME IS '发布时间'
;

COMMENT ON COLUMN EM_SC_SCAN_RULE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SC_SCAN_RULE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SC_SCAN_RULE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SC_SCAN_RULE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SC_SCAN_RULE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_LOG_AGENT_USE (
	ID VARCHAR(32) NOT NULL,
	OPEN_AGENT_ID INT DEFAULT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	ACCESS_TOKEN VARCHAR(100) DEFAULT NULL,
	USE_DATE VARCHAR(10) DEFAULT NULL,
	USE_TIME VARCHAR(8) DEFAULT NULL,
	IP VARCHAR(255) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_LOG_AGENT_USE IS '应用使用日志'
;

COMMENT ON COLUMN EM_LOG_AGENT_USE.ID IS '主键'
;

COMMENT ON COLUMN EM_LOG_AGENT_USE.OPEN_AGENT_ID IS '应用ID'
;

COMMENT ON COLUMN EM_LOG_AGENT_USE.BASE_USER_ID IS '用户ID'
;

COMMENT ON COLUMN EM_LOG_AGENT_USE.ACCESS_TOKEN IS '访问token'
;

COMMENT ON COLUMN EM_LOG_AGENT_USE.USE_DATE IS '使用日期'
;

COMMENT ON COLUMN EM_LOG_AGENT_USE.USE_TIME IS '使用时间'
;

COMMENT ON COLUMN EM_LOG_AGENT_USE.IP IS 'IP地址'
;

COMMENT ON COLUMN EM_LOG_AGENT_USE.CREATE_TIME IS '日志创建时间'
;

COMMENT ON COLUMN EM_LOG_AGENT_USE.TENANT_ID IS '租户ID'
;


CREATE TABLE EM_CP_CHECKIN_SYNC_COND (
	ID VARCHAR(32) NOT NULL,
	OUTSYS_ID VARCHAR(32) DEFAULT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	COND_TYPE SMALLINT DEFAULT NULL,
	AUTH_TYPE SMALLINT DEFAULT NULL,
	AUTH_TYPE_NAME VARCHAR(32) DEFAULT NULL,
	AUTH_VALUE VARCHAR(32) DEFAULT NULL,
	AUTH_VALUE_NAME VARCHAR(32) DEFAULT NULL,
	AUTH_SECLEVEL VARCHAR(32) DEFAULT NULL,
	AUTH_SECLEVEL_MAX VARCHAR(32) DEFAULT NULL,
	SHOWORDER INT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	CHECKIN_SET_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_CP_CHECKIN_SYNC_COND IS '企业号考勤打卡数据同步条件表'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_COND.ID IS '主键ID'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_COND.OUTSYS_ID IS '集成系统ID'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_COND.CP_CORP_ID IS '企业号基本信息ID'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_COND.COND_TYPE IS '条件类型：1-人员，2-部门，3-分部'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_COND.AUTH_TYPE IS '规则类型：0-人员，1-分部，2-部门，3-角色，4-所有人'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_COND.AUTH_TYPE_NAME IS '规则类型显示名'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_COND.AUTH_VALUE IS '规则类型值'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_COND.AUTH_VALUE_NAME IS '规则类型值显示名'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_COND.AUTH_SECLEVEL IS '规则安全级别最小值'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_COND.AUTH_SECLEVEL_MAX IS '规则安全级别最大值'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_COND.SHOWORDER IS '显示顺序'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_COND.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_COND.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_COND.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_COND.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_COND.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_COND.TENANT_ID IS '企业租户ID'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_COND.CHECKIN_SET_ID IS '打卡同步设置id'
;


CREATE TABLE EM_CP_USER_SYNC_COND (
	ID VARCHAR(32) NOT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	OUTSYS_ID VARCHAR(32) DEFAULT NULL,
	COND_TYPE SMALLINT DEFAULT NULL,
	AUTH_TYPE SMALLINT DEFAULT NULL,
	AUTH_TYPE_NAME VARCHAR(255) DEFAULT NULL,
	AUTH_VALUE VARCHAR(32) DEFAULT NULL,
	AUTH_VALUE_NAME VARCHAR(255) DEFAULT NULL,
	AUTH_SECLEVEL VARCHAR(32) DEFAULT NULL,
	AUTH_SECLEVEL_MAX VARCHAR(32) DEFAULT NULL,
	SHOWORDER INT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	IS_CONTAINS_CHILD SMALLINT NOT NULL DEFAULT '1',
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_CP_USER_SYNC_COND IS '企业号通讯录成员与集成系统人员同步条件表'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_COND.ID IS '主键ID'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_COND.CP_CORP_ID IS '企业号基本信息ID'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_COND.OUTSYS_ID IS '集成系统ID'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_COND.COND_TYPE IS '条件类型：1-人员，2-部门，3-分部'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_COND.AUTH_TYPE IS '规则类型：0-人员，1-分部，2-部门，3-角色，4-所有人'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_COND.AUTH_TYPE_NAME IS '规则类型显示名'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_COND.AUTH_VALUE IS '规则类型值'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_COND.AUTH_VALUE_NAME IS '规则类型值显示名'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_COND.AUTH_SECLEVEL IS '规则安全级别最小值'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_COND.AUTH_SECLEVEL_MAX IS '规则安全级别最大值'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_COND.SHOWORDER IS '显示顺序'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_COND.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_COND.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_COND.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_COND.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_COND.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_COND.TENANT_ID IS '企业租户ID'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_COND.IS_CONTAINS_CHILD IS '是否包含下级，默认包含'
;


CREATE TABLE EM_SYS_CA_RIGHT (
	ID VARCHAR(32) NOT NULL,
	HRM_DATA_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_TYPE SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_SYS_CA_RIGHT IS 'ca使用权限设置表'
;

COMMENT ON COLUMN EM_SYS_CA_RIGHT.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SYS_CA_RIGHT.HRM_DATA_ID IS '通讯录成员或部门表ID'
;

COMMENT ON COLUMN EM_SYS_CA_RIGHT.HRM_DATA_TYPE IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;

COMMENT ON COLUMN EM_SYS_CA_RIGHT.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_SYS_CA_RIGHT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_CA_RIGHT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_CA_RIGHT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_CA_RIGHT.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_CA_RIGHT.TENANT_ID IS '企业租户ID'
;


CREATE TABLE QRTZ_SCHEDULER_STATE (
	SCHED_NAME VARCHAR(120) NOT NULL,
	INSTANCE_NAME VARCHAR(190) NOT NULL,
	LAST_CHECKIN_TIME BIGINT NOT NULL,
	CHECKIN_INTERVAL BIGINT NOT NULL,
	PRIMARY KEY (SCHED_NAME, INSTANCE_NAME)
)
;


CREATE TABLE EM_CP_MSG (
	ID VARCHAR(32) NOT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	CP_AGENT_ID VARCHAR(32) DEFAULT NULL,
	RELATE_AGENT_ID VARCHAR(32) DEFAULT NULL,
	MSG_JSON TEXT,
	MSG_DATA_ID VARCHAR(50) DEFAULT NULL,
	MSG_DATA_TYPE VARCHAR(20) DEFAULT NULL,
	LINK_URL VARCHAR(500) DEFAULT NULL,
	LINK_URL_PC VARCHAR(500) DEFAULT NULL,
	IM_MSG_ID TEXT,
	TOUSERS TEXT,
	SENDE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_CP_MSG IS '企业号推送消息信息表'
;

COMMENT ON COLUMN EM_CP_MSG.ID IS '主键ID'
;

COMMENT ON COLUMN EM_CP_MSG.CP_CORP_ID IS '所属企业号ID'
;

COMMENT ON COLUMN EM_CP_MSG.CP_AGENT_ID IS '所属企业号应用ID'
;

COMMENT ON COLUMN EM_CP_MSG.RELATE_AGENT_ID IS '关联的本地消息型应用ID'
;

COMMENT ON COLUMN EM_CP_MSG.MSG_JSON IS '消息内容'
;

COMMENT ON COLUMN EM_CP_MSG.MSG_DATA_ID IS '消息数据ID'
;

COMMENT ON COLUMN EM_CP_MSG.MSG_DATA_TYPE IS '消息数据类型'
;

COMMENT ON COLUMN EM_CP_MSG.LINK_URL IS '链接地址'
;

COMMENT ON COLUMN EM_CP_MSG.LINK_URL_PC IS 'PC端链接地址'
;

COMMENT ON COLUMN EM_CP_MSG.IM_MSG_ID IS 'IM返回的消息ID'
;

COMMENT ON COLUMN EM_CP_MSG.TOUSERS IS '消息接收者'
;

COMMENT ON COLUMN EM_CP_MSG.SENDE_TIME IS '发送时间'
;

COMMENT ON COLUMN EM_CP_MSG.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_CP_MSG.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_MSG.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_MSG.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_MSG.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_MSG.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_DEPT_USER (
	ID VARCHAR(32) NOT NULL,
	CP_USER_ID VARCHAR(32) DEFAULT NULL,
	CP_DEPT_ID VARCHAR(32) DEFAULT NULL,
	POSITION VARCHAR(800) DEFAULT NULL,
	SHOWORDER BIGINT DEFAULT NULL,
	ISFITOA SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_CP_DEPT_USER IS '企业号通讯录成员与部门关联表'
;

COMMENT ON COLUMN EM_CP_DEPT_USER.ID IS '主键ID'
;

COMMENT ON COLUMN EM_CP_DEPT_USER.CP_USER_ID IS '通讯录人员表ID'
;

COMMENT ON COLUMN EM_CP_DEPT_USER.CP_DEPT_ID IS '通讯录部门表ID'
;

COMMENT ON COLUMN EM_CP_DEPT_USER.POSITION IS '岗位'
;

COMMENT ON COLUMN EM_CP_DEPT_USER.SHOWORDER IS '显示顺序'
;

COMMENT ON COLUMN EM_CP_DEPT_USER.ISFITOA IS '人员在企业号和OA里的这个部门是否一致，1-是，0-否'
;

COMMENT ON COLUMN EM_CP_DEPT_USER.STATUS IS '状态'
;

COMMENT ON COLUMN EM_CP_DEPT_USER.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_DEPT_USER.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_DEPT_USER.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_DEPT_USER.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_DEPT_USER.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SH_RIGHT_TARGET (
	ID VARCHAR(32) NOT NULL,
	RIGHT_BASE_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_TYPE SMALLINT DEFAULT NULL,
	HRM_DATA_ID VARCHAR(32) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_SH_RIGHT_TARGET IS '企业通讯录权限规则对象表'
;

COMMENT ON COLUMN EM_SH_RIGHT_TARGET.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SH_RIGHT_TARGET.RIGHT_BASE_ID IS '权限设置基础ID'
;

COMMENT ON COLUMN EM_SH_RIGHT_TARGET.HRM_DATA_TYPE IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;

COMMENT ON COLUMN EM_SH_RIGHT_TARGET.HRM_DATA_ID IS '通讯录成员或部门表ID'
;

COMMENT ON COLUMN EM_SH_RIGHT_TARGET.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_SH_RIGHT_TARGET.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SH_RIGHT_TARGET.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SH_RIGHT_TARGET.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SH_RIGHT_TARGET.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SH_RIGHT_TARGET.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_MSG_GROUP (
	ID VARCHAR(32) NOT NULL,
	GROUP_TYPE SMALLINT DEFAULT '1',
	GROUP_NAME VARCHAR(100) DEFAULT NULL,
	ENGLISH_NAME VARCHAR(100) DEFAULT NULL,
	DESCRIPTION VARCHAR(200) DEFAULT NULL,
	LOGO VARCHAR(255) DEFAULT NULL,
	VIEW_COUNT INT DEFAULT NULL,
	SERVER_GROUP_ID VARCHAR(50) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_MSG_GROUP IS '企业消息群组基础表'
;

COMMENT ON COLUMN EM_MSG_GROUP.ID IS '主键ID'
;

COMMENT ON COLUMN EM_MSG_GROUP.GROUP_TYPE IS '群组类型 1-普通群，2-部门群，3-公司群'
;

COMMENT ON COLUMN EM_MSG_GROUP.GROUP_NAME IS '群组名称'
;

COMMENT ON COLUMN EM_MSG_GROUP.ENGLISH_NAME IS '英文名称'
;

COMMENT ON COLUMN EM_MSG_GROUP.DESCRIPTION IS '描述'
;

COMMENT ON COLUMN EM_MSG_GROUP.LOGO IS '头像'
;

COMMENT ON COLUMN EM_MSG_GROUP.VIEW_COUNT IS '新成员可查看最近聊天记录数量，默认100'
;

COMMENT ON COLUMN EM_MSG_GROUP.SERVER_GROUP_ID IS '对应的消息服务器群组ID'
;

COMMENT ON COLUMN EM_MSG_GROUP.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_MSG_GROUP.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_MSG_GROUP.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_MSG_GROUP.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_MSG_GROUP.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_MSG_GROUP.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_BASEUSER_LOCATION (
	ID SERIAL NOT NULL,
	REPORT_TYPE SMALLINT DEFAULT NULL,
	CLIENT_INFO VARCHAR(1000) DEFAULT NULL,
	CLIENT_TYPE SMALLINT DEFAULT '0',
	DEVICE_ID VARCHAR(500) DEFAULT NULL,
	LONGITUDE VARCHAR(100) DEFAULT NULL,
	LATITUDE VARCHAR(100) DEFAULT NULL,
	LOCATING TEXT,
	STATUS INT DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_SYS_BASEUSER_LOCATION IS '用户定位信息记录表'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_LOCATION.ID IS '主键'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_LOCATION.REPORT_TYPE IS '上报类型，1-定时触发,2-登录后触发,3-唤醒后触发,4-发送消息时触发,5-打开新窗口时触发'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_LOCATION.CLIENT_INFO IS '上报客户端数据信息'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_LOCATION.CLIENT_TYPE IS '设备类型：1-PC客户端，2-ios，3-android，4-web'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_LOCATION.DEVICE_ID IS '设备标识'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_LOCATION.LONGITUDE IS '经度'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_LOCATION.LATITUDE IS '纬度'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_LOCATION.LOCATING IS '精确位置'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_LOCATION.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_LOCATION.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_LOCATION.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_LOCATION.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_LOCATION.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_LOCATION.TENANT_ID IS '企业租户ID'
;


CREATE TYPE PROXY_TYPE_ENUM_ AS ENUM('HTTP', 'SOCKS')
;

CREATE TABLE EM_SYS_PROXY (
	ID VARCHAR(32) NOT NULL,
	ENABLED SMALLINT DEFAULT NULL,
	PROXY_TYPE PROXY_TYPE_ENUM_ DEFAULT NULL,
	HOST VARCHAR(255) DEFAULT NULL,
	PORT INT DEFAULT NULL,
	USERNAME VARCHAR(255) DEFAULT NULL,
	PASSWORD VARCHAR(255) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_PROXY IS '系统代理信息'
;

COMMENT ON COLUMN EM_SYS_PROXY.ID IS '主键'
;

COMMENT ON COLUMN EM_SYS_PROXY.ENABLED IS '是否启用：0-否、1-是'
;

COMMENT ON COLUMN EM_SYS_PROXY.PROXY_TYPE IS '代理服务协议'
;

COMMENT ON COLUMN EM_SYS_PROXY.HOST IS '代理服务地址'
;

COMMENT ON COLUMN EM_SYS_PROXY.PORT IS '代理服务端口'
;

COMMENT ON COLUMN EM_SYS_PROXY.USERNAME IS '代理服务账号'
;

COMMENT ON COLUMN EM_SYS_PROXY.PASSWORD IS '代理服务密码'
;

COMMENT ON COLUMN EM_SYS_PROXY.STATUS IS '状态'
;

COMMENT ON COLUMN EM_SYS_PROXY.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_PROXY.CREATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_PROXY.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_PROXY.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_PROXY.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_CITY (
	CITY_CODE INT NOT NULL,
	CITY_NAME VARCHAR(50) NOT NULL,
	PROVINCE_CODE INT NOT NULL,
	PRIMARY KEY (CITY_CODE)
)
;


COMMENT ON TABLE EM_SYS_CITY IS '城市表'
;

COMMENT ON COLUMN EM_SYS_CITY.CITY_CODE IS '代码'
;

COMMENT ON COLUMN EM_SYS_CITY.CITY_NAME IS '名称'
;

COMMENT ON COLUMN EM_SYS_CITY.PROVINCE_CODE IS '所属省份代码'
;


CREATE TABLE EM_SYS_LANG_DATA (
	ID VARCHAR(32) NOT NULL,
	DATA_TAG VARCHAR(50) DEFAULT NULL,
	DATA_ID VARCHAR(32) DEFAULT NULL,
	LANG_TAG VARCHAR(10) DEFAULT NULL,
	SET_VALUE VARCHAR(200) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_SYS_LANG_DATA IS '系统配置数据多语言设置'
;

COMMENT ON COLUMN EM_SYS_LANG_DATA.DATA_TAG IS '数据标识，规则为：表名:字段名，如em_sc_theme_nav:nav_name'
;

COMMENT ON COLUMN EM_SYS_LANG_DATA.DATA_ID IS '数据ID，即具体数据的主键ID值'
;

COMMENT ON COLUMN EM_SYS_LANG_DATA.LANG_TAG IS '语言标识：zh-汉语(简体)，zh_TW-汉语(繁体)，en-英语，ja-日语，ko-韩语，vi-越南语'
;

COMMENT ON COLUMN EM_SYS_LANG_DATA.SET_VALUE IS '设置项显示内容'
;

COMMENT ON COLUMN EM_SYS_LANG_DATA.STATUS IS '状态：1-正常、3-删除'
;

COMMENT ON COLUMN EM_SYS_LANG_DATA.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_LANG_DATA.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_LANG_DATA.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_LANG_DATA.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_LANG_DATA.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_HRM_GROUP_USER (
	ID VARCHAR(32) NOT NULL,
	HRM_GROUP_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_TYPE SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_HRM_GROUP_USER IS '企业通讯录分组与成员及部门关联表'
;

COMMENT ON COLUMN EM_HRM_GROUP_USER.ID IS '主键ID'
;

COMMENT ON COLUMN EM_HRM_GROUP_USER.HRM_GROUP_ID IS '通讯录分组表ID'
;

COMMENT ON COLUMN EM_HRM_GROUP_USER.HRM_DATA_ID IS '通讯录成员或部门表ID'
;

COMMENT ON COLUMN EM_HRM_GROUP_USER.HRM_DATA_TYPE IS '通讯录数据类型：1-成员，2-部门(不包含下级部门)，3-部门(包含下级部门)'
;

COMMENT ON COLUMN EM_HRM_GROUP_USER.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_HRM_GROUP_USER.STATUS IS '状态 1-正常，2-禁用，3-删除'
;

COMMENT ON COLUMN EM_HRM_GROUP_USER.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_HRM_GROUP_USER.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_HRM_GROUP_USER.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_HRM_GROUP_USER.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_TAG (
	ID VARCHAR(32) NOT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	OPEN_TAG_ID VARCHAR(100) DEFAULT NULL,
	TAG_NAME VARCHAR(100) DEFAULT NULL,
	USER_AMOUNT INT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_CP_TAG IS '企业号通讯录标签表'
;

COMMENT ON COLUMN EM_CP_TAG.ID IS '主键'
;

COMMENT ON COLUMN EM_CP_TAG.CP_CORP_ID IS '企业号基本信息ID'
;

COMMENT ON COLUMN EM_CP_TAG.OPEN_TAG_ID IS '公众号标签ID'
;

COMMENT ON COLUMN EM_CP_TAG.TAG_NAME IS '标签名称'
;

COMMENT ON COLUMN EM_CP_TAG.USER_AMOUNT IS '标签用户数'
;

COMMENT ON COLUMN EM_CP_TAG.STATUS IS '状态 1-正常，2-禁用，3-删除'
;

COMMENT ON COLUMN EM_CP_TAG.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_TAG.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_TAG.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_TAG.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_TAG.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_LOCALIZATION (
	ID VARCHAR(32) NOT NULL,
	ISLOCAL SMALLINT DEFAULT '0',
	APPZIPFILE VARCHAR(500) DEFAULT NULL,
	INDEXPAGE VARCHAR(500) DEFAULT NULL,
	QUERY VARCHAR(500) DEFAULT NULL,
	BASEURL VARCHAR(500) DEFAULT NULL,
	VERSION VARCHAR(200) DEFAULT NULL,
	MINVERSION VARCHAR(200) DEFAULT NULL,
	FUNTYPE SMALLINT NOT NULL,
	TARGETID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_LOCALIZATION IS '系统支持本地化配置数据表'
;

COMMENT ON COLUMN EM_SYS_LOCALIZATION.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SYS_LOCALIZATION.ISLOCAL IS '是否开启本地化：1-是，0-否（默认）'
;

COMMENT ON COLUMN EM_SYS_LOCALIZATION.APPZIPFILE IS '压缩文件下载路径'
;

COMMENT ON COLUMN EM_SYS_LOCALIZATION.INDEXPAGE IS '压缩文件解压后的首页地址，第一层文件夹为解压后的文件夹名称'
;

COMMENT ON COLUMN EM_SYS_LOCALIZATION.QUERY IS '附加参数，会追加到访问路径后面'
;

COMMENT ON COLUMN EM_SYS_LOCALIZATION.BASEURL IS '离线应用的其他接口如果传输的是相对路径，那么会使用此地址作为请求的基础地址'
;

COMMENT ON COLUMN EM_SYS_LOCALIZATION.VERSION IS '版本号，字符串类型的整数值'
;

COMMENT ON COLUMN EM_SYS_LOCALIZATION.MINVERSION IS '小版本，字符串类型的整数值'
;

COMMENT ON COLUMN EM_SYS_LOCALIZATION.FUNTYPE IS '本地化配置功能使用位置，类型，1-应用，2-打开人员卡片信息，3-修改密码等，如果该对象存在继承者，这个字段无效(目前类型为1的 保存在应用表 em_agent_base)'
;

COMMENT ON COLUMN EM_SYS_LOCALIZATION.TARGETID IS '本地化配置功能使用位置，类型，1-应用，此时对于的应用id'
;


CREATE TYPE STRATEGY_ENUM_2 AS ENUM('cloopen')
;

CREATE TABLE EM_SETTING_VOICE (
	ID VARCHAR(32) NOT NULL,
	NAME VARCHAR(255) DEFAULT NULL,
	STRATEGY STRATEGY_ENUM_2 DEFAULT NULL,
	SETTING TEXT,
	IS_DEFALUT SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SETTING_VOICE IS '语音通知设置表'
;

COMMENT ON COLUMN EM_SETTING_VOICE.ID IS '主键'
;

COMMENT ON COLUMN EM_SETTING_VOICE.NAME IS '语音通知模板名称'
;

COMMENT ON COLUMN EM_SETTING_VOICE.STRATEGY IS '语音通知模板策略'
;

COMMENT ON COLUMN EM_SETTING_VOICE.SETTING IS '语音通知模板设置参数（JSON数据）'
;

COMMENT ON COLUMN EM_SETTING_VOICE.IS_DEFALUT IS '是否设为默认：1-是，其他-否'
;

COMMENT ON COLUMN EM_SETTING_VOICE.STATUS IS '状态'
;

COMMENT ON COLUMN EM_SETTING_VOICE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SETTING_VOICE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SETTING_VOICE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SETTING_VOICE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SETTING_VOICE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SH_USER_FIELDHIDDEN (
	ID VARCHAR(32) NOT NULL,
	FIELD_ID VARCHAR(32) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_SH_USER_FIELDHIDDEN IS '企业通讯录信息隐藏设置表'
;

COMMENT ON COLUMN EM_SH_USER_FIELDHIDDEN.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SH_USER_FIELDHIDDEN.FIELD_ID IS '隐藏的字段ID： 1-手机，2-邮箱，3-岗位，4-座机，否则是em_hrm_user_attr表的ID'
;

COMMENT ON COLUMN EM_SH_USER_FIELDHIDDEN.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_SH_USER_FIELDHIDDEN.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SH_USER_FIELDHIDDEN.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SH_USER_FIELDHIDDEN.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SH_USER_FIELDHIDDEN.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SH_USER_FIELDHIDDEN.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_CLIENTTASK_RIGHT (
	ID VARCHAR(32) NOT NULL,
	TASK_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_TYPE SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_SYS_CLIENTTASK_RIGHT IS '客户端定时任务使用权限设置表'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_RIGHT.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_RIGHT.TASK_ID IS '对应任务id'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_RIGHT.HRM_DATA_ID IS '通讯录成员或部门表ID'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_RIGHT.HRM_DATA_TYPE IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_RIGHT.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_RIGHT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_RIGHT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_RIGHT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_RIGHT.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_RIGHT.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CA_BASEUSER_CERT (
	ID VARCHAR(32) NOT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	DEVICE_ID VARCHAR(100) DEFAULT NULL,
	CERT_ID VARCHAR(100) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_CA_BASEUSER_CERT IS '用户CA证书信息记录表'
;

COMMENT ON COLUMN EM_CA_BASEUSER_CERT.ID IS '主键'
;

COMMENT ON COLUMN EM_CA_BASEUSER_CERT.BASE_USER_ID IS '基础用户ID'
;

COMMENT ON COLUMN EM_CA_BASEUSER_CERT.DEVICE_ID IS '设备标识'
;

COMMENT ON COLUMN EM_CA_BASEUSER_CERT.CERT_ID IS '证书标识'
;

COMMENT ON COLUMN EM_CA_BASEUSER_CERT.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_CA_BASEUSER_CERT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CA_BASEUSER_CERT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CA_BASEUSER_CERT.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CA_BASEUSER_CERT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CA_BASEUSER_CERT.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_HRM_DEPT (
	ID VARCHAR(32) NOT NULL,
	OPEN_DEPT_ID INT DEFAULT NULL,
	DEPT_NAME VARCHAR(255) DEFAULT NULL,
	ENGLISH_NAME VARCHAR(255) DEFAULT NULL,
	PARENT_ID VARCHAR(32) DEFAULT NULL,
	ALL_PARENT_IDS VARCHAR(1000) DEFAULT NULL,
	SHOWORDER DECIMAL(19, 2) DEFAULT NULL,
	OUTSYS_ID VARCHAR(32) DEFAULT NULL,
	OUTSYS_DEPT_TYPE SMALLINT DEFAULT NULL,
	OUTSYS_DEPT_ID VARCHAR(32) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_HRM_DEPT IS '企业通信录部门表'
;

COMMENT ON COLUMN EM_HRM_DEPT.ID IS '主键ID'
;

COMMENT ON COLUMN EM_HRM_DEPT.OPEN_DEPT_ID IS 'API交互时的唯一标识，采用某企业内自增长逻辑，即按tenantid自增长'
;

COMMENT ON COLUMN EM_HRM_DEPT.PARENT_ID IS '上级部门ID'
;

COMMENT ON COLUMN EM_HRM_DEPT.ALL_PARENT_IDS IS '所有上级部门ID用逗号分隔'
;

COMMENT ON COLUMN EM_HRM_DEPT.SHOWORDER IS '显示顺序'
;

COMMENT ON COLUMN EM_HRM_DEPT.OUTSYS_ID IS '对应集成系统的ID'
;

COMMENT ON COLUMN EM_HRM_DEPT.OUTSYS_DEPT_TYPE IS '对应集成系统部门类型'
;

COMMENT ON COLUMN EM_HRM_DEPT.OUTSYS_DEPT_ID IS '对应集成系统部门ID'
;

COMMENT ON COLUMN EM_HRM_DEPT.STATUS IS '状态 1-正常，2-封存，3-删除'
;

COMMENT ON COLUMN EM_HRM_DEPT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_HRM_DEPT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_HRM_DEPT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_HRM_DEPT.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_HRM_DEPT.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_BASEUSER_CONTACT (
	ID VARCHAR(32) NOT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	CONTACT_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_SYS_BASEUSER_CONTACT IS '常用联系人'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_CONTACT.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_CONTACT.BASE_USER_ID IS '人员基础用户ID'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_CONTACT.CONTACT_USER_ID IS '联系人员的基础用户ID'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_CONTACT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_CONTACT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_CONTACT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_CONTACT.UPDATE_TIME IS '修改时间'
;


CREATE TABLE EM_VIDEO_ZHUMU_USER (
	ID VARCHAR(32) NOT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	ZCODE VARCHAR(50) DEFAULT NULL,
	EMAIL VARCHAR(100) DEFAULT NULL,
	PMI VARCHAR(50) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_VIDEO_ZHUMU_USER IS '瞩目视频会议人员标识表'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_USER.BASE_USER_ID IS '基础用户ID'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_USER.ZCODE IS '瞩目人员标识'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_USER.EMAIL IS '邮箱'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_USER.PMI IS '个人会议号'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_USER.STATUS IS '状态'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_USER.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_USER.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_USER.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_USER.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_VIDEO_ZHUMU_USER.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_VIDEO_CHAT_BASE (
	ID VARCHAR(32) NOT NULL,
	CHAT_NAME VARCHAR(100) DEFAULT NULL,
	CHAT_UID VARCHAR(100) DEFAULT NULL,
	CHAT_TYPE SMALLINT DEFAULT NULL,
	CHAT_MEMBER_COUNT INT DEFAULT NULL,
	CHAT_MEMBER_IDS TEXT,
	LAST_CALL_SENDER_ID VARCHAR(32) DEFAULT NULL,
	LAST_CALL_TYPE SMALLINT DEFAULT NULL,
	LAST_CALL_TIME BIGINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_VIDEO_CHAT_BASE IS '音视频会话基本信息表'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_BASE.ID IS '主键ID'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_BASE.CHAT_NAME IS '会话名称'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_BASE.CHAT_UID IS '会话标识，相同参与人的会话标识相同，即为同一个会话'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_BASE.CHAT_TYPE IS '会话类型：1-点对点，2-会议'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_BASE.CHAT_MEMBER_COUNT IS '会话所有成员数'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_BASE.CHAT_MEMBER_IDS IS '会话所有成员ID逗号分隔'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_BASE.LAST_CALL_SENDER_ID IS '最后一次的通话发起人ID，对应em_sys_base_user表的主键'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_BASE.LAST_CALL_TYPE IS '最后一次的通话类型 1-音频 2-视频 3-sip电话 4-普通电话'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_BASE.LAST_CALL_TIME IS '最后一次的通话时间'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_BASE.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_BASE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_BASE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_BASE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_BASE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_BASE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_MSG_EXPRESSION_ITEM (
	ID VARCHAR(32) NOT NULL,
	ITEM_NAME VARCHAR(100) DEFAULT NULL,
	ITEM_ICON VARCHAR(32) DEFAULT NULL,
	SHOWORDER INT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_MSG_EXPRESSION_ITEM IS '消息自定义表情分组表'
;

COMMENT ON COLUMN EM_MSG_EXPRESSION_ITEM.ID IS '主键'
;

COMMENT ON COLUMN EM_MSG_EXPRESSION_ITEM.ITEM_NAME IS '分组名称'
;

COMMENT ON COLUMN EM_MSG_EXPRESSION_ITEM.ITEM_ICON IS '分组图标ID'
;

COMMENT ON COLUMN EM_MSG_EXPRESSION_ITEM.SHOWORDER IS '显示顺序'
;

COMMENT ON COLUMN EM_MSG_EXPRESSION_ITEM.STATUS IS '状态 1-正常，2-禁用，3-删除'
;

COMMENT ON COLUMN EM_MSG_EXPRESSION_ITEM.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_MSG_EXPRESSION_ITEM.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_MSG_EXPRESSION_ITEM.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_MSG_EXPRESSION_ITEM.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_MSG_EXPRESSION_ITEM.TENANT_ID IS '企业租户ID'
;


CREATE TYPE STRATEGY_ENUM_3 AS ENUM('ALIYUN', 'QCLOUD', 'QINIU', 'HUAWEIYUN')
;

CREATE TABLE EM_OSS_TEMPLATE (
	ID VARCHAR(32) NOT NULL,
	NAME VARCHAR(255) DEFAULT NULL,
	STRATEGY STRATEGY_ENUM_3 DEFAULT NULL,
	SETTING TEXT,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_OSS_TEMPLATE IS 'OSS模板设置表'
;

COMMENT ON COLUMN EM_OSS_TEMPLATE.ID IS '主键'
;

COMMENT ON COLUMN EM_OSS_TEMPLATE.NAME IS 'OSS模板名称'
;

COMMENT ON COLUMN EM_OSS_TEMPLATE.SETTING IS 'OSS模板设置参数（JSON数据）'
;

COMMENT ON COLUMN EM_OSS_TEMPLATE.STATUS IS '状态'
;

COMMENT ON COLUMN EM_OSS_TEMPLATE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_OSS_TEMPLATE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_OSS_TEMPLATE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_OSS_TEMPLATE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_OSS_TEMPLATE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_LANG_CLIENTSET (
	ID VARCHAR(32) NOT NULL,
	CLIENT_TYPE SMALLINT DEFAULT NULL,
	DATA_TAG VARCHAR(100) DEFAULT NULL,
	LANG_TAG VARCHAR(10) DEFAULT NULL,
	SET_NAME VARCHAR(500) DEFAULT NULL,
	SET_VALUE VARCHAR(200) DEFAULT NULL,
	SET_VALUE_CUSTOM VARCHAR(500) DEFAULT NULL,
	SET_TYPE SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_LANG_CLIENTSET IS '客户端多语言设置'
;

COMMENT ON COLUMN EM_SYS_LANG_CLIENTSET.CLIENT_TYPE IS '客户端类型 1-移动APP，2-PC端'
;

COMMENT ON COLUMN EM_SYS_LANG_CLIENTSET.DATA_TAG IS '数据标识'
;

COMMENT ON COLUMN EM_SYS_LANG_CLIENTSET.LANG_TAG IS '语言标识：zh-汉语(简体)，zh_TW-汉语(繁体)，en-英语，ja-日语，ko-韩语，vi-越南语'
;

COMMENT ON COLUMN EM_SYS_LANG_CLIENTSET.SET_VALUE IS '设置项显示内容'
;

COMMENT ON COLUMN EM_SYS_LANG_CLIENTSET.SET_TYPE IS '类型:1-系统,2-自定义'
;

COMMENT ON COLUMN EM_SYS_LANG_CLIENTSET.STATUS IS '状态：1-正常、3-删除'
;

COMMENT ON COLUMN EM_SYS_LANG_CLIENTSET.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_LANG_CLIENTSET.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_LANG_CLIENTSET.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_LANG_CLIENTSET.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_LANG_CLIENTSET.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SETTING_ROLE_USER (
	ID VARCHAR(32) NOT NULL,
	SETTING_ROLE_ID VARCHAR(32) DEFAULT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_SETTING_ROLE_USER IS '企业管理角色与基础用户关联表'
;

COMMENT ON COLUMN EM_SETTING_ROLE_USER.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SETTING_ROLE_USER.SETTING_ROLE_ID IS '角色ID'
;

COMMENT ON COLUMN EM_SETTING_ROLE_USER.BASE_USER_ID IS '基础用户ID'
;

COMMENT ON COLUMN EM_SETTING_ROLE_USER.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_SETTING_ROLE_USER.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SETTING_ROLE_USER.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SETTING_ROLE_USER.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SETTING_ROLE_USER.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SETTING_ROLE_USER.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_MSG_CREATE_GROUP_RIGHT (
	ID VARCHAR(32) NOT NULL,
	HRM_DATA_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_TYPE SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_SYS_MSG_CREATE_GROUP_RIGHT IS '消息创建群聊使用权限设置表'
;

COMMENT ON COLUMN EM_SYS_MSG_CREATE_GROUP_RIGHT.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SYS_MSG_CREATE_GROUP_RIGHT.HRM_DATA_ID IS '通讯录成员或部门表ID'
;

COMMENT ON COLUMN EM_SYS_MSG_CREATE_GROUP_RIGHT.HRM_DATA_TYPE IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;

COMMENT ON COLUMN EM_SYS_MSG_CREATE_GROUP_RIGHT.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_SYS_MSG_CREATE_GROUP_RIGHT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_MSG_CREATE_GROUP_RIGHT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_MSG_CREATE_GROUP_RIGHT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_MSG_CREATE_GROUP_RIGHT.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_MSG_CREATE_GROUP_RIGHT.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_PROCESS_INSTANCE (
	ID VARCHAR(32) NOT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	OUTSYS_ID VARCHAR(32) DEFAULT NULL,
	MSG_DATA_ID VARCHAR(50) DEFAULT NULL,
	MSG_DATA_TYPE VARCHAR(20) DEFAULT NULL,
	PROCESS_INSTANCE_ID VARCHAR(100) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_CP_PROCESS_INSTANCE IS '企业号待办消息流程实例'
;

COMMENT ON COLUMN EM_CP_PROCESS_INSTANCE.ID IS '主键'
;

COMMENT ON COLUMN EM_CP_PROCESS_INSTANCE.CP_CORP_ID IS '企业号基本信息ID'
;

COMMENT ON COLUMN EM_CP_PROCESS_INSTANCE.OUTSYS_ID IS '集成系统ID'
;

COMMENT ON COLUMN EM_CP_PROCESS_INSTANCE.MSG_DATA_ID IS '消息数据ID'
;

COMMENT ON COLUMN EM_CP_PROCESS_INSTANCE.MSG_DATA_TYPE IS '消息数据类型'
;

COMMENT ON COLUMN EM_CP_PROCESS_INSTANCE.PROCESS_INSTANCE_ID IS '实例ID'
;

COMMENT ON COLUMN EM_CP_PROCESS_INSTANCE.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_CP_PROCESS_INSTANCE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_PROCESS_INSTANCE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_PROCESS_INSTANCE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_PROCESS_INSTANCE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_PROCESS_INSTANCE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_LOG_ACCESS (
	ID VARCHAR(32) NOT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	BASE_USER_NAME VARCHAR(255) DEFAULT NULL,
	BASE_USER_STATUS SMALLINT DEFAULT NULL,
	OPERATION VARCHAR(255) DEFAULT NULL,
	ACCESS_TOKEN VARCHAR(100) DEFAULT NULL,
	LOGIN_TYPE SMALLINT DEFAULT NULL,
	LOGIN_MODE SMALLINT DEFAULT NULL,
	CLIENT_TYPE SMALLINT DEFAULT NULL,
	CLIENT_VERSION VARCHAR(50) DEFAULT NULL,
	DEVICE_ID VARCHAR(255) DEFAULT NULL,
	LANG_TYPE VARCHAR(20) DEFAULT NULL,
	OS_VERSION VARCHAR(800) DEFAULT NULL,
	CLIENT_MODEL VARCHAR(2000) DEFAULT NULL,
	IP VARCHAR(255) DEFAULT NULL,
	USER_AGENT VARCHAR(500) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;
COMMENT ON TABLE EM_LOG_ACCESS IS '访问日志'
;

COMMENT ON COLUMN EM_LOG_ACCESS.ID IS '主键'
;

COMMENT ON COLUMN EM_LOG_ACCESS.BASE_USER_ID IS '用户ID'
;

COMMENT ON COLUMN EM_LOG_ACCESS.BASE_USER_NAME IS '用户名'
;

COMMENT ON COLUMN EM_LOG_ACCESS.BASE_USER_STATUS IS '用户状态 1-已注册，2-未注册，3-删除'
;

COMMENT ON COLUMN EM_LOG_ACCESS.OPERATION IS '操作：login-登录，logout-登出'
;

COMMENT ON COLUMN EM_LOG_ACCESS.ACCESS_TOKEN IS '访问token'
;

COMMENT ON COLUMN EM_LOG_ACCESS.LOGIN_TYPE IS '登录类型：1-客户端，2-管理端，3-接口'
;

COMMENT ON COLUMN EM_LOG_ACCESS.LOGIN_MODE IS '登录方式：1-账号密码登录，2-短信验证码登录，3-扫码登录'
;

COMMENT ON COLUMN EM_LOG_ACCESS.CLIENT_TYPE IS '客户端类型： 1-PC客户端，2-IOS客户端，3-安卓客户端，4-web版'
;

COMMENT ON COLUMN EM_LOG_ACCESS.CLIENT_VERSION IS '客户端版本'
;

COMMENT ON COLUMN EM_LOG_ACCESS.DEVICE_ID IS '客户端硬件标识'
;

COMMENT ON COLUMN EM_LOG_ACCESS.LANG_TYPE IS '语言类型'
;

COMMENT ON COLUMN EM_LOG_ACCESS.OS_VERSION IS '客户端操作系统版本'
;

COMMENT ON COLUMN EM_LOG_ACCESS.IP IS 'IP地址'
;

COMMENT ON COLUMN EM_LOG_ACCESS.USER_AGENT IS '访问头信息'
;

COMMENT ON COLUMN EM_LOG_ACCESS.CREATE_TIME IS '日志创建时间'
;

COMMENT ON COLUMN EM_LOG_ACCESS.TENANT_ID IS '租户ID'
;


CREATE TABLE QRTZ_SIMPLE_TRIGGERS (
	SCHED_NAME VARCHAR(120) NOT NULL,
	TRIGGER_NAME VARCHAR(190) NOT NULL,
	TRIGGER_GROUP VARCHAR(190) NOT NULL,
	REPEAT_COUNT BIGINT NOT NULL,
	REPEAT_INTERVAL BIGINT NOT NULL,
	TIMES_TRIGGERED BIGINT NOT NULL,
	PRIMARY KEY (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
)
;



CREATE TABLE EM_SYS_FACE_VERIFY_RANGE (
	ID VARCHAR(32) NOT NULL,
	HRM_DATA_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_TYPE SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_SYS_FACE_VERIFY_RANGE IS '人脸登录验证使用范围设置表'
;

COMMENT ON COLUMN EM_SYS_FACE_VERIFY_RANGE.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SYS_FACE_VERIFY_RANGE.HRM_DATA_ID IS '通讯录成员或部门表ID'
;

COMMENT ON COLUMN EM_SYS_FACE_VERIFY_RANGE.HRM_DATA_TYPE IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;

COMMENT ON COLUMN EM_SYS_FACE_VERIFY_RANGE.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_SYS_FACE_VERIFY_RANGE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_FACE_VERIFY_RANGE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_FACE_VERIFY_RANGE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_FACE_VERIFY_RANGE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_FACE_VERIFY_RANGE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SETTING_ROLE_RIGHT (
	ID VARCHAR(32) NOT NULL,
	SETTING_ROLE_ID VARCHAR(32) DEFAULT NULL,
	RIGHT_DATA_TYPE SMALLINT DEFAULT NULL,
	RIGHT_DATA_ID VARCHAR(32) DEFAULT NULL,
	RIGHT_LEVEL SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_SETTING_ROLE_RIGHT IS '企业管理角色与权限关联表'
;

COMMENT ON COLUMN EM_SETTING_ROLE_RIGHT.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SETTING_ROLE_RIGHT.SETTING_ROLE_ID IS '管理组ID'
;

COMMENT ON COLUMN EM_SETTING_ROLE_RIGHT.RIGHT_DATA_TYPE IS '管理数据类型 1-通讯录部门，2-通讯录成员，3-应用查看管理，4-应用创建'
;

COMMENT ON COLUMN EM_SETTING_ROLE_RIGHT.RIGHT_DATA_ID IS '管理的数据ID，即部门成员应用ID'
;

COMMENT ON COLUMN EM_SETTING_ROLE_RIGHT.RIGHT_LEVEL IS '管理的权限级别，对应通讯录：1-仅具有查看权限，2-具有管理权限；对于应用：1-仅具有发送消息权限，2-具体管理权限'
;

COMMENT ON COLUMN EM_SETTING_ROLE_RIGHT.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_SETTING_ROLE_RIGHT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SETTING_ROLE_RIGHT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SETTING_ROLE_RIGHT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SETTING_ROLE_RIGHT.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SETTING_ROLE_RIGHT.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_WATERMARK_SETTING (
	ID VARCHAR(32) NOT NULL,
	ENABLE_MSG_LIST SMALLINT DEFAULT NULL,
	ENABLE_MSG_WINDOW SMALLINT DEFAULT NULL,
	ENABLE_MSG_PROP SMALLINT DEFAULT NULL,
	ENABLE_CONTACT_HOME SMALLINT DEFAULT NULL,
	ENABLE_CONTACT_LIST SMALLINT DEFAULT NULL,
	ENABLE_CONTACT_VIEW SMALLINT DEFAULT NULL,
	ENABLE_WEBVIEW_DEFAULT SMALLINT DEFAULT NULL,
	ENABLE_IMAGE_PREVIEW SMALLINT DEFAULT '0',
	SPACING_VAL INT DEFAULT NULL,
	SPACING_H_VAL INT DEFAULT '80',
	SPACING_V_VAL INT DEFAULT '80',
	DENSITY_VAL INT DEFAULT NULL,
	FONT_COLOR VARCHAR(10) DEFAULT '#dfdfdf',
	FONT_ANGLE INT DEFAULT '30',
	CONTENT_VAL1 VARCHAR(100) DEFAULT NULL,
	FONT_SIZE1 INT DEFAULT NULL,
	CONTENT_VAL2 VARCHAR(100) DEFAULT NULL,
	FONT_SIZE2 INT DEFAULT NULL,
	CONTENT_VAL3 VARCHAR(100) DEFAULT NULL,
	FONT_SIZE3 INT DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_WATERMARK_SETTING IS '系统水印设置'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.ENABLE_MSG_LIST IS '消息会话列表是否启用水印：0-禁用、1-启用'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.ENABLE_MSG_WINDOW IS '消息会话窗口是否启用水印：0-禁用、1-启用'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.ENABLE_MSG_PROP IS '消息会话属性是否启用水印：0-禁用、1-启用'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.ENABLE_CONTACT_HOME IS '通讯录主页是否启用水印：0-禁用、1-启用'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.ENABLE_CONTACT_LIST IS '通讯录列表是否启用水印：0-禁用、1-启用'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.ENABLE_CONTACT_VIEW IS '通讯录详情是否启用水印：0-禁用、1-启用'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.ENABLE_WEBVIEW_DEFAULT IS '加载页面默认是否启用水印：0-禁用、1-启用'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.ENABLE_IMAGE_PREVIEW IS '预览图片是否显示水印'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.SPACING_VAL IS '水印间距值，单位PX'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.SPACING_H_VAL IS '横向间距值'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.SPACING_V_VAL IS '纵向间距值'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.DENSITY_VAL IS '水印密度值，分1、2、3三个等级，数值越大密度越大'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.FONT_COLOR IS '字体颜色'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.FONT_ANGLE IS '文字显示角度'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.CONTENT_VAL1 IS '第一行水印内容，多个标记用逗号分隔，其中变化值用特殊变量表示，如${username}表示用户名、${loginid}表示登录名、${mobile}表示手机号、${mobileL4}表示手机号后四位、${time}表示当前时间等'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.FONT_SIZE1 IS '第一行字体大小，单位PX'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.CONTENT_VAL2 IS '第二行水印内容，多个标记用逗号分隔，其中变化值用特殊变量表示，如${username}表示用户名、${loginid}表示登录名、${mobile}表示手机号、${mobileL4}表示手机号后四位、${time}表示当前时间等'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.FONT_SIZE2 IS '第二行字体大小，单位PX'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.CONTENT_VAL3 IS '第三行水印内容，多个标记用逗号分隔，其中变化值用特殊变量表示，如${username}表示用户名、${loginid}表示登录名、${mobile}表示手机号、${mobileL4}表示手机号后四位、${time}表示当前时间等'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.FONT_SIZE3 IS '第三行字体大小，单位PX'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.STATUS IS '状态：1-正常、3-删除'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_WATERMARK_SETTING.TENANT_ID IS '企业租户ID'
;


CREATE TABLE QRTZ_CRON_TRIGGERS (
	SCHED_NAME VARCHAR(120) NOT NULL,
	TRIGGER_NAME VARCHAR(190) NOT NULL,
	TRIGGER_GROUP VARCHAR(190) NOT NULL,
	CRON_EXPRESSION VARCHAR(120) NOT NULL,
	TIME_ZONE_ID VARCHAR(80) DEFAULT NULL,
	PRIMARY KEY (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
)
;



CREATE TABLE EM_SH_RIGHT_BASE (
	ID VARCHAR(32) NOT NULL,
	RIGHT_BASE_NAME VARCHAR(100) DEFAULT NULL,
	RIGHT_BASE_TYPE SMALLINT DEFAULT NULL,
	PRIORITY INT DEFAULT '0',
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_SH_RIGHT_BASE IS '企业通讯录权限规则基础表'
;

COMMENT ON COLUMN EM_SH_RIGHT_BASE.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SH_RIGHT_BASE.RIGHT_BASE_NAME IS '权限规则名称'
;

COMMENT ON COLUMN EM_SH_RIGHT_BASE.RIGHT_BASE_TYPE IS '规则类型：1-通讯录权限规则 2-登录权限规则'
;

COMMENT ON COLUMN EM_SH_RIGHT_BASE.PRIORITY IS '优先级'
;

COMMENT ON COLUMN EM_SH_RIGHT_BASE.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_SH_RIGHT_BASE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SH_RIGHT_BASE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SH_RIGHT_BASE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SH_RIGHT_BASE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SH_RIGHT_BASE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_TRADE_DETAIL (
	CATEGORY_CODE VARCHAR(4) NOT NULL,
	CATEGORY_NAME VARCHAR(100) NOT NULL,
	DESCRITION VARCHAR(1000) DEFAULT NULL,
	PRIMARY KEY (CATEGORY_CODE)
)
;

COMMENT ON TABLE EM_SYS_TRADE_DETAIL IS '行业门类表'
;

COMMENT ON COLUMN EM_SYS_TRADE_DETAIL.CATEGORY_CODE IS '行业代码'
;

COMMENT ON COLUMN EM_SYS_TRADE_DETAIL.CATEGORY_NAME IS '行业类别名称'
;

COMMENT ON COLUMN EM_SYS_TRADE_DETAIL.DESCRITION IS '行业描述'
;


CREATE TABLE SPRING_SESSION (
	PRIMARY_ID CHAR(36) NOT NULL,
	SESSION_ID CHAR(36) NOT NULL,
	CREATION_TIME BIGINT NOT NULL,
	LAST_ACCESS_TIME BIGINT NOT NULL,
	MAX_INACTIVE_INTERVAL INT NOT NULL,
	EXPIRY_TIME BIGINT NOT NULL,
	PRINCIPAL_NAME VARCHAR(100) DEFAULT NULL,
	PRIMARY KEY (PRIMARY_ID)
)
;





CREATE TABLE EM_CP_MSGAUDIT_FILE (
	ID VARCHAR(32) NOT NULL,
	CORP_ID VARCHAR(32) DEFAULT NULL,
	FILE_NAME VARCHAR(1000) DEFAULT NULL,
	FILE_EXTENSION VARCHAR(255) DEFAULT NULL,
	FILE_CONTENT_TYPE VARCHAR(255) DEFAULT NULL,
	FILE_SIZE BIGINT DEFAULT NULL,
	FILE_PATH VARCHAR(255) DEFAULT NULL,
	SDK_FILE_ID TEXT,
	FILE_SYNC_STATUS SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_CP_MSGAUDIT_FILE IS '会话内容存档文件'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_FILE.ID IS '主键'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_FILE.CORP_ID IS '企业号基本信息ID'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_FILE.FILE_NAME IS '文件名称'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_FILE.FILE_EXTENSION IS '文件扩展名'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_FILE.FILE_CONTENT_TYPE IS '文件类型'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_FILE.FILE_SIZE IS '文件大小'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_FILE.FILE_PATH IS '文件路径'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_FILE.SDK_FILE_ID IS '接口媒体资源的id信息'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_FILE.FILE_SYNC_STATUS IS '同步状态：0-未同步、1-已同步'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_FILE.STATUS IS '状态'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_FILE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_FILE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_FILE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_FILE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_FILE.TENANT_ID IS '租户ID'
;


CREATE TABLE EM_SYS_NOTICE_READ (
	ID VARCHAR(32) NOT NULL,
	NOTICE_ID VARCHAR(32) DEFAULT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_NOTICE_READ IS '系统通知阅读状态表'
;

COMMENT ON COLUMN EM_SYS_NOTICE_READ.ID IS '主键'
;

COMMENT ON COLUMN EM_SYS_NOTICE_READ.NOTICE_ID IS '通知ID'
;

COMMENT ON COLUMN EM_SYS_NOTICE_READ.BASE_USER_ID IS '基础用户ID'
;

COMMENT ON COLUMN EM_SYS_NOTICE_READ.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_NOTICE_READ.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_NOTICE_READ.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_NOTICE_READ.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_NOTICE_READ.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_PAY_UNIFIEDORDER (
	ID VARCHAR(32) NOT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	OPEN_USER_ID VARCHAR(128) DEFAULT NULL,
	MCHID VARCHAR(32) DEFAULT NULL,
	TRADE_TYPE VARCHAR(16) DEFAULT NULL,
	OUT_TRADE_NO VARCHAR(32) DEFAULT NULL,
	TOTAL_FEE INT DEFAULT NULL,
	BODY VARCHAR(128) DEFAULT NULL,
	ATTACH VARCHAR(127) DEFAULT NULL,
	NONCE_STR VARCHAR(32) DEFAULT NULL,
	NOTIFY_URL VARCHAR(256) DEFAULT NULL,
	SPBILL_CREATE_IP VARCHAR(16) DEFAULT NULL,
	SIGN VARCHAR(32) DEFAULT NULL,
	ORDER_STATUS SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_CP_PAY_UNIFIEDORDER IS '企业号支付订单'
;

COMMENT ON COLUMN EM_CP_PAY_UNIFIEDORDER.ID IS '主键'
;

COMMENT ON COLUMN EM_CP_PAY_UNIFIEDORDER.CP_CORP_ID IS '企业号基本信息ID'
;

COMMENT ON COLUMN EM_CP_PAY_UNIFIEDORDER.OPEN_USER_ID IS '用户在企业号内的唯一标识'
;

COMMENT ON COLUMN EM_CP_PAY_UNIFIEDORDER.MCHID IS '商户ID'
;

COMMENT ON COLUMN EM_CP_PAY_UNIFIEDORDER.TRADE_TYPE IS '交易类型'
;

COMMENT ON COLUMN EM_CP_PAY_UNIFIEDORDER.OUT_TRADE_NO IS '订单号'
;

COMMENT ON COLUMN EM_CP_PAY_UNIFIEDORDER.TOTAL_FEE IS '总金额'
;

COMMENT ON COLUMN EM_CP_PAY_UNIFIEDORDER.BODY IS '商品描述'
;

COMMENT ON COLUMN EM_CP_PAY_UNIFIEDORDER.ATTACH IS '附加数据'
;

COMMENT ON COLUMN EM_CP_PAY_UNIFIEDORDER.NONCE_STR IS '随机字符串'
;

COMMENT ON COLUMN EM_CP_PAY_UNIFIEDORDER.NOTIFY_URL IS '通知地址'
;

COMMENT ON COLUMN EM_CP_PAY_UNIFIEDORDER.SPBILL_CREATE_IP IS '终端IP'
;

COMMENT ON COLUMN EM_CP_PAY_UNIFIEDORDER.SIGN IS '签名'
;

COMMENT ON COLUMN EM_CP_PAY_UNIFIEDORDER.ORDER_STATUS IS '订单状态，0：下单成功，1：下单失败，2：支付成功，3：支付失败'
;

COMMENT ON COLUMN EM_CP_PAY_UNIFIEDORDER.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_CP_PAY_UNIFIEDORDER.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_PAY_UNIFIEDORDER.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_PAY_UNIFIEDORDER.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_PAY_UNIFIEDORDER.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_PAY_UNIFIEDORDER.TENANT_ID IS '企业租户ID'
;


CREATE TABLE QRTZ_BLOB_TRIGGERS (
	SCHED_NAME VARCHAR(120) NOT NULL,
	TRIGGER_NAME VARCHAR(190) NOT NULL,
	TRIGGER_GROUP VARCHAR(190) NOT NULL,
	BLOB_DATA BYTEA,
	PRIMARY KEY (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
)
;




CREATE TABLE EM_OTP_VERIFY_RECORD (
	ID VARCHAR(32) NOT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	USER_DOMAIN VARCHAR(255) DEFAULT NULL,
	TOKEN VARCHAR(255) DEFAULT NULL,
	SUCCESS SMALLINT DEFAULT NULL,
	VERIFY_MSG TEXT,
	IP VARCHAR(255) DEFAULT NULL,
	STATUS VARCHAR(255) DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_OTP_VERIFY_RECORD IS 'OTP验证记录'
;

COMMENT ON COLUMN EM_OTP_VERIFY_RECORD.ID IS '主键'
;

COMMENT ON COLUMN EM_OTP_VERIFY_RECORD.BASE_USER_ID IS '用户ID'
;

COMMENT ON COLUMN EM_OTP_VERIFY_RECORD.USER_DOMAIN IS '用户域'
;

COMMENT ON COLUMN EM_OTP_VERIFY_RECORD.TOKEN IS '令牌'
;

COMMENT ON COLUMN EM_OTP_VERIFY_RECORD.SUCCESS IS '是否验证成功：0-失败、1-成功'
;

COMMENT ON COLUMN EM_OTP_VERIFY_RECORD.VERIFY_MSG IS '验证信息'
;

COMMENT ON COLUMN EM_OTP_VERIFY_RECORD.IP IS 'ip地址'
;

COMMENT ON COLUMN EM_OTP_VERIFY_RECORD.STATUS IS '状态'
;

COMMENT ON COLUMN EM_OTP_VERIFY_RECORD.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_OTP_VERIFY_RECORD.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_OTP_VERIFY_RECORD.TENANT_ID IS '租户ID'
;


CREATE TABLE EM_LOG_MANAGE (
	ID VARCHAR(32) NOT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	BASE_USER_NAME VARCHAR(100) DEFAULT NULL,
	HRM_USER_ID VARCHAR(32) DEFAULT NULL,
	HRM_USER_NAME VARCHAR(100) DEFAULT NULL,
	TYPE1 INT DEFAULT NULL,
	TYPE2 INT DEFAULT NULL,
	TYPE3 INT DEFAULT NULL,
	DATAINFO TEXT,
	METHOD VARCHAR(255) DEFAULT NULL,
	PARAMS TEXT,
	IP VARCHAR(255) DEFAULT NULL,
	SHOWORDER SERIAL NOT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;
COMMENT ON TABLE EM_LOG_MANAGE IS '管理端操作日志'
;

COMMENT ON COLUMN EM_LOG_MANAGE.ID IS '主键ID'
;

COMMENT ON COLUMN EM_LOG_MANAGE.BASE_USER_ID IS '用户ID'
;

COMMENT ON COLUMN EM_LOG_MANAGE.BASE_USER_NAME IS '用户名'
;

COMMENT ON COLUMN EM_LOG_MANAGE.HRM_USER_ID IS '通讯录用户ID'
;

COMMENT ON COLUMN EM_LOG_MANAGE.HRM_USER_NAME IS '通讯录用户名'
;

COMMENT ON COLUMN EM_LOG_MANAGE.TYPE1 IS '操作功能模块'
;

COMMENT ON COLUMN EM_LOG_MANAGE.TYPE2 IS '操作具体功能'
;

COMMENT ON COLUMN EM_LOG_MANAGE.TYPE3 IS '操作具体类型'
;

COMMENT ON COLUMN EM_LOG_MANAGE.DATAINFO IS '相关数据'
;

COMMENT ON COLUMN EM_LOG_MANAGE.METHOD IS '请求方法'
;

COMMENT ON COLUMN EM_LOG_MANAGE.PARAMS IS '请求参数'
;

COMMENT ON COLUMN EM_LOG_MANAGE.IP IS 'IP地址'
;

COMMENT ON COLUMN EM_LOG_MANAGE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_LOG_MANAGE.TENANT_ID IS '租户ID'
;


CREATE TABLE EM_SYS_NOTICE (
	ID VARCHAR(32) NOT NULL,
	TITLE VARCHAR(200) DEFAULT NULL,
	CONTENT TEXT,
	LINKURL VARCHAR(200) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	PUBLISH_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_NOTICE IS '系统通知表'
;

COMMENT ON COLUMN EM_SYS_NOTICE.ID IS '主键'
;

COMMENT ON COLUMN EM_SYS_NOTICE.TITLE IS '通知名称'
;

COMMENT ON COLUMN EM_SYS_NOTICE.CONTENT IS '通知内容'
;

COMMENT ON COLUMN EM_SYS_NOTICE.LINKURL IS '链接地址'
;

COMMENT ON COLUMN EM_SYS_NOTICE.STATUS IS '状态：1-发布，2-草稿，3-删除'
;

COMMENT ON COLUMN EM_SYS_NOTICE.PUBLISH_TIME IS '发布时间'
;

COMMENT ON COLUMN EM_SYS_NOTICE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_NOTICE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_NOTICE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_NOTICE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_NOTICE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_MINE_SETTING (
	ID VARCHAR(32) NOT NULL,
	ITEM_NAME VARCHAR(50) DEFAULT NULL,
	ITEM_ICON VARCHAR(100) DEFAULT NULL,
	ITEM_TYPE SMALLINT DEFAULT '0',
	ITEM_SETTING2 VARCHAR(500) DEFAULT NULL,
	ITEM_SETTING3 VARCHAR(500) DEFAULT NULL,
	ITEM_SETTING1 VARCHAR(500) DEFAULT NULL,
	ITEM_ORDER INT DEFAULT '0',
	IS_SYS INT DEFAULT '0',
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_SYS_MINE_SETTING IS '个人信息设置表'
;

COMMENT ON COLUMN EM_SYS_MINE_SETTING.ITEM_NAME IS '菜单项名称，支持多语言'
;

COMMENT ON COLUMN EM_SYS_MINE_SETTING.ITEM_ICON IS '菜单项图标'
;

COMMENT ON COLUMN EM_SYS_MINE_SETTING.ITEM_TYPE IS '菜单项类型：0-空白，1-设置，2-扫一扫，3-切换主题，4-收藏，5-钱包，10-打开页面，11-打开应用'
;

COMMENT ON COLUMN EM_SYS_MINE_SETTING.ITEM_SETTING3 IS '链接打开方式'
;

COMMENT ON COLUMN EM_SYS_MINE_SETTING.ITEM_SETTING1 IS '打开页面类型，菜单需要打开的功能类型，0-第三方链接，1-主次账号切换，2-修改密码，3-集成系统地址，4-本系统地址，5-自定义开发'
;

COMMENT ON COLUMN EM_SYS_MINE_SETTING.ITEM_ORDER IS '菜单项显示顺序'
;

COMMENT ON COLUMN EM_SYS_MINE_SETTING.IS_SYS IS '是否系统默认1-系统默认，不允许删，0-自定义'
;

COMMENT ON COLUMN EM_SYS_MINE_SETTING.STATUS IS '状态 2-禁用'
;

COMMENT ON COLUMN EM_SYS_MINE_SETTING.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_MINE_SETTING.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_MINE_SETTING.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_MINE_SETTING.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_MINE_SETTING.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_FACE_SETTING (
	ID VARCHAR(32) NOT NULL,
	ENABLED SMALLINT DEFAULT NULL,
	ENABLE_LIVE_CHECK SMALLINT DEFAULT '1',
	API_URL VARCHAR(200) DEFAULT NULL,
	APP_ID VARCHAR(100) DEFAULT NULL,
	AUTH_KEY_ID VARCHAR(100) DEFAULT NULL,
	RIGHT_TYPE SMALLINT DEFAULT NULL,
	ENABLE_LOGIN_VERIFY SMALLINT DEFAULT NULL,
	VERIFY_RANGE_TYPE SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	ENABLE_AWAKE_CHECK SMALLINT DEFAULT NULL,
	AWAKE_RANGE_TYPE SMALLINT DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_FACE_SETTING IS '人脸集成设置信息'
;

COMMENT ON COLUMN EM_SYS_FACE_SETTING.ENABLED IS '是否开启人脸集成功能：0-禁用、1-开启'
;

COMMENT ON COLUMN EM_SYS_FACE_SETTING.ENABLE_LIVE_CHECK IS '是否开启活体验证'
;

COMMENT ON COLUMN EM_SYS_FACE_SETTING.API_URL IS '接口地址'
;

COMMENT ON COLUMN EM_SYS_FACE_SETTING.APP_ID IS '接入的appId'
;

COMMENT ON COLUMN EM_SYS_FACE_SETTING.AUTH_KEY_ID IS '接入的authKeyID'
;

COMMENT ON COLUMN EM_SYS_FACE_SETTING.RIGHT_TYPE IS '权限类型：1-包含，2-排除'
;

COMMENT ON COLUMN EM_SYS_FACE_SETTING.ENABLE_LOGIN_VERIFY IS '是否开启登录验证：1-是，0-否'
;

COMMENT ON COLUMN EM_SYS_FACE_SETTING.VERIFY_RANGE_TYPE IS '登录验证范围类型：1-包含，2-排除'
;

COMMENT ON COLUMN EM_SYS_FACE_SETTING.STATUS IS '状态'
;

COMMENT ON COLUMN EM_SYS_FACE_SETTING.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_FACE_SETTING.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_FACE_SETTING.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_FACE_SETTING.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_FACE_SETTING.TENANT_ID IS '企业租户ID'
;

COMMENT ON COLUMN EM_SYS_FACE_SETTING.ENABLE_AWAKE_CHECK IS '是否开启人脸唤醒验证'
;

COMMENT ON COLUMN EM_SYS_FACE_SETTING.AWAKE_RANGE_TYPE IS '人脸唤醒验证是范围类型'
;


CREATE TABLE EM_CP_MSG_EXT_ALL (
	ID VARCHAR(32) NOT NULL,
	EXT_FIELD1 VARCHAR(100) DEFAULT NULL,
	EXT_FIELD2 VARCHAR(100) DEFAULT NULL,
	EXT_FIELD3 VARCHAR(100) DEFAULT NULL,
	EXT_FIELD4 VARCHAR(100) DEFAULT NULL,
	EXT_FIELD5 VARCHAR(100) DEFAULT NULL,
	EXT_FIELD6 VARCHAR(100) DEFAULT NULL,
	EXT_FIELD7 VARCHAR(100) DEFAULT NULL,
	EXT_FIELD8 VARCHAR(100) DEFAULT NULL,
	EXT_FIELD9 VARCHAR(100) DEFAULT NULL,
	EXT_FIELD10 VARCHAR(100) DEFAULT NULL,
	EXT_FIELD11 VARCHAR(1000) DEFAULT NULL,
	EXT_FIELD12 VARCHAR(1000) DEFAULT NULL,
	EXT_FIELD13 VARCHAR(1000) DEFAULT NULL,
	EXT_FIELD14 VARCHAR(1000) DEFAULT NULL,
	EXT_FIELD15 VARCHAR(1000) DEFAULT NULL,
	EXT_FIELD16 TEXT,
	EXT_FIELD17 TEXT,
	EXT_FIELD18 TEXT,
	EXT_FIELD19 TEXT,
	EXT_FIELD20 TEXT,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_CP_MSG_EXT_ALL IS '企业号推送消息信息扩展备份表'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.ID IS '主键，消息ID'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.EXT_FIELD1 IS '消息规则ID'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.EXT_FIELD2 IS '应用OpenId'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.EXT_FIELD3 IS '扩展字段3'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.EXT_FIELD4 IS '扩展字段4'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.EXT_FIELD5 IS '扩展字段5'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.EXT_FIELD6 IS '扩展字段6'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.EXT_FIELD7 IS '扩展字段7'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.EXT_FIELD8 IS '扩展字段8'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.EXT_FIELD9 IS '扩展字段9'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.EXT_FIELD10 IS '扩展字段10'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.EXT_FIELD11 IS '扩展字段11'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.EXT_FIELD12 IS '扩展字段12'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.EXT_FIELD13 IS '扩展字段13'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.EXT_FIELD14 IS '扩展字段14'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.EXT_FIELD15 IS '扩展字段15'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.EXT_FIELD16 IS '扩展字段16'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.EXT_FIELD17 IS '扩展字段17'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.EXT_FIELD18 IS '扩展字段18'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.EXT_FIELD19 IS '扩展字段19'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.EXT_FIELD20 IS '扩展字段20'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_MSG_EXT_ALL.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_AGENT_MSG_LOG_RESEND (
	ID VARCHAR(32) NOT NULL,
	MSG_LOG_ID VARCHAR(32) DEFAULT NULL,
	OPEN_AGENT_ID INT DEFAULT NULL,
	TARGET_TYPE SMALLINT DEFAULT '0',
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	CP_AGENT_ID VARCHAR(32) DEFAULT NULL,
	TOUSER TEXT,
	TOPARTY TEXT,
	TODEPT TEXT,
	TOTAG TEXT,
	MSGTYPE VARCHAR(10) DEFAULT NULL,
	SAFE SMALLINT DEFAULT '0',
	DATAINFO TEXT,
	REQUSETINFO TEXT,
	ERRCODE INT DEFAULT NULL,
	ERRMSG VARCHAR(1000) DEFAULT NULL,
	INVALIDUSER TEXT,
	INVALIDPARTY TEXT,
	INVALIDDEPT TEXT,
	INVALIDTAG TEXT,
	REALITYRECEIVERS TEXT,
	SOURCE_MSG_ID VARCHAR(100) DEFAULT NULL,
	SERVER_MSG_ID VARCHAR(100) DEFAULT NULL,
	SEND_TYPE SMALLINT DEFAULT NULL,
	SEND_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	LOG_GROUP_ID VARCHAR(100) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;
COMMENT ON TABLE EM_AGENT_MSG_LOG_RESEND IS '企业应用重发消息记录表'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.ID IS '主键ID'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.MSG_LOG_ID IS '第一次推送消息的消息记录ID'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.OPEN_AGENT_ID IS '企业应用openid'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.TARGET_TYPE IS '推送目标类型，0-无，1-E-mobile，2-企业号'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.CP_CORP_ID IS '推送目标的企业号ID，当目标类型为2时有效'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.CP_AGENT_ID IS '推送目标的企业号应用ID，当目标类型为2时有效'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.TOUSER IS '成员ID列表（消息接收者，多个接收者用‘|’分隔，最多支持1000个）。特殊情况：指定为@all，则向该企业应用的全部成员发送'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.TOPARTY IS '部门ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.TODEPT IS '部门ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.TOTAG IS '标签ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.MSGTYPE IS '消息类型 text-文本，image-图片，voice-语音，video-视频，file-文件，news-图文'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.SAFE IS '表示是否是保密消息，0表示否，1表示是，默认0'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.DATAINFO IS '发送数据的详细信息，json格式的完整内容'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.REQUSETINFO IS '请求数据vo'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.ERRCODE IS '发送结果状态码'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.ERRMSG IS '错误信息'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.INVALIDUSER IS '无效的成员ID列表'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.INVALIDPARTY IS '无效的部门ID列表'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.INVALIDDEPT IS '无效的部门ID列表'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.INVALIDTAG IS '无效的标签ID列表'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.REALITYRECEIVERS IS '消息发送实际上所有接收人id'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.SOURCE_MSG_ID IS '消息数据原始ID，接口传入，不传则系统自动生成'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.SERVER_MSG_ID IS '消息数据在消息服务端的ID'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.SEND_TYPE IS '消息发送类型，1-立即发送，2-定时发送'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.SEND_TIME IS '消息发送时间，如果为定时发送，这里为定时发送时间'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.LOG_GROUP_ID IS '操作批次id'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG_RESEND.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_USER_SYNC_FIELD (
	ID VARCHAR(32) NOT NULL,
	CP_SYNCSET_ID VARCHAR(32) DEFAULT NULL,
	USER_FIELD_NAME VARCHAR(50) DEFAULT NULL,
	USER_FIELD_KEY VARCHAR(50) DEFAULT NULL,
	USER_FIELD_TYPE SMALLINT DEFAULT '0',
	USER_FIELD_TYPE_CP VARCHAR(50) DEFAULT NULL,
	OUTSYS_FIELD_NAME VARCHAR(50) DEFAULT NULL,
	OUTSYS_FIELD_KEY VARCHAR(50) DEFAULT NULL,
	OUTSYS_FIELD_TYPE SMALLINT DEFAULT '0',
	SHOWORDER INT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_CP_USER_SYNC_FIELD IS '企业号人员同步字段配置'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_FIELD.ID IS '主键'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_FIELD.CP_SYNCSET_ID IS '企业号同步设置ID'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_FIELD.USER_FIELD_NAME IS '企业号字段名称'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_FIELD.USER_FIELD_KEY IS '企业号字段唯一标识'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_FIELD.USER_FIELD_TYPE IS '企业号字段类型，0：基础字段，1：自定义字段'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_FIELD.USER_FIELD_TYPE_CP IS '企业号字段类型，在第三方APP里定义的类型'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_FIELD.OUTSYS_FIELD_NAME IS '集成系统字段名称'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_FIELD.OUTSYS_FIELD_KEY IS '集成系统字段唯一标识'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_FIELD.OUTSYS_FIELD_TYPE IS '集成系统字段类型，0：基础字段，1：自定义字段'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_FIELD.SHOWORDER IS '显示排序'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_FIELD.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_FIELD.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_FIELD.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_FIELD.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_FIELD.TENANT_ID IS '企业租户ID'
;


CREATE TABLE QRTZ_CALENDARS (
	SCHED_NAME VARCHAR(120) NOT NULL,
	CALENDAR_NAME VARCHAR(190) NOT NULL,
	CALENDAR BYTEA NOT NULL,
	PRIMARY KEY (SCHED_NAME, CALENDAR_NAME)
)
;


CREATE TABLE EM_SYS_REMOTE_SETTING (
	ID VARCHAR(32) NOT NULL,
	ENABLED SMALLINT DEFAULT NULL,
	SEVER_TYPE SMALLINT DEFAULT NULL,
	APP_ID VARCHAR(100) DEFAULT NULL,
	APP_KEY VARCHAR(100) DEFAULT NULL,
	PHSRC VARCHAR(100) DEFAULT NULL,
	SHA1 VARCHAR(100) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_REMOTE_SETTING IS '远程协助服务设置信息'
;

COMMENT ON COLUMN EM_SYS_REMOTE_SETTING.ENABLED IS '是否开启远程协助服务：0-禁用、1-开启'
;

COMMENT ON COLUMN EM_SYS_REMOTE_SETTING.SEVER_TYPE IS '服务器类型：1-公有 2-私有'
;

COMMENT ON COLUMN EM_SYS_REMOTE_SETTING.APP_ID IS '接入的appid'
;

COMMENT ON COLUMN EM_SYS_REMOTE_SETTING.APP_KEY IS '接入的appkey'
;

COMMENT ON COLUMN EM_SYS_REMOTE_SETTING.PHSRC IS '连接私有服务器PHSRC值'
;

COMMENT ON COLUMN EM_SYS_REMOTE_SETTING.SHA1 IS '连接私有服务器的sha1值'
;

COMMENT ON COLUMN EM_SYS_REMOTE_SETTING.STATUS IS '状态'
;

COMMENT ON COLUMN EM_SYS_REMOTE_SETTING.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_REMOTE_SETTING.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_REMOTE_SETTING.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_REMOTE_SETTING.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_REMOTE_SETTING.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_LICENSE_MODULE (
	ID VARCHAR(32) NOT NULL,
	IDENTIFICATION_NUMBER VARCHAR(33) DEFAULT NULL,
	MODULE VARCHAR(32) DEFAULT NULL,
	COUNT SMALLINT DEFAULT NULL,
	USER_COUNT INT DEFAULT NULL,
	USER_COUNT_TYPE SMALLINT DEFAULT NULL,
	EXPIRE_DATE TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	LICENSE_ID VARCHAR(32) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_LICENSE_MODULE IS '服务端License模块信息表'
;

COMMENT ON COLUMN EM_LICENSE_MODULE.ID IS '主键'
;

COMMENT ON COLUMN EM_LICENSE_MODULE.IDENTIFICATION_NUMBER IS '识别码'
;

COMMENT ON COLUMN EM_LICENSE_MODULE.MODULE IS '模块名称'
;

COMMENT ON COLUMN EM_LICENSE_MODULE.COUNT IS '集成数量'
;

COMMENT ON COLUMN EM_LICENSE_MODULE.USER_COUNT IS '用户数量'
;

COMMENT ON COLUMN EM_LICENSE_MODULE.USER_COUNT_TYPE IS '用户数类型，1-并发、2-注册，默认并发'
;

COMMENT ON COLUMN EM_LICENSE_MODULE.EXPIRE_DATE IS '过期时间'
;

COMMENT ON COLUMN EM_LICENSE_MODULE.LICENSE_ID IS '关联主license主键'
;

COMMENT ON COLUMN EM_LICENSE_MODULE.STATUS IS '状态'
;

COMMENT ON COLUMN EM_LICENSE_MODULE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_LICENSE_MODULE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_LICENSE_MODULE.UPDATE_USER_ID IS '最后修改人'
;

COMMENT ON COLUMN EM_LICENSE_MODULE.UPDATE_TIME IS '最后修改时间'
;

COMMENT ON COLUMN EM_LICENSE_MODULE.TENANT_ID IS '租户ID'
;


CREATE TABLE QRTZ_LOCKS (
	SCHED_NAME VARCHAR(120) NOT NULL,
	LOCK_NAME VARCHAR(40) NOT NULL,
	PRIMARY KEY (SCHED_NAME, LOCK_NAME)
)
;


CREATE TABLE EM_CP_MSGAUDIT_ROOM_LIVE (
	ID VARCHAR(32) NOT NULL,
	CORP_ID VARCHAR(32) DEFAULT NULL,
	ROOM_ID VARCHAR(32) DEFAULT NULL,
	OPEN_ROOM_ID VARCHAR(255) DEFAULT NULL,
	IS_EXTERNAL SMALLINT DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_CP_MSGAUDIT_ROOM_LIVE IS '活跃会话标记'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM_LIVE.ID IS '主键'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM_LIVE.CORP_ID IS '企业ID'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM_LIVE.ROOM_ID IS '会话ID'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM_LIVE.OPEN_ROOM_ID IS '接口会话ID'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM_LIVE.IS_EXTERNAL IS '是否为外部群：0-否、1-是'
;


CREATE TABLE EM_CP_SECONDAUTH (
	ID VARCHAR(32) NOT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	LINK_URL VARCHAR(1000) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_CP_SECONDAUTH IS '企业号二次验证'
;

COMMENT ON COLUMN EM_CP_SECONDAUTH.ID IS '主键'
;

COMMENT ON COLUMN EM_CP_SECONDAUTH.CP_CORP_ID IS '企业号基本信息ID'
;

COMMENT ON COLUMN EM_CP_SECONDAUTH.LINK_URL IS '自定义二次验证链接地址'
;

COMMENT ON COLUMN EM_CP_SECONDAUTH.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_CP_SECONDAUTH.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_SECONDAUTH.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_SECONDAUTH.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_SECONDAUTH.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_SECONDAUTH.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_MSG_GROUP_DEPT_USER (
	ID VARCHAR(32) NOT NULL,
	GROUP_ID VARCHAR(50) DEFAULT NULL,
	DEPT_ID VARCHAR(32) DEFAULT NULL,
	USER_ID VARCHAR(32) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;
COMMENT ON TABLE EM_MSG_GROUP_DEPT_USER IS '部门群成员表'
;

COMMENT ON COLUMN EM_MSG_GROUP_DEPT_USER.GROUP_ID IS '群组ID'
;

COMMENT ON COLUMN EM_MSG_GROUP_DEPT_USER.DEPT_ID IS '部门ID'
;

COMMENT ON COLUMN EM_MSG_GROUP_DEPT_USER.USER_ID IS '人员ID'
;

COMMENT ON COLUMN EM_MSG_GROUP_DEPT_USER.STATUS IS '状态'
;

COMMENT ON COLUMN EM_MSG_GROUP_DEPT_USER.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_MSG_GROUP_DEPT_USER.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_MSG_GROUP_DEPT_USER.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_MSG_GROUP_DEPT_USER.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_MSG_GROUP_DEPT_USER.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_HRM_USER_ATTR_VALUE (
	ID VARCHAR(32) NOT NULL,
	HRM_USER_ID VARCHAR(32) DEFAULT NULL,
	ATTR_ID VARCHAR(32) DEFAULT NULL,
	ATTR_VALUE VARCHAR(100) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_HRM_USER_ATTR_VALUE IS '企业通讯录成员自定义字段内容表'
;

COMMENT ON COLUMN EM_HRM_USER_ATTR_VALUE.ID IS '主键ID'
;

COMMENT ON COLUMN EM_HRM_USER_ATTR_VALUE.HRM_USER_ID IS '企业通讯录成员ID'
;

COMMENT ON COLUMN EM_HRM_USER_ATTR_VALUE.ATTR_ID IS '自定义字段定义表ID'
;

COMMENT ON COLUMN EM_HRM_USER_ATTR_VALUE.ATTR_VALUE IS '自定义字段值'
;

COMMENT ON COLUMN EM_HRM_USER_ATTR_VALUE.STATUS IS '状态 1=正常，3=已删除'
;

COMMENT ON COLUMN EM_HRM_USER_ATTR_VALUE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_HRM_USER_ATTR_VALUE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_HRM_USER_ATTR_VALUE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_HRM_USER_ATTR_VALUE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_HRM_USER_ATTR_VALUE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_TENANT (
	ID VARCHAR(32) NOT NULL,
	CORP_ID VARCHAR(50) DEFAULT NULL,
	TENANT_NAME VARCHAR(1000) DEFAULT NULL,
	LOGO VARCHAR(255) DEFAULT NULL,
	MAXUSER INT DEFAULT NULL,
	PROVINCE_ID VARCHAR(32) DEFAULT NULL,
	CITY_ID VARCHAR(32) DEFAULT NULL,
	TRADE_CATE_ID VARCHAR(32) DEFAULT NULL,
	TRADE_TYPE_ID VARCHAR(32) DEFAULT NULL,
	CONTACT_NAME VARCHAR(100) DEFAULT NULL,
	CONTACT_EMAIL VARCHAR(100) DEFAULT NULL,
	CONTACT_ADDRESS VARCHAR(100) DEFAULT NULL,
	CONTACT_TELEPHONE VARCHAR(32) DEFAULT NULL,
	DOMAIN_URL VARCHAR(100) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_TENANT IS '企业租户表'
;

COMMENT ON COLUMN EM_SYS_TENANT.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SYS_TENANT.CORP_ID IS '企业CorpId'
;

COMMENT ON COLUMN EM_SYS_TENANT.LOGO IS '图标'
;

COMMENT ON COLUMN EM_SYS_TENANT.MAXUSER IS '最大用户数'
;

COMMENT ON COLUMN EM_SYS_TENANT.PROVINCE_ID IS '省份ID'
;

COMMENT ON COLUMN EM_SYS_TENANT.CITY_ID IS '城市ID'
;

COMMENT ON COLUMN EM_SYS_TENANT.TRADE_CATE_ID IS '行业种类ID'
;

COMMENT ON COLUMN EM_SYS_TENANT.TRADE_TYPE_ID IS '行业类型ID'
;

COMMENT ON COLUMN EM_SYS_TENANT.CONTACT_NAME IS '联系人姓名'
;

COMMENT ON COLUMN EM_SYS_TENANT.CONTACT_EMAIL IS '联系邮箱'
;

COMMENT ON COLUMN EM_SYS_TENANT.CONTACT_ADDRESS IS '详细地址'
;

COMMENT ON COLUMN EM_SYS_TENANT.CONTACT_TELEPHONE IS '联系电话'
;

COMMENT ON COLUMN EM_SYS_TENANT.DOMAIN_URL IS '绑定域名地址'
;

COMMENT ON COLUMN EM_SYS_TENANT.STATUS IS '状态: 1-正常，2-禁用，3-删除'
;

COMMENT ON COLUMN EM_SYS_TENANT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_TENANT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_TENANT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_TENANT.UPDATE_TIME IS '修改时间'
;


CREATE TABLE EM_SYS_CONFIG_DATA (
	ID VARCHAR(32) NOT NULL,
	DATA_NAME VARCHAR(100) DEFAULT NULL,
	DATA_TAG VARCHAR(100) DEFAULT NULL,
	DATA_TYPE SMALLINT DEFAULT NULL,
	DATA_VALUE VARCHAR(500) DEFAULT NULL,
	DATA_REMARK VARCHAR(500) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_CONFIG_DATA IS '系统配置数据表'
;

COMMENT ON COLUMN EM_SYS_CONFIG_DATA.ID IS '主键'
;

COMMENT ON COLUMN EM_SYS_CONFIG_DATA.DATA_NAME IS '数据名称'
;

COMMENT ON COLUMN EM_SYS_CONFIG_DATA.DATA_TAG IS '数据标识'
;

COMMENT ON COLUMN EM_SYS_CONFIG_DATA.DATA_TYPE IS '数据类型，0-客户端配置数据，1-系统配置数据,默认0'
;

COMMENT ON COLUMN EM_SYS_CONFIG_DATA.DATA_REMARK IS '备注信息'
;

COMMENT ON COLUMN EM_SYS_CONFIG_DATA.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_SYS_CONFIG_DATA.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_CONFIG_DATA.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_CONFIG_DATA.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_CONFIG_DATA.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_CONFIG_DATA.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_SECURITY_SETTING (
	ID VARCHAR(32) NOT NULL,
	ENABLE_LOGIN_CAPTCHA SMALLINT DEFAULT NULL,
	ENABLE_REGISTER_CAPTCHA SMALLINT DEFAULT NULL,
	MAXIMUM_LOGIN_ATTEMPTS INT DEFAULT NULL,
	MINIMUM_PASSWORD_LENGTH INT DEFAULT NULL,
	ENABLE_SPECIAL_PASSWORD SMALLINT DEFAULT NULL,
	ENABLE_ACCESS_RESTRICTIONS SMALLINT DEFAULT NULL,
	IP_WHITELISTS TEXT,
	RECORD_INFORMATION TEXT,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_SECURITY_SETTING IS '系统安全设置'
;

COMMENT ON COLUMN EM_SYS_SECURITY_SETTING.ENABLE_LOGIN_CAPTCHA IS '是否启动登录图片验证码：0-禁用、1-启用'
;

COMMENT ON COLUMN EM_SYS_SECURITY_SETTING.ENABLE_REGISTER_CAPTCHA IS '是否启动注册图片验证码：0-禁用、1-启用'
;

COMMENT ON COLUMN EM_SYS_SECURITY_SETTING.MAXIMUM_LOGIN_ATTEMPTS IS '登录操作最大尝试次数'
;

COMMENT ON COLUMN EM_SYS_SECURITY_SETTING.MINIMUM_PASSWORD_LENGTH IS '最小密码长度'
;

COMMENT ON COLUMN EM_SYS_SECURITY_SETTING.ENABLE_SPECIAL_PASSWORD IS '是否必须大小写及特殊字符'
;

COMMENT ON COLUMN EM_SYS_SECURITY_SETTING.ENABLE_ACCESS_RESTRICTIONS IS '是否启用后台访问限制：0-禁用、1-启用'
;

COMMENT ON COLUMN EM_SYS_SECURITY_SETTING.IP_WHITELISTS IS 'IP白名单'
;

COMMENT ON COLUMN EM_SYS_SECURITY_SETTING.STATUS IS '状态'
;

COMMENT ON COLUMN EM_SYS_SECURITY_SETTING.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_SECURITY_SETTING.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_SECURITY_SETTING.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_SECURITY_SETTING.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_SECURITY_SETTING.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_CLIENT_VERSION (
	ID VARCHAR(32) NOT NULL,
	CLIENT_TYPE SMALLINT DEFAULT NULL,
	CVERSION VARCHAR(50) DEFAULT NULL,
	UPDATE_TIPS VARCHAR(100) DEFAULT NULL,
	VNUMBER VARCHAR(100) DEFAULT NULL,
	CONTENT VARCHAR(1000) DEFAULT NULL,
	DOWNLOAD_TYPE SMALLINT DEFAULT NULL,
	LINKURL VARCHAR(200) DEFAULT NULL,
	FILE_ID VARCHAR(32) DEFAULT NULL,
	PACKAGE_NAME VARCHAR(32) DEFAULT NULL,
	UPDATE_CHECK SMALLINT DEFAULT NULL,
	FORCE_UPDATE SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	PUBLISH_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_CLIENT_VERSION IS '系统客户端版本表'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION.ID IS '主键'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION.CLIENT_TYPE IS '客户端类型：1-windows，2-mac，3-ios，4-android'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION.CVERSION IS '版本号'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION.UPDATE_TIPS IS '升级提示语'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION.VNUMBER IS '客户端版本序号'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION.CONTENT IS '更新内容'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION.DOWNLOAD_TYPE IS '下载方式：1-自定义链接（默认）、2-本地上传'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION.LINKURL IS '下载链接地址'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION.FILE_ID IS '程序文件ID，当选择为本地上传时保存上传文件的ID'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION.PACKAGE_NAME IS 'IOS程序包名'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION.UPDATE_CHECK IS '是否本地升级检测：1-是，0-否'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION.FORCE_UPDATE IS '是否强制升级：1-是，0-否'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION.STATUS IS '状态：1-发布，2-草稿，3-删除'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION.PUBLISH_TIME IS '发布时间'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_CLIENT_VERSION.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_SCAN_RULE (
	ID VARCHAR(32) NOT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	CP_AGENT_ID VARCHAR(32) DEFAULT NULL,
	OUTSYS_ID VARCHAR(32) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_CP_SCAN_RULE IS '企业号扫码登录EC规则表'
;

COMMENT ON COLUMN EM_CP_SCAN_RULE.ID IS '主键ID'
;

COMMENT ON COLUMN EM_CP_SCAN_RULE.CP_CORP_ID IS '所属企业号ID'
;

COMMENT ON COLUMN EM_CP_SCAN_RULE.CP_AGENT_ID IS '所属企业号应用ID'
;

COMMENT ON COLUMN EM_CP_SCAN_RULE.OUTSYS_ID IS '集成系统ID'
;

COMMENT ON COLUMN EM_CP_SCAN_RULE.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_CP_SCAN_RULE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_SCAN_RULE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_SCAN_RULE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_SCAN_RULE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_SCAN_RULE.TENANT_ID IS '企业租户ID'
;


CREATE TYPE TRANSACTIONALMODE_ENUM_ AS ENUM('OFF', 'LOCAL', 'XA', 'XA_STRICT')
;

CREATE TYPE MEMORYSTOREEVICTIONPOLICY_ENUM_ AS ENUM('LRU', 'LFU', 'FIFO')
;

CREATE TYPE PERSISTENCESTRATEGY_ENUM_ AS ENUM('LOCALTEMPSWAP', 'LOCALRESTARTABLE', 'NONE', 'DISTRIBUTED')
;

CREATE TABLE EM_SYS_CACHE_CONFIGURATION (
	ID SERIAL NOT NULL,
	CACHENAME VARCHAR(191) DEFAULT NULL,
	MAXENTRIESLOCALHEAP BIGINT DEFAULT NULL,
	MAXENTRIESLOCALDISK BIGINT DEFAULT NULL,
	ETERNAL SMALLINT DEFAULT NULL,
	CLEARONFLUSH SMALLINT DEFAULT NULL,
	TIMETOIDLESECONDS BIGINT DEFAULT NULL,
	TIMETOLIVESECONDS BIGINT DEFAULT NULL,
	DISKSPOOLBUFFERSIZEMB INT DEFAULT NULL,
	PERSISTENCESTRATEGY PERSISTENCESTRATEGY_ENUM_ DEFAULT NULL,
	DISKEXPIRYTHREADINTERVALSECOND BIGINT DEFAULT NULL,
	MEMORYSTOREEVICTIONPOLICY MEMORYSTOREEVICTIONPOLICY_ENUM_ DEFAULT NULL,
	TRANSACTIONALMODE TRANSACTIONALMODE_ENUM_ DEFAULT NULL,
	ISDEFAULTCACHE SMALLINT DEFAULT NULL,
	ALLOW_REMOVE SMALLINT DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

ALTER TABLE EM_SYS_CACHE_CONFIGURATION
	ADD CONSTRAINT UNIQUE_EM_SYS_CACHE_CONFIGURATION_cacheName UNIQUE (CACHENAME)
;

COMMENT ON TABLE EM_SYS_CACHE_CONFIGURATION IS '缓存信息表'
;

COMMENT ON COLUMN EM_SYS_CACHE_CONFIGURATION.CACHENAME IS '缓存名称'
;

COMMENT ON COLUMN EM_SYS_CACHE_CONFIGURATION.MAXENTRIESLOCALHEAP IS '同maxElementsInMemory，内存中缓存的element的最大数目'
;

COMMENT ON COLUMN EM_SYS_CACHE_CONFIGURATION.MAXENTRIESLOCALDISK IS '同maxElementsOnDisk，磁盘上缓存的element的最大数目'
;

COMMENT ON COLUMN EM_SYS_CACHE_CONFIGURATION.ETERNAL IS '缓存中的element是否永久有效'
;

COMMENT ON COLUMN EM_SYS_CACHE_CONFIGURATION.CLEARONFLUSH IS '缓存满了是否删除'
;

COMMENT ON COLUMN EM_SYS_CACHE_CONFIGURATION.TIMETOIDLESECONDS IS '缓存过期前的空闲时间'
;

COMMENT ON COLUMN EM_SYS_CACHE_CONFIGURATION.TIMETOLIVESECONDS IS '缓存过期前的生存时间'
;

COMMENT ON COLUMN EM_SYS_CACHE_CONFIGURATION.DISKSPOOLBUFFERSIZEMB IS '磁盘缓存的缓存区大小'
;

COMMENT ON COLUMN EM_SYS_CACHE_CONFIGURATION.PERSISTENCESTRATEGY IS '缓存持久化策略'
;

COMMENT ON COLUMN EM_SYS_CACHE_CONFIGURATION.DISKEXPIRYTHREADINTERVALSECOND IS '磁盘缓存的清理线程运行间隔'
;

COMMENT ON COLUMN EM_SYS_CACHE_CONFIGURATION.MEMORYSTOREEVICTIONPOLICY IS '移除缓存中element的策略'
;

COMMENT ON COLUMN EM_SYS_CACHE_CONFIGURATION.TRANSACTIONALMODE IS '缓存事务模式'
;

COMMENT ON COLUMN EM_SYS_CACHE_CONFIGURATION.ISDEFAULTCACHE IS '是否为默认缓存'
;

COMMENT ON COLUMN EM_SYS_CACHE_CONFIGURATION.ALLOW_REMOVE IS '是否允许手动清空缓存：0-不允许、1-允许'
;


CREATE TABLE EM_SYS_DDURL_MAPPING (
	ID VARCHAR(32) NOT NULL,
	MAPPING_KEY VARCHAR(100) DEFAULT NULL,
	MAPPING_URL VARCHAR(100) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_DDURL_MAPPING IS '钉钉地址映射对应表'
;

COMMENT ON COLUMN EM_SYS_DDURL_MAPPING.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SYS_DDURL_MAPPING.MAPPING_KEY IS '地址映射对应的key'
;

COMMENT ON COLUMN EM_SYS_DDURL_MAPPING.MAPPING_URL IS 'key对应需要访问的地址'
;


CREATE TABLE EM_FACE_BASEUSER_PHOTO (
	ID VARCHAR(32) NOT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	PHOTO_ID VARCHAR(32) DEFAULT NULL,
	COLLECT_STATUS SMALLINT DEFAULT NULL,
	COLLECT_DESC VARCHAR(500) DEFAULT NULL,
	UUID VARCHAR(50) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_FACE_BASEUSER_PHOTO IS '用户人脸信息记录表'
;

COMMENT ON COLUMN EM_FACE_BASEUSER_PHOTO.ID IS '主键'
;

COMMENT ON COLUMN EM_FACE_BASEUSER_PHOTO.BASE_USER_ID IS '基础用户ID'
;

COMMENT ON COLUMN EM_FACE_BASEUSER_PHOTO.PHOTO_ID IS '采集照片ID'
;

COMMENT ON COLUMN EM_FACE_BASEUSER_PHOTO.COLLECT_STATUS IS '采集状态：0-未采集，1-成功，2-失败'
;

COMMENT ON COLUMN EM_FACE_BASEUSER_PHOTO.COLLECT_DESC IS '采集信息描述'
;

COMMENT ON COLUMN EM_FACE_BASEUSER_PHOTO.UUID IS '人脸设置存储的用户id'
;

COMMENT ON COLUMN EM_FACE_BASEUSER_PHOTO.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_FACE_BASEUSER_PHOTO.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_FACE_BASEUSER_PHOTO.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_FACE_BASEUSER_PHOTO.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_FACE_BASEUSER_PHOTO.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_FACE_BASEUSER_PHOTO.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_AGENT_MSG_LOG (
	ID VARCHAR(32) NOT NULL,
	OPEN_AGENT_ID INT DEFAULT NULL,
	TARGET_TYPE SMALLINT DEFAULT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	CP_AGENT_ID VARCHAR(32) DEFAULT NULL,
	TOUSER TEXT,
	TOPARTY TEXT,
	TODEPT TEXT,
	TOTAG TEXT,
	MSGTYPE VARCHAR(10) DEFAULT NULL,
	SAFE SMALLINT DEFAULT '0',
	DATAINFO TEXT,
	REQUSETINFO TEXT,
	ERRCODE INT DEFAULT NULL,
	ERRMSG VARCHAR(1000) DEFAULT NULL,
	INVALIDUSER TEXT,
	INVALIDPARTY TEXT,
	INVALIDDEPT TEXT,
	INVALIDTAG TEXT,
	REALITYRECEIVERS TEXT,
	SOURCE_MSG_ID VARCHAR(100) DEFAULT NULL,
	SERVER_MSG_ID VARCHAR(100) DEFAULT NULL,
	SEND_TYPE SMALLINT DEFAULT NULL,
	SEND_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	LOG_GROUP_ID VARCHAR(100) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_AGENT_MSG_LOG IS '企业应用发送消息记录表'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.ID IS '主键ID'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.OPEN_AGENT_ID IS '企业应用openid'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.TARGET_TYPE IS '推送目标类型从，0-无，1-E-Mobile，2-企业号'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.CP_CORP_ID IS '推送目标的企业号ID，当目标类型为2时有效'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.CP_AGENT_ID IS '推送目标的企业号应用ID，当目标类型为2时有效'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.TOUSER IS '成员ID列表（消息接收者，多个接收者用‘|’分隔，最多支持1000个）。特殊情况：指定为@all，则向该企业应用的全部成员发送'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.TOPARTY IS '部门ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.TODEPT IS '部门ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.TOTAG IS '标签ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.MSGTYPE IS '消息类型 text-文本，image-图片，voice-语音，video-视频，file-文件，news-图文'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.SAFE IS '表示是否是保密消息，0表示否，1表示是，默认0'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.DATAINFO IS '发送数据的详细信息，json格式的完整内容'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.REQUSETINFO IS '请求数据vo'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.ERRCODE IS '发送结果状态码'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.ERRMSG IS '错误信息'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.INVALIDUSER IS '无效的成员ID列表'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.INVALIDPARTY IS '无效的部门ID列表'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.INVALIDDEPT IS '无效的部门ID列表'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.INVALIDTAG IS '无效的标签ID列表'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.REALITYRECEIVERS IS '消息发送实际上所有接收人id'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.SOURCE_MSG_ID IS '消息数据原始ID，接口传入，不传则系统自动生成'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.SERVER_MSG_ID IS '消息数据在消息服务端的ID'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.SEND_TYPE IS '消息发送类型，1-立即发送，2-定时发送'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.SEND_TIME IS '消息发送时间，如果为定时发送，这里为定时发送时间'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.LOG_GROUP_ID IS '操作批次id'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_AGENT_MSG_LOG.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_HRM_USER (
	ID VARCHAR(32) NOT NULL,
	OPEN_USER_ID VARCHAR(100) DEFAULT NULL,
	USER_NAME VARCHAR(100) DEFAULT NULL,
	NAME_SIMPLE_PINGYIN VARCHAR(500) DEFAULT NULL,
	NAME_FULL_PINGYIN VARCHAR(500) DEFAULT NULL,
	NICK_NAME VARCHAR(100) DEFAULT NULL,
	ENGLISH_NAME VARCHAR(100) DEFAULT NULL,
	MOBILE VARCHAR(1000) DEFAULT NULL,
	MOBILE_PREFIX VARCHAR(32) DEFAULT NULL,
	POSITION VARCHAR(800) DEFAULT NULL,
	GENDER SMALLINT DEFAULT NULL,
	EMAIL VARCHAR(100) DEFAULT NULL,
	IDCARD VARCHAR(20) DEFAULT NULL,
	WORKCODE VARCHAR(800) DEFAULT NULL,
	TELEPHONE VARCHAR(100) DEFAULT NULL,
	OTHERPHONE VARCHAR(50) DEFAULT NULL,
	AVATAR VARCHAR(255) DEFAULT NULL,
	SHOWORDER DECIMAL(19, 2) DEFAULT NULL,
	ISLEADER SMALLINT DEFAULT NULL,
	SECLEVEL INT DEFAULT NULL,
	COMPANY_ID VARCHAR(32) DEFAULT NULL,
	ISADMIN SMALLINT DEFAULT NULL,
	MANAGER_ID VARCHAR(32) DEFAULT NULL,
	MAIN_ID VARCHAR(255) DEFAULT '',
	ADMIN_PASSWORD VARCHAR(100) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_HRM_USER IS '企业通讯录成员表'
;

COMMENT ON COLUMN EM_HRM_USER.ID IS '主键ID'
;

COMMENT ON COLUMN EM_HRM_USER.OPEN_USER_ID IS '用户在企业内的唯一标识'
;

COMMENT ON COLUMN EM_HRM_USER.USER_NAME IS '姓名'
;

COMMENT ON COLUMN EM_HRM_USER.NAME_SIMPLE_PINGYIN IS '名字拼音简拼'
;

COMMENT ON COLUMN EM_HRM_USER.NAME_FULL_PINGYIN IS '名字拼音全拼'
;

COMMENT ON COLUMN EM_HRM_USER.NICK_NAME IS '昵称'
;

COMMENT ON COLUMN EM_HRM_USER.ENGLISH_NAME IS '英文名'
;

COMMENT ON COLUMN EM_HRM_USER.MOBILE_PREFIX IS '国际手机区号'
;

COMMENT ON COLUMN EM_HRM_USER.GENDER IS '性别 1表示男性，2表示女性，0表示未知'
;

COMMENT ON COLUMN EM_HRM_USER.EMAIL IS '邮箱'
;

COMMENT ON COLUMN EM_HRM_USER.IDCARD IS '身份证号'
;

COMMENT ON COLUMN EM_HRM_USER.TELEPHONE IS '座机'
;

COMMENT ON COLUMN EM_HRM_USER.OTHERPHONE IS '其他电话'
;

COMMENT ON COLUMN EM_HRM_USER.AVATAR IS '头像'
;

COMMENT ON COLUMN EM_HRM_USER.SHOWORDER IS '显示顺序'
;

COMMENT ON COLUMN EM_HRM_USER.ISLEADER IS '标识是否为上级 1-是，0-否'
;

COMMENT ON COLUMN EM_HRM_USER.SECLEVEL IS '安全级别'
;

COMMENT ON COLUMN EM_HRM_USER.COMPANY_ID IS '人员所属分部id'
;

COMMENT ON COLUMN EM_HRM_USER.ISADMIN IS '是否为管理员 1-是，0-否'
;

COMMENT ON COLUMN EM_HRM_USER.MANAGER_ID IS '所属上级人员，管理该表主键id'
;

COMMENT ON COLUMN EM_HRM_USER.MAIN_ID IS '次账号数据对应的主账号人员id'
;

COMMENT ON COLUMN EM_HRM_USER.ADMIN_PASSWORD IS '管理密码'
;

COMMENT ON COLUMN EM_HRM_USER.STATUS IS '状态 1=已激活，2=已禁用，3=已删除，4=未激活，5=已离职，6=已退出'
;

COMMENT ON COLUMN EM_HRM_USER.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_HRM_USER.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_HRM_USER.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_HRM_USER.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_HRM_USER.BASE_USER_ID IS '基础用户ID'
;

COMMENT ON COLUMN EM_HRM_USER.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_MSG_GROUP_SHARETK (
	ID VARCHAR(32) NOT NULL,
	GROUP_ID VARCHAR(50) DEFAULT NULL,
	OPERATOR VARCHAR(32) DEFAULT NULL,
	SHARETK VARCHAR(32) DEFAULT NULL,
	QRCODE_FILE_ID VARCHAR(32) DEFAULT NULL,
	GROUP_NAME VARCHAR(100) DEFAULT NULL,
	GROUP_ICON VARCHAR(32) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_MSG_GROUP_SHARETK IS '消息群组分享标识表'
;

COMMENT ON COLUMN EM_MSG_GROUP_SHARETK.GROUP_ID IS '群组ID'
;

COMMENT ON COLUMN EM_MSG_GROUP_SHARETK.OPERATOR IS '分享者人员ID'
;

COMMENT ON COLUMN EM_MSG_GROUP_SHARETK.SHARETK IS '分享标识'
;

COMMENT ON COLUMN EM_MSG_GROUP_SHARETK.QRCODE_FILE_ID IS '分享二维码图片ID'
;

COMMENT ON COLUMN EM_MSG_GROUP_SHARETK.GROUP_NAME IS '群组名称'
;

COMMENT ON COLUMN EM_MSG_GROUP_SHARETK.GROUP_ICON IS '群组头像文件ID'
;

COMMENT ON COLUMN EM_MSG_GROUP_SHARETK.STATUS IS '状态'
;

COMMENT ON COLUMN EM_MSG_GROUP_SHARETK.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_MSG_GROUP_SHARETK.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_MSG_GROUP_SHARETK.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_MSG_GROUP_SHARETK.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_MSG_GROUP_SHARETK.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_AGENT_BASE (
	ID VARCHAR(32) NOT NULL,
	AGENTID INT NOT NULL,
	AGENT_CATE SMALLINT DEFAULT '1',
	AGENT_TYPE SMALLINT DEFAULT '1',
	HOME_TYPE SMALLINT DEFAULT '1',
	AGENT_NAME VARCHAR(100) DEFAULT NULL,
	ENGLISH_NAME VARCHAR(100) DEFAULT NULL,
	ASSOCIATE_OUTSYSID VARCHAR(32) DEFAULT NULL,
	DESCRIPTION VARCHAR(200) DEFAULT NULL,
	LOGO VARCHAR(255) DEFAULT NULL,
	LOGO_PC VARCHAR(255) DEFAULT NULL,
	REDIRECT_DOMAIN VARCHAR(100) DEFAULT NULL,
	MSG_URL VARCHAR(200) DEFAULT NULL,
	SHARE_URL VARCHAR(200) DEFAULT NULL,
	SHARE_URL_PC VARCHAR(500) DEFAULT NULL,
	DIALOG_URL VARCHAR(200) DEFAULT NULL,
	DIALOG_URL_PC VARCHAR(200) DEFAULT NULL,
	DIALOG_OPEN_TYPE SMALLINT DEFAULT NULL,
	STATUS_URL VARCHAR(200) DEFAULT NULL,
	ATTENTION_URL VARCHAR(200) DEFAULT NULL,
	HOME_URL VARCHAR(200) DEFAULT NULL,
	HOME_URL_PC VARCHAR(200) DEFAULT NULL,
	MANAGE_URL VARCHAR(200) DEFAULT NULL,
	COUNT_URL VARCHAR(200) DEFAULT NULL,
	COUNT_CLEAR_TYPE SMALLINT DEFAULT NULL,
	COUNT_SHOW_TYPE SMALLINT DEFAULT NULL,
	COUNT_CYCLE BIGINT DEFAULT NULL,
	SEND_TO_EM SMALLINT DEFAULT NULL,
	COUNT_TYPE SMALLINT DEFAULT NULL,
	ISTOP SMALLINT DEFAULT NULL,
	ISUNDISTURB SMALLINT DEFAULT NULL,
	REPORT_LOCATION_FLAG SMALLINT DEFAULT NULL,
	ISREPORTENTER SMALLINT DEFAULT NULL,
	IOS_PKGNAME VARCHAR(50) DEFAULT NULL,
	IOS_DOWNLOADURL VARCHAR(500) DEFAULT NULL,
	AND_PKGNAME VARCHAR(50) DEFAULT NULL,
	AND_DOWNLOADURL VARCHAR(500) DEFAULT NULL,
	APP_AUTH VARCHAR(100) DEFAULT NULL,
	APP_GOPAGE VARCHAR(500) DEFAULT NULL,
	CLIENTTYPES VARCHAR(20) DEFAULT NULL,
	ISSHOWINPORTAL SMALLINT DEFAULT '1',
	ISSHOWINSTORE SMALLINT DEFAULT '1',
	MSG_EXTEND_URL VARCHAR(200) DEFAULT NULL,
	MSG_EXTEND_URL_PC VARCHAR(500) DEFAULT NULL,
	MSG_EXTEND_NAME VARCHAR(100) DEFAULT NULL,
	MSG_EXTEND_SHOWORDER DECIMAL(10, 2) DEFAULT NULL,
	MSG_EXTEND_ISHEAD SMALLINT DEFAULT NULL,
	MSG_EXTEND_WWIDTH INT DEFAULT NULL,
	MSG_EXTEND_WHEIGHT INT DEFAULT NULL,
	MSG_EXTEND_ISPRELOAD SMALLINT DEFAULT NULL,
	ENABLE_AUTH SMALLINT DEFAULT NULL,
	AUTH_TYPE SMALLINT DEFAULT NULL,
	AUTH_ACCESS_TOKEN VARCHAR(50) DEFAULT NULL,
	AUTH_USERID_FIELD VARCHAR(500) DEFAULT NULL,
	AUTH_OUTSYSID VARCHAR(32) DEFAULT NULL,
	AUTH_PARAM_TYPE SMALLINT DEFAULT NULL,
	ISLOCAL SMALLINT DEFAULT '0',
	APPZIPFILE VARCHAR(500) DEFAULT NULL,
	VERSION VARCHAR(10) DEFAULT NULL,
	MINVERSION VARCHAR(10) DEFAULT NULL,
	INDEXPAGE VARCHAR(500) DEFAULT NULL,
	QUERY VARCHAR(500) DEFAULT NULL,
	BASEURL VARCHAR(500) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	RELEVANCE_INTEGRATE_SYS_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_AGENT_BASE IS '企业应用基本信息表'
;

COMMENT ON COLUMN EM_AGENT_BASE.ID IS '主键ID'
;

COMMENT ON COLUMN EM_AGENT_BASE.AGENT_CATE IS '应用种类1:自建应用 2：集成应用'
;

COMMENT ON COLUMN EM_AGENT_BASE.AGENT_TYPE IS '应用类型 1：主页型 2：消息型 3：分享型'
;

COMMENT ON COLUMN EM_AGENT_BASE.HOME_TYPE IS '应用主页类型:1-打开页面，2-打开第三方APP'
;

COMMENT ON COLUMN EM_AGENT_BASE.AGENT_NAME IS '应用名称'
;

COMMENT ON COLUMN EM_AGENT_BASE.ENGLISH_NAME IS '英文名称'
;

COMMENT ON COLUMN EM_AGENT_BASE.ASSOCIATE_OUTSYSID IS '应用关联的集成系统'
;

COMMENT ON COLUMN EM_AGENT_BASE.DESCRIPTION IS '描述'
;

COMMENT ON COLUMN EM_AGENT_BASE.LOGO IS '图标'
;

COMMENT ON COLUMN EM_AGENT_BASE.LOGO_PC IS 'pc端显示图标，不填默认和移动端图标，logo'
;

COMMENT ON COLUMN EM_AGENT_BASE.REDIRECT_DOMAIN IS '可信域名'
;

COMMENT ON COLUMN EM_AGENT_BASE.MSG_URL IS '消息链接地址'
;

COMMENT ON COLUMN EM_AGENT_BASE.SHARE_URL IS '消息分享地址'
;

COMMENT ON COLUMN EM_AGENT_BASE.SHARE_URL_PC IS '消息回调PC打开地址'
;

COMMENT ON COLUMN EM_AGENT_BASE.DIALOG_URL IS '消息主页地址：用户在消息会话列表中点击此应用会话时打开的页面地址，不设置则进入系统默认的消息页面'
;

COMMENT ON COLUMN EM_AGENT_BASE.DIALOG_URL_PC IS 'PC端消息主页地址：用户在消息会话列表中点击此应用会话时打开的页面地址，不设置则进入系统默认的消息页面'
;

COMMENT ON COLUMN EM_AGENT_BASE.DIALOG_OPEN_TYPE IS '打开方式  1-默认 2-弹出'
;

COMMENT ON COLUMN EM_AGENT_BASE.STATUS_URL IS '消息状态接口地址：推送到此应用的消息的状态获取接口地址，例如流程的已处理未处理'
;

COMMENT ON COLUMN EM_AGENT_BASE.ATTENTION_URL IS '消息提醒设置地址：用户个性化设置消息提醒的页面地址'
;

COMMENT ON COLUMN EM_AGENT_BASE.HOME_URL IS '应用主页地址'
;

COMMENT ON COLUMN EM_AGENT_BASE.HOME_URL_PC IS 'PC版应用主页地址'
;

COMMENT ON COLUMN EM_AGENT_BASE.MANAGE_URL IS '后台管理主页'
;

COMMENT ON COLUMN EM_AGENT_BASE.COUNT_URL IS '统计提示信息数量url地址'
;

COMMENT ON COLUMN EM_AGENT_BASE.COUNT_CLEAR_TYPE IS '未读数清除方式 0-不清除，1-清除 默认0'
;

COMMENT ON COLUMN EM_AGENT_BASE.COUNT_SHOW_TYPE IS '消息应用未读数显示类型,数字-1/红点-2 默认为1 '
;

COMMENT ON COLUMN EM_AGENT_BASE.COUNT_CYCLE IS '统计周期'
;

COMMENT ON COLUMN EM_AGENT_BASE.SEND_TO_EM IS '消息信息：是否发送消息eMobile'
;

COMMENT ON COLUMN EM_AGENT_BASE.COUNT_TYPE IS '消息应用统计类型，1-默认，2-接口'
;

COMMENT ON COLUMN EM_AGENT_BASE.ISTOP IS '消息应用是否置顶'
;

COMMENT ON COLUMN EM_AGENT_BASE.ISUNDISTURB IS '消息应用是否免打扰'
;

COMMENT ON COLUMN EM_AGENT_BASE.REPORT_LOCATION_FLAG IS '企业应用是否打开地理位置上报 0：不上报；1：进入会话上报'
;

COMMENT ON COLUMN EM_AGENT_BASE.ISREPORTENTER IS '是否上报用户进入应用事件。0：不接收；1：接收'
;

COMMENT ON COLUMN EM_AGENT_BASE.IOS_PKGNAME IS '第三方APPiOS应用scheme'
;

COMMENT ON COLUMN EM_AGENT_BASE.IOS_DOWNLOADURL IS '第三方APPiOS应用下载地址'
;

COMMENT ON COLUMN EM_AGENT_BASE.AND_PKGNAME IS '第三方APPAndroid应用包名'
;

COMMENT ON COLUMN EM_AGENT_BASE.AND_DOWNLOADURL IS '第三方APPAndroid应用下载地址'
;

COMMENT ON COLUMN EM_AGENT_BASE.APP_AUTH IS '第三方APP访问验证参数'
;

COMMENT ON COLUMN EM_AGENT_BASE.APP_GOPAGE IS '第三方APP访问直接打开的地址'
;

COMMENT ON COLUMN EM_AGENT_BASE.CLIENTTYPES IS '适用客户端类型：1-PC客户端，2-IOS客户端，3-安卓客户端，4-web版，适用于多个客户端时用逗号分隔表示，值为null或者空字符串时表示适用于所有客户端类型'
;

COMMENT ON COLUMN EM_AGENT_BASE.ISSHOWINPORTAL IS '是否显示在门户的其他应用分组中 1-显示，0-不显示'
;

COMMENT ON COLUMN EM_AGENT_BASE.ISSHOWINSTORE IS '是否显示在应用商店中，即所有应用列表中 1-显示，0-不显示'
;

COMMENT ON COLUMN EM_AGENT_BASE.MSG_EXTEND_URL IS '消息扩展链接地址'
;

COMMENT ON COLUMN EM_AGENT_BASE.MSG_EXTEND_URL_PC IS '分享链接PC打开地址'
;

COMMENT ON COLUMN EM_AGENT_BASE.MSG_EXTEND_NAME IS '消息扩展名称，不设置则与应用名称相同'
;

COMMENT ON COLUMN EM_AGENT_BASE.MSG_EXTEND_SHOWORDER IS '消息扩展排序'
;

COMMENT ON COLUMN EM_AGENT_BASE.MSG_EXTEND_ISHEAD IS '应用消息拓展，添加是否显示头'
;

COMMENT ON COLUMN EM_AGENT_BASE.MSG_EXTEND_WWIDTH IS '应用消息拓展，显示窗口宽度'
;

COMMENT ON COLUMN EM_AGENT_BASE.MSG_EXTEND_WHEIGHT IS '应用消息拓展，显示窗口高度'
;

COMMENT ON COLUMN EM_AGENT_BASE.MSG_EXTEND_ISPRELOAD IS '消息是否显示预加载'
;

COMMENT ON COLUMN EM_AGENT_BASE.ENABLE_AUTH IS '是否开启授权'
;

COMMENT ON COLUMN EM_AGENT_BASE.AUTH_TYPE IS '单点登录方式 1：oauth2 2：SHA1 3：ecology'
;

COMMENT ON COLUMN EM_AGENT_BASE.AUTH_ACCESS_TOKEN IS '单点登录秘钥，当auth_type为2时使用'
;

COMMENT ON COLUMN EM_AGENT_BASE.AUTH_USERID_FIELD IS '单点登录用户标识字段，当auth_type为2时使用，其中1标识基础用户ID，2标识通讯录userid，3标识通讯录手机号，其他表示自定义字段ID'
;

COMMENT ON COLUMN EM_AGENT_BASE.AUTH_OUTSYSID IS '单点登录集成系统ID，当auth_type为3时使用，对应em_integrate_outsys_info表的id'
;

COMMENT ON COLUMN EM_AGENT_BASE.AUTH_PARAM_TYPE IS '授权后访问地址url的拼接处理方式，1-如果存在#号，在#后拼接参数，2-如果存在#号，在#号前拼接参数'
;

COMMENT ON COLUMN EM_AGENT_BASE.ISLOCAL IS '是否开启本地化：1-是，0-否（默认）'
;

COMMENT ON COLUMN EM_AGENT_BASE.VERSION IS '版本号，字符串类型的整数值'
;

COMMENT ON COLUMN EM_AGENT_BASE.MINVERSION IS '小版本，字符串类型的整数值'
;

COMMENT ON COLUMN EM_AGENT_BASE.STATUS IS '状态 1-正常，2-禁用，3-删除'
;

COMMENT ON COLUMN EM_AGENT_BASE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_AGENT_BASE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_AGENT_BASE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_AGENT_BASE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_AGENT_BASE.TENANT_ID IS '企业租户ID'
;

COMMENT ON COLUMN EM_AGENT_BASE.RELEVANCE_INTEGRATE_SYS_ID IS '企业微信集成系统 关联的外部系统集成id'
;


CREATE TABLE SPRING_SESSION_ATTRIBUTES (
	SESSION_PRIMARY_ID CHAR(36) NOT NULL,
	ATTRIBUTE_NAME VARCHAR(191) NOT NULL,
	ATTRIBUTE_BYTES BYTEA NOT NULL,
	PRIMARY KEY (SESSION_PRIMARY_ID, ATTRIBUTE_NAME)
)
;



CREATE TABLE QRTZ_JOB_DETAILS (
	SCHED_NAME VARCHAR(120) NOT NULL,
	JOB_NAME VARCHAR(190) NOT NULL,
	JOB_GROUP VARCHAR(190) NOT NULL,
	DESCRIPTION VARCHAR(250) DEFAULT NULL,
	JOB_CLASS_NAME VARCHAR(250) NOT NULL,
	IS_DURABLE VARCHAR(8) NOT NULL,
	IS_NONCONCURRENT VARCHAR(8) NOT NULL,
	IS_UPDATE_DATA VARCHAR(8) NOT NULL,
	REQUESTS_RECOVERY VARCHAR(8) NOT NULL,
	JOB_DATA BYTEA,
	PRIMARY KEY (SCHED_NAME, JOB_NAME, JOB_GROUP)
)
;




CREATE TABLE EM_SC_THEME_NAV (
	ID VARCHAR(32) NOT NULL,
	THEME_BASE_ID VARCHAR(32) DEFAULT NULL,
	NAV_NAME VARCHAR(50) DEFAULT NULL,
	NAV_FUNC INT DEFAULT NULL,
	NAV_FUNC_SET1 VARCHAR(200) DEFAULT NULL,
	NAV_FUNC_SET2 VARCHAR(200) DEFAULT NULL,
	NAV_FUNC_SET3 VARCHAR(200) DEFAULT NULL,
	NAV_FUNC_SET4 VARCHAR(200) DEFAULT NULL,
	ISSHOW SMALLINT DEFAULT NULL,
	SHOWORDER INT DEFAULT NULL,
	ISDEFAULT SMALLINT DEFAULT NULL,
	ICON_DEFAULT VARCHAR(200) NOT NULL,
	ICON_SELECTED VARCHAR(200) NOT NULL,
	TOP_BGCOLOR VARCHAR(50) DEFAULT NULL,
	TOP_TITLE VARCHAR(50) DEFAULT NULL,
	TOP_TXTCOLOR VARCHAR(50) DEFAULT NULL,
	ICON_MORE VARCHAR(200) NOT NULL,
	NAV_BTN_COLOR VARCHAR(50) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_SC_THEME_NAV IS '企业客户端主题导航明细设置表'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.THEME_BASE_ID IS '主题ID'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.NAV_NAME IS '导航名称'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.NAV_FUNC IS '导航功能：-1-消息，-2-通讯录，-3-工作台，-4-我，1-应用，2-门户，3-自定义链接'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.NAV_FUNC_SET1 IS '导航功能设置，如应用ID、门户ID，自定义链接地址等'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.NAV_FUNC_SET2 IS '导航功能设置，如自定义链接的打开方式1表示默认窗口，2表示新窗口'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.NAV_FUNC_SET3 IS '功能设置，如自定义链接的打开方式为2表示新窗口，此时为打开的宽度'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.NAV_FUNC_SET4 IS '功能设置，如自定义链接的打开方式为2表示新窗口，此时为打开的高度'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.ISSHOW IS '是否显示：1-登显示，0-不显示'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.SHOWORDER IS '显示顺序'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.ISDEFAULT IS '是否默认：1-默认，0-不默认'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.ICON_DEFAULT IS '默认显示图标'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.ICON_SELECTED IS '选中显示图标'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.TOP_BGCOLOR IS '顶部背景颜色'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.TOP_TITLE IS '顶部显示标题'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.TOP_TXTCOLOR IS '顶部显示标题文字颜色'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.ICON_MORE IS '顶部更多按钮图标'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.NAV_BTN_COLOR IS '导航按钮颜色'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SC_THEME_NAV.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_CLIENT_DOWNLOAD (
	ID VARCHAR(32) NOT NULL,
	ISWIN SMALLINT NOT NULL,
	WIN_CUSTOMIZE SMALLINT NOT NULL,
	WIN_LINK VARCHAR(200) DEFAULT NULL,
	ISXP SMALLINT NOT NULL,
	XP_CUSTOMIZE SMALLINT NOT NULL,
	XP_LINK VARCHAR(200) DEFAULT NULL,
	ISMAC SMALLINT NOT NULL,
	MAC_CUSTOMIZE SMALLINT NOT NULL,
	MAC_LINK VARCHAR(200) DEFAULT NULL,
	ISIOS SMALLINT NOT NULL,
	IOS_CUSTOMIZE SMALLINT NOT NULL,
	IOS_LINK VARCHAR(200) DEFAULT NULL,
	ISANDROID SMALLINT NOT NULL,
	ANDROID_CUSTOMIZE SMALLINT NOT NULL,
	ANDROID_LINK VARCHAR(200) DEFAULT NULL,
	REMARK TEXT,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_CLIENT_DOWNLOAD IS '客户端下载地址配置'
;

COMMENT ON COLUMN EM_SYS_CLIENT_DOWNLOAD.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SYS_CLIENT_DOWNLOAD.ISWIN IS '是否开启win7及以上版本，1表示开启，0表示关闭'
;

COMMENT ON COLUMN EM_SYS_CLIENT_DOWNLOAD.WIN_CUSTOMIZE IS 'win版本下载地址是否是自定义 1-自定义 0-默认'
;

COMMENT ON COLUMN EM_SYS_CLIENT_DOWNLOAD.WIN_LINK IS 'win7及以上设备下载地址'
;

COMMENT ON COLUMN EM_SYS_CLIENT_DOWNLOAD.ISXP IS '是否开启xp版本，1表示开启，0表示关闭'
;

COMMENT ON COLUMN EM_SYS_CLIENT_DOWNLOAD.XP_CUSTOMIZE IS 'xp版本下载地址是否是自定义 1-自定义 0-默认'
;

COMMENT ON COLUMN EM_SYS_CLIENT_DOWNLOAD.XP_LINK IS 'xp版本下载地址'
;

COMMENT ON COLUMN EM_SYS_CLIENT_DOWNLOAD.ISMAC IS '是否开启mac版本，1表示开启，0表示关闭'
;

COMMENT ON COLUMN EM_SYS_CLIENT_DOWNLOAD.MAC_CUSTOMIZE IS 'mac版本下载地址是否是自定义 1-自定义 0-默认'
;

COMMENT ON COLUMN EM_SYS_CLIENT_DOWNLOAD.MAC_LINK IS 'mac版本下载地址'
;

COMMENT ON COLUMN EM_SYS_CLIENT_DOWNLOAD.ISIOS IS '是否开启ios版本，1表示开启，0表示关闭'
;

COMMENT ON COLUMN EM_SYS_CLIENT_DOWNLOAD.IOS_CUSTOMIZE IS 'ios版本下载地址是否自定义 1-自定义 0-默认'
;

COMMENT ON COLUMN EM_SYS_CLIENT_DOWNLOAD.IOS_LINK IS 'ios版本下载地址'
;

COMMENT ON COLUMN EM_SYS_CLIENT_DOWNLOAD.ISANDROID IS '是否开启android版本，1表示开启，0表示关闭'
;

COMMENT ON COLUMN EM_SYS_CLIENT_DOWNLOAD.ANDROID_CUSTOMIZE IS 'android版本下载地址是否自定义 1-自定义 0-默认'
;

COMMENT ON COLUMN EM_SYS_CLIENT_DOWNLOAD.ANDROID_LINK IS 'android版本下载地址'
;

COMMENT ON COLUMN EM_SYS_CLIENT_DOWNLOAD.REMARK IS '备注信息'
;

COMMENT ON COLUMN EM_SYS_CLIENT_DOWNLOAD.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_CLIENT_DOWNLOAD.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_CLIENT_DOWNLOAD.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SC_PORTAL_CATEGORY_ELEMENT (
	ID VARCHAR(32) NOT NULL,
	PORTAL_BASE_ID VARCHAR(32) DEFAULT NULL,
	PORTAL_CATEGORY_ID VARCHAR(32) DEFAULT NULL,
	BTN_TYPE SMALLINT DEFAULT NULL,
	ELEMENT_NAME VARCHAR(50) DEFAULT NULL,
	ENGLISH_NAME VARCHAR(50) DEFAULT NULL,
	ELEMENT_TYPE INT DEFAULT NULL,
	ELEMENT_SET1 VARCHAR(200) DEFAULT NULL,
	ELEMENT_SET2 VARCHAR(1000) DEFAULT NULL,
	SHOWORDER INT DEFAULT NULL,
	ICON_DEFAULT VARCHAR(200) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_SC_PORTAL_CATEGORY_ELEMENT IS '企业客户端门户分组元素设置表'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_ELEMENT.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_ELEMENT.PORTAL_BASE_ID IS '门户ID'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_ELEMENT.PORTAL_CATEGORY_ID IS '分组ID'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_ELEMENT.BTN_TYPE IS '按钮类型 1-右上角按钮，2-消息功能按钮'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_ELEMENT.ELEMENT_NAME IS '元素名称'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_ELEMENT.ENGLISH_NAME IS '英文名称'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_ELEMENT.ELEMENT_TYPE IS '元素类型：1-应用，2-门户，3-自定义链接，4-幻灯片'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_ELEMENT.ELEMENT_SET1 IS '元素功能设置，如应用ID、门户ID、自定义链接地址，幻灯片图片等'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_ELEMENT.ELEMENT_SET2 IS '元素功能设置，如链接的打开方式1表示默认窗口，2表示新窗口,如果是配置型幻灯片，这存储相关json配置'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_ELEMENT.SHOWORDER IS '显示顺序'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_ELEMENT.ICON_DEFAULT IS '默认显示图标'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_ELEMENT.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_ELEMENT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_ELEMENT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_ELEMENT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_ELEMENT.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_ELEMENT.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_MSG_GROUP_CLIENT_WX (
	ID VARCHAR(32) NOT NULL,
	GROUPID VARCHAR(64) NOT NULL,
	GROUP_NAME VARCHAR(255) DEFAULT NULL,
	WX_GROUPID VARCHAR(64) DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_MSG_GROUP_CLIENT_WX IS '客户端创建企业微信群组表'
;

COMMENT ON COLUMN EM_MSG_GROUP_CLIENT_WX.ID IS '主键ID'
;

COMMENT ON COLUMN EM_MSG_GROUP_CLIENT_WX.GROUPID IS 'emobile群组ID'
;

COMMENT ON COLUMN EM_MSG_GROUP_CLIENT_WX.GROUP_NAME IS '群组名称'
;

COMMENT ON COLUMN EM_MSG_GROUP_CLIENT_WX.WX_GROUPID IS '企业微信群组ID'
;

COMMENT ON COLUMN EM_MSG_GROUP_CLIENT_WX.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_MSG_GROUP_CLIENT_WX.CREATE_TIME IS '创建时间'
;


CREATE TABLE EM_SYS_TRADE (
	CATEGORY_CODE VARCHAR(4) NOT NULL,
	CATEGORY_NAME VARCHAR(100) NOT NULL,
	DESCRITION VARCHAR(1000) DEFAULT NULL,
	PID VARCHAR(4) NOT NULL,
	PRIMARY KEY (CATEGORY_CODE)
)
;


COMMENT ON TABLE EM_SYS_TRADE IS '行业大类表'
;

COMMENT ON COLUMN EM_SYS_TRADE.CATEGORY_CODE IS '行业代码'
;

COMMENT ON COLUMN EM_SYS_TRADE.CATEGORY_NAME IS '行业类别名称'
;

COMMENT ON COLUMN EM_SYS_TRADE.DESCRITION IS '行业描述'
;

COMMENT ON COLUMN EM_SYS_TRADE.PID IS '上一级行业代码'
;


CREATE TABLE EM_SYS_FACE_RIGHT (
	ID VARCHAR(32) NOT NULL,
	HRM_DATA_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_TYPE SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_SYS_FACE_RIGHT IS '人脸使用权限设置表'
;

COMMENT ON COLUMN EM_SYS_FACE_RIGHT.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SYS_FACE_RIGHT.HRM_DATA_ID IS '通讯录成员或部门表ID'
;

COMMENT ON COLUMN EM_SYS_FACE_RIGHT.HRM_DATA_TYPE IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;

COMMENT ON COLUMN EM_SYS_FACE_RIGHT.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_SYS_FACE_RIGHT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_FACE_RIGHT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_FACE_RIGHT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_FACE_RIGHT.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_FACE_RIGHT.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_MSGAUDIT_KEY (
	ID VARCHAR(32) NOT NULL,
	CORP_ID VARCHAR(32) DEFAULT NULL,
	VERSION INT DEFAULT NULL,
	PRIVATE_KEY TEXT,
	PUBLIC_KEY TEXT,
	REMARK TEXT,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_CP_MSGAUDIT_KEY IS '消息存档密钥'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_KEY.ID IS '主键'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_KEY.CORP_ID IS '企业号基本信息ID'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_KEY.VERSION IS '版本号'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_KEY.PRIVATE_KEY IS '私钥'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_KEY.PUBLIC_KEY IS '公钥'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_KEY.REMARK IS '备注'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_KEY.STATUS IS '状态'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_KEY.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_KEY.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_KEY.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_KEY.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_KEY.TENANT_ID IS '租户ID'
;


CREATE TABLE QRTZ_FIRED_TRIGGERS (
	SCHED_NAME VARCHAR(120) NOT NULL,
	ENTRY_ID VARCHAR(95) NOT NULL,
	TRIGGER_NAME VARCHAR(190) NOT NULL,
	TRIGGER_GROUP VARCHAR(190) NOT NULL,
	INSTANCE_NAME VARCHAR(190) NOT NULL,
	FIRED_TIME BIGINT NOT NULL,
	SCHED_TIME BIGINT NOT NULL,
	PRIORITY INT NOT NULL,
	STATE VARCHAR(16) NOT NULL,
	JOB_NAME VARCHAR(190) DEFAULT NULL,
	JOB_GROUP VARCHAR(190) DEFAULT NULL,
	IS_NONCONCURRENT VARCHAR(8) DEFAULT NULL,
	REQUESTS_RECOVERY VARCHAR(8) DEFAULT NULL,
	PRIMARY KEY (SCHED_NAME, ENTRY_ID)
)
;



CREATE TABLE EM_SYS_BASEUSER_DEVICE (
	ID VARCHAR(32) NOT NULL,
	DEVICE_NAME VARCHAR(2000) DEFAULT NULL,
	CLIENT_TYPE SMALLINT DEFAULT '0',
	DEVICE_ID VARCHAR(500) DEFAULT NULL,
	DEVICE_MODEL VARCHAR(500) DEFAULT NULL,
	OS_VERSION VARCHAR(500) DEFAULT NULL,
	BINDING SMALLINT DEFAULT NULL,
	LAST_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	LOGIN_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_SYS_BASEUSER_DEVICE IS '用户设备信息记录表'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE.ID IS '主键'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE.DEVICE_NAME IS '设备名称'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE.CLIENT_TYPE IS '设备类型：1-PC客户端，2-ios，3-android，4-web'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE.DEVICE_ID IS '设备标识'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE.DEVICE_MODEL IS '设备型号'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE.OS_VERSION IS '操作系统信息'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE.BINDING IS '是否绑定：1-是，0-否'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE.LAST_TIME IS '最后登录时间'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE.LOGIN_USER_ID IS '登录者基础用户id'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_INTEGRATE_OUTSYS_INFO (
	ID VARCHAR(32) NOT NULL,
	SYS_NAME VARCHAR(50) DEFAULT NULL,
	SYS_TYPE SMALLINT DEFAULT '1',
	SYS_URL VARCHAR(100) DEFAULT NULL,
	SYS_URL_OPEN VARCHAR(100) DEFAULT NULL,
	SYS_URL_PC VARCHAR(100) DEFAULT NULL,
	SYS_ACCESSTOKEN VARCHAR(50) DEFAULT NULL,
	SYS_UUID VARCHAR(50) DEFAULT NULL,
	RSA_PUB VARCHAR(1000) DEFAULT NULL,
	AUTH_TYPE SMALLINT DEFAULT NULL,
	REDIRECT_DOMAIN VARCHAR(100) DEFAULT NULL,
	AUTH_ACCESS_TOKEN VARCHAR(50) DEFAULT NULL,
	AUTH_USERID_FIELD VARCHAR(32) DEFAULT NULL,
	REMARK VARCHAR(200) DEFAULT NULL,
	WORKBENCH_AGENTID SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	ENABLE_DIRECT SMALLINT DEFAULT NULL,
	PASSID VARCHAR(100) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_INTEGRATE_OUTSYS_INFO IS '集成系统信息表'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.ID IS '主键ID'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.SYS_NAME IS '系统名称'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.SYS_TYPE IS '系统类型：1-ecology系统'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.SYS_URL IS '系统访问地址'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.SYS_URL_OPEN IS '系统移动端访问地址'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.SYS_URL_PC IS '系统pc端访问地址'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.SYS_ACCESSTOKEN IS '系统接入秘钥'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.SYS_UUID IS '系统uuid标识'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.RSA_PUB IS '集成系统约定间加密秘钥'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.AUTH_TYPE IS '单点登录方式：0:未设置,1：oauth2 2：SHA1 3：AUTH_CODE'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.REDIRECT_DOMAIN IS '授权类型未1 oauth2 时，使用的可信域名'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.AUTH_ACCESS_TOKEN IS '单点登录秘钥，当auth_type为2时使用'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.AUTH_USERID_FIELD IS '单点登录用户标识字段，-1表示继承系统ecology方式，需根据集成系统id获得对应的继承系统用户所在id，其中1标识基础用户ID，2标识通讯录userid，3标识通讯录手机号，其他表示自定义字段ID'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.REMARK IS '备注'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.WORKBENCH_AGENTID IS '集成接入对应的工作台应用id'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.STATUS IS '状态 1-正常，2-禁用，3-删除'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.TENANT_ID IS '企业租户ID'
;

COMMENT ON COLUMN EM_INTEGRATE_OUTSYS_INFO.ENABLE_DIRECT IS '是否直连，1-是。0-否'
;


CREATE TABLE EM_SYS_TASK (
	ID VARCHAR(32) NOT NULL,
	ENABLED SMALLINT DEFAULT NULL,
	CLASS_NAME VARCHAR(255) DEFAULT NULL,
	START_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	END_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	CYCLE BIGINT DEFAULT NULL,
	DESCRIPTION VARCHAR(255) DEFAULT NULL,
	IS_LOCAL SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_TASK IS '系统任务表'
;

COMMENT ON COLUMN EM_SYS_TASK.ID IS '主键'
;

COMMENT ON COLUMN EM_SYS_TASK.ENABLED IS '是否启动：1-启用、0-停用'
;

COMMENT ON COLUMN EM_SYS_TASK.CLASS_NAME IS '任务的JAVA类'
;

COMMENT ON COLUMN EM_SYS_TASK.START_TIME IS '任务开始时间'
;

COMMENT ON COLUMN EM_SYS_TASK.END_TIME IS '任务结束时间'
;

COMMENT ON COLUMN EM_SYS_TASK.CYCLE IS '执行周期（单位：毫秒）'
;

COMMENT ON COLUMN EM_SYS_TASK.DESCRIPTION IS '任务描述'
;

COMMENT ON COLUMN EM_SYS_TASK.IS_LOCAL IS '是否本地任务'
;

COMMENT ON COLUMN EM_SYS_TASK.STATUS IS '状态 1-正常，2-禁用，3-删除'
;

COMMENT ON COLUMN EM_SYS_TASK.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_TASK.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_TASK.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_TASK.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_TASK.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_MSGAUDIT_ROOM_MEMBER (
	ID VARCHAR(32) NOT NULL,
	ROOM_ID VARCHAR(64) DEFAULT NULL,
	MEMBER_ID VARCHAR(64) DEFAULT NULL,
	JOIN_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_CP_MSGAUDIT_ROOM_MEMBER IS '会话内容存档会话成员关联关系'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM_MEMBER.ID IS '主键'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM_MEMBER.ROOM_ID IS '会话ID'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM_MEMBER.MEMBER_ID IS '成员ID'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM_MEMBER.JOIN_TIME IS '加入时间'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM_MEMBER.STATUS IS '状态'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM_MEMBER.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM_MEMBER.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM_MEMBER.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM_MEMBER.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM_MEMBER.TENANT_ID IS '租户ID'
;


CREATE TABLE EM_MSG_DING_BAK (
	ID VARCHAR(32) NOT NULL,
	SEND_USER_ID VARCHAR(32) DEFAULT NULL,
	TOUSERIDS TEXT,
	MESSAGEID VARCHAR(50) DEFAULT NULL,
	MSG_CONTENT VARCHAR(1000) DEFAULT NULL,
	MSG_TYPE SMALLINT DEFAULT '1',
	SEND_TYPE SMALLINT DEFAULT '1',
	SEND_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	SEND_RESULT SMALLINT DEFAULT '1',
	MSG_DING_ID VARCHAR(50) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_MSG_DING_BAK IS '必达消息数据表'
;

COMMENT ON COLUMN EM_MSG_DING_BAK.ID IS '主键ID'
;

COMMENT ON COLUMN EM_MSG_DING_BAK.SEND_USER_ID IS '发送人id'
;

COMMENT ON COLUMN EM_MSG_DING_BAK.TOUSERIDS IS '接收人员id，多个用逗号分隔'
;

COMMENT ON COLUMN EM_MSG_DING_BAK.MESSAGEID IS '消息转必达id'
;

COMMENT ON COLUMN EM_MSG_DING_BAK.MSG_CONTENT IS '消息内容'
;

COMMENT ON COLUMN EM_MSG_DING_BAK.MSG_TYPE IS '消息类型：1-应用内，2-短信，3-电话'
;

COMMENT ON COLUMN EM_MSG_DING_BAK.SEND_TYPE IS '发送类型：1-立即发送，2-定时发送'
;

COMMENT ON COLUMN EM_MSG_DING_BAK.SEND_TIME IS '定时发送的时间，格式为YYYY-MM-DD HH:MM:ss'
;

COMMENT ON COLUMN EM_MSG_DING_BAK.SEND_RESULT IS '发送结果：1-发生成功，2-等待发送，3-发送失败'
;

COMMENT ON COLUMN EM_MSG_DING_BAK.MSG_DING_ID IS '对应消息服务中的数据ID'
;

COMMENT ON COLUMN EM_MSG_DING_BAK.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_MSG_DING_BAK.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_MSG_DING_BAK.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_MSG_DING_BAK.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_MSG_DING_BAK.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_MSG_DING_BAK.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_CHECKIN_SYNC_SET (
	ID VARCHAR(32) NOT NULL,
	SYNC_NAME VARCHAR(50) DEFAULT NULL,
	SYS_TASK_ID VARCHAR(32) DEFAULT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	TIME_TYPE SMALLINT DEFAULT NULL,
	DATA_STARTTIME VARCHAR(50) DEFAULT NULL,
	DATA_ENDTIME VARCHAR(50) DEFAULT NULL,
	OUTSYS_ID VARCHAR(32) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	OPEN_CHECKIN_DATA_TYPE SMALLINT DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_CP_CHECKIN_SYNC_SET IS '企业号考勤打卡数据同步设置表'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_SET.ID IS '主键ID'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_SET.SYNC_NAME IS '同步设置名称'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_SET.SYS_TASK_ID IS '定时同步任务ID'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_SET.CP_CORP_ID IS '企业号基本信息ID'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_SET.TIME_TYPE IS '时间类型，1代表当天，2代表时间段，3代表前一天'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_SET.DATA_STARTTIME IS '打卡数据开始时间'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_SET.DATA_ENDTIME IS '打卡数据结束时间'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_SET.OUTSYS_ID IS '集成系统ID'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_SET.STATUS IS '状态：1-正常、3-删除'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_SET.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_SET.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_SET.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_SET.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_SET.TENANT_ID IS '企业租户ID'
;

COMMENT ON COLUMN EM_CP_CHECKIN_SYNC_SET.OPEN_CHECKIN_DATA_TYPE IS '打卡类型。1：上下班打卡；2：外出打卡；3：全部打卡'
;


CREATE TABLE EM_CP_USER_SYNC_SET (
	ID VARCHAR(32) NOT NULL,
	SYS_TASK_ID VARCHAR(32) DEFAULT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	SYNC_TYPE SMALLINT DEFAULT '1',
	IS_SYNC_AVATAR SMALLINT DEFAULT NULL,
	OPEN_DEPT_ID TEXT,
	BIND_TYPE SMALLINT DEFAULT '0',
	ROOT_DEPT_ID VARCHAR(32) DEFAULT NULL,
	ADD_TYPE SMALLINT DEFAULT '1',
	INVITE_TYPE SMALLINT DEFAULT '0',
	USERID_FIELD SMALLINT DEFAULT '1',
	USER_DEL_TYPE SMALLINT DEFAULT '1',
	IS_DISABLEDUSER_TO_DEPT SMALLINT DEFAULT NULL,
	IS_SYNC_MULTIDEPT SMALLINT DEFAULT '1',
	IS_COVER_CPDEPT SMALLINT DEFAULT '0',
	DEPT_SYNC_TYPE SMALLINT DEFAULT '1',
	ISALLUSER SMALLINT DEFAULT '0',
	ISEXTERNAL SMALLINT DEFAULT NULL,
	MATCH_USER_FIELD SMALLINT DEFAULT '1',
	MATCH_USER_CUSTOMFIELD VARCHAR(50) DEFAULT NULL,
	MATCH_OUTSYS_FIELD SMALLINT DEFAULT '1',
	MATCH_OUTSYS_CUSTOMFIELD VARCHAR(50) DEFAULT NULL,
	OUTSYS_ID VARCHAR(32) DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	ISOPEN_ERRORLOG_WARN SMALLINT DEFAULT '0',
	ERRORLOG_AGENTID VARCHAR(32) DEFAULT NULL,
	ERRORLOG_RECEVER_IDS VARCHAR(256) DEFAULT NULL,
	IS_ORG_CONTAIN_CHILD SMALLINT DEFAULT '1',
	IS_USER_CONTAIN_CHILD SMALLINT DEFAULT '1',
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_CP_USER_SYNC_SET IS '企业号通讯录成员同步设置表'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.ID IS '主键ID'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.SYS_TASK_ID IS '定时同步任务ID'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.CP_CORP_ID IS '企业号基本信息ID'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.SYNC_TYPE IS '同步类型：1-从企业号同步 ，2-从集成系统同步'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.IS_SYNC_AVATAR IS '从企业号同步时，如果为钉钉同步，是否将钉钉关联人员头像同步到oa，默认为0-否'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.OPEN_DEPT_ID IS '从企业号同步时对应的部门ID，当sync_type为1时需要此值，不设置则为企业号获取到的顶级部门'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.BIND_TYPE IS '新成员关联集成系统用户类型：0-不关联，1-自动关联 ，2-手动关联，3-先自动后手动，当sync_type为1时需要此值'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.ROOT_DEPT_ID IS '集成系统部门对应的顶级部门ID，即em_cp_dept表主键ID，当sync_type为2时需要此值'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.ADD_TYPE IS '新成员是否添加到企业号：1-是 ，0-否，当sync_type为2时需要此值'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.INVITE_TYPE IS '新成员是否邀请加入，主要针对企业微信：1-是 ，0-否，当sync_type为2时需要此值'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.USERID_FIELD IS '新成员账号字段：1-数据库ID ，2-登录账号，3-手机号，当sync_type为2时需要此值'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.USER_DEL_TYPE IS '离职成员的处理方式：1-禁用 ，2-删除，当sync_type为2时需要此值'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.IS_DISABLEDUSER_TO_DEPT IS '禁用成员是否移动到统一部门：0-否 ，1-是，当sync_type为2时需要此值'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.IS_SYNC_MULTIDEPT IS '成员所在部门是否包含次账号部门：0-否 ，1-是，当sync_type为2时需要此值'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.IS_COVER_CPDEPT IS '成员所在部门是否完全以EC为准：0-否 ，1-是，当sync_type为2时需要此值'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.DEPT_SYNC_TYPE IS '部门同步方式：1-同步部门 2-不同步部门且将人员移动到顶级部门下 3-不同步部门且人员部门信息不变，当sync_type为2时需要此值'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.ISALLUSER IS '是否同步无账号人员：0-否 ，1-是，当sync_type为2时需要此值'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.ISEXTERNAL IS '是否同步外部用户，0-否，1-是'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.MATCH_USER_FIELD IS '已存在成员本系统的匹配字段：1-账号 ，2-手机号，3-邮箱，4-工号，100-自定义字段'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.MATCH_USER_CUSTOMFIELD IS '已存在成员本系统的匹配自定义字段'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.MATCH_OUTSYS_FIELD IS '已存在成员集成系统的匹配字段：1-数据库ID ，2-登录账号，3-手机，4-邮箱，5-工号'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.MATCH_OUTSYS_CUSTOMFIELD IS '自定义OA匹配字段'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.OUTSYS_ID IS '集成系统ID'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.TENANT_ID IS '企业租户ID'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.ISOPEN_ERRORLOG_WARN IS '是否开启错误日志提醒功能'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.ERRORLOG_AGENTID IS '日志提醒应用id'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.ERRORLOG_RECEVER_IDS IS '日志提醒接受人ids'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.IS_ORG_CONTAIN_CHILD IS '同步范围设置，是否包含子部门'
;

COMMENT ON COLUMN EM_CP_USER_SYNC_SET.IS_USER_CONTAIN_CHILD IS '同步范围设置，人员范围，是否包含子部门'
;


CREATE TABLE EM_CP_DOMAIN_FILE (
	ID VARCHAR(32) NOT NULL,
	CP_CORP_ID VARCHAR(32) NOT NULL,
	MEDIA_ID VARCHAR(50) NOT NULL,
	FILE_NAME VARCHAR(2000) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_CP_DOMAIN_FILE IS '可信域名文件上传记录'
;

COMMENT ON COLUMN EM_CP_DOMAIN_FILE.ID IS '主键ID'
;

COMMENT ON COLUMN EM_CP_DOMAIN_FILE.CP_CORP_ID IS '文件所属企业号id'
;

COMMENT ON COLUMN EM_CP_DOMAIN_FILE.MEDIA_ID IS '文件id'
;

COMMENT ON COLUMN EM_CP_DOMAIN_FILE.FILE_NAME IS '文件名称'
;

COMMENT ON COLUMN EM_CP_DOMAIN_FILE.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_CP_DOMAIN_FILE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_DOMAIN_FILE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_DOMAIN_FILE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_DOMAIN_FILE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_DOMAIN_FILE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_BASEUSER_ATTEND (
	ID VARCHAR(32) NOT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	ATTEND_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_SYS_BASEUSER_ATTEND IS '关注人'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_ATTEND.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_ATTEND.BASE_USER_ID IS '人员基础用户ID'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_ATTEND.ATTEND_USER_ID IS '关注人员的基础用户ID'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_ATTEND.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_ATTEND.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_ATTEND.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_ATTEND.UPDATE_TIME IS '修改时间'
;


CREATE TABLE EM_AGENT_VIEW (
	ID VARCHAR(32) NOT NULL,
	AGENT_BASE_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_TYPE SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_AGENT_VIEW IS '企业应用可见范围设置表'
;

COMMENT ON COLUMN EM_AGENT_VIEW.ID IS '主键ID'
;

COMMENT ON COLUMN EM_AGENT_VIEW.AGENT_BASE_ID IS '应用ID'
;

COMMENT ON COLUMN EM_AGENT_VIEW.HRM_DATA_ID IS '通讯录成员或部门表ID'
;

COMMENT ON COLUMN EM_AGENT_VIEW.HRM_DATA_TYPE IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;

COMMENT ON COLUMN EM_AGENT_VIEW.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_AGENT_VIEW.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_AGENT_VIEW.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_AGENT_VIEW.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_AGENT_VIEW.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_AGENT_VIEW.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_GROUP_NUMBER_RIGHT (
	ID VARCHAR(32) NOT NULL,
	RIGHT_GROUP_NUMBER_NAME VARCHAR(32) DEFAULT NULL,
	PRIORITY INT DEFAULT NULL,
	RIGHT_GROUP_NUMBER_LIMIT INT DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_GROUP_NUMBER_RIGHT IS '群成员人数上限规则表'
;

COMMENT ON COLUMN EM_SYS_GROUP_NUMBER_RIGHT.ID IS '主键id'
;

COMMENT ON COLUMN EM_SYS_GROUP_NUMBER_RIGHT.RIGHT_GROUP_NUMBER_NAME IS '群成员人数上限规则名称'
;

COMMENT ON COLUMN EM_SYS_GROUP_NUMBER_RIGHT.PRIORITY IS '群成员人数上限规则优先级'
;

COMMENT ON COLUMN EM_SYS_GROUP_NUMBER_RIGHT.RIGHT_GROUP_NUMBER_LIMIT IS '群成员人数上限'
;

COMMENT ON COLUMN EM_SYS_GROUP_NUMBER_RIGHT.STATUS IS '状态 1-正常 2-禁用 3-删除'
;

COMMENT ON COLUMN EM_SYS_GROUP_NUMBER_RIGHT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_GROUP_NUMBER_RIGHT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_GROUP_NUMBER_RIGHT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_GROUP_NUMBER_RIGHT.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_GROUP_NUMBER_RIGHT.TENANT_ID IS '企业租户id'
;


CREATE TABLE EM_CP_MSG_ALL (
	ID VARCHAR(32) NOT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	CP_AGENT_ID VARCHAR(32) DEFAULT NULL,
	RELATE_AGENT_ID VARCHAR(32) DEFAULT NULL,
	MSG_JSON TEXT,
	MSG_DATA_ID VARCHAR(50) DEFAULT NULL,
	MSG_DATA_TYPE VARCHAR(20) DEFAULT NULL,
	LINK_URL VARCHAR(500) DEFAULT NULL,
	LINK_URL_PC VARCHAR(500) DEFAULT NULL,
	IM_MSG_ID TEXT,
	TOUSERS TEXT,
	SENDE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_CP_MSG_ALL IS '企业号推送消息所有数据表'
;

COMMENT ON COLUMN EM_CP_MSG_ALL.ID IS '主键ID'
;

COMMENT ON COLUMN EM_CP_MSG_ALL.CP_CORP_ID IS '所属企业号ID'
;

COMMENT ON COLUMN EM_CP_MSG_ALL.CP_AGENT_ID IS '所属企业号应用ID'
;

COMMENT ON COLUMN EM_CP_MSG_ALL.RELATE_AGENT_ID IS '关联的本地消息型应用ID'
;

COMMENT ON COLUMN EM_CP_MSG_ALL.MSG_JSON IS '消息内容'
;

COMMENT ON COLUMN EM_CP_MSG_ALL.MSG_DATA_ID IS '消息数据ID'
;

COMMENT ON COLUMN EM_CP_MSG_ALL.MSG_DATA_TYPE IS '消息数据类型'
;

COMMENT ON COLUMN EM_CP_MSG_ALL.LINK_URL IS '链接地址'
;

COMMENT ON COLUMN EM_CP_MSG_ALL.LINK_URL_PC IS 'PC端链接地址'
;

COMMENT ON COLUMN EM_CP_MSG_ALL.IM_MSG_ID IS 'IM返回的消息ID'
;

COMMENT ON COLUMN EM_CP_MSG_ALL.TOUSERS IS '消息接收者'
;

COMMENT ON COLUMN EM_CP_MSG_ALL.SENDE_TIME IS '发送时间'
;

COMMENT ON COLUMN EM_CP_MSG_ALL.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_CP_MSG_ALL.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_MSG_ALL.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_MSG_ALL.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_MSG_ALL.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_MSG_ALL.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_EHCACHE_CLUSTER_SETTING (
	ID VARCHAR(32) NOT NULL,
	ENABLED SMALLINT DEFAULT NULL,
	MULTICASTGROUPADDRESS VARCHAR(255) DEFAULT NULL,
	MULTICASTGROUPPORT INT DEFAULT NULL,
	TIMETOLIVE INT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_EHCACHE_CLUSTER_SETTING IS '缓存集群设置表'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_SETTING.ID IS '主键'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_SETTING.ENABLED IS '是否启用集群'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_SETTING.MULTICASTGROUPADDRESS IS '缓存集群使用的组播IP'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_SETTING.MULTICASTGROUPPORT IS '缓存集群使用的端口'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_SETTING.TIMETOLIVE IS '缓存组播范围'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_SETTING.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_SETTING.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_SETTING.UPDATE_USER_ID IS '最后修改人'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_SETTING.UPDATE_TIME IS '最后修改时间'
;


CREATE TABLE EM_SYS_COUNTRY_MOBILE_PREFIX (
	ID SERIAL NOT NULL,
	COUNTRY VARCHAR(255) DEFAULT NULL,
	MOBILE_PREFIX VARCHAR(255) DEFAULT NULL,
	AREA VARCHAR(255) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_COUNTRY_MOBILE_PREFIX IS '国际电话号码区号'
;

COMMENT ON COLUMN EM_SYS_COUNTRY_MOBILE_PREFIX.COUNTRY IS '国家名称'
;

COMMENT ON COLUMN EM_SYS_COUNTRY_MOBILE_PREFIX.MOBILE_PREFIX IS '区号'
;

COMMENT ON COLUMN EM_SYS_COUNTRY_MOBILE_PREFIX.AREA IS '所在的洲'
;


CREATE TABLE EM_CP_TAG_USER (
	ID VARCHAR(32) NOT NULL,
	CP_TAG_ID VARCHAR(32) DEFAULT NULL,
	CP_USER_ID VARCHAR(32) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_CP_TAG_USER IS '企业号通讯录标签与成员关联表'
;

COMMENT ON COLUMN EM_CP_TAG_USER.ID IS '主键'
;

COMMENT ON COLUMN EM_CP_TAG_USER.CP_TAG_ID IS '通讯录标签表ID'
;

COMMENT ON COLUMN EM_CP_TAG_USER.CP_USER_ID IS '通讯录人员表ID'
;

COMMENT ON COLUMN EM_CP_TAG_USER.STATUS IS '状态 1-正常，2-禁用，3-删除'
;

COMMENT ON COLUMN EM_CP_TAG_USER.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_TAG_USER.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_TAG_USER.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_TAG_USER.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_TAG_USER.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_EHCACHE_CLUSTER_NODE (
	ID VARCHAR(32) NOT NULL,
	NODE_ID VARCHAR(191) DEFAULT NULL,
	NODE_NAME VARCHAR(255) DEFAULT NULL,
	COMPUTER_NAME VARCHAR(255) DEFAULT NULL,
	LOCAL_IPS VARCHAR(255) DEFAULT NULL,
	IP_FOR_CLUSTER VARCHAR(255) DEFAULT NULL,
	OS_NAME VARCHAR(255) DEFAULT NULL,
	LAST_START_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	PORT INT DEFAULT NULL,
	REMOTE_OBJECT_PORT INT DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_EHCACHE_CLUSTER_NODE IS '缓存集群节点表'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_NODE.ID IS '主键'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_NODE.NODE_ID IS '节点id'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_NODE.NODE_NAME IS '节点名称'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_NODE.COMPUTER_NAME IS '计算机名称'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_NODE.LOCAL_IPS IS '本机所有ip地址'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_NODE.IP_FOR_CLUSTER IS '缓存集群使用的ip'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_NODE.OS_NAME IS '操作系统'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_NODE.LAST_START_TIME IS '最后启动时间'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_NODE.PORT IS '注册端口'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_NODE.REMOTE_OBJECT_PORT IS '服务端口'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_NODE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_NODE.UPDATE_USER_ID IS '最后修改人'
;

COMMENT ON COLUMN EM_EHCACHE_CLUSTER_NODE.UPDATE_TIME IS '最后修改时间'
;


CREATE TABLE EM_LOG_CLIENT_REPORT (
	ID VARCHAR(32) NOT NULL,
	BASE_USER_ID VARCHAR(32) NOT NULL,
	BASE_USER_NAME VARCHAR(32) DEFAULT NULL,
	CLIENT_TYPE SMALLINT DEFAULT NULL,
	CLIENT_VERSION VARCHAR(50) DEFAULT NULL,
	DEVICE_ID VARCHAR(200) DEFAULT NULL,
	CLIENT_MODEL VARCHAR(200) DEFAULT NULL,
	OS_VERSION VARCHAR(200) DEFAULT NULL,
	LOG_FILE_ID VARCHAR(32) DEFAULT NULL,
	IP VARCHAR(200) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_LOG_CLIENT_REPORT IS '客户端上报日志记录表'
;

COMMENT ON COLUMN EM_LOG_CLIENT_REPORT.ID IS '主键'
;

COMMENT ON COLUMN EM_LOG_CLIENT_REPORT.BASE_USER_ID IS '用户ID'
;

COMMENT ON COLUMN EM_LOG_CLIENT_REPORT.BASE_USER_NAME IS '用户名'
;

COMMENT ON COLUMN EM_LOG_CLIENT_REPORT.CLIENT_TYPE IS '客户端类型： 1-PC客户端，2-IOS客户端，3-安卓客户端'
;

COMMENT ON COLUMN EM_LOG_CLIENT_REPORT.CLIENT_VERSION IS '客户端版本号'
;

COMMENT ON COLUMN EM_LOG_CLIENT_REPORT.DEVICE_ID IS '客户端硬件标识'
;

COMMENT ON COLUMN EM_LOG_CLIENT_REPORT.CLIENT_MODEL IS '客户端设备型号'
;

COMMENT ON COLUMN EM_LOG_CLIENT_REPORT.OS_VERSION IS '客户端操作系统版本'
;

COMMENT ON COLUMN EM_LOG_CLIENT_REPORT.LOG_FILE_ID IS '日志文件ID'
;

COMMENT ON COLUMN EM_LOG_CLIENT_REPORT.IP IS '客户端IP地址'
;

COMMENT ON COLUMN EM_LOG_CLIENT_REPORT.CREATE_TIME IS '上报时间'
;

COMMENT ON COLUMN EM_LOG_CLIENT_REPORT.TENANT_ID IS '租户ID'
;


CREATE TABLE EM_SYS_URL_MAPPING (
	ID VARCHAR(32) NOT NULL,
	URL_TYPE SMALLINT DEFAULT NULL,
	OUTSYS_ID VARCHAR(32) DEFAULT NULL,
	REQUEST_TYPE SMALLINT DEFAULT NULL,
	REQUEST_PARAM VARCHAR(1000) DEFAULT NULL,
	MAPPING_URL VARCHAR(100) DEFAULT NULL,
	MAPPING_HOST VARCHAR(100) DEFAULT NULL,
	MAPPING_PORT VARCHAR(100) DEFAULT NULL,
	MAPPING_ENCRYPT SMALLINT DEFAULT NULL,
	PRIORITY INT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_URL_MAPPING IS '系统访问地址映射关系表'
;

COMMENT ON COLUMN EM_SYS_URL_MAPPING.URL_TYPE IS '地址类型：1-EC、2-APP消息、3-PC消息'
;

COMMENT ON COLUMN EM_SYS_URL_MAPPING.OUTSYS_ID IS '当url_type为1时，表示对应的ecology系统id'
;

COMMENT ON COLUMN EM_SYS_URL_MAPPING.REQUEST_TYPE IS '请求判断类型：1-根据EM访问地址判断、2-根据客户端IP判断'
;

COMMENT ON COLUMN EM_SYS_URL_MAPPING.REQUEST_PARAM IS '请求参数，当request_type为1时表示请求的EM地址，当request_type为2时表示客户端的IP，多个IP用分号隔开'
;

COMMENT ON COLUMN EM_SYS_URL_MAPPING.MAPPING_URL IS '映射的EC系统访问地址'
;

COMMENT ON COLUMN EM_SYS_URL_MAPPING.MAPPING_HOST IS '映射的消息服务地址'
;

COMMENT ON COLUMN EM_SYS_URL_MAPPING.MAPPING_PORT IS '映射的消息服务端口号'
;

COMMENT ON COLUMN EM_SYS_URL_MAPPING.MAPPING_ENCRYPT IS '映射的消息服务连接是否加密'
;

COMMENT ON COLUMN EM_SYS_URL_MAPPING.PRIORITY IS '优先级，数值越大优先级越高'
;

COMMENT ON COLUMN EM_SYS_URL_MAPPING.STATUS IS '状态'
;

COMMENT ON COLUMN EM_SYS_URL_MAPPING.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_URL_MAPPING.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_URL_MAPPING.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_URL_MAPPING.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_URL_MAPPING.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_LINK (
	ID VARCHAR(32) NOT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	CP_AGENT_ID VARCHAR(32) DEFAULT NULL,
	LINK_NAME VARCHAR(50) DEFAULT NULL,
	LINK_DESC VARCHAR(500) DEFAULT NULL,
	LINK_TYPE SMALLINT DEFAULT NULL,
	LINK_MENU_KEY VARCHAR(50) DEFAULT NULL,
	LINK_MENU_PID VARCHAR(32) DEFAULT NULL,
	LINK_ACTION_TYPE SMALLINT DEFAULT NULL,
	LINK_ACTION_SETTING VARCHAR(500) DEFAULT NULL,
	SHOWORDER INT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_CP_LINK IS '企业号链接功能信息表'
;

COMMENT ON COLUMN EM_CP_LINK.ID IS '主键ID'
;

COMMENT ON COLUMN EM_CP_LINK.CP_CORP_ID IS '所属企业号ID'
;

COMMENT ON COLUMN EM_CP_LINK.CP_AGENT_ID IS '所属企业号应用ID'
;

COMMENT ON COLUMN EM_CP_LINK.LINK_NAME IS '链接名称'
;

COMMENT ON COLUMN EM_CP_LINK.LINK_DESC IS '链接描述信息'
;

COMMENT ON COLUMN EM_CP_LINK.LINK_TYPE IS '链接类型： 1-应用主页，2-应用菜单，3-普通链接'
;

COMMENT ON COLUMN EM_CP_LINK.LINK_MENU_KEY IS 'link_type为2时对应的菜单key值'
;

COMMENT ON COLUMN EM_CP_LINK.LINK_MENU_PID IS 'link_type为2时对应的菜单的上级ID'
;

COMMENT ON COLUMN EM_CP_LINK.LINK_ACTION_TYPE IS '链接动作类型： 1-打开门户，2-打开应用，3-自定义链接'
;

COMMENT ON COLUMN EM_CP_LINK.LINK_ACTION_SETTING IS '链接动作参数值，link_action_type为1时表示门户ID，link_action_type为2时表示应用ID，link_action_type为3时表示自定义链接地址'
;

COMMENT ON COLUMN EM_CP_LINK.SHOWORDER IS '显示顺序'
;

COMMENT ON COLUMN EM_CP_LINK.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_CP_LINK.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_LINK.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_LINK.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_LINK.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_LINK.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_TENANT_ADMIN (
	ID VARCHAR(32) NOT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	ADMIN_TYPE SMALLINT DEFAULT NULL,
	AGENT_BASE_ID VARCHAR(32) DEFAULT NULL,
	ADMIN_PASSWORD VARCHAR(100) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_SYS_TENANT_ADMIN IS '基础用户租户管理关联表'
;

COMMENT ON COLUMN EM_SYS_TENANT_ADMIN.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SYS_TENANT_ADMIN.BASE_USER_ID IS '基础用户ID'
;

COMMENT ON COLUMN EM_SYS_TENANT_ADMIN.TENANT_ID IS '企业租户ID'
;

COMMENT ON COLUMN EM_SYS_TENANT_ADMIN.ADMIN_TYPE IS '管理员类型：1-创建人，2-超级管理员，3-分级管理员，4-外部管理员，5-应用管理员，6-接口管理员'
;

COMMENT ON COLUMN EM_SYS_TENANT_ADMIN.AGENT_BASE_ID IS '应用管理对应的应用ID'
;

COMMENT ON COLUMN EM_SYS_TENANT_ADMIN.ADMIN_PASSWORD IS '管理密码'
;

COMMENT ON COLUMN EM_SYS_TENANT_ADMIN.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_SYS_TENANT_ADMIN.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_TENANT_ADMIN.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_TENANT_ADMIN.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_TENANT_ADMIN.UPDATE_TIME IS '修改时间'
;


CREATE TABLE EM_HRM_GROUP_VIEW (
	ID VARCHAR(32) NOT NULL,
	HRM_GROUP_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_TYPE SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_HRM_GROUP_VIEW IS '企业应用可见范围设置表'
;

COMMENT ON COLUMN EM_HRM_GROUP_VIEW.ID IS '主键ID'
;

COMMENT ON COLUMN EM_HRM_GROUP_VIEW.HRM_GROUP_ID IS '组ID'
;

COMMENT ON COLUMN EM_HRM_GROUP_VIEW.HRM_DATA_ID IS '通讯录成员或部门表ID'
;

COMMENT ON COLUMN EM_HRM_GROUP_VIEW.HRM_DATA_TYPE IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;

COMMENT ON COLUMN EM_HRM_GROUP_VIEW.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_HRM_GROUP_VIEW.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_HRM_GROUP_VIEW.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_HRM_GROUP_VIEW.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_HRM_GROUP_VIEW.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_HRM_GROUP_VIEW.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_OTP_USERINFO (
	ID VARCHAR(32) NOT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	USER_DOMAIN VARCHAR(255) DEFAULT NULL,
	SERIAL_NO VARCHAR(255) DEFAULT NULL,
	ACTIVE_CODE VARCHAR(255) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_OTP_USERINFO IS 'OTP用户信息'
;

COMMENT ON COLUMN EM_OTP_USERINFO.ID IS '主键'
;

COMMENT ON COLUMN EM_OTP_USERINFO.BASE_USER_ID IS '用户ID'
;

COMMENT ON COLUMN EM_OTP_USERINFO.USER_DOMAIN IS '用户域'
;

COMMENT ON COLUMN EM_OTP_USERINFO.SERIAL_NO IS '序列号'
;

COMMENT ON COLUMN EM_OTP_USERINFO.ACTIVE_CODE IS '激活码'
;

COMMENT ON COLUMN EM_OTP_USERINFO.STATUS IS '状态'
;

COMMENT ON COLUMN EM_OTP_USERINFO.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_OTP_USERINFO.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_OTP_USERINFO.UPDATE_USER_ID IS '最后修改人'
;

COMMENT ON COLUMN EM_OTP_USERINFO.UPDATE_TIME IS '最后修改时间'
;

COMMENT ON COLUMN EM_OTP_USERINFO.TENANT_ID IS '租户ID'
;


CREATE TABLE EM_SYS_LANG_BASE (
	ID VARCHAR(32) NOT NULL,
	LANG_NAME VARCHAR(10) DEFAULT NULL,
	LANG_TAG VARCHAR(10) DEFAULT NULL,
	ISDEFAULT SMALLINT DEFAULT NULL,
	SHOW_ORDER DECIMAL(10, 2) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_LANG_BASE IS '系统多语言设置'
;

COMMENT ON COLUMN EM_SYS_LANG_BASE.LANG_NAME IS '语言名称'
;

COMMENT ON COLUMN EM_SYS_LANG_BASE.LANG_TAG IS '语言标识：zh-汉语(简体)，zh_TW-汉语(繁体)，en-英语，ja-日语，ko-韩语，vi-越南语'
;

COMMENT ON COLUMN EM_SYS_LANG_BASE.ISDEFAULT IS '是否默认：1-是、0-否'
;

COMMENT ON COLUMN EM_SYS_LANG_BASE.SHOW_ORDER IS '显示顺序'
;

COMMENT ON COLUMN EM_SYS_LANG_BASE.STATUS IS '状态：1-正常、2-禁用、3-删除'
;

COMMENT ON COLUMN EM_SYS_LANG_BASE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_LANG_BASE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_LANG_BASE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_LANG_BASE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_LANG_BASE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_VIDEO_CHAT_CALL_ATTEND (
	ID VARCHAR(32) NOT NULL,
	CHAT_CALL_ID VARCHAR(32) DEFAULT NULL,
	ATTEND_MEMBER_ID VARCHAR(32) DEFAULT NULL,
	ATTEND_TYPE SMALLINT DEFAULT NULL,
	ATTEND_TARGET_IDS TEXT,
	ATTEND_TIME BIGINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_VIDEO_CHAT_CALL_ATTEND IS '音视频会话通话记录参与明细表'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL_ATTEND.ID IS '主键ID'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL_ATTEND.CHAT_CALL_ID IS '会话通话记录表ID'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL_ATTEND.ATTEND_MEMBER_ID IS '通话参与人ID，对应em_sys_base_user表的主键'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL_ATTEND.ATTEND_TYPE IS '参与类型 1-发起，2-加入，3-退出，4-踢出'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL_ATTEND.ATTEND_TARGET_IDS IS '会话记录目标成员ID逗号分隔'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL_ATTEND.ATTEND_TIME IS '参与时间'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL_ATTEND.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL_ATTEND.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL_ATTEND.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL_ATTEND.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL_ATTEND.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_VIDEO_CHAT_CALL_ATTEND.TENANT_ID IS '企业租户ID'
;


CREATE TABLE QRTZ_TRIGGERS (
	SCHED_NAME VARCHAR(120) NOT NULL,
	TRIGGER_NAME VARCHAR(190) NOT NULL,
	TRIGGER_GROUP VARCHAR(190) NOT NULL,
	JOB_NAME VARCHAR(190) NOT NULL,
	JOB_GROUP VARCHAR(190) NOT NULL,
	DESCRIPTION VARCHAR(250) DEFAULT NULL,
	NEXT_FIRE_TIME BIGINT DEFAULT NULL,
	PREV_FIRE_TIME BIGINT DEFAULT NULL,
	PRIORITY INT DEFAULT NULL,
	TRIGGER_STATE VARCHAR(16) NOT NULL,
	TRIGGER_TYPE VARCHAR(8) NOT NULL,
	START_TIME BIGINT NOT NULL,
	END_TIME BIGINT DEFAULT NULL,
	CALENDAR_NAME VARCHAR(190) DEFAULT NULL,
	MISFIRE_INSTR SMALLINT DEFAULT NULL,
	JOB_DATA BYTEA,
	PRIMARY KEY (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
)
;





CREATE TABLE EM_SC_PORTAL_USERACCESS (
	ID VARCHAR(32) NOT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	PORTAL_BASE_ID VARCHAR(32) DEFAULT NULL,
	ELEMENT_ID VARCHAR(32) DEFAULT NULL,
	IP VARCHAR(255) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;
COMMENT ON TABLE EM_SC_PORTAL_USERACCESS IS '企业客户端门户用户元素访问记录'
;

COMMENT ON COLUMN EM_SC_PORTAL_USERACCESS.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SC_PORTAL_USERACCESS.BASE_USER_ID IS '基础用户ID'
;

COMMENT ON COLUMN EM_SC_PORTAL_USERACCESS.PORTAL_BASE_ID IS '门户ID'
;

COMMENT ON COLUMN EM_SC_PORTAL_USERACCESS.ELEMENT_ID IS '元素ID'
;

COMMENT ON COLUMN EM_SC_PORTAL_USERACCESS.IP IS 'IP地址'
;

COMMENT ON COLUMN EM_SC_PORTAL_USERACCESS.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SC_PORTAL_USERACCESS.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_VERIFY_TOKEN (
	VERIFY_TOKEN VARCHAR(100) NOT NULL,
	EXPIRE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (VERIFY_TOKEN)
)
;

COMMENT ON TABLE EM_SYS_VERIFY_TOKEN IS '外部系统访问验证token数据表'
;

COMMENT ON COLUMN EM_SYS_VERIFY_TOKEN.VERIFY_TOKEN IS '验证的token值'
;

COMMENT ON COLUMN EM_SYS_VERIFY_TOKEN.EXPIRE_TIME IS '过期时间'
;

COMMENT ON COLUMN EM_SYS_VERIFY_TOKEN.STATUS IS '状态 1-正常，2-无效，3-删除'
;

COMMENT ON COLUMN EM_SYS_VERIFY_TOKEN.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_VERIFY_TOKEN.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_HRM_DEPT_TEMP (
	ID VARCHAR(32) NOT NULL,
	OUTSYS_ID VARCHAR(32) DEFAULT NULL,
	DEPT_NAME VARCHAR(100) DEFAULT NULL,
	OUTSYS_DEPT_ID VARCHAR(32) DEFAULT NULL,
	OUTSYS_DEPT_PID VARCHAR(32) DEFAULT NULL,
	OUTSYS_DEPT_PID2 VARCHAR(32) DEFAULT NULL,
	OUTSYS_DEPT_TYPE SMALLINT DEFAULT NULL,
	SHOWORDER INT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_HRM_DEPT_TEMP IS '通讯录与Ecology系统同步部门临时表'
;

COMMENT ON COLUMN EM_HRM_DEPT_TEMP.ID IS '主键ID'
;

COMMENT ON COLUMN EM_HRM_DEPT_TEMP.OUTSYS_ID IS '对应的Ecology系统ID'
;

COMMENT ON COLUMN EM_HRM_DEPT_TEMP.DEPT_NAME IS 'Ecology系统中部门名称'
;

COMMENT ON COLUMN EM_HRM_DEPT_TEMP.OUTSYS_DEPT_ID IS 'Ecology系统中部门ID'
;

COMMENT ON COLUMN EM_HRM_DEPT_TEMP.OUTSYS_DEPT_PID IS 'Ecology系统中部门的上级部门ID'
;

COMMENT ON COLUMN EM_HRM_DEPT_TEMP.OUTSYS_DEPT_PID2 IS 'Ecology系统中部门的上级分部ID'
;

COMMENT ON COLUMN EM_HRM_DEPT_TEMP.OUTSYS_DEPT_TYPE IS 'Ecology系统中部门的类型 1表示分部 2表示部门'
;

COMMENT ON COLUMN EM_HRM_DEPT_TEMP.SHOWORDER IS 'Ecology系统中部门的显示顺序'
;

COMMENT ON COLUMN EM_HRM_DEPT_TEMP.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_HRM_DEPT_TEMP.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_HRM_DEPT_TEMP.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_HRM_DEPT_TEMP.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_HRM_DEPT_TEMP.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_HRM_USER_SYNC_STATE (
	ID VARCHAR(32) NOT NULL,
	SYNC_STATE SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_HRM_USER_SYNC_STATE IS '通讯录成员与集成系统人员同步状态表'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_STATE.ID IS '主键ID'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_STATE.SYNC_STATE IS '同步状态：1-未同步，2-同步中'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_STATE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_STATE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_STATE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_STATE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_HRM_USER_SYNC_STATE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SC_WORKBENCH (
	ID VARCHAR(32) NOT NULL,
	CLIENT_TYPE SMALLINT DEFAULT NULL,
	SET_TYPE SMALLINT DEFAULT NULL,
	SET_VALUE VARCHAR(200) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_SC_WORKBENCH IS '企业客户端工作台设置表'
;

COMMENT ON COLUMN EM_SC_WORKBENCH.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SC_WORKBENCH.CLIENT_TYPE IS '客户端类型 1-移动APP，2-PC客户端，3-web客户端'
;

COMMENT ON COLUMN EM_SC_WORKBENCH.SET_TYPE IS '设置类型：1-默认门户，2-指定门户，2-自定义链接'
;

COMMENT ON COLUMN EM_SC_WORKBENCH.SET_VALUE IS '设置数据，针对门户对应门户的主键ID，针对自定义链接则为对应的链接地址'
;

COMMENT ON COLUMN EM_SC_WORKBENCH.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_SC_WORKBENCH.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SC_WORKBENCH.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SC_WORKBENCH.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SC_WORKBENCH.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SC_WORKBENCH.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_LICENSE (
	ID VARCHAR(32) NOT NULL,
	CUSTOM_ID VARCHAR(32) DEFAULT NULL,
	COMPANY_NAME VARCHAR(255) DEFAULT NULL,
	COMPANY_NAME_ZH_CN VARCHAR(255) DEFAULT NULL,
	IDENTIFICATION_NUMBER VARCHAR(33) DEFAULT NULL,
	TEMPORARY SMALLINT DEFAULT NULL,
	ETERNAL SMALLINT DEFAULT NULL,
	EXPIRE_DATE TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	USER_COUNT INT DEFAULT NULL,
	EM_COUNT INT DEFAULT NULL,
	EM_USER_COUNT INT DEFAULT NULL,
	EM_USER_COUNT_TYPE SMALLINT DEFAULT NULL,
	EM_EXPIRE_DATE TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	EM_PC_USER_COUNT INT DEFAULT NULL,
	EM_PC_USER_COUNT_TYPE SMALLINT DEFAULT NULL,
	EM_PC_EXPIRE_DATE TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	CP_COUNT INT DEFAULT NULL,
	CP_USER_COUNT INT DEFAULT NULL,
	CP_USER_COUNT_TYPE SMALLINT DEFAULT NULL,
	CP_EXPIRE_DATE TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	MP_COUNT INT DEFAULT NULL,
	MP_USER_COUNT INT DEFAULT NULL,
	MP_USER_COUNT_TYPE SMALLINT DEFAULT NULL,
	MP_EXPIRE_DATE TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	DD_COUNT INT DEFAULT NULL,
	DD_USER_COUNT INT DEFAULT NULL,
	DD_USER_COUNT_TYPE SMALLINT DEFAULT NULL,
	DD_EXPIRE_DATE TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	LX_COUNT INT DEFAULT NULL,
	LX_USER_COUNT INT DEFAULT NULL,
	LX_USER_COUNT_TYPE SMALLINT DEFAULT NULL,
	LX_EXPIRE_DATE TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	GZB_COUNT INT DEFAULT NULL,
	GZB_USER_COUNT INT DEFAULT NULL,
	GZB_USER_COUNT_TYPE SMALLINT DEFAULT NULL,
	GZB_EXPIRE_DATE TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	JDYZJ_COUNT INT DEFAULT NULL,
	JDYZJ_USER_COUNT INT DEFAULT NULL,
	JDYZJ_USER_COUNT_TYPE SMALLINT DEFAULT NULL,
	JDYZJ_EXPIRE_DATE TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	HFX_COUNT INT DEFAULT NULL,
	HFX_USER_COUNT INT DEFAULT NULL,
	HFX_USER_COUNT_TYPE SMALLINT DEFAULT NULL,
	HFX_EXPIRE_DATE TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	FXXK_COUNT INT DEFAULT NULL,
	FXXK_USER_COUNT INT DEFAULT NULL,
	FXXK_USER_COUNT_TYPE SMALLINT DEFAULT NULL,
	FXXK_EXPIRE_DATE TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	WL_COUNT INT DEFAULT NULL,
	WL_USER_COUNT INT DEFAULT NULL,
	WL_USER_COUNT_TYPE SMALLINT DEFAULT NULL,
	WL_EXPIRE_DATE TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	SALARY_COUNT INT DEFAULT NULL,
	STATUS VARCHAR(255) DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_LICENSE IS '服务端License信息表'
;

COMMENT ON COLUMN EM_LICENSE.ID IS '主键'
;

COMMENT ON COLUMN EM_LICENSE.CUSTOM_ID IS '客户ID'
;

COMMENT ON COLUMN EM_LICENSE.COMPANY_NAME IS '公司名称'
;

COMMENT ON COLUMN EM_LICENSE.COMPANY_NAME_ZH_CN IS '公司名称（中文）'
;

COMMENT ON COLUMN EM_LICENSE.IDENTIFICATION_NUMBER IS '识别码'
;

COMMENT ON COLUMN EM_LICENSE.TEMPORARY IS '是否为临时license：0-否、1-是'
;

COMMENT ON COLUMN EM_LICENSE.ETERNAL IS '是否永久有效：0-否、1-是'
;

COMMENT ON COLUMN EM_LICENSE.EXPIRE_DATE IS '过期时间'
;

COMMENT ON COLUMN EM_LICENSE.USER_COUNT IS '用户数量'
;

COMMENT ON COLUMN EM_LICENSE.EM_COUNT IS 'emobile集成数量'
;

COMMENT ON COLUMN EM_LICENSE.EM_USER_COUNT IS 'emobile移动端用户数量'
;

COMMENT ON COLUMN EM_LICENSE.EM_USER_COUNT_TYPE IS 'emobile移动端用户数类型，1-并发、2-注册，默认并发'
;

COMMENT ON COLUMN EM_LICENSE.EM_EXPIRE_DATE IS 'emobile移动端模块过期时间'
;

COMMENT ON COLUMN EM_LICENSE.EM_PC_USER_COUNT IS 'emobile pc端用户数量'
;

COMMENT ON COLUMN EM_LICENSE.EM_PC_USER_COUNT_TYPE IS 'emobile pc端用户数类型，1-并发、2-注册，默认并发'
;

COMMENT ON COLUMN EM_LICENSE.EM_PC_EXPIRE_DATE IS 'emobile pc端模块过期时间'
;

COMMENT ON COLUMN EM_LICENSE.CP_COUNT IS '企业号/企业微信集成数量'
;

COMMENT ON COLUMN EM_LICENSE.CP_USER_COUNT IS '企业号/企业微信用户数量'
;

COMMENT ON COLUMN EM_LICENSE.CP_USER_COUNT_TYPE IS '企业号/企业微信用户数类型，1-并发、2-注册，默认并发'
;

COMMENT ON COLUMN EM_LICENSE.CP_EXPIRE_DATE IS '企业号/企业微信模块过期时间'
;

COMMENT ON COLUMN EM_LICENSE.MP_COUNT IS '公众号集成数量'
;

COMMENT ON COLUMN EM_LICENSE.MP_USER_COUNT IS '公众号用户数量'
;

COMMENT ON COLUMN EM_LICENSE.MP_USER_COUNT_TYPE IS '公众号用户数类型，1-并发、2-注册，默认并发'
;

COMMENT ON COLUMN EM_LICENSE.MP_EXPIRE_DATE IS '公众号模块过期时间'
;

COMMENT ON COLUMN EM_LICENSE.DD_COUNT IS '钉钉集成数量'
;

COMMENT ON COLUMN EM_LICENSE.DD_USER_COUNT IS '钉钉用户数量'
;

COMMENT ON COLUMN EM_LICENSE.DD_USER_COUNT_TYPE IS '钉钉用户数类型，1-并发、2-注册，默认并发'
;

COMMENT ON COLUMN EM_LICENSE.DD_EXPIRE_DATE IS '钉钉模块过期时间'
;

COMMENT ON COLUMN EM_LICENSE.LX_COUNT IS '蓝信集成数量'
;

COMMENT ON COLUMN EM_LICENSE.LX_USER_COUNT IS '蓝信用户数量'
;

COMMENT ON COLUMN EM_LICENSE.LX_USER_COUNT_TYPE IS '蓝信用户数类型，1-并发、2-注册，默认并发'
;

COMMENT ON COLUMN EM_LICENSE.LX_EXPIRE_DATE IS '蓝信模块过期时间'
;

COMMENT ON COLUMN EM_LICENSE.GZB_COUNT IS '工作宝集成数量'
;

COMMENT ON COLUMN EM_LICENSE.GZB_USER_COUNT IS '工作宝用户数量'
;

COMMENT ON COLUMN EM_LICENSE.GZB_USER_COUNT_TYPE IS '工作宝用户数类型，1-并发、2-注册，默认并发'
;

COMMENT ON COLUMN EM_LICENSE.GZB_EXPIRE_DATE IS '工作宝模块过期时间'
;

COMMENT ON COLUMN EM_LICENSE.JDYZJ_COUNT IS '金蝶云之家集成数量'
;

COMMENT ON COLUMN EM_LICENSE.JDYZJ_USER_COUNT IS '金蝶云之家用户数量'
;

COMMENT ON COLUMN EM_LICENSE.JDYZJ_USER_COUNT_TYPE IS '金蝶云之家用户数类型，1-并发、2-注册，默认并发'
;

COMMENT ON COLUMN EM_LICENSE.JDYZJ_EXPIRE_DATE IS '金蝶云之家模块过期时间'
;

COMMENT ON COLUMN EM_LICENSE.HFX_COUNT IS '和飞信集成数量'
;

COMMENT ON COLUMN EM_LICENSE.HFX_USER_COUNT IS '和飞信用户数量'
;

COMMENT ON COLUMN EM_LICENSE.HFX_USER_COUNT_TYPE IS '和飞信用户数类型，1-并发、2-注册，默认并发'
;

COMMENT ON COLUMN EM_LICENSE.HFX_EXPIRE_DATE IS '和飞信模块过期时间'
;

COMMENT ON COLUMN EM_LICENSE.FXXK_COUNT IS '分享逍客集成数量'
;

COMMENT ON COLUMN EM_LICENSE.FXXK_USER_COUNT IS '分享逍客用户数量'
;

COMMENT ON COLUMN EM_LICENSE.FXXK_USER_COUNT_TYPE IS '分享逍客用户数类型，1-并发、2-注册，默认并发'
;

COMMENT ON COLUMN EM_LICENSE.FXXK_EXPIRE_DATE IS '分享逍客模块过期时间'
;

COMMENT ON COLUMN EM_LICENSE.WL_COUNT IS 'WeLink集成数量'
;

COMMENT ON COLUMN EM_LICENSE.WL_USER_COUNT IS 'WeLink用户数量'
;

COMMENT ON COLUMN EM_LICENSE.WL_USER_COUNT_TYPE IS 'WeLink用户数类型，1-并发、2-注册，默认并发'
;

COMMENT ON COLUMN EM_LICENSE.WL_EXPIRE_DATE IS 'WeLink模块过期时间'
;

COMMENT ON COLUMN EM_LICENSE.SALARY_COUNT IS '工资单集成数量'
;

COMMENT ON COLUMN EM_LICENSE.STATUS IS '状态'
;

COMMENT ON COLUMN EM_LICENSE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_LICENSE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_LICENSE.UPDATE_USER_ID IS '最后修改人'
;

COMMENT ON COLUMN EM_LICENSE.UPDATE_TIME IS '最后修改时间'
;

COMMENT ON COLUMN EM_LICENSE.TENANT_ID IS '租户ID'
;


CREATE TABLE EM_SYS_ERRCODE (
	ERRCODE INT NOT NULL,
	ERRMSG VARCHAR(1000) NOT NULL,
	ERRMSG_EN VARCHAR(1000) NOT NULL,
	PRIMARY KEY (ERRCODE)
)
;

COMMENT ON TABLE EM_SYS_ERRCODE IS '错误码信息表'
;

COMMENT ON COLUMN EM_SYS_ERRCODE.ERRCODE IS '错误编码'
;

COMMENT ON COLUMN EM_SYS_ERRCODE.ERRMSG IS '中文错误信息'
;

COMMENT ON COLUMN EM_SYS_ERRCODE.ERRMSG_EN IS '英文错误信息'
;


CREATE TABLE EM_HRM_DEPT_USER (
	ID VARCHAR(32) NOT NULL,
	HRM_USER_ID VARCHAR(32) DEFAULT NULL,
	HRM_DEPT_ID VARCHAR(32) DEFAULT NULL,
	SHOWORDER DECIMAL(19, 2) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_HRM_DEPT_USER IS '企业通讯录成员与部门关联表'
;

COMMENT ON COLUMN EM_HRM_DEPT_USER.ID IS '主键ID'
;

COMMENT ON COLUMN EM_HRM_DEPT_USER.HRM_USER_ID IS '通讯录人员表ID'
;

COMMENT ON COLUMN EM_HRM_DEPT_USER.HRM_DEPT_ID IS '通讯录部门表ID'
;

COMMENT ON COLUMN EM_HRM_DEPT_USER.SHOWORDER IS '显示顺序'
;

COMMENT ON COLUMN EM_HRM_DEPT_USER.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_HRM_DEPT_USER.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_HRM_DEPT_USER.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_HRM_DEPT_USER.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_HRM_DEPT_USER.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_HRM_DEPT_USER.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SIGN_RIGHT (
	ID VARCHAR(32) NOT NULL,
	CLIENT_TYPE SMALLINT DEFAULT NULL,
	HRM_DATA_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_TYPE SMALLINT DEFAULT NULL,
	SIGN_TYPE SMALLINT DEFAULT '1',
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_SIGN_RIGHT IS '手写签批使用权限设置表'
;

COMMENT ON COLUMN EM_SIGN_RIGHT.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SIGN_RIGHT.CLIENT_TYPE IS '2-IOS客户端，3-安卓客户端'
;

COMMENT ON COLUMN EM_SIGN_RIGHT.HRM_DATA_ID IS '通讯录成员或部门表ID'
;

COMMENT ON COLUMN EM_SIGN_RIGHT.HRM_DATA_TYPE IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;

COMMENT ON COLUMN EM_SIGN_RIGHT.SIGN_TYPE IS 'office签批还是pdf 签批 1-office 2-pdf'
;

COMMENT ON COLUMN EM_SIGN_RIGHT.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_SIGN_RIGHT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SIGN_RIGHT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SIGN_RIGHT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SIGN_RIGHT.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SIGN_RIGHT.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_UPGRADE_RECORD (
	ID SERIAL NOT NULL,
	VERSION VARCHAR(255) DEFAULT NULL,
	SCRIPT TEXT,
	BEGIN_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	END_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_UPGRADE_RECORD IS '数据库升级记录表'
;

COMMENT ON COLUMN EM_SYS_UPGRADE_RECORD.ID IS '主键'
;

COMMENT ON COLUMN EM_SYS_UPGRADE_RECORD.VERSION IS '版本'
;

COMMENT ON COLUMN EM_SYS_UPGRADE_RECORD.SCRIPT IS '本次升级执行的脚本'
;

COMMENT ON COLUMN EM_SYS_UPGRADE_RECORD.BEGIN_TIME IS '开始时间'
;

COMMENT ON COLUMN EM_SYS_UPGRADE_RECORD.END_TIME IS '结束时间'
;


CREATE TABLE EM_SYS_CONC_WHITELIST (
	ID VARCHAR(32) NOT NULL,
	CP_TYPE SMALLINT NOT NULL,
	BASE_USER_ID VARCHAR(100) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_SYS_CONC_WHITELIST IS '并发控制白名单'
;

COMMENT ON COLUMN EM_SYS_CONC_WHITELIST.ID IS '主键'
;

COMMENT ON COLUMN EM_SYS_CONC_WHITELIST.CP_TYPE IS '对应授权模块的类型'
;

COMMENT ON COLUMN EM_SYS_CONC_WHITELIST.BASE_USER_ID IS '白名单人员主键id'
;

COMMENT ON COLUMN EM_SYS_CONC_WHITELIST.STATUS IS '状态 1-正常，2-禁用，3-删除'
;

COMMENT ON COLUMN EM_SYS_CONC_WHITELIST.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_CONC_WHITELIST.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_CONC_WHITELIST.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_CONC_WHITELIST.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_CONC_WHITELIST.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SC_PORTAL_CATEGORY_USERSET (
	ID VARCHAR(32) NOT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	PORTAL_BASE_ID VARCHAR(32) DEFAULT NULL,
	PORTAL_CATEGORY_ID VARCHAR(32) DEFAULT NULL,
	SET_ELEMENT_IDS VARCHAR(500) DEFAULT NULL,
	REDUCE_ELEMENT_IDS VARCHAR(500) DEFAULT NULL,
	INCREASE_ELEMENT_IDS VARCHAR(500) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;
COMMENT ON TABLE EM_SC_PORTAL_CATEGORY_USERSET IS '企业客户端门户分组用户自定义设置表'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_USERSET.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_USERSET.BASE_USER_ID IS '基础用户ID'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_USERSET.PORTAL_BASE_ID IS '门户ID'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_USERSET.PORTAL_CATEGORY_ID IS '分组ID'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_USERSET.SET_ELEMENT_IDS IS '此分组用户设置的元素id集合用逗号分隔'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_USERSET.REDUCE_ELEMENT_IDS IS '此分组相对于门户分组减少的元素id集合用逗号分隔'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_USERSET.INCREASE_ELEMENT_IDS IS '此分组相对于门户分组新增的元素id集合用逗号分隔'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_USERSET.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_USERSET.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_USERSET.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_USERSET.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_USERSET.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SC_PORTAL_CATEGORY_USERSET.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_REDPACKET_SETTING (
	ID VARCHAR(32) NOT NULL,
	ENABLED SMALLINT DEFAULT NULL,
	APP_KEY VARCHAR(100) DEFAULT NULL,
	CUSTOM_ID VARCHAR(100) DEFAULT NULL,
	CUSTOM_NAME VARCHAR(100) DEFAULT '1',
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_REDPACKET_SETTING IS '红包服务设置信息'
;

COMMENT ON COLUMN EM_SYS_REDPACKET_SETTING.ENABLED IS '是否开启红包服务：0-禁用、1-开启'
;

COMMENT ON COLUMN EM_SYS_REDPACKET_SETTING.APP_KEY IS '接入的秘钥'
;

COMMENT ON COLUMN EM_SYS_REDPACKET_SETTING.CUSTOM_ID IS '商户ID'
;

COMMENT ON COLUMN EM_SYS_REDPACKET_SETTING.CUSTOM_NAME IS '商户名称'
;

COMMENT ON COLUMN EM_SYS_REDPACKET_SETTING.STATUS IS '状态'
;

COMMENT ON COLUMN EM_SYS_REDPACKET_SETTING.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_REDPACKET_SETTING.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_REDPACKET_SETTING.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_REDPACKET_SETTING.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_REDPACKET_SETTING.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_MSGAUDIT_MESSAGE (
	ID VARCHAR(32) NOT NULL,
	CORP_ID VARCHAR(32) DEFAULT NULL,
	SEQ BIGINT DEFAULT NULL,
	ROOM_ID VARCHAR(32) DEFAULT NULL,
	MSG_ID VARCHAR(64) DEFAULT NULL,
	MSG_ACTION VARCHAR(32) DEFAULT NULL,
	MSG_FROM VARCHAR(255) DEFAULT NULL,
	TO_LIST TEXT,
	MSG_TYPE VARCHAR(32) DEFAULT NULL,
	MSG_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	CONTENT TEXT,
	SDK_FILE_ID TEXT,
	FILE_ID VARCHAR(32) DEFAULT NULL,
	MSG_JSON TEXT,
	STATUS SMALLINT DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_CP_MSGAUDIT_MESSAGE IS '会话内容存档消息'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MESSAGE.ID IS '主键'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MESSAGE.CORP_ID IS '企业ID'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MESSAGE.SEQ IS 'seq'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MESSAGE.ROOM_ID IS '会话ID'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MESSAGE.MSG_ID IS '接口消息ID'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MESSAGE.MSG_ACTION IS '消息动作：send-发送消息、recall-撤回消息、switch-切换企业日志'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MESSAGE.MSG_FROM IS '消息发送方id'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MESSAGE.TO_LIST IS '消息接收方列表，可能是多个，同一个企业内容为userid，非相同企业为external_userid'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MESSAGE.MSG_TYPE IS '消息类型'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MESSAGE.MSG_TIME IS '消息发送时间'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MESSAGE.CONTENT IS '消息内容'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MESSAGE.SDK_FILE_ID IS '接口媒体资源的id信息'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MESSAGE.FILE_ID IS '文件ID'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MESSAGE.MSG_JSON IS '消息原始JSON数据'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MESSAGE.STATUS IS '状态'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MESSAGE.TENANT_ID IS '租户ID'
;


CREATE TABLE EM_CP_MSGAUDIT_SYNC_RECORD (
	ID VARCHAR(32) NOT NULL,
	CORP_ID VARCHAR(32) DEFAULT NULL,
	FIRST_SEQ BIGINT DEFAULT NULL,
	LAST_SEQ BIGINT DEFAULT NULL,
	MESSAGE_COUNT BIGINT DEFAULT NULL,
	ERROR_MSG TEXT,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_CP_MSGAUDIT_SYNC_RECORD IS '会话内容存档同步记录'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_SYNC_RECORD.ID IS '主键'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_SYNC_RECORD.CORP_ID IS '企业ID'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_SYNC_RECORD.FIRST_SEQ IS '开始seq'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_SYNC_RECORD.LAST_SEQ IS '结束seq'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_SYNC_RECORD.MESSAGE_COUNT IS '同步消息数量'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_SYNC_RECORD.ERROR_MSG IS '同步失败错误信息'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_SYNC_RECORD.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_SYNC_RECORD.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_SYNC_RECORD.TENANT_ID IS '租户ID'
;


CREATE TABLE EM_SC_THEME_VIEW (
	ID VARCHAR(32) NOT NULL,
	THEME_BASE_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_TYPE SMALLINT DEFAULT NULL,
	HRM_DATA_ID VARCHAR(32) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_SC_THEME_VIEW IS '企业客户端主题可见范围设置表'
;

COMMENT ON COLUMN EM_SC_THEME_VIEW.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SC_THEME_VIEW.THEME_BASE_ID IS '主题ID'
;

COMMENT ON COLUMN EM_SC_THEME_VIEW.HRM_DATA_TYPE IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;

COMMENT ON COLUMN EM_SC_THEME_VIEW.HRM_DATA_ID IS '通讯录成员或部门表ID'
;

COMMENT ON COLUMN EM_SC_THEME_VIEW.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_SC_THEME_VIEW.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SC_THEME_VIEW.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SC_THEME_VIEW.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SC_THEME_VIEW.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SC_THEME_VIEW.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_CLIENTTASK_SETTING (
	ID VARCHAR(32) NOT NULL,
	TASK_TYPE SMALLINT DEFAULT NULL,
	DATA_RETENTION_DAY INT DEFAULT '30',
	RECORD_ACTION_TYPE SMALLINT DEFAULT NULL,
	RECORD_ACTION_SETTING VARCHAR(200) DEFAULT NULL,
	ENABLE_TIMIMG SMALLINT DEFAULT NULL,
	ENABLE_LOGIN SMALLINT DEFAULT NULL,
	ENABLE_RELOGIN SMALLINT DEFAULT NULL,
	ENABLE_SENDMSG SMALLINT DEFAULT NULL,
	ENABLE_OPENLINK SMALLINT DEFAULT NULL,
	TASK_CYCLE INT DEFAULT NULL,
	TASK_TIME_TYPE SMALLINT DEFAULT NULL,
	TASK_TIME_START VARCHAR(20) DEFAULT NULL,
	TASK_TIME_END VARCHAR(20) DEFAULT NULL,
	TASK_TIME_LIST VARCHAR(2000) DEFAULT NULL,
	TASK_RANGE_TYPE SMALLINT DEFAULT NULL,
	TASK_ACTION_TYPE SMALLINT DEFAULT NULL,
	TASK_ACTION_SETTING VARCHAR(200) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_CLIENTTASK_SETTING IS '客户端定时任务设置表'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.ID IS '主键'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.TASK_TYPE IS '任务类型：1-上报活跃、2-上报定位、3-上报步数、4-请求弹窗'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.DATA_RETENTION_DAY IS '任务数据保留时间,单位天'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.RECORD_ACTION_TYPE IS '数据记录类型，1-本系统记录，2-OA记录'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.RECORD_ACTION_SETTING IS '数据记录类型为2-OA记录是，对应的集成系统id'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.ENABLE_TIMIMG IS '是否定时触发（默认是）'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.ENABLE_LOGIN IS '是否登录后触发（默认否）'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.ENABLE_RELOGIN IS '是否唤醒后触发（默认否）'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.ENABLE_SENDMSG IS '是否发送消息时触发（默认否）'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.ENABLE_OPENLINK IS '是否打开新窗口时触发（默认否）'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.TASK_CYCLE IS '任务执行周期，单位为秒'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.TASK_TIME_TYPE IS '任务执行时间类型，1-所有时间、2-指定时间段'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.TASK_TIME_START IS '任务执行指定时间段的开始时间'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.TASK_TIME_END IS '任务执行指定时间段的结束时间'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.TASK_TIME_LIST IS '任务执行时间段json字符串'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.TASK_RANGE_TYPE IS '任务执行适用范围类型：1-包含，2-排除'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.TASK_ACTION_TYPE IS '定时任务动作类型，1-位置收集，2-自动打卡，3-调整提醒'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.TASK_ACTION_SETTING IS '定时任务动作类型对应的集成系统id'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.STATUS IS '状态：1-正常，2-禁用，3-删除'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_CLIENTTASK_SETTING.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_HRM_USER_ATTR (
	ID VARCHAR(32) NOT NULL,
	ATTR_TAG VARCHAR(32) DEFAULT NULL,
	ATTR_NAME VARCHAR(100) DEFAULT NULL,
	ENGLISH_NAME VARCHAR(100) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_HRM_USER_ATTR IS '企业通讯录成员自定义字段定义表'
;

COMMENT ON COLUMN EM_HRM_USER_ATTR.ID IS '主键ID'
;

COMMENT ON COLUMN EM_HRM_USER_ATTR.ATTR_TAG IS '自定义字段标识'
;

COMMENT ON COLUMN EM_HRM_USER_ATTR.ATTR_NAME IS '自定义字段名称'
;

COMMENT ON COLUMN EM_HRM_USER_ATTR.ENGLISH_NAME IS '自定义字段英文名称'
;

COMMENT ON COLUMN EM_HRM_USER_ATTR.STATUS IS '状态 1=正常，3=已删除'
;

COMMENT ON COLUMN EM_HRM_USER_ATTR.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_HRM_USER_ATTR.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_HRM_USER_ATTR.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_HRM_USER_ATTR.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_HRM_USER_ATTR.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_BASEUSER_DEVICE_RIGHT (
	ID VARCHAR(32) NOT NULL,
	HRM_DATA_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_TYPE SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_SYS_BASEUSER_DEVICE_RIGHT IS '绑定设备验证使用范围设置表'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE_RIGHT.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE_RIGHT.HRM_DATA_ID IS '通讯录成员或部门表ID'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE_RIGHT.HRM_DATA_TYPE IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE_RIGHT.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE_RIGHT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE_RIGHT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE_RIGHT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE_RIGHT.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_BASEUSER_DEVICE_RIGHT.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_MSGAUDIT_ROOM (
	ID VARCHAR(32) NOT NULL,
	CORP_ID VARCHAR(32) DEFAULT NULL,
	ROOM_ID VARCHAR(64) DEFAULT NULL,
	ROOM_TYPE SMALLINT DEFAULT NULL,
	IS_EXTERNAL SMALLINT DEFAULT NULL,
	ROOM_NAME VARCHAR(255) DEFAULT NULL,
	ROOM_CREATOR VARCHAR(255) DEFAULT NULL,
	ROOM_CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	ROOM_NOTICE TEXT,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(255) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_CP_MSGAUDIT_ROOM IS '会话内容存档会话'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM.ID IS '主键'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM.CORP_ID IS '企业ID'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM.ROOM_ID IS '接口会话ID'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM.ROOM_TYPE IS '会话类型：1-单聊、2-群聊'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM.IS_EXTERNAL IS '是否为外部群（单聊忽略该字段）：0-否、1-是'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM.ROOM_NAME IS '群名称'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM.ROOM_CREATOR IS '群创建者'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM.ROOM_CREATE_TIME IS '群创建时间'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM.ROOM_NOTICE IS '群公告'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM.STATUS IS '状态'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_ROOM.TENANT_ID IS '租户ID'
;


CREATE TABLE EM_HRM_USER_CODE (
	AUTH_CODE VARCHAR(100) NOT NULL,
	BASE_USER_ID VARCHAR(32) NOT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	DEVICE_ID VARCHAR(100) DEFAULT NULL,
	EXPIRE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	AGENT_BASE_ID VARCHAR(50) DEFAULT NULL,
	PRIMARY KEY (AUTH_CODE)
)
;



COMMENT ON TABLE EM_HRM_USER_CODE IS '企业用户授权code信息'
;

COMMENT ON COLUMN EM_HRM_USER_CODE.AUTH_CODE IS '授权code'
;

COMMENT ON COLUMN EM_HRM_USER_CODE.BASE_USER_ID IS '基础用户ID'
;

COMMENT ON COLUMN EM_HRM_USER_CODE.TENANT_ID IS '企业租户ID'
;

COMMENT ON COLUMN EM_HRM_USER_CODE.DEVICE_ID IS '手机设备号'
;

COMMENT ON COLUMN EM_HRM_USER_CODE.EXPIRE_TIME IS '过期时间'
;

COMMENT ON COLUMN EM_HRM_USER_CODE.STATUS IS '状态 1-正常，2-无效，3-删除'
;

COMMENT ON COLUMN EM_HRM_USER_CODE.AGENT_BASE_ID IS '应用授权时候，绑定的应用主键id'
;


CREATE TABLE EM_LOG_ERROR (
	ID VARCHAR(32) NOT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	BASE_USER_NAME VARCHAR(255) DEFAULT NULL,
	OPERATION VARCHAR(255) DEFAULT NULL,
	PARAMS TEXT,
	ERROR_TYPE VARCHAR(255) DEFAULT NULL,
	EXCEPTION TEXT,
	IP VARCHAR(255) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_LOG_ERROR IS '错误日志'
;

COMMENT ON COLUMN EM_LOG_ERROR.ID IS '主键'
;

COMMENT ON COLUMN EM_LOG_ERROR.BASE_USER_ID IS '用户ID'
;

COMMENT ON COLUMN EM_LOG_ERROR.BASE_USER_NAME IS '用户名'
;

COMMENT ON COLUMN EM_LOG_ERROR.OPERATION IS '操作'
;

COMMENT ON COLUMN EM_LOG_ERROR.PARAMS IS '请求参数'
;

COMMENT ON COLUMN EM_LOG_ERROR.ERROR_TYPE IS '错误类型'
;

COMMENT ON COLUMN EM_LOG_ERROR.EXCEPTION IS '异常信息'
;

COMMENT ON COLUMN EM_LOG_ERROR.IP IS 'IP地址'
;

COMMENT ON COLUMN EM_LOG_ERROR.CREATE_TIME IS '日志创建时间'
;

COMMENT ON COLUMN EM_LOG_ERROR.TENANT_ID IS '租户ID'
;


CREATE TABLE EM_LOG_ACCESS_BAK (
	ID VARCHAR(32) NOT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	BASE_USER_NAME VARCHAR(255) DEFAULT NULL,
	BASE_USER_STATUS SMALLINT DEFAULT NULL,
	OPERATION VARCHAR(255) DEFAULT NULL,
	ACCESS_TOKEN VARCHAR(100) DEFAULT NULL,
	LOGIN_TYPE SMALLINT DEFAULT NULL,
	LOGIN_MODE SMALLINT DEFAULT NULL,
	CLIENT_TYPE SMALLINT DEFAULT NULL,
	CLIENT_VERSION VARCHAR(50) DEFAULT NULL,
	DEVICE_ID VARCHAR(255) DEFAULT NULL,
	LANG_TYPE VARCHAR(10) DEFAULT NULL,
	OS_VERSION VARCHAR(500) DEFAULT NULL,
	CLIENT_MODEL VARCHAR(100) DEFAULT NULL,
	IP VARCHAR(255) DEFAULT NULL,
	USER_AGENT VARCHAR(500) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_LOG_ACCESS_BAK IS '访问日志'
;

COMMENT ON COLUMN EM_LOG_ACCESS_BAK.ID IS '主键'
;

COMMENT ON COLUMN EM_LOG_ACCESS_BAK.BASE_USER_ID IS '用户ID'
;

COMMENT ON COLUMN EM_LOG_ACCESS_BAK.BASE_USER_NAME IS '用户名'
;

COMMENT ON COLUMN EM_LOG_ACCESS_BAK.BASE_USER_STATUS IS '用户状态 1-已注册，2-未注册，3-删除'
;

COMMENT ON COLUMN EM_LOG_ACCESS_BAK.OPERATION IS '操作：login-登录，logout-登出'
;

COMMENT ON COLUMN EM_LOG_ACCESS_BAK.ACCESS_TOKEN IS '访问token'
;

COMMENT ON COLUMN EM_LOG_ACCESS_BAK.LOGIN_TYPE IS '登录类型：1-客户端，2-管理端，3-接口'
;

COMMENT ON COLUMN EM_LOG_ACCESS_BAK.LOGIN_MODE IS '登录方式：1-账号密码登录，2-短信验证码登录，3-扫码登录'
;

COMMENT ON COLUMN EM_LOG_ACCESS_BAK.CLIENT_TYPE IS '客户端类型： 1-PC客户端，2-IOS客户端，3-安卓客户端，4-web版'
;

COMMENT ON COLUMN EM_LOG_ACCESS_BAK.CLIENT_VERSION IS '客户端版本'
;

COMMENT ON COLUMN EM_LOG_ACCESS_BAK.DEVICE_ID IS '客户端硬件标识'
;

COMMENT ON COLUMN EM_LOG_ACCESS_BAK.LANG_TYPE IS '语言类型'
;

COMMENT ON COLUMN EM_LOG_ACCESS_BAK.OS_VERSION IS '客户端操作系统版本'
;

COMMENT ON COLUMN EM_LOG_ACCESS_BAK.CLIENT_MODEL IS '客户端设备型号'
;

COMMENT ON COLUMN EM_LOG_ACCESS_BAK.IP IS 'IP地址'
;

COMMENT ON COLUMN EM_LOG_ACCESS_BAK.USER_AGENT IS '访问头信息'
;

COMMENT ON COLUMN EM_LOG_ACCESS_BAK.CREATE_TIME IS '日志创建时间'
;

COMMENT ON COLUMN EM_LOG_ACCESS_BAK.TENANT_ID IS '租户ID'
;


CREATE TABLE EM_SC_THEME_NAV_BTN (
	ID VARCHAR(32) NOT NULL,
	THEME_BASE_ID VARCHAR(32) DEFAULT NULL,
	THEME_NAV_ID VARCHAR(32) DEFAULT NULL,
	BTN_TYPE SMALLINT DEFAULT NULL,
	BTN_NAME VARCHAR(50) DEFAULT NULL,
	BTN_FUNC INT DEFAULT NULL,
	BTN_FUNC_SET1 VARCHAR(200) DEFAULT NULL,
	BTN_FUNC_SET2 VARCHAR(200) DEFAULT NULL,
	BTN_FUNC_SET3 VARCHAR(200) DEFAULT NULL,
	BTN_FUNC_SET4 VARCHAR(200) DEFAULT NULL,
	ISSHOW SMALLINT DEFAULT NULL,
	SHOWORDER INT DEFAULT NULL,
	ICON_DEFAULT VARCHAR(200) NOT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_SC_THEME_NAV_BTN IS '企业客户端主题导航按钮设置表'
;

COMMENT ON COLUMN EM_SC_THEME_NAV_BTN.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SC_THEME_NAV_BTN.THEME_BASE_ID IS '主题ID'
;

COMMENT ON COLUMN EM_SC_THEME_NAV_BTN.THEME_NAV_ID IS '导航明细ID'
;

COMMENT ON COLUMN EM_SC_THEME_NAV_BTN.BTN_TYPE IS '按钮类型 1-右上角按钮，2-消息功能按钮'
;

COMMENT ON COLUMN EM_SC_THEME_NAV_BTN.BTN_NAME IS '按钮名称'
;

COMMENT ON COLUMN EM_SC_THEME_NAV_BTN.BTN_FUNC IS '按钮功能：1-应用，2-门户，3-自定义链接'
;

COMMENT ON COLUMN EM_SC_THEME_NAV_BTN.BTN_FUNC_SET1 IS '按钮功能设置，如应用ID、门户ID，自定义链接地址等'
;

COMMENT ON COLUMN EM_SC_THEME_NAV_BTN.BTN_FUNC_SET2 IS '按钮功能设置，如自定义链接的打开方式1表示默认窗口，2表示新窗口'
;

COMMENT ON COLUMN EM_SC_THEME_NAV_BTN.BTN_FUNC_SET3 IS '按钮功能设置，如自定义链接的打开方式为2表示新窗口，此时为打开的宽度'
;

COMMENT ON COLUMN EM_SC_THEME_NAV_BTN.BTN_FUNC_SET4 IS '按钮功能设置，如自定义链接的打开方式为2表示新窗口，此时为打开的高度'
;

COMMENT ON COLUMN EM_SC_THEME_NAV_BTN.ISSHOW IS '是否显示：1-登显示，0-不显示'
;

COMMENT ON COLUMN EM_SC_THEME_NAV_BTN.SHOWORDER IS '显示顺序'
;

COMMENT ON COLUMN EM_SC_THEME_NAV_BTN.ICON_DEFAULT IS '默认显示图标'
;

COMMENT ON COLUMN EM_SC_THEME_NAV_BTN.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_SC_THEME_NAV_BTN.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SC_THEME_NAV_BTN.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SC_THEME_NAV_BTN.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SC_THEME_NAV_BTN.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SC_THEME_NAV_BTN.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_SYS_PROVINCE (
	PROVINCE_CODE INT NOT NULL,
	PROVINCE_NAME VARCHAR(50) NOT NULL,
	PRIMARY KEY (PROVINCE_CODE)
)
;

COMMENT ON TABLE EM_SYS_PROVINCE IS '省份表'
;

COMMENT ON COLUMN EM_SYS_PROVINCE.PROVINCE_CODE IS '代码'
;

COMMENT ON COLUMN EM_SYS_PROVINCE.PROVINCE_NAME IS '名称'
;


CREATE TABLE EM_DEMO_USER (
	ID VARCHAR(32) NOT NULL,
	NICK_NAME VARCHAR(255) DEFAULT NULL,
	USERNAME VARCHAR(100) DEFAULT NULL,
	PASSWORD VARCHAR(255) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



CREATE TABLE EM_CP_CORP (
	ID VARCHAR(32) NOT NULL,
	CORP_NAME VARCHAR(50) DEFAULT NULL,
	OPEN_CORP_ID VARCHAR(100) DEFAULT NULL,
	CORP_KEY VARCHAR(100) DEFAULT NULL,
	CORP_SECRET VARCHAR(100) DEFAULT NULL,
	AUTH_AGENT_ID VARCHAR(100) DEFAULT NULL,
	CP_TYPE SMALLINT DEFAULT NULL,
	MP_TYPE SMALLINT DEFAULT NULL,
	IS_CERTIFIED SMALLINT DEFAULT NULL,
	QRCODE VARCHAR(32) DEFAULT NULL,
	JDYZJ_TYPE SMALLINT DEFAULT NULL,
	API_URL_BASE VARCHAR(200) DEFAULT NULL,
	API_URL_USER VARCHAR(200) DEFAULT NULL,
	API_URL_MSG VARCHAR(200) DEFAULT NULL,
	API_URL_TOKEN VARCHAR(200) DEFAULT NULL,
	API_URL_JSSDK VARCHAR(200) DEFAULT NULL,
	API_URL_WEIBO VARCHAR(200) DEFAULT NULL,
	ORGMANAGE_ACTIVE SMALLINT DEFAULT NULL,
	MANAGER_MOBILE VARCHAR(20) DEFAULT NULL,
	CUSTOMER_NAME VARCHAR(200) DEFAULT NULL,
	INDUSTRY VARCHAR(200) DEFAULT NULL,
	CORP_DESC VARCHAR(500) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	VPN_ADDR VARCHAR(100) DEFAULT '',
	MATCH_ACTIVE SMALLINT DEFAULT NULL,
	MATCH_OUTSYS_ID VARCHAR(32) DEFAULT NULL,
	MATCH_USER_FIELD SMALLINT DEFAULT NULL,
	MATCH_USER_CUSTOMFIELD VARCHAR(50) DEFAULT NULL,
	MATCH_OUTSYS_FIELD SMALLINT DEFAULT NULL,
	MATCH_OUTSYS_CUSTOMFIELD VARCHAR(50) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_CP_CORP IS '企业号基本信息表'
;

COMMENT ON COLUMN EM_CP_CORP.CORP_NAME IS '企业号名称'
;

COMMENT ON COLUMN EM_CP_CORP.OPEN_CORP_ID IS '企业号CORPID'
;

COMMENT ON COLUMN EM_CP_CORP.CORP_KEY IS '企业号KEY'
;

COMMENT ON COLUMN EM_CP_CORP.CORP_SECRET IS '企业号秘钥'
;

COMMENT ON COLUMN EM_CP_CORP.AUTH_AGENT_ID IS '授权应用ID'
;

COMMENT ON COLUMN EM_CP_CORP.CP_TYPE IS '企业号类型：1-企业微信、2-钉钉、3-简聊、4-蓝信、5-工作宝、8-金蝶云之家'
;

COMMENT ON COLUMN EM_CP_CORP.MP_TYPE IS '公众号类型：0-订阅号、1-服务号'
;

COMMENT ON COLUMN EM_CP_CORP.IS_CERTIFIED IS '是否为认证过的企业：0，null-否、1-是'
;

COMMENT ON COLUMN EM_CP_CORP.QRCODE IS '二维码图片'
;

COMMENT ON COLUMN EM_CP_CORP.JDYZJ_TYPE IS '金蝶云之家类型：0-公有云，新版私有云、1-旧版私有云'
;

COMMENT ON COLUMN EM_CP_CORP.API_URL_BASE IS '企业号基础接口api地址'
;

COMMENT ON COLUMN EM_CP_CORP.API_URL_USER IS '企业号获取用户信息接口api地址'
;

COMMENT ON COLUMN EM_CP_CORP.API_URL_MSG IS '企业号消息推送接口api地址'
;

COMMENT ON COLUMN EM_CP_CORP.API_URL_TOKEN IS '企业号获取token接口api地址'
;

COMMENT ON COLUMN EM_CP_CORP.API_URL_JSSDK IS '企业号JS-SDK接口api地址'
;

COMMENT ON COLUMN EM_CP_CORP.API_URL_WEIBO IS '云之家微博服务api地址'
;

COMMENT ON COLUMN EM_CP_CORP.ORGMANAGE_ACTIVE IS '是否启用通讯录管理功能，1-是，0-否'
;

COMMENT ON COLUMN EM_CP_CORP.MANAGER_MOBILE IS '管理员手机号'
;

COMMENT ON COLUMN EM_CP_CORP.CUSTOMER_NAME IS '客户名称'
;

COMMENT ON COLUMN EM_CP_CORP.INDUSTRY IS '行业类型'
;

COMMENT ON COLUMN EM_CP_CORP.CORP_DESC IS '企业号描述信息'
;

COMMENT ON COLUMN EM_CP_CORP.STATUS IS '状态：1-正常、3-删除'
;

COMMENT ON COLUMN EM_CP_CORP.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_CORP.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_CORP.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_CORP.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_CORP.TENANT_ID IS '企业租户ID'
;

COMMENT ON COLUMN EM_CP_CORP.VPN_ADDR IS 'VPN地址'
;

COMMENT ON COLUMN EM_CP_CORP.MATCH_ACTIVE IS '是否启用自动关联EC成员，1-是，0-否'
;

COMMENT ON COLUMN EM_CP_CORP.MATCH_OUTSYS_ID IS '匹配的集成系统ID'
;

COMMENT ON COLUMN EM_CP_CORP.MATCH_USER_FIELD IS '企业号的匹配字段：1-账号，2-手机号，3-邮箱，4-工号，100-自定义字段'
;

COMMENT ON COLUMN EM_CP_CORP.MATCH_USER_CUSTOMFIELD IS '企业号的匹配自定义字段'
;

COMMENT ON COLUMN EM_CP_CORP.MATCH_OUTSYS_FIELD IS '集成系统的匹配字段：1-数据库ID，2-登录账号，3-手机，4-邮箱，5-工号，6-身份证号码，100-自定义字段'
;

COMMENT ON COLUMN EM_CP_CORP.MATCH_OUTSYS_CUSTOMFIELD IS '集成系统的匹配自定义字段'
;


CREATE TABLE EM_SYS_LOGIN_VERIFY_RULE (
	ID VARCHAR(32) NOT NULL,
	VERIFY_TYPE SMALLINT DEFAULT '1',
	VERIFY_URL VARCHAR(100) DEFAULT NULL,
	VERIFY_PARM VARCHAR(50) DEFAULT NULL,
	PRIORITY INT DEFAULT '0',
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_LOGIN_VERIFY_RULE IS '系统账号密码登录验证规则表'
;

COMMENT ON COLUMN EM_SYS_LOGIN_VERIFY_RULE.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SYS_LOGIN_VERIFY_RULE.VERIFY_TYPE IS '验证方式：1-本系统 2-ecology系统'
;

COMMENT ON COLUMN EM_SYS_LOGIN_VERIFY_RULE.VERIFY_URL IS '验证地址，如ecology系统地址'
;

COMMENT ON COLUMN EM_SYS_LOGIN_VERIFY_RULE.VERIFY_PARM IS '验证所需的其他参数值'
;

COMMENT ON COLUMN EM_SYS_LOGIN_VERIFY_RULE.PRIORITY IS '规则优先级'
;

COMMENT ON COLUMN EM_SYS_LOGIN_VERIFY_RULE.STATUS IS '状态 1-正常，2-禁用，3-删除'
;

COMMENT ON COLUMN EM_SYS_LOGIN_VERIFY_RULE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_LOGIN_VERIFY_RULE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_LOGIN_VERIFY_RULE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_LOGIN_VERIFY_RULE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_LOGIN_VERIFY_RULE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_USER_ACCOUNT (
	ID VARCHAR(32) NOT NULL,
	CP_USER_ID VARCHAR(32) DEFAULT NULL,
	OUTSYS_ID VARCHAR(32) DEFAULT NULL,
	OUTSYS_USER_ID VARCHAR(32) DEFAULT NULL,
	OUTSYS_USER_NAME VARCHAR(100) DEFAULT NULL,
	OUTSYS_USER_AVATAR VARCHAR(200) DEFAULT NULL,
	OUTSYS_SUBACCOUNT VARCHAR(255) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	IS_SYNC_EC SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_CP_USER_ACCOUNT IS '通讯录成员与集成系统人员关联表'
;

COMMENT ON COLUMN EM_CP_USER_ACCOUNT.ID IS '主键ID'
;

COMMENT ON COLUMN EM_CP_USER_ACCOUNT.CP_USER_ID IS '用户ID'
;

COMMENT ON COLUMN EM_CP_USER_ACCOUNT.OUTSYS_ID IS '集成系统ID'
;

COMMENT ON COLUMN EM_CP_USER_ACCOUNT.OUTSYS_USER_ID IS '集成系统中的用户ID'
;

COMMENT ON COLUMN EM_CP_USER_ACCOUNT.OUTSYS_USER_NAME IS '集成系统中的用户姓名'
;

COMMENT ON COLUMN EM_CP_USER_ACCOUNT.OUTSYS_USER_AVATAR IS '集成系统中的用户头像MD5值'
;

COMMENT ON COLUMN EM_CP_USER_ACCOUNT.OUTSYS_SUBACCOUNT IS '成员次账号信息'
;

COMMENT ON COLUMN EM_CP_USER_ACCOUNT.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_CP_USER_ACCOUNT.IS_SYNC_EC IS '人员数据是否同步到ecology，0-否，1-是'
;

COMMENT ON COLUMN EM_CP_USER_ACCOUNT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_USER_ACCOUNT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_USER_ACCOUNT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_USER_ACCOUNT.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_USER_ACCOUNT.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_DEPT_SIMULATED (
	ID VARCHAR(32) NOT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	OPEN_DEPT_ID VARCHAR(100) DEFAULT NULL,
	DEPT_NAME VARCHAR(100) DEFAULT NULL,
	ENGLISH_NAME VARCHAR(100) DEFAULT NULL,
	PARENT_ID VARCHAR(100) DEFAULT NULL,
	ALL_PARENT_IDS VARCHAR(1000) DEFAULT NULL,
	OUTSYS_ID VARCHAR(32) DEFAULT NULL,
	OUTSYS_DEPT_TYPE SMALLINT DEFAULT NULL,
	OUTSYS_DEPT_ID VARCHAR(32) DEFAULT NULL,
	SHOWORDER BIGINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;




COMMENT ON TABLE EM_CP_DEPT_SIMULATED IS '企业号通讯录部门模拟表'
;

COMMENT ON COLUMN EM_CP_DEPT_SIMULATED.ID IS '主键ID'
;

COMMENT ON COLUMN EM_CP_DEPT_SIMULATED.CP_CORP_ID IS '企业号基本信息ID'
;

COMMENT ON COLUMN EM_CP_DEPT_SIMULATED.OPEN_DEPT_ID IS '企业号中的部门ID'
;

COMMENT ON COLUMN EM_CP_DEPT_SIMULATED.DEPT_NAME IS '部门名称'
;

COMMENT ON COLUMN EM_CP_DEPT_SIMULATED.ENGLISH_NAME IS '英文名称'
;

COMMENT ON COLUMN EM_CP_DEPT_SIMULATED.PARENT_ID IS '上级部门ID'
;

COMMENT ON COLUMN EM_CP_DEPT_SIMULATED.ALL_PARENT_IDS IS '所有上级部门ID用逗号分隔'
;

COMMENT ON COLUMN EM_CP_DEPT_SIMULATED.OUTSYS_ID IS '对应集成系统的ID'
;

COMMENT ON COLUMN EM_CP_DEPT_SIMULATED.OUTSYS_DEPT_TYPE IS '对应集成系统部门类型：1-分部，2-部门'
;

COMMENT ON COLUMN EM_CP_DEPT_SIMULATED.OUTSYS_DEPT_ID IS '对应集成系统部门ID'
;

COMMENT ON COLUMN EM_CP_DEPT_SIMULATED.SHOWORDER IS '显示顺序'
;

COMMENT ON COLUMN EM_CP_DEPT_SIMULATED.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_CP_DEPT_SIMULATED.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_DEPT_SIMULATED.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_DEPT_SIMULATED.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_DEPT_SIMULATED.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_DEPT_SIMULATED.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_LOG_CLIENT_USE (
	ID VARCHAR(32) NOT NULL,
	CP_TYPE SMALLINT DEFAULT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	ACCESS_TOKEN VARCHAR(100) DEFAULT NULL,
	CLIENT_TYPE SMALLINT DEFAULT NULL,
	USE_DATE VARCHAR(10) DEFAULT NULL,
	LAST_USE_TIME VARCHAR(8) DEFAULT NULL,
	IP VARCHAR(255) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_LOG_CLIENT_USE IS '客户端每天使用日志'
;

COMMENT ON COLUMN EM_LOG_CLIENT_USE.ID IS '主键'
;

COMMENT ON COLUMN EM_LOG_CLIENT_USE.CP_TYPE IS '客户端使用的模块类型'
;

COMMENT ON COLUMN EM_LOG_CLIENT_USE.BASE_USER_ID IS '用户ID'
;

COMMENT ON COLUMN EM_LOG_CLIENT_USE.ACCESS_TOKEN IS '访问token'
;

COMMENT ON COLUMN EM_LOG_CLIENT_USE.CLIENT_TYPE IS '登录客户端类型：1表示PC，2表示IOS，3表示安卓，4表示web'
;

COMMENT ON COLUMN EM_LOG_CLIENT_USE.USE_DATE IS '使用日期'
;

COMMENT ON COLUMN EM_LOG_CLIENT_USE.LAST_USE_TIME IS '最后使用时间'
;

COMMENT ON COLUMN EM_LOG_CLIENT_USE.IP IS 'IP地址'
;

COMMENT ON COLUMN EM_LOG_CLIENT_USE.CREATE_TIME IS '日志创建时间'
;

COMMENT ON COLUMN EM_LOG_CLIENT_USE.UPDATE_TIME IS '日志更新时间'
;

COMMENT ON COLUMN EM_LOG_CLIENT_USE.TENANT_ID IS '租户ID'
;


CREATE TABLE EM_SC_PORTAL_BASE (
	ID VARCHAR(32) NOT NULL,
	CLIENT_TYPE SMALLINT DEFAULT NULL,
	PORTAL_NAME VARCHAR(100) DEFAULT NULL,
	SHOW_TYPE SMALLINT DEFAULT '1',
	ISDEFAULT SMALLINT DEFAULT NULL,
	ISUSERSET SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_SC_PORTAL_BASE IS '企业客户端门户基础信息表'
;

COMMENT ON COLUMN EM_SC_PORTAL_BASE.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SC_PORTAL_BASE.CLIENT_TYPE IS '客户端类型 1-移动APP，2-PC客户端，3-web客户端'
;

COMMENT ON COLUMN EM_SC_PORTAL_BASE.PORTAL_NAME IS '门户名称'
;

COMMENT ON COLUMN EM_SC_PORTAL_BASE.SHOW_TYPE IS '显示模式'
;

COMMENT ON COLUMN EM_SC_PORTAL_BASE.ISDEFAULT IS '是否默认门户：1-是、0-否'
;

COMMENT ON COLUMN EM_SC_PORTAL_BASE.ISUSERSET IS '是否支持用户自定义：1-是、0-否'
;

COMMENT ON COLUMN EM_SC_PORTAL_BASE.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_SC_PORTAL_BASE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SC_PORTAL_BASE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SC_PORTAL_BASE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SC_PORTAL_BASE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SC_PORTAL_BASE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_MSGAUDIT_MEMBER (
	ID VARCHAR(32) NOT NULL,
	CORP_ID VARCHAR(32) DEFAULT NULL,
	MEMBER_ID VARCHAR(64) DEFAULT NULL,
	MEMBER_NAME VARCHAR(255) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_CP_MSGAUDIT_MEMBER IS '会话内容存档成员'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MEMBER.ID IS '主键'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MEMBER.CORP_ID IS '企业ID'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MEMBER.MEMBER_ID IS '接口成员ID'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MEMBER.MEMBER_NAME IS '成员名称'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MEMBER.STATUS IS '状态'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MEMBER.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MEMBER.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MEMBER.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MEMBER.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_MEMBER.TENANT_ID IS '租户ID'
;


CREATE TABLE EM_CP_MSGAUDIT_SYNC_SETTING (
	ID VARCHAR(32) NOT NULL,
	CORP_ID VARCHAR(32) DEFAULT NULL,
	SEQ BIGINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;


COMMENT ON TABLE EM_CP_MSGAUDIT_SYNC_SETTING IS '会话内容存档同步设置'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_SYNC_SETTING.ID IS '主键'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_SYNC_SETTING.CORP_ID IS '企业ID'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_SYNC_SETTING.SEQ IS '最大seq'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_SYNC_SETTING.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_SYNC_SETTING.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_SYNC_SETTING.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_SYNC_SETTING.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_MSGAUDIT_SYNC_SETTING.TENANT_ID IS '租户ID'
;


CREATE TABLE EM_SETTING_ROLE (
	ID VARCHAR(32) NOT NULL,
	OPEN_ROLE_ID INT DEFAULT NULL,
	ROLE_NAME VARCHAR(100) DEFAULT NULL,
	ENGLISH_NAME VARCHAR(100) DEFAULT NULL,
	DESCRIPTION VARCHAR(200) DEFAULT NULL,
	ROLE_TYPE SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_SETTING_ROLE IS '企业管理角色表'
;

COMMENT ON COLUMN EM_SETTING_ROLE.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SETTING_ROLE.OPEN_ROLE_ID IS 'API交互时的唯一标识，采用某企业内自增长逻辑，即按tenantid自增长'
;

COMMENT ON COLUMN EM_SETTING_ROLE.ROLE_NAME IS '角色名称'
;

COMMENT ON COLUMN EM_SETTING_ROLE.ENGLISH_NAME IS '英文名称'
;

COMMENT ON COLUMN EM_SETTING_ROLE.DESCRIPTION IS '角色描述'
;

COMMENT ON COLUMN EM_SETTING_ROLE.ROLE_TYPE IS '角色类型 1-用户角色，2-应用角色，3-接口角色'
;

COMMENT ON COLUMN EM_SETTING_ROLE.STATUS IS '状态 1-正常，2-禁用，3-删除'
;

COMMENT ON COLUMN EM_SETTING_ROLE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SETTING_ROLE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SETTING_ROLE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SETTING_ROLE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SETTING_ROLE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_MSG_SETLOG (
	ID VARCHAR(32) NOT NULL,
	TOUSERS TEXT,
	MSG_DATA_ID VARCHAR(50) DEFAULT NULL,
	MSG_DATA_TYPE VARCHAR(20) DEFAULT NULL,
	REQUESTINFO TEXT,
	RESULTINFO TEXT,
	TYPE SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	MSG_STATUS VARCHAR(50) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_CP_MSG_SETLOG IS '企业号消息变更日志表'
;

COMMENT ON COLUMN EM_CP_MSG_SETLOG.ID IS '主键ID'
;

COMMENT ON COLUMN EM_CP_MSG_SETLOG.TOUSERS IS '消息接收者'
;

COMMENT ON COLUMN EM_CP_MSG_SETLOG.MSG_DATA_ID IS '消息数据ID'
;

COMMENT ON COLUMN EM_CP_MSG_SETLOG.MSG_DATA_TYPE IS '消息数据类型'
;

COMMENT ON COLUMN EM_CP_MSG_SETLOG.REQUESTINFO IS '消息变更请求内容'
;

COMMENT ON COLUMN EM_CP_MSG_SETLOG.RESULTINFO IS '消息变更结果'
;

COMMENT ON COLUMN EM_CP_MSG_SETLOG.TYPE IS '消息变更类型，0、null-默认待办变已办，1-删除待办'
;

COMMENT ON COLUMN EM_CP_MSG_SETLOG.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_CP_MSG_SETLOG.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_MSG_SETLOG.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_MSG_SETLOG.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_MSG_SETLOG.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_MSG_SETLOG.TENANT_ID IS '企业租户ID'
;

COMMENT ON COLUMN EM_CP_MSG_SETLOG.MSG_STATUS IS '飞书待办消息状态'
;


CREATE TABLE EM_HRM_USER_ACCOUNT (
	ID VARCHAR(32) NOT NULL,
	HRM_USER_ID VARCHAR(32) DEFAULT NULL,
	OUTSYS_ID VARCHAR(32) DEFAULT NULL,
	OUTSYS_USER_ID VARCHAR(32) DEFAULT NULL,
	OUTSYS_USER_NAME VARCHAR(100) DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;



COMMENT ON TABLE EM_HRM_USER_ACCOUNT IS '通讯录成员与集成系统人员关联表'
;

COMMENT ON COLUMN EM_HRM_USER_ACCOUNT.ID IS '主键ID'
;

COMMENT ON COLUMN EM_HRM_USER_ACCOUNT.HRM_USER_ID IS 'HRM用户ID'
;

COMMENT ON COLUMN EM_HRM_USER_ACCOUNT.OUTSYS_ID IS '集成系统ID'
;

COMMENT ON COLUMN EM_HRM_USER_ACCOUNT.OUTSYS_USER_ID IS '集成系统中的用户ID'
;

COMMENT ON COLUMN EM_HRM_USER_ACCOUNT.OUTSYS_USER_NAME IS '集成系统中的用户姓名'
;

COMMENT ON COLUMN EM_HRM_USER_ACCOUNT.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_HRM_USER_ACCOUNT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_HRM_USER_ACCOUNT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_HRM_USER_ACCOUNT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_HRM_USER_ACCOUNT.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_HRM_USER_ACCOUNT.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_USER (
	ID VARCHAR(32) NOT NULL,
	CP_CORP_ID VARCHAR(32) DEFAULT NULL,
	OPEN_USER_ID VARCHAR(100) DEFAULT NULL,
	USER_NAME VARCHAR(100) DEFAULT NULL,
	NICK_NAME VARCHAR(100) DEFAULT NULL,
	ENGLISH_NAME VARCHAR(100) DEFAULT NULL,
	MOBILE VARCHAR(50) DEFAULT NULL,
	POSITION VARCHAR(800) DEFAULT NULL,
	GENDER SMALLINT DEFAULT NULL,
	EMAIL VARCHAR(100) DEFAULT NULL,
	IDCARD VARCHAR(20) DEFAULT NULL,
	WORKCODE VARCHAR(800) DEFAULT NULL,
	TELEPHONE VARCHAR(100) DEFAULT NULL,
	ADDRESS VARCHAR(500) DEFAULT NULL,
	AVATAR VARCHAR(500) DEFAULT NULL,
	SHOWORDER BIGINT DEFAULT NULL,
	IS_LEADER_IN_DEPT VARCHAR(800) DEFAULT NULL,
	ISSYNC SMALLINT DEFAULT NULL,
	CORP_STATUS SMALLINT DEFAULT NULL,
	ISADMIN SMALLINT DEFAULT NULL,
	CUSTOMFIELD TEXT,
	EXTERNAL_POSITION VARCHAR(800) DEFAULT NULL,
	EXTERNAL_CUSTOMFIELD TEXT,
	LAST_SYNC_STATUS SMALLINT DEFAULT NULL,
	LAST_SYNC_ERROR VARCHAR(500) DEFAULT NULL,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	BASE_USER_ID VARCHAR(32) DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	ACCOUNT_ID VARCHAR(100) DEFAULT NULL,
	ACCOUNT_NAME VARCHAR(50) DEFAULT NULL,
	QR_CODE VARCHAR(1000) DEFAULT NULL,
	EXTERNAL_USERID VARCHAR(500) DEFAULT NULL,
	MANAGE_ID VARCHAR(50) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;
COMMENT ON TABLE EM_CP_USER IS '企业号通讯录成员表'
;

COMMENT ON COLUMN EM_CP_USER.ID IS '主键ID'
;

COMMENT ON COLUMN EM_CP_USER.CP_CORP_ID IS '企业号基本信息ID'
;

COMMENT ON COLUMN EM_CP_USER.OPEN_USER_ID IS '用户在企业号内的唯一标识'
;

COMMENT ON COLUMN EM_CP_USER.USER_NAME IS '姓名'
;

COMMENT ON COLUMN EM_CP_USER.NICK_NAME IS '昵称'
;

COMMENT ON COLUMN EM_CP_USER.ENGLISH_NAME IS '英文名'
;

COMMENT ON COLUMN EM_CP_USER.MOBILE IS '手机'
;

COMMENT ON COLUMN EM_CP_USER.GENDER IS '性别 1表示男性，2表示女性，0表示未知'
;

COMMENT ON COLUMN EM_CP_USER.EMAIL IS '邮箱'
;

COMMENT ON COLUMN EM_CP_USER.IDCARD IS '身份证号'
;

COMMENT ON COLUMN EM_CP_USER.TELEPHONE IS '座机'
;

COMMENT ON COLUMN EM_CP_USER.ADDRESS IS '工作地点'
;

COMMENT ON COLUMN EM_CP_USER.AVATAR IS '头像'
;

COMMENT ON COLUMN EM_CP_USER.SHOWORDER IS '显示顺序'
;

COMMENT ON COLUMN EM_CP_USER.IS_LEADER_IN_DEPT IS '用户所管理的部门id，多个用逗号隔开'
;

COMMENT ON COLUMN EM_CP_USER.ISSYNC IS '是否已添加到企业号通讯录 1-是，0-否'
;

COMMENT ON COLUMN EM_CP_USER.CORP_STATUS IS '企业号通讯录中的状态'
;

COMMENT ON COLUMN EM_CP_USER.ISADMIN IS '是否为企业的管理员 1-是，0-否'
;

COMMENT ON COLUMN EM_CP_USER.CUSTOMFIELD IS '自定义字段'
;

COMMENT ON COLUMN EM_CP_USER.EXTERNAL_POSITION IS '对外岗位'
;

COMMENT ON COLUMN EM_CP_USER.EXTERNAL_CUSTOMFIELD IS '对外自定义字段'
;

COMMENT ON COLUMN EM_CP_USER.LAST_SYNC_STATUS IS '最后同步到企业号中的状态：0-成功，1-失败'
;

COMMENT ON COLUMN EM_CP_USER.LAST_SYNC_ERROR IS '最后同步到企业号中失败的信息'
;

COMMENT ON COLUMN EM_CP_USER.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_CP_USER.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_USER.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_USER.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_USER.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_USER.BASE_USER_ID IS '基础用户ID'
;

COMMENT ON COLUMN EM_CP_USER.TENANT_ID IS '企业租户ID'
;

COMMENT ON COLUMN EM_CP_USER.ACCOUNT_ID IS '账号ID，适用于政务钉钉'
;

COMMENT ON COLUMN EM_CP_USER.ACCOUNT_NAME IS '账号名称，适用于政务钉钉'
;

COMMENT ON COLUMN EM_CP_USER.QR_CODE IS '二维码链接'
;

COMMENT ON COLUMN EM_CP_USER.EXTERNAL_USERID IS '外部联系人ID'
;

COMMENT ON COLUMN EM_CP_USER.MANAGE_ID IS '人员直接上级ID（飞书）'
;


CREATE TABLE EM_SYS_MSG_SENSITIVE (
	ID VARCHAR(32) NOT NULL,
	SENSITIVE_WORD_FILTER SMALLINT DEFAULT NULL,
	SENSITIVE_WORD_DEALTYPE SMALLINT DEFAULT NULL,
	SENSITIVE_WORD_CONTENT TEXT,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_MSG_SENSITIVE IS '消息敏感词过滤设置表'
;

COMMENT ON COLUMN EM_SYS_MSG_SENSITIVE.SENSITIVE_WORD_FILTER IS '是否开启敏感词过滤功能，1表示开启 0表示关闭'
;

COMMENT ON COLUMN EM_SYS_MSG_SENSITIVE.SENSITIVE_WORD_DEALTYPE IS '敏感词处理方式，1表示禁止发送并提示，2表示自动替换为*'
;

COMMENT ON COLUMN EM_SYS_MSG_SENSITIVE.SENSITIVE_WORD_CONTENT IS '敏感词内容，多个用逗号分隔'
;

COMMENT ON COLUMN EM_SYS_MSG_SENSITIVE.STATUS IS '状态'
;

COMMENT ON COLUMN EM_SYS_MSG_SENSITIVE.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_MSG_SENSITIVE.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_MSG_SENSITIVE.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_MSG_SENSITIVE.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_MSG_SENSITIVE.TENANT_ID IS '企业租户ID'
;


CREATE TABLE EM_CP_MSG_EXT (
	ID VARCHAR(32) NOT NULL,
	EXT_FIELD1 VARCHAR(100) DEFAULT NULL,
	EXT_FIELD2 VARCHAR(100) DEFAULT NULL,
	EXT_FIELD3 VARCHAR(100) DEFAULT NULL,
	EXT_FIELD4 VARCHAR(100) DEFAULT NULL,
	EXT_FIELD5 VARCHAR(100) DEFAULT NULL,
	EXT_FIELD6 VARCHAR(100) DEFAULT NULL,
	EXT_FIELD7 VARCHAR(100) DEFAULT NULL,
	EXT_FIELD8 VARCHAR(100) DEFAULT NULL,
	EXT_FIELD9 VARCHAR(100) DEFAULT NULL,
	EXT_FIELD10 VARCHAR(100) DEFAULT NULL,
	EXT_FIELD11 VARCHAR(1000) DEFAULT NULL,
	EXT_FIELD12 VARCHAR(1000) DEFAULT NULL,
	EXT_FIELD13 VARCHAR(1000) DEFAULT NULL,
	EXT_FIELD14 VARCHAR(1000) DEFAULT NULL,
	EXT_FIELD15 VARCHAR(1000) DEFAULT NULL,
	EXT_FIELD16 TEXT,
	EXT_FIELD17 TEXT,
	EXT_FIELD18 TEXT,
	EXT_FIELD19 TEXT,
	EXT_FIELD20 TEXT,
	STATUS SMALLINT DEFAULT NULL,
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_CP_MSG_EXT IS '企业号推送消息信息扩展表'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.ID IS '主键，消息ID'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.EXT_FIELD1 IS '消息规则ID'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.EXT_FIELD2 IS '应用OpenId'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.EXT_FIELD3 IS '扩展字段3'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.EXT_FIELD4 IS '扩展字段4'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.EXT_FIELD5 IS '扩展字段5'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.EXT_FIELD6 IS '扩展字段6'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.EXT_FIELD7 IS '扩展字段7'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.EXT_FIELD8 IS '扩展字段8'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.EXT_FIELD9 IS '扩展字段9'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.EXT_FIELD10 IS '扩展字段10'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.EXT_FIELD11 IS '扩展字段11'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.EXT_FIELD12 IS '扩展字段12'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.EXT_FIELD13 IS '扩展字段13'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.EXT_FIELD14 IS '扩展字段14'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.EXT_FIELD15 IS '扩展字段15'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.EXT_FIELD16 IS '扩展字段16'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.EXT_FIELD17 IS '扩展字段17'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.EXT_FIELD18 IS '扩展字段18'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.EXT_FIELD19 IS '扩展字段19'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.EXT_FIELD20 IS '扩展字段20'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.STATUS IS '状态 1-正常，3-删除'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_CP_MSG_EXT.TENANT_ID IS '企业租户ID'
;

create table em_sys_chat_file_right(
    id VARCHAR(32) NOT NULL PRIMARY KEY,
    right_chat_file_name VARCHAR(32) DEFAULT NULL,
    PRIORITY INT DEFAULT NULL,
    chat_photo SMALLINT DEFAULT NULL,
    chat_file SMALLINT DEFAULT NULL,
    chat_file_receive SMALLINT DEFAULT NULL,
    status SMALLINT DEFAULT NULL,
    create_user_id VARCHAR(32) DEFAULT NULL,
    create_time TIMESTAMP DEFAULT NULL,
    update_user_id VARCHAR(32) DEFAULT NULL,
    update_time TIMESTAMP DEFAULT NULL,
    tenant_id VARCHAR(32) DEFAULT NULL
)
;
COMMENT ON TABLE em_sys_chat_file_right IS '聊天文件权限规则表'
;

COMMENT ON COLUMN em_sys_chat_file_right.id IS '主键id'
;

COMMENT ON COLUMN em_sys_chat_file_right.right_chat_file_name IS '聊天文件权限规则名称'
;

COMMENT ON COLUMN em_sys_chat_file_right.priority IS '聊天文件权限规则优先级'
;

COMMENT ON COLUMN em_sys_chat_file_right.chat_photo IS '图片下载权限'
;

COMMENT ON COLUMN em_sys_chat_file_right.chat_file IS '文件发送权限'
;

COMMENT ON COLUMN em_sys_chat_file_right.chat_file_receive IS '文件下载权限'
;

COMMENT ON COLUMN em_sys_chat_file_right.status IS '状态 1-正常 2-禁用 3-删除'
;

COMMENT ON COLUMN em_sys_chat_file_right.create_user_id IS '创建人'
;

COMMENT ON COLUMN em_sys_chat_file_right.create_time IS '创建时间'
;

COMMENT ON COLUMN em_sys_chat_file_right.update_user_id IS '修改人'
;

COMMENT ON COLUMN em_sys_chat_file_right.update_time IS '修改时间'
;

COMMENT ON COLUMN em_sys_chat_file_right.tenant_id IS '企业租户id'
;


alter table em_sys_base_file alter media_type type varchar(255),add check (media_type IN ('image','voice','video','file'))
;
