CREATE TABLE EM_CP_USER_SYNC_COND_WX (
     ID VARCHAR(32) NOT NULL,
     CP_CORP_ID VARCHAR(32) DEFAULT NULL,
     OUTSYS_ID VARCHAR(32) DEFAULT NULL,
     COND_TYPE SMALLINT DEFAULT NULL,
     AUTH_TYPE SMALLINT DEFAULT NULL,
     AUTH_TYPE_NAME VARCHAR(255) DEFAULT NULL,
     AUTH_VALUE VARCHAR(32) DEFAULT NULL,
     AUTH_VALUE_NAME VARCHAR(255) DEFAULT NULL,
     AUTH_SECLEVEL VARCHAR(32) DEFAULT NULL,
     AUTH_SECLEVEL_MAX VARCHAR(32) DEFAULT NULL,
     SHOWORDER SMALLINT DEFAULT NULL,
     STATUS SMALLINT DEFAULT NULL,
     CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
     CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
     UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
     UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
     TENANT_ID VARCHAR(32) DEFAULT NULL,
     IS_CONTAINS_CHILD SMALLINT DEFAULT NULL,
     PRIMARY KEY (ID)
)
;

COMMENT ON TABLE em_cp_user_sync_cond_wx IS '从企业微信同步 关联部门范围表'
;
COMMENT ON COLUMN em_cp_user_sync_cond_wx.cp_corp_id 	 IS '企业号基本信息ID'
;
COMMENT ON COLUMN em_cp_user_sync_cond_wx.outsys_id 	 IS '集成系统ID'
;
COMMENT ON COLUMN em_cp_user_sync_cond_wx.cond_type 	 IS '条件类型：1-人员，2-部门，3-分部'
;
COMMENT ON COLUMN em_cp_user_sync_cond_wx.auth_type 	 IS '规则类型：0-人员，1-分部，2-部门，3-角色，4-所有人'
;
COMMENT ON COLUMN em_cp_user_sync_cond_wx.auth_type_name 	 IS '规则类型显示名'
;
COMMENT ON COLUMN em_cp_user_sync_cond_wx.auth_value 	 IS '规则类型值'
;
COMMENT ON COLUMN em_cp_user_sync_cond_wx.auth_value_name 	 IS '规则类型值显示名'
;
COMMENT ON COLUMN em_cp_user_sync_cond_wx.auth_seclevel 	 IS '规则安全级别最小值'
;
COMMENT ON COLUMN em_cp_user_sync_cond_wx.auth_seclevel_max 	IS '规则安全级别最大值'
;

